/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.fuse.transformation.CustomMapping;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.MappingType;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.editor.internal.MappingViewer;
import org.jboss.tools.fuse.transformation.editor.internal.MappingsViewer;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;

final class MappingSummary
extends MappingViewer {
    final MappingsViewer mappingsViewer;
    final Composite mappingSourcePane;
    final Composite mapsToPane;
    final Label mapsToLabel;
    final Composite mappingTargetPane;
    final MappingsViewer.TraversalListener sourceTraversalListener;
    final MappingsViewer.TraversalListener targetTraversalListener;
    final PropertyChangeListener configListener;

    MappingSummary(TransformationConfig config, MappingOperation<?, ?> mapping, MappingsViewer mappingsViewer, List<PotentialDropTarget> potentialDropTargets) {
        super(config, potentialDropTargets);
        this.mapping = mapping;
        this.mappingsViewer = mappingsViewer;
        this.mappingSourcePane = this.createMappingPane(mappingsViewer.sourcePane);
        this.createSourceText(this.mappingSourcePane, 131072);
        this.sourceText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.mapsToPane = new Composite(mappingsViewer.mapsToPane, 0);
        this.mapsToPane.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.mapsToPane.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.mapsToPane.setBackground(mappingsViewer.getBackground());
        this.mapsToLabel = new Label(this.mapsToPane, 0);
        this.mapsToLabel.setImage(Util.Images.MAPPED);
        this.mapsToLabel.setBackground(this.mapsToPane.getBackground());
        StringBuilder builder = new StringBuilder();
        if (mapping.getType() == MappingType.CUSTOM) {
            builder.append(((CustomMapping)mapping).getMappingOperation());
            builder.append('(');
        }
        builder.append(this.name(mapping.getSource()));
        if (mapping.getType() == MappingType.CUSTOM) {
            builder.append(')');
        }
        builder.append(" => ");
        builder.append(this.name(mapping.getTarget()));
        this.mapsToLabel.setToolTipText(builder.toString());
        this.mappingTargetPane = this.createMappingPane(mappingsViewer.targetPane);
        this.createTargetText(this.mappingTargetPane);
        this.targetText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        int height = this.mappingSourcePane.computeSize((int)-1, (int)-1).y;
        height = Math.max(height, this.mapsToPane.computeSize((int)-1, (int)-1).y);
        ((GridData)this.mappingSourcePane.getLayoutData()).heightHint = height = Math.max(height, this.mappingTargetPane.computeSize((int)-1, (int)-1).y);
        ((GridData)this.mapsToPane.getLayoutData()).heightHint = height;
        ((GridData)this.mappingTargetPane.getLayoutData()).heightHint = height;
        this.sourceTraversalListener = new MappingsViewer.TraversalListener(mappingsViewer.prevTargetText, this.targetText);
        this.sourceTraversalListener.prevTraversalListener = mappingsViewer.prevTraversalListener;
        this.sourceText.addTraverseListener((TraverseListener)this.sourceTraversalListener);
        this.sourceTraversalListener.nextTraversalListener = this.targetTraversalListener = new MappingsViewer.TraversalListener(this.sourceText, null);
        this.targetTraversalListener.prevTraversalListener = this.sourceTraversalListener;
        this.targetText.addTraverseListener((TraverseListener)this.targetTraversalListener);
        if (mappingsViewer.prevTraversalListener != null) {
            mappingsViewer.prevTraversalListener.nextText = this.sourceText;
            mappingsViewer.prevTraversalListener.nextTraversalListener = this.sourceTraversalListener;
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                MappingSummary.this.sourceText.setFocus();
            }
        };
        this.mappingSourcePane.addMouseListener((MouseListener)mouseListener);
        this.mapsToPane.addMouseListener((MouseListener)mouseListener);
        this.mapsToLabel.addMouseListener((MouseListener)mouseListener);
        this.mappingTargetPane.addMouseListener((MouseListener)mouseListener);
        mappingsViewer.prevTargetText = this.targetText;
        mappingsViewer.prevTraversalListener = this.targetTraversalListener;
        this.configListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                MappingSummary.this.configEvent(event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
        };
        config.addListener(this.configListener);
    }

    void configEvent(String eventType, Object oldValue, Object newValue) {
        if (eventType.equals("variableValue")) {
            this.variableValueUpdated((Variable)newValue);
            return;
        }
        if (!this.equals(this.mapping, oldValue)) {
            return;
        }
        if (eventType.equals("mapping")) {
            this.dispose((MappingOperation)oldValue);
        } else if (eventType.equals("mappingSource")) {
            this.mapping = (MappingOperation)newValue;
            this.setSourceText();
            this.mappingSourcePane.layout();
            this.sourceText.setFocus();
        } else if (eventType.equals("mappingTarget")) {
            this.mapping = (MappingOperation)newValue;
            this.setTargetText();
            this.mappingTargetPane.layout();
            this.targetText.setFocus();
        } else if (eventType.equals("mappingCustomize")) {
            this.mapping = (MappingOperation)newValue;
            this.setSourceText();
        }
    }

    private Composite createMappingPane(Composite parent) {
        Composite pane = new Composite(parent, 0);
        pane.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        pane.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(0, 5).create());
        pane.setBackground(this.mappingsViewer.getBackground());
        return pane;
    }

    @Override
    Text createText(Composite parent, int style) {
        final Text text = super.createText(parent, style);
        text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                MappingSummary.this.selected(text);
            }

            public void focusLost(FocusEvent event) {
                if (MappingSummary.this.mappingsViewer.selectedMappingSummary == MappingSummary.this) {
                    MappingSummary.this.setBackground(Util.Colors.SELECTED_NO_FOCUS);
                }
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 0x1000002) {
                    MappingSummary.this.mappingsViewer.selectNextMappingSummary();
                } else if (event.keyCode == 0x1000001) {
                    MappingSummary.this.mappingsViewer.selectPreviousMappingSummary();
                }
            }
        });
        return text;
    }

    void deselect() {
        this.setBackground(this.mappingsViewer.getBackground());
    }

    void dispose(MappingOperation<?, ?> mapping) {
        this.mappingSourcePane.dispose();
        this.mapsToPane.dispose();
        this.mappingTargetPane.dispose();
        if (this.sourceTraversalListener.prevTraversalListener != null) {
            this.sourceTraversalListener.prevTraversalListener.nextText = this.targetTraversalListener.nextText;
            this.sourceTraversalListener.prevTraversalListener.nextTraversalListener = this.targetTraversalListener.nextTraversalListener;
        }
        if (this.targetTraversalListener.nextTraversalListener != null) {
            this.targetTraversalListener.nextTraversalListener.prevText = this.sourceTraversalListener.prevText;
            this.targetTraversalListener.nextTraversalListener.prevTraversalListener = this.sourceTraversalListener.prevTraversalListener;
        }
        this.config.removeListener(this.configListener);
        this.mappingsViewer.removeMappingSummary(this);
        this.dispose();
    }

    void selected(Text text) {
        text.selectAll();
        this.setBackground(Util.Colors.SELECTED);
        this.mappingsViewer.selected(this);
    }

    void setBackground(Color color) {
        this.mappingSourcePane.setBackground(color);
        this.mapsToPane.setBackground(color);
        this.mapsToLabel.setBackground(color);
        this.mappingTargetPane.setBackground(color);
    }
}

