/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    public static String PLUGIN_ID;
    private final Map<RGB, Color> colorRegistry = new HashMap<RGB, Color>();

    static {
        PLUGIN_ID = "org.jboss.tools.fuse.transformation.editor";
    }

    public static Color color(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        Color color = Activator.plugin.colorRegistry.get(rgb);
        if (color != null) {
            return color;
        }
        color = new Color(null, rgb);
        Activator.plugin.colorRegistry.put(rgb, color);
        return color;
    }

    public static void error(Throwable error) {
        Status status = new Status(4, plugin.getBundle().getSymbolicName(), "Unexpected error: " + error.getMessage(), error);
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)status.getMessage(), (IStatus)status);
        plugin.getLog().log((IStatus)status);
    }

    public static ImageDescriptor imageDescriptor(String name) {
        String key = String.valueOf(plugin.getBundle().getSymbolicName()) + "." + name;
        ImageDescriptor img = plugin.getImageRegistry().getDescriptor(key);
        if (img != null) {
            return img;
        }
        img = ImageDescriptor.createFromURL((URL)plugin.getBundle().getEntry("icons/" + name));
        plugin.getImageRegistry().put(key, img);
        return img;
    }

    public static Activator plugin() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        for (Color color : this.colorRegistry.values()) {
            color.dispose();
        }
        plugin = null;
        super.stop(context);
    }
}

