/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class CreateFolderChange
extends ResourceChange {
    private final IFolder _folder;

    public CreateFolderChange(IFolder folder) {
        this._folder = folder;
    }

    protected IResource getModifiedResource() {
        return this._folder;
    }

    public String getName() {
        return "Create destination folder hierarchy";
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IFolder createdRootFolder = this.recursiveCreateFolder(this._folder, pm);
        return new DeleteResourceChange(createdRootFolder.getFullPath(), true);
    }

    private IFolder recursiveCreateFolder(IFolder folder, IProgressMonitor pm) throws CoreException {
        if (folder.getParent().exists()) {
            folder.create(true, true, pm);
            return folder;
        }
        IFolder root = this.recursiveCreateFolder((IFolder)folder.getParent(), pm);
        folder.create(true, true, pm);
        return root;
    }
}

