/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.component;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.PropertyValue;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.diagram.shared.DomainPropertyInputDialog;
import org.switchyard.tools.ui.editor.diagram.shared.SCAPropertyValueTable;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class ComponentPropertiesComposite
extends AbstractModelComposite<Component>
implements ResourceSetListener {
    private Component _component;
    private FormToolkit _toolkit = null;
    private TransactionalEditingDomain _domain = null;
    private SCAPropertyValueTable _componentProperties = null;

    public ComponentPropertiesComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        this._toolkit = this.getWidgetFactory();
        this._componentProperties = new SCAPropertyValueTable(this, 2){

            @Override
            protected void removeFromList() {
                PropertyValue toRemove;
                final IStructuredSelection ssel = ComponentPropertiesComposite.this._componentProperties.getStructuredSelection();
                if (ssel != null && !ssel.isEmpty() && ssel.size() > 1) {
                    if (ssel != null && ComponentPropertiesComposite.this._domain != null) {
                        ComponentPropertiesComposite.this._domain.getCommandStack().execute((Command)new RecordingCommand(ComponentPropertiesComposite.this._domain){

                            protected void doExecute() {
                                for (PropertyValue toRemove : ssel) {
                                    ComponentPropertiesComposite.this.removeDomainProperty(toRemove);
                                }
                            }
                        });
                    }
                } else if (ssel != null && ssel.size() == 1 && (toRemove = ComponentPropertiesComposite.this._componentProperties.getTableSelection()) != null) {
                    ComponentPropertiesComposite.this.removeDomainProperty(toRemove);
                }
            }

            @Override
            protected void addPropertyTypeToList() {
                DomainPropertyInputDialog dialog = new DomainPropertyInputDialog(Display.getCurrent().getActiveShell());
                int rtn_value = dialog.open();
                if (rtn_value == 0) {
                    String name = dialog.getPropertyName();
                    String value = dialog.getPropertyValue();
                    ComponentPropertiesComposite.this.addDomainProperty(name, value);
                }
            }
        };
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this._componentProperties.setLayoutData(data);
        this._toolkit.adapt((Composite)this._componentProperties);
        this.addDomainListener();
    }

    @Override
    public void refresh() {
        Object targetObj = this.getTargetObject();
        if (targetObj != null && targetObj instanceof Component) {
            this._component = (Component)targetObj;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ComponentPropertiesComposite.this._componentProperties != null && !ComponentPropertiesComposite.this._componentProperties.isDisposed()) {
                        ComponentPropertiesComposite.this._componentProperties.setSelection((EList<PropertyValue>)ComponentPropertiesComposite.this._component.getProperty());
                        ComponentPropertiesComposite.this._componentProperties.setTargetObject((EObject)ComponentPropertiesComposite.this._component);
                    }
                }
            });
        }
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        this.refresh();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void dispose() {
        this.removeDomainListener();
        super.dispose();
    }

    private void removeDomainProperty(final PropertyValue property) {
        EList properties;
        if (this._component != null && (properties = this._component.getProperty()) != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    properties.remove((Object)property);
                }
            });
        }
    }

    private void addDomainProperty(final String name, final String value) {
        if (this._component != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    EList properties = ComponentPropertiesComposite.this._component.getProperty();
                    PropertyValue newProperty = ScaFactory.eINSTANCE.createPropertyValue();
                    newProperty.setName(name);
                    newProperty.setValue(value);
                    properties.add((Object)newProperty);
                }
            });
        }
    }
}

