/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.model.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.switchyard.tools.ui.editor.model.merge.MergedModelAdapterFactory;

public class MergedModelUpdateAdapter
extends EContentAdapter
implements Adapter {
    private MergedModelAdapterFactory _factory;

    protected MergedModelUpdateAdapter(MergedModelAdapterFactory factory) {
        this._factory = factory;
    }

    public void notifyChanged(Notification notification) {
        block20: {
            if (notification.isTouch() || !(notification.getNotifier() instanceof EObject)) {
                return;
            }
            EObject source = (EObject)notification.getNotifier();
            EObject generated = this.getGenerated(source);
            if (generated == null || this._factory.isCopiedSource(source, generated)) {
                return;
            }
            boolean oldDeliver = generated.eDeliver();
            generated.eSetDeliver(false);
            try {
                EStructuralFeature feature = ExtendedMetaData.INSTANCE.getAffiliation(generated.eClass(), (EStructuralFeature)notification.getFeature());
                if (FeatureMap.Entry.class.isAssignableFrom(feature.getEType().getInstanceClass())) {
                    return;
                }
                if (feature.isMany()) {
                    Object newValue = notification.getNewValue();
                    switch (notification.getEventType()) {
                        case 3: {
                            if (feature instanceof EReference && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) {
                                ((EList)generated.eGet(feature)).add(notification.getPosition(), this.copy(newValue));
                                break;
                            }
                            ((EList)generated.eGet(feature)).add(notification.getPosition(), this.getGeneratedReference(newValue));
                            break;
                        }
                        case 5: {
                            if (feature instanceof EReference && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) {
                                ((EList)generated.eGet(feature)).addAll(notification.getPosition(), (Collection)this.copy(newValue));
                                break;
                            }
                            ((EList)generated.eGet(feature)).addAll(notification.getPosition(), (Collection)this.getGeneratedReference(newValue));
                            break;
                        }
                        case 4: {
                            Object removed = notification.getOldValue();
                            ((EList)generated.eGet(feature)).remove(removed instanceof EObject ? this._factory.getGenerated((EObject)removed) : removed);
                            if (feature instanceof EReference && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) {
                                this._factory.removeMatchFromSource(removed);
                                break;
                            }
                            break block20;
                        }
                        case 6: {
                            boolean isContainment = feature instanceof EReference && (((EReference)feature).isContainment() || ((EReference)feature).isContainer());
                            EList sourceList = (EList)generated.eGet(feature);
                            for (Object removed : (Collection)notification.getOldValue()) {
                                sourceList.remove(removed instanceof EObject ? this._factory.getGenerated((EObject)removed) : removed);
                                if (!isContainment || !(removed instanceof EObject)) continue;
                                this._factory.removeMatchFromSource(removed);
                            }
                            break block20;
                        }
                    }
                    break block20;
                }
                if (feature instanceof EReference && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) {
                    this.handleContainmentSet(notification, generated, feature);
                } else {
                    generated.eSet(feature, this.getGeneratedReference(notification.getNewValue()));
                }
            }
            finally {
                generated.eSetDeliver(oldDeliver);
                super.notifyChanged(notification);
            }
        }
    }

    private void handleContainmentSet(Notification notification, EObject generated, EStructuralFeature feature) {
        if (generated.eIsSet(feature)) {
            Object existingGenerated = generated.eGet(feature);
            if (existingGenerated instanceof EObject) {
                EObject existingSource = this._factory.getSource((EObject)existingGenerated);
                EObject newSource = (EObject)notification.getNewValue();
                if (this._factory.isCopiedSource(existingSource, (EObject)existingGenerated) || this._factory.getDifferencesFor(existingSource).size() > 0) {
                    if (existingSource == existingGenerated || existingSource == null) {
                        this._factory.calculateDifferences();
                    } else if (newSource != existingSource) {
                        ArrayList generatedContents = new ArrayList(((EObject)existingGenerated).eContents());
                        for (EObject generatedContent : generatedContents) {
                            EObject sourceContent = this._factory.getSource(generatedContent);
                            if (sourceContent == generatedContent) continue;
                            Object container = ((EObject)existingGenerated).eGet(generatedContent.eContainingFeature());
                            if (container instanceof FeatureMap) {
                                if (ExtendedMetaData.INSTANCE.getFeatureKind(generatedContent.eContainingFeature()) == 5) {
                                    EClass docRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(generatedContent.eClass().getEPackage());
                                    for (EStructuralFeature testFeature : ExtendedMetaData.INSTANCE.getElements(docRoot)) {
                                        if (testFeature.getEType() != generatedContent.eClass()) continue;
                                        Object data = ((FeatureMap)container).get(testFeature, false);
                                        if (data == generatedContent) {
                                            ((FeatureMap)container).unset(testFeature);
                                        } else if (data instanceof Collection) {
                                            ((Collection)data).remove(generatedContent);
                                            if (((Collection)data).isEmpty()) {
                                                ((FeatureMap)container).unset(testFeature);
                                            }
                                        }
                                        break;
                                    }
                                }
                            } else {
                                ((Collection)container).remove(generatedContent);
                            }
                            this._factory.removeMatchFromSource(sourceContent);
                        }
                        this._factory.calculateDifferences();
                    }
                } else if (notification.isReset()) {
                    generated.eUnset(feature);
                } else {
                    generated.eSet(feature, this.copy(notification.getNewValue()));
                }
            } else if (notification.isReset()) {
                generated.eUnset(feature);
            } else {
                generated.eSet(feature, this.copy(notification.getNewValue()));
            }
        } else if (notification.isReset()) {
            generated.eUnset(feature);
        } else {
            generated.eSet(feature, this.copy(notification.getNewValue()));
        }
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
    }

    private EObject getGenerated(EObject changed) {
        if (changed instanceof EObject) {
            return this._factory.getGenerated(changed);
        }
        return null;
    }

    private Object copy(Object object) {
        List list;
        if (object instanceof EObject) {
            NoReferenceCopier copier = new NoReferenceCopier();
            EObject copy = copier.copy((EObject)object);
            copier.copyReferences();
            return copy;
        }
        if (object instanceof List && (list = (List)object).size() > 0 && list.get(0) instanceof EObject) {
            return new NoReferenceCopier().copyAll(list);
        }
        return object;
    }

    private Object getGeneratedReference(Object object) {
        List list;
        if (object instanceof EObject) {
            EObject generated = this._factory.getGenerated((EObject)object);
            if (generated == null && (generated = (EObject)this.copy(object)) != null) {
                EObject source = (EObject)object;
                EObject generatedContainer = this._factory.getGenerated(source.eContainer());
                if (generatedContainer != null) {
                    EStructuralFeature containingFeature = source.eContainingFeature();
                    ((List)generatedContainer.eGet(containingFeature)).add(((List)source.eContainer().eGet(containingFeature)).indexOf(source), generated);
                }
                this._factory.setMatchedFromSource((EObject)object, generated);
            }
            return generated;
        }
        if (object instanceof List && (list = (List)object).size() > 0 && list.get(0) instanceof EObject) {
            ArrayList<EObject> generatedList = new ArrayList<EObject>(list.size());
            for (EObject source : list) {
                EObject generated = (EObject)this.getGeneratedReference(source);
                if (generated == null) continue;
                generatedList.add(generated);
            }
            return generatedList;
        }
        return object;
    }

    private final class NoReferenceCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;

        public NoReferenceCopier() {
            super(true, false);
        }

        public EObject get(Object key) {
            EObject copy = (EObject)super.get(key);
            if (copy == null && (copy = MergedModelUpdateAdapter.this._factory.getGenerated((EObject)key)) == null) {
                copy = (EObject)key;
            }
            return copy;
        }

        protected EObject createCopy(EObject eObject) {
            EObject copy = super.createCopy(eObject);
            MergedModelUpdateAdapter.this._factory.setMatchedFromSource(eObject, copy);
            return copy;
        }
    }
}

