/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class TableColumnLayout
extends org.eclipse.jface.layout.TableColumnLayout {
    private boolean _inupdateMode = false;
    private boolean _relayout = true;
    private Listener _resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (!TableColumnLayout.this._inupdateMode) {
                TableColumnLayout.this.updateColumnData(event.widget);
            }
        }
    };

    public void setColumnData(Widget column, ColumnLayoutData data) {
        if (column.getData("org.eclipse.jface.LAYOUT_DATA") == null) {
            column.addListener(11, this._resizeListener);
        }
        column.setData("org.eclipse.jface.LAYOUT_DATA", (Object)data);
    }

    private void layoutTableTree(Scrollable scrollable, int width, Rectangle area, boolean increase) {
        boolean recalculate;
        int numberOfColumns = this.getColumnCount(scrollable);
        int[] widths = new int[numberOfColumns];
        int[] weightColumnIndices = new int[numberOfColumns];
        int numberOfWeightColumns = 0;
        int fixedWidth = 0;
        int totalWeight = 0;
        int i = 0;
        while (i < numberOfColumns) {
            ColumnLayoutData col = this.getLayoutData(scrollable, i);
            if (col instanceof ColumnPixelData) {
                ColumnPixelData cpd = (ColumnPixelData)col;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += this.getColumnTrim();
                }
                widths[i] = pixels;
                fixedWidth += pixels;
            } else if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                weightColumnIndices[numberOfWeightColumns] = i;
                ++numberOfWeightColumns;
                totalWeight += cw.weight;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        block1: do {
            recalculate = false;
            int i2 = 0;
            while (i2 < numberOfWeightColumns) {
                int allowedWidth;
                int colIndex = weightColumnIndices[i2];
                ColumnWeightData cw = (ColumnWeightData)this.getLayoutData(scrollable, colIndex);
                int minWidth = cw.minimumWidth;
                int n = allowedWidth = totalWeight == 0 ? 0 : (width - fixedWidth) * cw.weight / totalWeight;
                if (allowedWidth < minWidth) {
                    totalWeight -= cw.weight;
                    fixedWidth += minWidth;
                    widths[colIndex] = minWidth;
                    System.arraycopy(weightColumnIndices, i2 + 1, weightColumnIndices, i2, --numberOfWeightColumns - i2);
                    recalculate = true;
                    continue block1;
                }
                widths[colIndex] = allowedWidth;
                ++i2;
            }
        } while (recalculate);
        if (increase) {
            scrollable.setSize(area.width, area.height);
        }
        this._inupdateMode = true;
        this.setColumnWidths(scrollable, widths);
        scrollable.update();
        this._inupdateMode = false;
        if (!increase) {
            scrollable.setSize(area.width, area.height);
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Scrollable scrollable = this.getScrollable(composite);
        Point result = scrollable.computeSize(wHint, hHint);
        if (wHint != -1) {
            result.x = wHint;
        }
        if (hHint != -1) {
            result.y = hHint;
        }
        int width = 0;
        int size = this.getColumnCount(scrollable);
        int i = 0;
        while (i < size) {
            ColumnPixelData col;
            ColumnLayoutData layoutData = this.getLayoutData(scrollable, i);
            if (layoutData instanceof ColumnPixelData) {
                col = (ColumnPixelData)layoutData;
                width += col.width;
                if (col.addTrim) {
                    width += this.getColumnTrim();
                }
            } else if (layoutData instanceof ColumnWeightData) {
                col = (ColumnWeightData)layoutData;
                width += col.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        if (width > result.x || wHint == -1) {
            result.x = width;
        }
        return result;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int tableWidth;
        Scrollable table;
        Rectangle area = composite.getClientArea();
        int trim = this.computeTrim(area, table = this.getScrollable(composite), tableWidth = table.getSize().x);
        int width = Math.max(0, area.width - trim);
        if (width > 1) {
            this.layoutTableTree(table, width, area, tableWidth < area.width);
        }
        if (this._relayout) {
            this._relayout = false;
            composite.layout();
        }
    }

    private int computeTrim(Rectangle area, Scrollable scrollable, int currentWidth) {
        return scrollable.computeTrim((int)0, (int)0, (int)0, (int)0).width;
    }

    private Scrollable getScrollable(Composite composite) {
        return (Scrollable)composite.getChildren()[0];
    }
}

