/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.connections;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;

public class SCADiagramCreateComponentServiceLinkFeature
extends AbstractCreateConnectionFeature {
    public SCADiagramCreateComponentServiceLinkFeature(IFeatureProvider fp) {
        super(fp, Messages.featureName_componentServiceReference, Messages.featureDescription_componentServiceReference);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        if (context.getSourceAnchor() != null && context.getTargetAnchor() != null) {
            Object source = this.getAnchorObject(context.getSourceAnchor());
            Object target = this.getAnchorObject(context.getTargetAnchor());
            if (source != null && target != null) {
                if (source instanceof Service && target instanceof ComponentService && !this.getDiagramBehavior().getEditingDomain().isReadOnly(((Service)source).eResource())) {
                    Service service = (Service)source;
                    ComponentService component = (ComponentService)target;
                    return service.getPromote() == null || !service.getPromote().equals(component);
                }
                if (source instanceof ComponentService && target instanceof Service && !this.getDiagramBehavior().getEditingDomain().isReadOnly(((Service)target).eResource())) {
                    Service service = (Service)target;
                    ComponentService component = (ComponentService)source;
                    return service.getPromote() == null || !service.getPromote().equals(component);
                }
            }
        }
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getAnchorObject(context.getSourceAnchor()) != null;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        Anchor targetAnchor = (Anchor)context.getTargetAnchor().getParent().getAnchors().get(0);
        Anchor sourceAnchor = (Anchor)context.getSourceAnchor().getParent().getAnchors().get(0);
        Object source = this.getAnchorObject(sourceAnchor);
        Object target = this.getAnchorObject(targetAnchor);
        if (source != null && target != null) {
            Service service;
            ComponentService componentService;
            if (source instanceof ComponentService) {
                componentService = (ComponentService)source;
                service = (Service)target;
                targetAnchor = sourceAnchor = targetAnchor;
            } else {
                componentService = (ComponentService)target;
                service = (Service)source;
            }
            AddConnectionContext addContext = new AddConnectionContext(sourceAnchor, targetAnchor);
            service.setPromote(componentService);
            addContext.setNewObject((Object)componentService);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            if (newConnection != null) {
                this.getFeatureProvider().updateIfPossibleAndNeeded((IUpdateContext)new UpdateContext((PictogramElement)newConnection));
            }
        }
        return newConnection;
    }

    private Object getAnchorObject(Anchor anchor) {
        Object object;
        if (anchor != null && ((object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof Service || object instanceof ComponentService)) {
            return object;
        }
        return null;
    }

    public String getCreateImageId() {
        return ImageProvider.IMG_16_CONNECTION;
    }
}

