/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.compositereference;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.NewContractWizardPage;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;
import org.switchyard.tools.ui.editor.transform.TransformDetails;

public class PromoteReferenceWizardPage
extends NewContractWizardPage {
    private Contract _sourceContract;
    private SwitchYardType _switchYard;
    private IProject _project;
    private TransformDetails _details;
    private IResource _targetResource;
    private IResource _sourceResource;
    private Button _createTransformersCheck;
    private NewTransformWizard _transformWizard = new NewTransformWizard();
    private boolean _creatingTransformers;

    public PromoteReferenceWizardPage() {
        super(PromoteReferenceWizardPage.class.getCanonicalName(), Messages.title_promoteComponentReference, Messages.description_promoteComponentReference, ScaPackage.eINSTANCE.getReference());
    }

    @Override
    public void init(Contract contract, Contract related) {
        super.init(contract, related);
        this._sourceContract = related;
        this._switchYard = MergedModelUtil.getSwitchYard((EObject)this._sourceContract);
        this._project = PlatformResourceAdapterFactory.getContainingProject((Object)this._switchYard);
        this._sourceResource = PlatformResourceAdapterFactory.getFileForObject((Object)this._sourceContract, (IProject)this._project);
    }

    public Collection<TransformType> getCreatedTransforms() {
        if (this._creatingTransformers) {
            return this._transformWizard.getCreatedTransforms();
        }
        return Collections.emptyList();
    }

    @Override
    protected void createAdditionalControls(Composite content, int nColumns) {
        if (nColumns > 1) {
            new Label(content, 0);
        }
        this._createTransformersCheck = new Button(content, 32);
        this._createTransformersCheck.setText(Messages.label_createRequiredTransformers);
        this._createTransformersCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, nColumns - 1, 1));
        this._createTransformersCheck.setSelection(true);
        this._createTransformersCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PromoteReferenceWizardPage.this.validate();
            }
        });
        if (nColumns > 1) {
            new Label(content, 0);
        }
        this._transformWizard.addPages();
    }

    @Override
    protected void validate() {
        block7: {
            IFile newTargetResource;
            super.validate();
            boolean canPromote = this.validatePromotion();
            if (!canPromote) {
                this.setErrorMessage(MessageFormat.format(Messages.error_compositeReferenceExists, this.getContract().getName()));
            }
            if ((newTargetResource = PlatformResourceAdapterFactory.getFileForObject((Object)this.getContract(), (IProject)this._project)) != null && this._sourceResource != null && !newTargetResource.equals((Object)this._sourceResource) && newTargetResource.exists() && this._sourceResource.exists()) {
                if (!newTargetResource.equals((Object)this._targetResource)) {
                    this._targetResource = newTargetResource;
                    try {
                        this.getWizard().getContainer().run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                                try {
                                    PromoteReferenceWizardPage.this._details = new TransformDetails(PromoteReferenceWizardPage.this._switchYard, PromoteReferenceWizardPage.this._sourceContract, PromoteReferenceWizardPage.this.getContract());
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                        if (!this._details.getDeclaredTransforms().containsAll(this._details.getRequiredTransforms())) {
                            this._transformWizard.init(this._details);
                            this._createTransformersCheck.setEnabled(true);
                            break block7;
                        }
                        this._createTransformersCheck.setEnabled(false);
                    }
                    catch (Exception exception) {
                        this._createTransformersCheck.setEnabled(false);
                    }
                }
            } else {
                this._createTransformersCheck.setEnabled(false);
                this._targetResource = newTargetResource;
            }
        }
        this._creatingTransformers = this._createTransformersCheck.isEnabled() && this._createTransformersCheck.getSelection();
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected IWizard getNextWizard() {
        if (this._createTransformersCheck.isEnabled() && this._createTransformersCheck.getSelection()) {
            return this._transformWizard;
        }
        return null;
    }

    private boolean validatePromotion() {
        EList refs = this._switchYard.getComposite().getReference();
        for (Reference ref : refs) {
            boolean nameMatch = false;
            boolean foundDupe = false;
            if (ref.getName().equals(this.getContract().getName())) {
                nameMatch = true;
                if (ref.getInterface().eClass().getName().equals(this.getContract().getInterface().eClass().getName())) {
                    JavaInterface newRefIntfc;
                    JavaInterface refIntfc;
                    if (ref.getInterface() instanceof JavaInterface) {
                        refIntfc = (JavaInterface)ref.getInterface();
                        newRefIntfc = (JavaInterface)this.getContract().getInterface();
                        if (refIntfc.getInterface().equals(newRefIntfc.getInterface())) {
                            foundDupe = true;
                        }
                    } else if (ref.getInterface() instanceof EsbInterface) {
                        refIntfc = (EsbInterface)ref.getInterface();
                        newRefIntfc = (EsbInterface)this.getContract().getInterface();
                        boolean inputMatch = false;
                        if (refIntfc.getInputType() != null && refIntfc.getInputType().equals(newRefIntfc.getInputType())) {
                            inputMatch = true;
                        } else if (refIntfc.getInputType() == null && newRefIntfc.getInputType() == null) {
                            inputMatch = true;
                        }
                        boolean outputMatch = false;
                        if (refIntfc.getOutputType() != null && refIntfc.getOutputType().equals(newRefIntfc.getOutputType())) {
                            outputMatch = true;
                        } else if (refIntfc.getOutputType() == null && newRefIntfc.getOutputType() == null) {
                            outputMatch = true;
                        }
                        boolean faultMatch = false;
                        if (refIntfc.getFaultType() != null && refIntfc.getFaultType().equals(newRefIntfc.getFaultType())) {
                            faultMatch = true;
                        } else if (refIntfc.getFaultType() == null && newRefIntfc.getFaultType() == null) {
                            faultMatch = true;
                        }
                        if (inputMatch && outputMatch && faultMatch) {
                            foundDupe = true;
                        }
                    } else if (ref.getInterface() instanceof WSDLPortType) {
                        refIntfc = (WSDLPortType)ref.getInterface();
                        newRefIntfc = (WSDLPortType)this.getContract().getInterface();
                        if (refIntfc.getInterface().equals(newRefIntfc.getInterface())) {
                            foundDupe = true;
                        }
                    }
                }
            }
            if (foundDupe && nameMatch) {
                return true;
            }
            if (foundDupe || !nameMatch) continue;
            return false;
        }
        return true;
    }
}

