/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.component;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.switchyard.tools.ui.editor.diagram.StyleUtil;

public class SCADiagramAddComponentFeature
extends AbstractAddShapeFeature {
    public SCADiagramAddComponentFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        if (context.getNewObject() instanceof Component) {
            ContainerShape targetContainer = context.getTargetContainer();
            if (targetContainer instanceof Composite) {
                return true;
            }
            if (this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer) instanceof Composite) {
                return true;
            }
        }
        return false;
    }

    public PictogramElement add(IAddContext context) {
        int anchorY;
        int anchorX;
        AddContext addContext;
        Component addedComponent = (Component)context.getNewObject();
        ContainerShape targetContainer = context.getTargetContainer();
        IGaService gaService = Graphiti.getGaService();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape(targetContainer, true);
        int edging = 30;
        int width = context.getWidth() <= 0 ? 100 : context.getWidth();
        int height = context.getHeight() <= 0 ? 50 : context.getHeight();
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX() - 15, context.getY() - 15, width + edging, height + edging);
        RoundedRectangle roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 12, 12);
        roundedRectangle.setStyle(StyleUtil.getStyleForComponent(this.getDiagram()));
        roundedRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)invisibleRectangle);
        roundedRectangle.setLineWidth(roundedRectangle.getStyle().getLineWidth());
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, 15, 15, width, height);
        this.link((PictogramElement)containerShape, addedComponent);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)roundedRectangle, "sca-type", "component");
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)roundedRectangle, addedComponent.getName());
        text.setForeground(this.manageColor((IColorConstant)new ColorConstant(StyleUtil.COMPONENT_PALETTE.getTextForeground())));
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        Font font = text.getFont();
        font = gaService.manageFont(this.getDiagram(), font.getName(), font.getSize(), false, true);
        text.setFont(font);
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 15, 15, width - edging, height - edging);
        if (addedComponent.getService().size() > 0) {
            addContext = new AddContext();
            anchorX = roundedRectangle.getX() - 8;
            anchorY = 2 * edging;
            addContext.setTargetContainer(containerShape);
            for (ComponentService componentService : addedComponent.getService()) {
                addContext.setNewObject((Object)componentService);
                addContext.setLocation(anchorX, anchorY);
                this.addGraphicalRepresentation((IAreaContext)addContext, componentService);
                anchorY += 20;
            }
        }
        if (addedComponent.getReference().size() > 0) {
            addContext = new AddContext();
            anchorX = roundedRectangle.getX() + roundedRectangle.getWidth() - 8;
            anchorY = 2 * edging;
            addContext.setTargetContainer(containerShape);
            for (ComponentReference componentReference : addedComponent.getReference()) {
                addContext.setNewObject((Object)componentReference);
                addContext.setLocation(anchorX, anchorY);
                this.addGraphicalRepresentation((IAreaContext)addContext, componentReference);
                anchorY += 20;
            }
        }
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }
}

