/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.databinding;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFObservable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;

public class EMFUpdateValueStrategyConversionErrorMessage
extends EMFUpdateValueStrategy {
    private final String _message;
    private final EditingDomain _domain;
    private final IObservableValue _root;
    private final FeaturePath _features;
    private final boolean _deleteEmptyContainers;

    public EMFUpdateValueStrategyConversionErrorMessage(String message, int updatePolicy, EditingDomain domain, IObservableValue root, FeaturePath features, boolean deleteEmptyContainers) {
        super(updatePolicy);
        this._message = message;
        this._domain = domain;
        this._root = root;
        this._features = features;
        this._deleteEmptyContainers = deleteEmptyContainers;
    }

    public EMFUpdateValueStrategyConversionErrorMessage(String message, int updatePolicy) {
        super(updatePolicy);
        this._message = message;
        this._domain = null;
        this._root = null;
        this._features = null;
        this._deleteEmptyContainers = false;
    }

    public EMFUpdateValueStrategyConversionErrorMessage(String message) {
        this._message = message;
        this._domain = null;
        this._root = null;
        this._features = null;
        this._deleteEmptyContainers = false;
    }

    public EMFUpdateValueStrategyConversionErrorMessage() {
        this(null);
    }

    protected IStatus doSet(IObservableValue observableValue, final Object value) {
        if (this._features != null) {
            try {
                EObject root;
                final Object origValue = observableValue.getValue();
                final EStructuralFeature[] features = this._features.getFeaturePath();
                EObject eObject = root = this._root == null ? null : (EObject)this._root.getValue();
                if (this._domain != null) {
                    this._domain.getCommandStack().execute((Command)new AbstractCommand("Update " + ((IEMFObservable)observableValue).getStructuralFeature().getName()){

                        protected boolean prepare() {
                            return true;
                        }

                        public void execute() {
                            EMFUpdateValueStrategyConversionErrorMessage.this.internalDoSet(root, features, value);
                        }

                        public void redo() {
                            this.execute();
                        }

                        public void undo() {
                            EMFUpdateValueStrategyConversionErrorMessage.this.internalDoSet(root, features, origValue);
                        }
                    });
                } else {
                    this.internalDoSet(root, features, value);
                }
            }
            catch (Exception e) {
                return ValidationStatus.error((String)"Error setting value", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
        return super.doSet(observableValue, value);
    }

    private IStatus internalDoSet(EObject root, EStructuralFeature[] features, Object value) {
        EObject container = this.populateFeaturePath(root, features);
        if (container != null) {
            container.eSet(features[features.length - 1], value);
        }
        this.pruneEmptyFeaturePath(root, features);
        return Status.OK_STATUS;
    }

    private EObject populateFeaturePath(EObject root, EStructuralFeature[] features) {
        EObject container = root;
        if (features != null) {
            int i = 0;
            int count = features.length - 1;
            while (i < count) {
                EStructuralFeature feature = features[i];
                EObject childContainer = (EObject)container.eGet(feature);
                if (childContainer == null) {
                    EClass type = (EClass)feature.getEType();
                    childContainer = type.getEPackage().getEFactoryInstance().create(type);
                    container.eSet(feature, (Object)childContainer);
                }
                container = childContainer;
                ++i;
            }
        }
        return container;
    }

    private IStatus pruneEmptyFeaturePath(EObject root, EStructuralFeature[] features) {
        if (this._deleteEmptyContainers) {
            this.removeEmptyFeatures(features, 0, root);
        }
        return Status.OK_STATUS;
    }

    private void removeEmptyFeatures(EStructuralFeature[] features, int index, EObject container) {
        if (container == null || index >= features.length - 1) {
            return;
        }
        EObject childContainer = (EObject)container.eGet(features[index]);
        this.removeEmptyFeatures(features, index + 1, childContainer);
        if (ObservablesUtil.isEmpty(childContainer)) {
            container.eSet(features[index], null);
        }
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        return new ConverterWithErrorMessage(super.createConverter(fromType, toType));
    }

    private final class ConverterWithErrorMessage
    implements IConverter {
        private final IConverter _delegate;

        private ConverterWithErrorMessage(IConverter delegate) {
            this._delegate = delegate;
        }

        public Object convert(Object fromObject) {
            try {
                return this._delegate.convert(fromObject);
            }
            catch (RuntimeException e) {
                if (EMFUpdateValueStrategyConversionErrorMessage.this._message != null) {
                    throw new RuntimeException(EMFUpdateValueStrategyConversionErrorMessage.this._message, e);
                }
                throw e;
            }
        }

        public Object getFromType() {
            return this._delegate.getFromType();
        }

        public Object getToType() {
            return this._delegate.getToType();
        }
    }
}

