/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JcaPackage;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;

public abstract class JCAPropertyTable
extends Composite {
    private TableViewer _propertyTreeTable;
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private ListenerList _changeListeners;
    private IObservableValue _bindingValue;

    public JCAPropertyTable(Composite parent, int style, FormToolkit toolkit, DataBindingContext context, FeaturePath featurePathToProperties, EditingDomain domain) {
        this(parent, style, false, toolkit, context, featurePathToProperties, domain);
    }

    public JCAPropertyTable(Composite parent, int style, boolean isReadOnly, FormToolkit toolkit, DataBindingContext context, FeaturePath featurePathToProperties, EditingDomain domain) {
        super(parent, style);
        ObservableListContentProvider contentProvider;
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        this._bindingValue = new WritableValue(SWTObservables.getRealm((Display)this.getDisplay()), null, JCABinding.class);
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, true, 1, 5);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        nameColumn.getColumn().setText(Messages.label_name);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableViewerColumn valueColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        valueColumn.getColumn().setText(Messages.label_value);
        tableLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        IEMFValueProperty nameProperty = domain == null ? EMFProperties.value((EStructuralFeature)JcaPackage.Literals.PROPERTY__NAME) : EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)JcaPackage.Literals.PROPERTY__NAME);
        IEMFValueProperty valueProperty = domain == null ? EMFProperties.value((EStructuralFeature)JcaPackage.Literals.PROPERTY__VALUE) : EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)JcaPackage.Literals.PROPERTY__VALUE);
        IValueProperty cellEditorTextProperty = CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)24));
        ObservableTracker.setIgnore((boolean)true);
        try {
            contentProvider = new ObservableListContentProvider();
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        nameColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this._propertyTreeTable, (DataBindingContext)context, (CellEditor)new TextCellEditor((Composite)this._propertyTreeTable.getTable()), (IValueProperty)cellEditorTextProperty, (IValueProperty)nameProperty));
        nameColumn.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(nameProperty.observeDetail(contentProvider.getKnownElements())));
        valueColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this._propertyTreeTable, (DataBindingContext)context, (CellEditor)new TextCellEditor((Composite)this._propertyTreeTable.getTable()), (IValueProperty)cellEditorTextProperty, (IValueProperty)valueProperty));
        valueColumn.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(valueProperty.observeDetail(contentProvider.getKnownElements())));
        this._propertyTreeTable.setContentProvider((IContentProvider)contentProvider);
        this._mAddButton = toolkit.createButton((Composite)this, Messages.button_add, 0);
        this._mAddButton.setLayoutData((Object)new GridData(256));
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JCAPropertyTable.this.addPropertyToList();
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JCAPropertyTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = toolkit.createButton((Composite)this, Messages.button_remove, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(256));
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JCAPropertyTable.this.removeFromList();
            }
        });
        IObservableList propertiesList = (domain == null ? EMFProperties.list((FeaturePath)featurePathToProperties) : EMFEditProperties.list((EditingDomain)domain, (FeaturePath)featurePathToProperties)).observeDetail(this._bindingValue);
        this._propertyTreeTable.setInput((Object)propertiesList);
        this.updatePropertyButtons();
    }

    protected abstract void addPropertyToList();

    protected abstract void removeFromList();

    protected Property getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof Property) {
            return (Property)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._bindingValue.setValue((Object)target);
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }
}

