/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.switchyard.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.ElementHandlerImpl;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceImpl;

public class SwitchyardResourceFactoryImpl
extends ResourceFactoryImpl {
    public static final String CONTENT_TYPE = "org.switchyard.content-type.1.x";

    public Resource createResource(URI uri) {
        SwitchyardResourceImpl result = new SwitchyardResourceImpl(uri);
        NamespaceVersionConverter emd = new NamespaceVersionConverter();
        result.getDefaultSaveOptions().put("EXTENDED_META_DATA", emd);
        result.getDefaultLoadOptions().put("EXTENDED_META_DATA", emd);
        result.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        result.getDefaultLoadOptions().put("DOM_USE_NAMESPACES_IN_SCOPE", Boolean.TRUE);
        result.getDefaultLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        result.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        result.getDefaultSaveOptions().put("ELEMENT_HANDLER", new ElementHandlerImpl(true));
        result.getDefaultSaveOptions().put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        result.getDefaultSaveOptions().put("ENCODING", "UTF-8");
        return result;
    }

    public static final class NamespaceVersionConverter
    extends BasicExtendedMetaData {
        private static final String MODEL_NAMESPACE_VERSION;
        private static final Pattern SWITCHYARD_NAMESPACE_PATTERN;
        private static final int NAMESPACE_TYPE_GROUP = 1;
        private static final int NAMESPACE_VERSION_GROUP = 3;
        private String _version;

        static {
            SWITCHYARD_NAMESPACE_PATTERN = Pattern.compile("(urn:switchyard-(config:|component-).*?:)((1\\.\\d+(\\.\\d+)*)|(2.0))$");
            Matcher matcher = SWITCHYARD_NAMESPACE_PATTERN.matcher("urn:switchyard-config:switchyard:2.0");
            if (matcher.matches()) {
                MODEL_NAMESPACE_VERSION = matcher.group(3);
            } else {
                EcorePlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.switchyard.tools.models.switchyard1_0", "Unable to determine namespace version used by default SwitchYard EMF model.  Defaulting to 1.0."));
                MODEL_NAMESPACE_VERSION = "1.0";
            }
        }

        private NamespaceVersionConverter() {
        }

        public String getVersion() {
            return this._version;
        }

        public void setVersion(String version) {
            this._version = version;
        }

        public EPackage getPackage(String namespace) {
            return super.getPackage(this.convertToModelNamespace(namespace));
        }

        public EPackage demandPackage(String namespace) {
            return super.demandPackage(this.convertToModelNamespace(namespace));
        }

        protected EStructuralFeature basicGetGroup(EStructuralFeature eStructuralFeature) {
            String qualifiedName;
            EAnnotation eAnnotation = this.getAnnotation((EModelElement)eStructuralFeature, false);
            if (eAnnotation != null && (qualifiedName = (String)eAnnotation.getDetails().get((Object)"group")) != null) {
                int fragmentIndex = qualifiedName.lastIndexOf(35);
                if (fragmentIndex == -1) {
                    return this.getElement(eStructuralFeature.getEContainingClass(), this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), qualifiedName);
                }
                if (fragmentIndex == 0) {
                    return this.getElement(eStructuralFeature.getEContainingClass(), null, qualifiedName.substring(1));
                }
                return this.getElement(eStructuralFeature.getEContainingClass(), this.convertToInstanceNamespace(qualifiedName.substring(0, fragmentIndex)), qualifiedName.substring(fragmentIndex + 1));
            }
            return null;
        }

        protected EStructuralFeature basicGetAffiliation(EStructuralFeature eStructuralFeature) {
            String qualifiedName;
            EAnnotation eAnnotation = this.getAnnotation((EModelElement)eStructuralFeature, false);
            if (eAnnotation != null && (qualifiedName = (String)eAnnotation.getDetails().get((Object)"affiliation")) != null) {
                int fragmentIndex = qualifiedName.lastIndexOf(35);
                if (fragmentIndex == -1) {
                    return this.getElement(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), qualifiedName);
                }
                if (fragmentIndex == 0) {
                    return this.getElement(null, qualifiedName.substring(1));
                }
                return this.getElement(this.convertToInstanceNamespace(qualifiedName.substring(0, fragmentIndex)), qualifiedName.substring(fragmentIndex + 1));
            }
            return null;
        }

        public String getNamespace(EPackage ePackage) {
            return this.convertToInstanceNamespace(super.getNamespace(ePackage));
        }

        public String getNamespace(EStructuralFeature eStructuralFeature) {
            return this.convertToInstanceNamespace(super.getNamespace(eStructuralFeature));
        }

        public void setNamespace(EStructuralFeature eStructuralFeature, String namespace) {
            super.setNamespace(eStructuralFeature, this.convertToModelNamespace(namespace));
        }

        public String basicGetNamespace(EStructuralFeature eStructuralFeature) {
            return this.convertToModelNamespace(super.basicGetNamespace(eStructuralFeature));
        }

        private String convertToInstanceNamespace(String modelNamespace) {
            Matcher matcher;
            if (this._version != null && modelNamespace != null && (matcher = SWITCHYARD_NAMESPACE_PATTERN.matcher(modelNamespace)).matches()) {
                return String.valueOf(matcher.group(1)) + this._version;
            }
            return modelNamespace;
        }

        private String convertToModelNamespace(String namespace) {
            if (namespace == null) {
                return null;
            }
            Matcher matcher = SWITCHYARD_NAMESPACE_PATTERN.matcher(namespace);
            if (matcher.matches()) {
                if (this._version == null) {
                    this._version = matcher.group(3);
                }
                return String.valueOf(matcher.group(1)) + MODEL_NAMESPACE_VERSION;
            }
            return namespace;
        }
    }
}

