/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.TransformSequenceBreakpoint;
import org.switchyard.tools.ui.debug.ValidateHandlerBreakpoint;

public class SwitchYardDebugModelPresentation
implements IDebugModelPresentation {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource = null;
        if (element instanceof IBreakpoint) {
            element = ((IBreakpoint)element).getMarker();
        }
        if (element instanceof IMarker) {
            resource = ((IMarker)element).getResource();
        }
        if (resource == null || resource.getProject() == null || !resource.getProject().isAccessible()) {
            return null;
        }
        IFile file = SwitchYardProjectManager.instance().getSwitchYardProject(resource.getProject()).getSwitchYardConfigurationFile();
        if (file != null) {
            return new FileEditorInput(file);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        try {
            IEditorDescriptor descriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile()) : IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof IMarker) {
            element = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)element);
        }
        if (element instanceof DelegatingJavaBreakpoint) {
            return Activator.getDefault().getImageRegistry().get("icons/switchyard_icon_16px.png");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IMarker) {
            element = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)element);
        }
        if (element instanceof TransformSequenceBreakpoint) {
            return "Transform Breakpoint: " + ((IBreakpoint)element).getMarker().getResource().getName();
        }
        if (element instanceof ValidateHandlerBreakpoint) {
            return "Validate Breakpoint: " + ((IBreakpoint)element).getMarker().getResource().getName();
        }
        if (element instanceof DelegatingJavaBreakpoint) {
            DelegatingJavaBreakpoint breakpoint = (DelegatingJavaBreakpoint)element;
            IInteractionConfiguration config = breakpoint.getInteractionConfiguration();
            if (config.getConsumerName() == null) {
                if (config.getProviderName() == null) {
                    return String.format("SwitchYard Service: <all> on %s", config.getTriggers() == null ? IInteractionConfiguration.TriggerType.values() : config.getTriggers().toArray());
                }
                return String.format("SwitchYard PROVIDER: %s on %s", config.getProviderName().getLocalPart(), config.getTriggers());
            }
            if (config.getProviderName() == null) {
                return String.format("SwitchYard CONSUMER: %s on %s", config.getConsumerName().getLocalPart(), config.getTriggers());
            }
            return String.format("SwitchYard Service Intercept: %s to %s on %s", config.getConsumerName().getLocalPart(), config.getProviderName().getLocalPart(), config.getTriggers());
        }
        return element == null ? "" : element.toString();
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }
}

