/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.switchyard.tools.ui.debug.ConsumerCallbackProcessorBreakpoint;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.ErrorHandlingProcessorBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.InteractionConfigurationBuilder;
import org.switchyard.tools.ui.debug.PolicyHandlerBreakpoint;
import org.switchyard.tools.ui.debug.ProviderProcessorBreakpoint;
import org.switchyard.tools.ui.debug.SecurityHandlerBreakpoint;
import org.switchyard.tools.ui.debug.ServiceInterceptBreakpoint;
import org.switchyard.tools.ui.debug.SwitchYardDebugUtil;
import org.switchyard.tools.ui.debug.TransactionHandlerBreakpoint;
import org.switchyard.tools.ui.debug.TransformHandlerBreakpoint;
import org.switchyard.tools.ui.debug.ValidateConfigurationBuilder;
import org.switchyard.tools.ui.debug.ValidateHandlerBreakpoint;

public class ServiceInteractionBreakpoint
extends DelegatingJavaBreakpoint<IInteractionConfiguration.AspectType> {
    private static final String MARKER_ID = "org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker";

    public ServiceInteractionBreakpoint() {
    }

    public ServiceInteractionBreakpoint(IResource resource, IInteractionConfiguration configuration, boolean register) throws DebugException {
        super(resource, configuration, register, MARKER_ID);
    }

    @Override
    protected void createDelegates() throws CoreException {
        IResource resource = this.getMarker().getResource();
        IInteractionConfiguration configuration = this.getInteractionConfiguration();
        Set<IInteractionConfiguration.TriggerType> triggers = configuration.getTriggers();
        Set<IInteractionConfiguration.AspectType> aspects = configuration.getAspects();
        boolean enabled = this.isEnabled();
        this.addDelegate(IInteractionConfiguration.AspectType.ENTRY, enabled, triggers, aspects, new ServiceInterceptBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.ENTRY), false){

            @Override
            protected SwitchYardDebugUtil.ServiceType getTargetType() {
                return SwitchYardDebugUtil.ServiceType.CONSUMER;
            }
        });
        this.addDelegate(IInteractionConfiguration.AspectType.TARGET_INVOCATION, enabled, triggers, aspects, new ProviderProcessorBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.TARGET_INVOCATION), false));
        this.addDelegate(IInteractionConfiguration.AspectType.RETURN, enabled, triggers, aspects, new ConsumerCallbackProcessorBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.RETURN), false));
        this.addDelegate(IInteractionConfiguration.AspectType.FAULT, enabled, triggers, aspects, new ErrorHandlingProcessorBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.FAULT), false));
        this.addDelegate(IInteractionConfiguration.AspectType.TRANSACTION, enabled, triggers, aspects, new TransactionHandlerBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.TRANSACTION), false));
        this.addDelegate(IInteractionConfiguration.AspectType.SECURITY, enabled, triggers, aspects, new SecurityHandlerBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.SECURITY), false));
        this.addDelegate(IInteractionConfiguration.AspectType.POLICY, enabled, triggers, aspects, new PolicyHandlerBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.POLICY), false));
        this.addDelegate(IInteractionConfiguration.AspectType.VALIDATION, enabled, triggers, aspects, new ValidateHandlerBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.VALIDATION), ValidateConfigurationBuilder.create().build(), false));
        this.addDelegate(IInteractionConfiguration.AspectType.TRANSFORMATION, enabled, triggers, aspects, new TransformHandlerBreakpoint(resource, this.transformInterceptConfiguration(configuration, IInteractionConfiguration.AspectType.TRANSFORMATION), false));
    }

    private void addDelegate(IInteractionConfiguration.AspectType aspect, boolean enabled, Set<IInteractionConfiguration.TriggerType> triggers, Set<IInteractionConfiguration.AspectType> aspects, JavaBreakpoint delegate) throws CoreException {
        if (!this.shouldEnable(aspect, enabled, triggers, aspects)) {
            delegate.setEnabled(false);
        }
        this.addDelegate(aspect, delegate);
    }

    @Override
    protected void configurationUpdated() throws CoreException {
        IInteractionConfiguration configuration = this.getInteractionConfiguration();
        for (Map.Entry entry : this.getDelegates().entrySet()) {
            JavaBreakpoint delegate = entry.getValue();
            if (!(delegate instanceof DelegatingJavaBreakpoint)) continue;
            try {
                ((DelegatingJavaBreakpoint)delegate).setInteractionConfiguration(this.transformInterceptConfiguration(configuration, (IInteractionConfiguration.AspectType)((Object)entry.getKey())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateEnabled(this.isEnabled());
        super.configurationUpdated();
    }

    @Override
    protected void updateEnabled(boolean enabled) throws CoreException {
        if (enabled) {
            IInteractionConfiguration iInteractionConfiguration = this.getInteractionConfiguration();
            Set<IInteractionConfiguration.TriggerType> triggers = iInteractionConfiguration.getTriggers();
            Set<IInteractionConfiguration.AspectType> aspects = iInteractionConfiguration.getAspects();
            for (Map.Entry entry : this.getDelegates().entrySet()) {
                JavaBreakpoint delegate;
                boolean shouldEnable = this.shouldEnable((IInteractionConfiguration.AspectType)((Object)entry.getKey()), enabled, triggers, aspects);
                if (shouldEnable == (delegate = entry.getValue()).isEnabled()) continue;
                try {
                    delegate.setEnabled(shouldEnable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (IBreakpoint iBreakpoint : this.getDelegates().values()) {
                try {
                    if (!iBreakpoint.isEnabled()) continue;
                    iBreakpoint.setEnabled(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean shouldEnable(IInteractionConfiguration.AspectType aspect, boolean enabled, Set<IInteractionConfiguration.TriggerType> triggers, Set<IInteractionConfiguration.AspectType> aspects) {
        return enabled && (aspects == null || aspects.contains((Object)aspect)) && aspect.shouldEnable(triggers);
    }

    private IInteractionConfiguration transformInterceptConfiguration(IInteractionConfiguration configuration, IInteractionConfiguration.AspectType aspect) {
        InteractionConfigurationBuilder builder = InteractionConfigurationBuilder.createFrom(configuration);
        Set<IInteractionConfiguration.TriggerType> triggers = configuration.getTriggers();
        Set<IInteractionConfiguration.TriggerType> supportedTriggers = aspect.getSupportedTriggers();
        if (triggers == null) {
            builder.triggers(supportedTriggers);
        } else if (supportedTriggers != null) {
            triggers.retainAll(supportedTriggers);
        }
        builder.triggers(triggers);
        return builder.build();
    }
}

