/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.extensions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.provider.ext.ICustomDblClickHandler;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.RouteContainer;
import org.jboss.tools.fuse.transformation.camel.EndpointHelper;

public class TransformationDblClickHandler
implements ICustomDblClickHandler {
    public boolean canHandle(AbstractNode clickedNode) {
        if (clickedNode instanceof Endpoint) {
            String refUri;
            Endpoint endpoint = (Endpoint)clickedNode;
            RouteContainer c = endpoint.getParent().getParent();
            String id = endpoint.getUri().substring(new String("ref:").length());
            if (id != null && (refUri = (String)c.getCamelContextEndpointUris().get(id)) != null && refUri.startsWith("dozer:")) {
                return true;
            }
        }
        return false;
    }

    private String getEndpointParameter(String uri, String key) {
        StringBuilder uriStr = new StringBuilder(uri);
        if (uriStr.indexOf(String.valueOf(key) + "=") < 0) {
            throw new IllegalArgumentException("Endpoint does not contain parameter: " + key);
        }
        int startIdx = uriStr.indexOf(key);
        int endIdx = uriStr.indexOf("&", startIdx);
        if (endIdx < 0) {
            endIdx = uriStr.length();
        }
        return uriStr.substring(startIdx + (String.valueOf(key) + '=').length(), endIdx);
    }

    public void handleDoubleClick(AbstractNode clickedNode) {
        if (clickedNode instanceof Endpoint) {
            String refUri;
            Endpoint endpoint = (Endpoint)clickedNode;
            RouteContainer c = endpoint.getParent().getParent();
            String id = endpoint.getUri().substring(new String("ref:").length());
            if (id != null && (refUri = (String)c.getCamelContextEndpointUris().get(id)) != null && refUri.startsWith("dozer:")) {
                String filename = this.getEndpointParameter(refUri, EndpointHelper.MAPPING_FILE);
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getEditors(filename, Platform.getContentTypeManager().getContentType("org.jboss.tools.fuse.transformation.editor.dozer-config-content-type"))[0];
                IEditorInput element = Activator.getDiagramEditor().getEditorInput();
                if (element instanceof IFileEditorInput) {
                    IFileEditorInput input = (IFileEditorInput)element;
                    IFile res = input.getFile();
                    try {
                        res.getProject().refreshLocal(2, null);
                        Path tempPath = new Path(filename);
                        IFile xmlFile = res.getProject().getFile((IPath)tempPath);
                        if (xmlFile != null && !xmlFile.exists()) {
                            tempPath = new Path("src/main/resources/" + filename);
                            xmlFile = res.getProject().getFile((IPath)tempPath);
                            if (xmlFile != null && !xmlFile.exists()) {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Transformation File Not Accessible", (String)("The Transformation file (" + filename + ") is not accessible in the Camel project."));
                                return;
                            }
                        }
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(xmlFile), desc.getId());
                    }
                    catch (Exception e) {
                        Activator.showUserError((String)"Exception Opening Transformation File", (String)("The Transformation file (" + filename + ") is not accessible in the Camel project."), (Exception)e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

