/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.fuse.transformation.camel.CamelConfigBuilder;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelConfigurationHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelFileTypeHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.internal.util.TestGenerator;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;

public class TransformTestWizardPage
extends NewTypeWizardPage {
    protected static final String CAMEL_FILE_PATH = "TransformTestWizardPage.CamelFilePath";
    protected static final String ENDPOINT = "TransformTestWizardPage.Endpoint";
    private ComboViewer transformationIDViewer;
    private Text _camelFilePathText;
    private IProject _project;
    private IJavaProject _javaProject;
    private IFile _camelConfigFile;
    private CamelConfigBuilder _builder = null;
    private String _transformID = null;
    private String _camelFilePath = null;
    private IResource _generatedClassResource;
    private IStatus _camelFileSelectedStatus = Status.OK_STATUS;
    private IStatus _camelEndpointSelectedStatus = Status.OK_STATUS;

    public TransformTestWizardPage() {
        super(true, TransformTestWizardPage.class.getSimpleName());
        this.setImageDescriptor(Activator.imageDescriptor("transform.png"));
        this.setTitle("New Transformation Test");
        this.setDescription("Specify the transformation endpoint to test, then provide the camel configuration, class name and java package for the generated test class.");
    }

    private void createCamelSpecificControls(Composite composite, int nColumns) {
        Label label = new Label(composite, 0);
        label.setText("Camel File Path:");
        label.setToolTipText("The path to the Camel configuration file. Select 'Browse...' to choose a file.");
        this._camelFilePathText = new Text(composite, 2056);
        this._camelFilePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._camelFilePathText.setToolTipText(label.getToolTipText());
        this._camelFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TransformTestWizardPage.this.handleFieldChanged(TransformTestWizardPage.CAMEL_FILE_PATH);
            }
        });
        Button camelPathButton = new Button(composite, 0);
        camelPathButton.setText("Browse...");
        camelPathButton.setToolTipText("Browse to select an available Camel file.");
        camelPathButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        camelPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransformTestWizardPage.this._builder = null;
                IResource res = Util.selectCamelResourceFromWorkspace(TransformTestWizardPage.this.getShell(), TransformTestWizardPage.this._project);
                if (res != null) {
                    String path = "";
                    try {
                        IFile camelConfigFile;
                        IPath respath = JavaUtil.getJavaPathForResource(res);
                        if (res != null && TransformTestWizardPage.this._project == null) {
                            TransformTestWizardPage.this._project = res.getProject();
                            TransformTestWizardPage.this._javaProject = JavaCore.create((IProject)TransformTestWizardPage.this._project);
                        }
                        if (TransformTestWizardPage.this._javaProject != null) {
                            IFolder srcFolder = TransformTestWizardPage.this._javaProject.getProject().getFolder("src/test/java");
                            IPackageFragmentRoot root = TransformTestWizardPage.this._javaProject.getPackageFragmentRoot((IResource)srcFolder);
                            TransformTestWizardPage.this.initContainerPage((IJavaElement)root);
                        }
                        if ((camelConfigFile = (IFile)TransformTestWizardPage.this._project.findMember(respath)) == null) {
                            IPath newrespath = new Path("src/main/resources/").append(respath);
                            camelConfigFile = (IFile)TransformTestWizardPage.this._project.findMember(newrespath);
                        }
                        if (camelConfigFile != null) {
                            path = respath.makeRelative().toString();
                            TransformTestWizardPage.this._camelFilePath = camelConfigFile.getProjectRelativePath().toPortableString();
                            File file = new File(camelConfigFile.getLocationURI());
                            boolean isValid = CamelFileTypeHelper.isSupportedCamelFile(TransformTestWizardPage.this._project, TransformTestWizardPage.this._camelFilePath);
                            if (isValid) {
                                TransformTestWizardPage.this._builder = CamelConfigurationHelper.load(file).getConfigBuilder();
                                TransformTestWizardPage.this._camelFileSelectedStatus = Status.OK_STATUS;
                            } else {
                                TransformTestWizardPage.this._builder = null;
                                TransformTestWizardPage.this._camelFileSelectedStatus = (IStatus)new Status(4, Activator.PLUGIN_ID, "File selected is not a Camel Spring or Blueprint file. Please select another file.");
                            }
                            if (TransformTestWizardPage.this._builder != null) {
                                TransformTestWizardPage.this.transformationIDViewer.getCombo().removeAll();
                                TransformTestWizardPage.this.transformationIDViewer.add(TransformTestWizardPage.this._builder.getTransformEndpointIds().toArray());
                            }
                        }
                    }
                    catch (Exception e) {
                        Activator.error(e);
                    }
                    if (TransformTestWizardPage.this._builder == null || TransformTestWizardPage.this._builder != null && TransformTestWizardPage.this._builder.getTransformEndpointIds().isEmpty()) {
                        TransformTestWizardPage.this.transformationIDViewer.getCombo().removeAll();
                        TransformTestWizardPage.this.transformationIDViewer.getCombo().setToolTipText("No transformation endpoints available");
                        TransformTestWizardPage.this._camelEndpointSelectedStatus = (IStatus)new Status(2, Activator.PLUGIN_ID, "No transformation endpoints available for the selected Camel file.");
                    } else {
                        TransformTestWizardPage.this._camelEndpointSelectedStatus = (IStatus)new Status(1, Activator.PLUGIN_ID, "Select from the list of available transformation endpoints");
                        TransformTestWizardPage.this.transformationIDViewer.getCombo().setToolTipText("Select from the list of available transformation endpoints");
                    }
                    TransformTestWizardPage.this._camelFilePathText.setText(path);
                    TransformTestWizardPage.this.handleFieldChanged(TransformTestWizardPage.CAMEL_FILE_PATH);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("Transformation ID:");
        label.setToolTipText("Transformation endpoint to test");
        this.transformationIDViewer = new ComboViewer(new Combo(composite, 8));
        this.transformationIDViewer.getCombo().setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).create());
        this.transformationIDViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        if (this._camelFilePath != null) {
            this._camelFilePathText.setText(this._camelFilePath);
        }
        boolean noEndpoints = true;
        this.transformationIDViewer.getCombo().removeAll();
        if (this._builder != null) {
            this.transformationIDViewer.add(this._builder.getTransformEndpointIds().toArray());
            noEndpoints = this._builder.getTransformEndpointIds().isEmpty();
        }
        if (!noEndpoints) {
            this.transformationIDViewer.getCombo().setToolTipText("Select from the list of available transformation endpoints");
            this._camelEndpointSelectedStatus = new Status(1, Activator.PLUGIN_ID, "Select from the list of available transformation endpoints");
        } else {
            this.transformationIDViewer.getCombo().setToolTipText("No transformation endpoints available");
            this._camelEndpointSelectedStatus = new Status(2, Activator.PLUGIN_ID, "No transformation endpoints available for the selected Camel file.");
        }
        this.transformationIDViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransformTestWizardPage.this._transformID = (String)((IStructuredSelection)TransformTestWizardPage.this.transformationIDViewer.getSelection()).getFirstElement();
                TransformTestWizardPage.this._camelEndpointSelectedStatus = Status.OK_STATUS;
                TransformTestWizardPage.this.handleFieldChanged(TransformTestWizardPage.ENDPOINT);
            }
        });
        this.doStatusUpdate();
        this.setErrorMessage(null);
    }

    private ICompilationUnit createJavaClass(String packageName, String className, IJavaProject project) {
        boolean isBlueprint;
        boolean isSpring;
        block19: {
            isSpring = CamelFileTypeHelper.isSpringFile(project.getProject(), this._camelFilePath);
            isBlueprint = CamelFileTypeHelper.isBlueprintFile(project.getProject(), this._camelFilePath);
            if (isSpring || isBlueprint) break block19;
            return null;
        }
        try {
            IFolder srcFolder;
            IFolder folder;
            IPath srcPath = null;
            if (this.getPackageFragmentRoot() != null) {
                srcPath = this.getPackageFragmentRoot().getPath().makeAbsolute();
                srcPath = srcPath.removeFirstSegments(1);
                folder = this._javaProject.getProject().getFolder(srcPath);
                if (!JavaUtil.findFolderOnProjectClasspath(this._javaProject, (IResource)folder)) {
                    JavaUtil.addFolderToProjectClasspath(this._javaProject, (IResource)folder);
                }
                if (!folder.exists()) {
                    try {
                        folder.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                folder = this._javaProject.getProject().getFolder("src/test/java");
                if (!folder.exists()) {
                    IFolder javaFolder;
                    IFolder testFolder;
                    IFolder srcFolder2 = this._javaProject.getProject().getFolder("src");
                    if (!srcFolder2.exists()) {
                        srcFolder2.create(true, true, null);
                    }
                    if (!(testFolder = srcFolder2.getFolder("test")).exists()) {
                        testFolder.create(true, true, null);
                    }
                    if (!(javaFolder = testFolder.getFolder("java")).exists()) {
                        javaFolder.create(true, true, null);
                    }
                }
                if (!JavaUtil.findFolderOnProjectClasspath(this._javaProject, (IResource)folder)) {
                    JavaUtil.addFolderToProjectClasspath(this._javaProject, (IResource)folder);
                }
                srcPath = folder.getProjectRelativePath();
            }
            if ((srcFolder = project.getProject().getFolder(srcPath)) == null || !srcFolder.exists()) {
                srcPath = project.getPath().append(srcPath.makeRelativeTo(project.getProject().getLocation()));
                srcFolder = project.getProject().getFolder(srcPath);
            }
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)srcFolder);
            if (packageName == null) {
                packageName = "";
            }
            if (root != null) {
                IPackageFragment pkg = root.createPackageFragment(packageName, false, null);
                StringBuffer clsContent = new StringBuffer();
                String filePath = this.getCamelFilePath();
                IResource res = project.getProject().findMember(filePath);
                IPath respath = JavaUtil.getJavaPathForResource(res);
                filePath = respath.makeRelative().toString();
                if (isSpring || isBlueprint) {
                    String codeTemplate = TestGenerator.createTransformTestText(this._transformID, packageName, className, filePath, isSpring);
                    if (codeTemplate != null) {
                        clsContent.append(codeTemplate);
                    }
                    ICompilationUnit wrapperCls = pkg.createCompilationUnit(String.valueOf(className) + ".java", clsContent.toString(), true, null);
                    wrapperCls.save(null, true);
                    return wrapperCls;
                }
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        ICompilationUnit createdClass = this.createJavaClass(this.getPackageText(), this.getTypeName(), this._javaProject);
        if (createdClass != null) {
            this._generatedClassResource = createdClass.getResource();
        }
    }

    public IResource getGeneratedResource() {
        return this._generatedClassResource;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCamelSpecificControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.doStatusUpdate();
        this.updateStatus((IStatus)new Status(0, Activator.PLUGIN_ID, "Specify the transformation endpoint to test, then provide the camel configuration, class name and java package for the generated test class."));
        this.setErrorMessage(null);
    }

    public boolean isPageComplete() {
        boolean endpointSelected = this.getTransformID() != null && !this.getTransformID().trim().isEmpty();
        boolean sourceFolderSpecified = this.getPackageFragmentRoot() != null || this.getPackageFragmentRootText() != null && this.getPackageFragmentRootText().endsWith("src/test/java");
        boolean classNameSpecified = this.getTypeName() != null;
        boolean superComplete = super.isPageComplete();
        return superComplete && endpointSelected && sourceFolderSpecified && classNameSpecified;
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this._javaProject = javaProject;
    }

    public IFile getDozerConfigFile() {
        return this._camelConfigFile;
    }

    public void setCamelConfigFile(IFile dozerConfigFile) {
        this._camelConfigFile = dozerConfigFile;
        if (dozerConfigFile != null) {
            this._camelFilePath = this._camelConfigFile.getProjectRelativePath().toPortableString();
        }
    }

    public CamelConfigBuilder getBuilder() {
        return this._builder;
    }

    public void setBuilder(CamelConfigBuilder builder) {
        this._builder = builder;
    }

    public String getTransformID() {
        return this._transformID;
    }

    public void setTransformID(String transformID) {
        this._transformID = transformID;
    }

    public String getCamelFilePath() {
        return this._camelFilePath;
    }

    public void setCamelFilePath(String path) {
        this._camelFilePath = path;
    }

    private void doStatusUpdate() {
        if (this.fContainerStatus.getMessage() != null && this.fContainerStatus.getMessage().endsWith("does not exist.") && this.getPackageFragmentRootText().endsWith("src/test/java")) {
            this.fContainerStatus = new StatusInfo(0, null);
        }
        if (this.fPackageStatus.getCode() == 4 && (this.fPackageStatus.getMessage() == null || this.fPackageStatus.getMessage().trim().isEmpty())) {
            this.fPackageStatus = new StatusInfo(0, null);
        } else if (this.fPackageStatus.getCode() == 2 && this.fPackageStatus.getMessage() != null && this.fPackageStatus.getMessage().contains("default package is discouraged")) {
            this.fPackageStatus = new StatusInfo(0, null);
        }
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this._camelFileSelectedStatus, this._camelEndpointSelectedStatus};
        this.updateStatus(status);
        IStatus currStatus = StatusUtil.getMostSevere((IStatus[])status);
        this.setPageComplete(currStatus.isOK());
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.setTypeName("TransformationTest", true);
        this.doStatusUpdate();
    }
}

