/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ClasspathResourceSelectionDialog
extends FilteredResourcesSelectionDialog {
    Set<String> fileExtensions;
    IJavaModel fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    public ClasspathResourceSelectionDialog(Shell parentShell, IContainer container, String title) {
        this(parentShell, container, Collections.emptySet(), title);
    }

    public ClasspathResourceSelectionDialog(Shell parentShell, IContainer container, String fileExtension, String title) {
        this(parentShell, container, fileExtension == null ? Collections.emptySet() : Collections.singleton(fileExtension), title);
    }

    public ClasspathResourceSelectionDialog(Shell parentShell, IContainer container, Set<String> fileExtensions, String title) {
        super(parentShell, false, container, 1);
        this.fileExtensions = fileExtensions == null ? Collections.emptySet() : fileExtensions;
        this.setTitle(title);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ClasspathResourceFilter();
    }

    class ClasspathResourceFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        ClasspathResourceFilter() {
            super((FilteredResourcesSelectionDialog)ClasspathResourceSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            IResource resource = (IResource)item;
            return super.matchItem(item) && (ClasspathResourceSelectionDialog.this.fileExtensions == null || ClasspathResourceSelectionDialog.this.fileExtensions.isEmpty() || ClasspathResourceSelectionDialog.this.fileExtensions.contains(resource.getFullPath().getFileExtension())) && this.select(resource);
        }

        private boolean isParentOnClassPath(IJavaProject javaProject, IResource resource) {
            boolean flag = false;
            while (!flag && resource.getParent() != null) {
                flag = javaProject.isOnClasspath(resource);
                if (!flag) {
                    resource = resource.getParent();
                    continue;
                }
                return flag;
            }
            return flag;
        }

        private boolean select(IResource resource) {
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                return javaProject != null && this.isParentOnClassPath(javaProject, resource) || project.getNature("org.eclipse.jdt.core.javanature") != null && ClasspathResourceSelectionDialog.this.fJavaModel.contains(resource);
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return filter instanceof ClasspathResourceFilter && super.equalsFilter(filter);
        }
    }
}

