/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.fusesource.ide.commons.contenttype.BlueprintXmlMatchingStrategy;
import org.fusesource.ide.commons.contenttype.SpringXmlMatchingStrategy;
import org.fusesource.ide.commons.contenttype.XmlMatchingStrategySupport;

public final class CamelFileTypeHelper {
    private static XmlMatchingStrategySupport blueprintXmlMatcher = new BlueprintXmlMatchingStrategy();
    private static XmlMatchingStrategySupport springXmlMatcher = new SpringXmlMatchingStrategy();

    public static boolean isBlueprintFile(IProject project, String filePath) {
        return CamelFileTypeHelper.fileMatches(project, filePath, blueprintXmlMatcher);
    }

    public static boolean isSpringFile(IProject project, String filePath) {
        return CamelFileTypeHelper.fileMatches(project, filePath, springXmlMatcher);
    }

    public static boolean isSupportedCamelFile(IProject project, String filePath) {
        boolean isSpring = CamelFileTypeHelper.isSpringFile(project, filePath);
        boolean isBlueprint = CamelFileTypeHelper.isBlueprintFile(project, filePath);
        return isSpring || isBlueprint;
    }

    private static boolean fileMatches(IProject project, String filePath, XmlMatchingStrategySupport matcher) {
        boolean matches = false;
        if (filePath != null && filePath.trim().length() > 0) {
            String rawPath = null;
            if (filePath.startsWith("file:")) {
                rawPath = filePath.substring(5);
            } else {
                IPath wholePath = project.getLocation().append(filePath);
                rawPath = wholePath.toPortableString();
            }
            Path fp = new Path(rawPath);
            File nf = new File(fp.toOSString());
            if (nf.exists() && nf.isFile()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath location = Path.fromOSString((String)nf.getAbsolutePath());
                IFile file = workspace.getRoot().getFileForLocation(location);
                matches = matcher.matches(file);
            }
        }
        return matches;
    }
}

