/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.fuse.transformation.Expression;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.MappingType;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.model.Model;

abstract class MappingViewer {
    final TransformationConfig config;
    MappingOperation<?, ?> mapping;
    Text sourceText;
    Text targetText;
    DropTarget sourceDropTarget;
    DropTarget targetDropTarget;
    final List<PotentialDropTarget> potentialDropTargets;

    MappingViewer(TransformationConfig config, List<PotentialDropTarget> potentialDropTargets) {
        this.config = config;
        this.potentialDropTargets = potentialDropTargets;
    }

    void createSourceText(Composite parent, int style) {
        this.sourceText = this.createText(parent, style);
        this.setSourceText();
        this.sourceDropTarget = new DropTarget((Control)this.sourceText, 2);
        this.sourceDropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        this.sourceDropTarget.addDropListener((DropTargetListener)new DropListener(this, this.sourceText){

            @Override
            boolean draggingFromValidObject() {
                return Util.draggingFromValidSource(config) && Util.validSourceAndTarget(Util.draggedObject(), mapping.getTarget(), config);
            }

            @Override
            void drop() throws Exception {
                this.dropOnSource();
            }
        });
        this.potentialDropTargets.add(new PotentialDropTarget((Control)this.sourceText){

            @Override
            public boolean valid() {
                return MappingViewer.this.mapping.getType() != MappingType.CUSTOM && Util.draggingFromValidSource(MappingViewer.this.config) && Util.validSourceAndTarget(Util.draggedObject(), MappingViewer.this.mapping.getTarget(), MappingViewer.this.config);
            }
        });
    }

    void createTargetText(Composite parent) {
        this.targetText = this.createText(parent, 0);
        this.setTargetText();
        this.targetDropTarget = new DropTarget((Control)this.targetText, 2);
        this.targetDropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        this.targetDropTarget.addDropListener((DropTargetListener)new DropListener(this, this.targetText){

            @Override
            boolean draggingFromValidObject() {
                return Util.draggingFromValidTarget(config) && Util.validSourceAndTarget(mapping.getSource(), Util.draggedObject(), config);
            }

            @Override
            void drop() throws Exception {
                this.dropOnTarget();
            }
        });
        this.potentialDropTargets.add(new PotentialDropTarget((Control)this.targetText){

            @Override
            public boolean valid() {
                return MappingViewer.this.mapping.getType() != MappingType.CUSTOM && Util.draggingFromValidTarget(MappingViewer.this.config) && Util.validSourceAndTarget(MappingViewer.this.mapping.getSource(), Util.draggedObject(), MappingViewer.this.config);
            }
        });
    }

    Text createText(Composite parent, int style) {
        Text text = new Text(parent, style | 0x800);
        text.setEditable(false);
        return text;
    }

    void dispose() {
        this.sourceDropTarget.dispose();
        this.targetDropTarget.dispose();
        Iterator<PotentialDropTarget> iter = this.potentialDropTargets.iterator();
        while (iter.hasNext()) {
            PotentialDropTarget potentialDropTarget = iter.next();
            if (potentialDropTarget.control != this.sourceText && potentialDropTarget.control != this.targetText) continue;
            iter.remove();
        }
    }

    void dropOnSource() throws Exception {
        this.mapping = this.config.setSource(this.mapping, Util.draggedObject());
        this.config.save();
    }

    void dropOnTarget() throws Exception {
        this.mapping = this.config.setTarget(this.mapping, (Model)Util.draggedObject());
        this.config.save();
    }

    boolean equals(MappingOperation<?, ?> mapping, Object object) {
        if (mapping == object) {
            return true;
        }
        if (mapping == null || object == null) {
            return false;
        }
        if (!(object instanceof MappingOperation)) {
            return false;
        }
        MappingOperation mapping2 = (MappingOperation)object;
        if (mapping.getSource() == mapping2.getSource() && mapping.getTarget() == mapping2.getTarget()) {
            return true;
        }
        if (mapping.getSource() != null && !mapping.getSource().equals(mapping2.getSource())) {
            return false;
        }
        return mapping.getTarget() == null || mapping.getTarget().equals(mapping2.getTarget());
    }

    String name(Object object) {
        if (object instanceof Model) {
            return ((Model)object).getName();
        }
        if (object instanceof Variable) {
            return "${" + ((Variable)object).getName() + "}";
        }
        if (object instanceof Expression) {
            return ((Expression)object).getLanguage();
        }
        return "";
    }

    void setSourceText() {
        this.setText(this.sourceText, this.mapping.getSource());
    }

    void setTargetText() {
        this.setText(this.targetText, this.mapping.getTarget());
    }

    private void setText(Text text, Object object) {
        text.setText(this.name(object));
        if (object instanceof Model) {
            Model model = (Model)object;
            text.setToolTipText(this.config.fullyQualifiedName(model));
            if (this.mapping.getType() == MappingType.CUSTOM && text == this.sourceText) {
                text.setBackground(Util.Colors.FUNCTION);
            } else {
                text.setBackground(Util.Colors.BACKGROUND);
            }
            text.setForeground(Util.Colors.FOREGROUND);
        } else if (object instanceof Variable) {
            text.setToolTipText(this.variableToolTip((Variable)object));
            text.setBackground(Util.Colors.BACKGROUND);
            text.setForeground(Util.Colors.VARIABLE);
        } else if (object instanceof Expression) {
            text.setToolTipText(((Expression)object).getExpression().replace("\\${", "${"));
            text.setBackground(Util.Colors.BACKGROUND);
            text.setForeground(Util.Colors.EXPRESSION);
        } else {
            text.setToolTipText("");
            text.setBackground(Util.Colors.BACKGROUND);
            text.setForeground(Util.Colors.FOREGROUND);
        }
    }

    String variableToolTip(Variable variable) {
        return "\"" + variable.getValue() + "\"";
    }

    void variableValueUpdated(Variable variable) {
        if (variable.equals(this.mapping.getSource())) {
            this.sourceText.setToolTipText(this.variableToolTip(variable));
        }
    }

    abstract class DropListener
    extends DropTargetAdapter {
        private final Text dropText;
        private Color background;
        private Color foreground;

        DropListener(Text dropText) {
            this.dropText = dropText;
        }

        public final void dragEnter(DropTargetEvent event) {
            this.background = this.dropText.getBackground();
            this.foreground = this.dropText.getForeground();
            if (MappingViewer.this.mapping.getType() != MappingType.CUSTOM && this.draggingFromValidObject()) {
                this.dropText.setBackground(Util.Colors.DROP_TARGET_BACKGROUND);
                this.dropText.setForeground(Util.Colors.DROP_TARGET_FOREGROUND);
            } else {
                event.detail = 0;
            }
        }

        abstract boolean draggingFromValidObject();

        public final void dragLeave(DropTargetEvent event) {
            this.dropText.setBackground(this.background);
            this.dropText.setForeground(this.foreground);
        }

        abstract void drop() throws Exception;

        public final void drop(DropTargetEvent event) {
            try {
                if (this.draggingFromValidObject()) {
                    this.drop();
                }
            }
            catch (Exception e) {
                Activator.error(e);
            }
        }
    }
}

