/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.switchyard.tools.ui.debug.InteractionConfigurationBuilder;
import org.switchyard.tools.ui.debug.ServiceInteractionBreakpoint;

public class SwitchYardStepHandler
implements IDebugEventSetListener {
    public static final String STEP_MARKER = SwitchYardStepHandler.class.getCanonicalName();
    private final IJavaThread _thread;
    private ServiceInteractionBreakpoint _breakpoint;

    public SwitchYardStepHandler(IJavaThread thread) {
        this._thread = thread;
    }

    public void step() throws CoreException {
        IDebugTarget debugTarget = this._thread.getDebugTarget();
        this._breakpoint = new ServiceInteractionBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), InteractionConfigurationBuilder.create().build(), false);
        this._breakpoint.setThreadFilter(this._thread);
        this._breakpoint.getMarker().setAttribute(STEP_MARKER, true);
        debugTarget.breakpointAdded((IBreakpoint)this._breakpoint);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        try {
            this._thread.resume();
        }
        catch (Exception exception) {
            this.cleanup();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (!(source != this._thread && source != this._thread.getDebugTarget() || event.getKind() != 2 && event.getKind() != 8)) {
                this.cleanup();
            }
            ++n2;
        }
    }

    private void cleanup() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        IDebugTarget target = this._thread.getDebugTarget();
        if (this._breakpoint != null) {
            target.breakpointRemoved((IBreakpoint)this._breakpoint, null);
            Job cleanupJob = new Job("Cleanup SwitchYard Bus Step Breakpoints"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        SwitchYardStepHandler.this._breakpoint.delete();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    SwitchYardStepHandler.this._breakpoint = null;
                    return Status.OK_STATUS;
                }
            };
            cleanupJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            cleanupJob.schedule();
        }
    }
}

