/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validator.wizards;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.models.switchyard1_0.validate.JavaValidateType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.AbstractSwitchyardComposite;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.validator.wizards.BaseValidatorComposite;

public class JavaValidatorComposite
extends BaseValidatorComposite {
    private Text _classText;
    private Button _browseButton;
    private Text _beanText;
    private Button _javaClassOption;
    private Button _beanOption;

    JavaValidatorComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        super.createContents(parent, style, context);
        this.getToolkit().createLabel(this.getPanel(), null, 0);
        Group inner = new Group(this.getPanel(), 0);
        inner.setText(Messages.label_javaValidatorType);
        this.getToolkit().adapt((Composite)inner);
        GridData innerGD = new GridData(4, 0, true, false, 2, 1);
        innerGD.horizontalIndent = -5;
        innerGD.verticalIndent = -5;
        inner.setLayoutData((Object)innerGD);
        inner.setLayout((Layout)new GridLayout(3, false));
        this._javaClassOption = this.getToolkit().createButton((Composite)inner, Messages.label_javaClass, 16);
        this._javaClassOption.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                JavaValidatorComposite.this.handleSelectedOption((Control)JavaValidatorComposite.this._javaClassOption);
            }
        });
        this.addGridData((Control)this._javaClassOption, 3, 0);
        this._classText = this.createLabelAndText((Composite)inner, Messages.label_class);
        this._browseButton = this.getToolkit().createButton((Composite)inner, Messages.button_browse, 8);
        this._browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaValidatorComposite.this.handleBrowse(JavaValidatorComposite.this._classText);
                JavaValidatorComposite.this.validate();
                JavaValidatorComposite.this.fireChangedEvent(JavaValidatorComposite.this._browseButton);
            }
        });
        this._beanOption = this.getToolkit().createButton((Composite)inner, Messages.label_bean, 16);
        this._beanOption.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                JavaValidatorComposite.this.handleSelectedOption((Control)JavaValidatorComposite.this._beanOption);
            }
        });
        this.addGridData((Control)this._beanOption, 3, 0);
        this._beanText = this.createLabelAndText((Composite)inner, Messages.label_name);
        this.addGridData((Control)this._beanText, 2, 768);
        this._javaClassOption.setSelection(true);
        this.handleSelectedOption((Control)this._javaClassOption);
    }

    private void handleSelectedOption(Control selected) {
        boolean classSelected = selected.equals(this._javaClassOption);
        this._classText.setEnabled(classSelected);
        this._browseButton.setEnabled(classSelected);
        this._beanText.setEnabled(!classSelected);
    }

    @Override
    protected boolean validate() {
        super.validate();
        if (this.getErrorMessage() == null) {
            String className = this._classText.getText().trim();
            String beanName = this._beanText.getText().trim();
            if (className.isEmpty() && beanName.isEmpty()) {
                this.setErrorMessage(Messages.error_specifyJavaValidatorClassOrBean);
            }
        }
        return this.getErrorMessage() == null;
    }

    protected void updateFeature(EObject eObject, String featureId, Object value, String removeFeatureId) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new AbstractSwitchyardComposite.BasicEObjectOperation(this, eObject, featureId, value));
        ops.add(new AbstractSwitchyardComposite.BasicEObjectOperation(this, eObject, removeFeatureId, null));
        this.wrapOperation(ops);
    }

    @Override
    protected void handleModify(Control control) {
        super.handleModify(control);
        if (control.equals(this._classText)) {
            this.updateFeature((EObject)((JavaValidateType)this.getValidator()), "class", this._classText.getText().trim(), "bean");
        } else if (control.equals(this._beanText)) {
            this.updateFeature((EObject)((JavaValidateType)this.getValidator()), "bean", this._beanText.getText().trim(), "class");
        } else {
            super.handleModify(control);
        }
        this.validate();
    }

    @Override
    protected void handleUndo(Control control) {
        super.handleUndo(control);
        this.setInUpdate(true);
        if (this.getValidator() != null) {
            JavaValidateType javaValidator = (JavaValidateType)this.getValidator();
            if (control.equals(this._classText)) {
                this._classText.setText(javaValidator.getClass_());
            } else if (control.equals(this._beanText)) {
                this._beanText.setText(javaValidator.getBean());
            }
        }
        this.setInUpdate(false);
    }

    @Override
    public void setValidator(ValidateType validator) {
        super.setValidator(validator);
        this.setInUpdate(true);
        JavaValidateType javaValidator = (JavaValidateType)this.getValidator();
        if (javaValidator != null) {
            if (javaValidator.getClass_() != null) {
                this.setTextValue(this._classText, javaValidator.getClass_());
                this._beanOption.setSelection(false);
                this._javaClassOption.setSelection(true);
                this.handleSelectedOption((Control)this._javaClassOption);
            } else if (javaValidator.getBean() != null) {
                this.setTextValue(this._beanText, javaValidator.getBean());
                this._beanOption.setSelection(true);
                this._javaClassOption.setSelection(false);
                this.handleSelectedOption((Control)this._beanOption);
            }
        }
        this.setInUpdate(false);
        this.addObservableListeners();
    }

    private void handleBrowse(Text control) {
        IJavaSearchScope scope = null;
        IProject project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        scope = javaProject == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false);
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                IType clazz = (IType)result[0];
                control.setText(clazz.getFullyQualifiedName());
                this.handleModify((Control)control);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }
}

