/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public abstract class AbstractChangeAwareModelComposite<T extends EObject>
extends AbstractModelComposite<T> {
    private ListenerList _changeListeners;

    public AbstractChangeAwareModelComposite(Class<T> type, ICompositeContainer container, Composite parent, int style) {
        super(type, container, parent, style);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this._changeListeners == null) {
            this._changeListeners = new ListenerList();
        }
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this._changeListeners != null && !this._changeListeners.isEmpty()) {
            this._changeListeners.remove((Object)listener);
        }
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        if (this._changeListeners != null && !this._changeListeners.isEmpty()) {
            Object[] listeners = this._changeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ChangeListener)listeners[i]).stateChanged(e);
                ++i;
            }
        }
    }
}

