/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BarrierProgressWaitJob
extends Job {
    private IRunnableWithProgress _runnable;
    private Object[] _barrier;
    private boolean _throwableCaught = false;

    public BarrierProgressWaitJob(String name, IRunnableWithProgress runnable) {
        super(name);
        this.setSystem(true);
        this._runnable = runnable;
        this._barrier = new Object[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            Object ret = this._runnable.run(monitor);
            Object[] objectArray = this._barrier;
            synchronized (this._barrier) {
                this._barrier[0] = ret;
                this._barrier.notify();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }
        catch (Exception e) {
            this._throwableCaught = true;
            Object[] objectArray = this._barrier;
            synchronized (this._barrier) {
                this._barrier.notify();
                this._barrier[0] = e;
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void monitorSafeJoin(IProgressMonitor monitor) {
        boolean done = false;
        while (!done) {
            Object[] objectArray = this._barrier;
            // MONITORENTER : this._barrier
            try {
                this._barrier.wait(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this._barrier[0] != null || monitor.isCanceled()) {
                done = true;
            }
            // MONITOREXIT : objectArray
        }
        if (!monitor.isCanceled()) return;
        this.cancel();
    }

    protected void canceling() {
        this.getThread().interrupt();
    }

    public Throwable getThrowable() {
        if (this._throwableCaught && this._barrier[0] instanceof Throwable) {
            return (Exception)this._barrier[0];
        }
        return null;
    }

    public Object getReturnValue() {
        return this._throwableCaught ? null : this._barrier[0];
    }

    public static interface IRunnableWithProgress {
        public Object run(IProgressMonitor var1) throws Exception;
    }
}

