/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.ui.editor.Activator;

public abstract class ClassDialogCellEditor
extends DialogCellEditor {
    private final String _baseType;
    private final String _title;
    private final String _description;

    public ClassDialogCellEditor(Composite parent, String baseType, String title, String description) {
        super(parent);
        this._baseType = baseType;
        this._title = title;
        this._description = description;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        try {
            Object[] types;
            Resource resource = this.getResource();
            String platformPath = resource == null ? null : resource.getURI().toPlatformString(true);
            Path path = platformPath == null ? null : new Path(platformPath);
            IProject project = path == null || path.segmentCount() == 0 ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            IJavaProject javaProject = project == null || !project.exists() || !project.isOpen() ? null : JavaCore.create((IProject)project);
            IType type = javaProject == null ? null : javaProject.findType(this._baseType);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)cellEditorWindow.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)(javaProject == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)type, (boolean)true, (boolean)false, null)), (int)2, (boolean)false, (String)"* ");
            dialog.setTitle(this._title);
            dialog.setMessage(this._description);
            if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                IType selection = (IType)types[0];
                return selection.getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            Activator.logStatus(e.getStatus());
        }
        return null;
    }

    protected abstract Resource getResource();
}

