/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.service;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.editor.diagram.StyleUtil;

public class SCADiagramAddServiceFeature
extends AbstractAddShapeFeature {
    public SCADiagramAddServiceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof Service && this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer()) instanceof Composite;
    }

    public PictogramElement add(IAddContext context) {
        Service addedService = null;
        if (context.getNewObject() instanceof Service) {
            addedService = (Service)context.getNewObject();
        }
        ContainerShape targetContainerShape = null;
        if (context.getTargetContainer() instanceof ContainerShape) {
            targetContainerShape = context.getTargetContainer();
        }
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        ContainerShape containerShape = peCreateService.createContainerShape(targetContainerShape, true);
        int width = context.getWidth() <= 0 ? 100 : context.getWidth();
        int height = context.getHeight() <= 0 ? 50 : context.getHeight();
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width, height);
        Polygon p = null;
        p = gaService.createPolygon((GraphicsAlgorithmContainer)invisibleRectangle, StyleUtil.LARGE_RIGHT_ARROW[0], StyleUtil.LARGE_RIGHT_ARROW[1]);
        p.setStyle(StyleUtil.getStyleForService(this.getDiagram()));
        p.setParentGraphicsAlgorithm((GraphicsAlgorithm)invisibleRectangle);
        p.setLineWidth(p.getStyle().getLineWidth());
        gaService.setLocationAndSize((GraphicsAlgorithm)p, 0, 0, width, height);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)p, "sca-type", "service");
        this.link((PictogramElement)containerShape, addedService);
        BoxRelativeAnchor anchor = peCreateService.createBoxRelativeAnchor((AnchorContainer)containerShape);
        Ellipse anchorGa = gaService.createEllipse((GraphicsAlgorithmContainer)anchor);
        anchorGa.setTransparency(Double.valueOf(0.9));
        anchorGa.setLineVisible(Boolean.valueOf(false));
        gaService.setLocationAndSize((GraphicsAlgorithm)anchorGa, -14, -6, 12, 12);
        anchor.setRelativeHeight(0.5);
        anchor.setRelativeWidth(1.0);
        anchor.setUseAnchorLocationAsConnectionEndpoint(true);
        this.link((PictogramElement)anchor, addedService);
        ChopboxAnchor chopboxAnchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        this.link((PictogramElement)chopboxAnchor, addedService);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)p, addedService.getName());
        Font font = gaService.manageFont(this.getDiagram(), text.getFont().getName(), text.getFont().getSize(), false, true);
        text.setFont(font);
        text.setForeground(this.manageColor((IColorConstant)new ColorConstant(StyleUtil.SERVICE_PALETTE.getTextForeground())));
        int left = ((Point)p.getPoints().get(5)).getX();
        int right = ((Point)p.getPoints().get(2)).getX();
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        gaService.setLocationAndSize((GraphicsAlgorithm)text, left + 5, 0, right - left - 10, height);
        this.layoutPictogramElement((PictogramElement)containerShape);
        if (this.updatePictogramElementNeeded((PictogramElement)containerShape)) {
            this.updatePictogramElement((PictogramElement)containerShape);
        }
        return containerShape;
    }
}

