/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.connections;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;

public class SCADiagramCreateReferenceLinkFeature
extends AbstractCreateConnectionFeature {
    public SCADiagramCreateReferenceLinkFeature(IFeatureProvider fp) {
        super(fp, Messages.featureName_wireReference, Messages.featureDescription_wireReference);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        if (context.getSourceAnchor() != null && context.getTargetAnchor() != null) {
            Object source = this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceAnchor());
            Object target = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetAnchor());
            if (source != null && target != null) {
                if (source instanceof ComponentReference && target instanceof Reference && !((Reference)target).getPromote().contains((Object)((ComponentReference)source)) && !this.getDiagramBehavior().getEditingDomain().isReadOnly(((Reference)target).eResource())) {
                    return true;
                }
                if (source instanceof ComponentReference && target instanceof ComponentService && !this.getDiagramBehavior().getEditingDomain().isReadOnly(((ComponentReference)source).eResource())) {
                    ComponentReference reference = (ComponentReference)source;
                    ComponentService service = (ComponentService)target;
                    return reference.eContainer() != service.eContainer() && (reference.getName() == null || !reference.getName().equals(service.getName()));
                }
            }
        }
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceAnchor()) instanceof ComponentReference && context.getSourceAnchor().getOutgoingConnections().size() == 0;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        Anchor sourceAnchor = (Anchor)context.getSourceAnchor().getParent().getAnchors().get(0);
        Anchor targetAnchor = (Anchor)context.getTargetAnchor().getParent().getAnchors().get(0);
        Object source = this.getBusinessObjectForPictogramElement((PictogramElement)sourceAnchor);
        Object target = this.getBusinessObjectForPictogramElement((PictogramElement)targetAnchor);
        if (source instanceof ComponentReference && target instanceof Reference) {
            ComponentReference componentReference = (ComponentReference)source;
            Reference reference = (Reference)target;
            reference.getPromote().add((Object)componentReference);
            AddConnectionContext addContext = new AddConnectionContext(sourceAnchor, targetAnchor);
            addContext.setNewObject((Object)componentReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        } else if (source instanceof ComponentReference && target instanceof ComponentService) {
            ComponentReference reference = (ComponentReference)this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceAnchor());
            ComponentService service = (ComponentService)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetAnchor());
            reference.setName(service.getName());
            AddConnectionContext addContext = new AddConnectionContext(sourceAnchor, targetAnchor);
            addContext.setNewObject((Object)reference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        }
        if (newConnection != null) {
            this.getFeatureProvider().updateIfPossibleAndNeeded((IUpdateContext)new UpdateContext(newConnection));
        }
        return newConnection;
    }

    public String getCreateImageId() {
        return ImageProvider.IMG_16_CONNECTION;
    }
}

