/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.composite;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;

public class SCADiagramLayoutCompositeFeature
extends AbstractLayoutFeature {
    public SCADiagramLayoutCompositeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        EList businessObjects = pe.getLink().getBusinessObjects();
        return businessObjects.size() == 1 && businessObjects.get(0) instanceof Composite;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        int edging = 60;
        int containerWidth = Math.max(500, containerGa.getWidth() - edging);
        int containerHeight = Math.max(300, containerGa.getHeight() - edging);
        for (Shape child : containerShape.getChildren()) {
            GraphicsAlgorithm ga = child.getGraphicsAlgorithm();
            if (this.getBusinessObjectForPictogramElement((PictogramElement)child) instanceof Component) {
                containerWidth = Math.max(containerWidth, ga.getX() + ga.getWidth());
            }
            containerHeight = Math.max(containerHeight, ga.getY() + ga.getHeight());
        }
        if (containerGa.getHeight() - edging < containerHeight) {
            containerGa.setHeight(containerHeight + edging);
            anythingChanged = true;
        }
        if (containerGa.getWidth() - edging < containerWidth) {
            containerGa.setWidth(containerWidth + edging);
            anythingChanged = true;
        }
        IGaService gaService = Graphiti.getGaService();
        for (GraphicsAlgorithm ga : containerGa.getGraphicsAlgorithmChildren()) {
            Rectangle rt;
            IDimension size = gaService.calculateSize(ga);
            if (ga instanceof Rectangle) {
                if (containerWidth == size.getWidth() && containerHeight == size.getHeight()) continue;
                rt = (Rectangle)ga;
                rt.setHeight(containerHeight);
                rt.setWidth(containerWidth);
                anythingChanged = true;
                continue;
            }
            if (!(ga instanceof RoundedRectangle) || containerWidth == size.getWidth() && containerHeight == size.getHeight()) continue;
            rt = (RoundedRectangle)ga;
            rt.setX(30);
            rt.setY(30);
            rt.setHeight(containerHeight);
            rt.setWidth(containerWidth);
            anythingChanged = true;
        }
        for (Shape child : containerShape.getChildren()) {
            GraphicsAlgorithm ga;
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)child);
            if (bo instanceof Service) {
                ga = child.getGraphicsAlgorithm();
                if (ga.getX() == 10) continue;
                ga.setX(10);
                anythingChanged = true;
                continue;
            }
            if (!(bo instanceof Reference)) continue;
            ga = child.getGraphicsAlgorithm();
            int desiredX = containerGa.getWidth() - ga.getWidth() - 30 + 20;
            if (ga.getX() == desiredX) continue;
            ga.setX(desiredX);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

