/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.DefaultUpdateDiagramFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.AutoLayoutFeature;

public class UpdateDiagramFeature
extends DefaultUpdateDiagramFeature {
    private boolean _hasDoneChanges;

    public UpdateDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean update(IUpdateContext context) {
        this._hasDoneChanges = false;
        boolean retVal = super.update(context);
        if (this.compositeMissing(context).toBoolean()) {
            Diagram d = (Diagram)context.getPictogramElement();
            for (EObject bo : d.getLink().getBusinessObjects()) {
                if (bo instanceof DocumentRoot) {
                    DocumentRoot root = (DocumentRoot)bo;
                    if (root.getSwitchyard() == null) continue;
                    SwitchYardType switchYard = root.getSwitchyard();
                    if (switchYard.getComposite() != null) {
                        this.addComposite(context, root.getSwitchyard().getComposite());
                        continue;
                    }
                    Composite newComposite = ScaFactory.eINSTANCE.createComposite();
                    newComposite.setName(switchYard.getName());
                    newComposite.setTargetNamespace(switchYard.getTargetNamespace());
                    switchYard.setComposite(newComposite);
                    this.addComposite(context, newComposite);
                    continue;
                }
                if (bo instanceof SwitchYardType) {
                    SwitchYardType switchYard = (SwitchYardType)bo;
                    if (switchYard.getComposite() == null) continue;
                    this.addComposite(context, switchYard.getComposite());
                    continue;
                }
                if (!(bo instanceof Composite)) continue;
                this.addComposite(context, (Composite)bo);
            }
        }
        this.updateConnections(context);
        return retVal;
    }

    public IReason updateNeeded(IUpdateContext context) {
        IReason retVal = super.updateNeeded(context);
        if (retVal.toBoolean()) {
            return retVal;
        }
        return this.compositeMissing(context);
    }

    public boolean hasDoneChanges() {
        return super.hasDoneChanges() || this._hasDoneChanges;
    }

    private IReason compositeMissing(IUpdateContext context) {
        Diagram d;
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof Diagram && (d = (Diagram)pe).getChildren().size() == 0) {
            return Reason.createTrueReason((String)Messages.updateReason_addComposite);
        }
        return Reason.createFalseReason();
    }

    private void addComposite(IUpdateContext updateContext, Composite composite) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)composite);
        addContext.setTargetContainer((ContainerShape)((Diagram)updateContext.getPictogramElement()));
        addContext.setX(20);
        addContext.setY(20);
        PictogramElement pe = this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        if (pe != null) {
            this.updatePictogramElement(pe);
            CustomContext context = new CustomContext(new PictogramElement[]{pe});
            AutoLayoutFeature layoutFeature = new AutoLayoutFeature(this.getFeatureProvider());
            if (layoutFeature.canExecute((ICustomContext)context)) {
                layoutFeature.execute((ICustomContext)context);
            }
            this._hasDoneChanges = true;
        }
    }

    private void updateConnections(IUpdateContext context) {
        for (Connection connection : new ArrayList(((Diagram)context.getPictogramElement()).getConnections())) {
            UpdateContext updateContext = new UpdateContext((PictogramElement)connection);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)updateContext) || !updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) continue;
            updateFeature.update((IUpdateContext)updateContext);
            boolean bl = this._hasDoneChanges = this._hasDoneChanges || updateFeature.hasDoneChanges();
        }
    }
}

