/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.BorderDecorator;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IImageDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.ILocationInfo;
import org.eclipse.graphiti.util.LocationInfo;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPBindingType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardBindingType;
import org.switchyard.tools.ui.editor.BindingTypeExtensionManager;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.AutoLayoutFeature;
import org.switchyard.tools.ui.editor.diagram.ChangeInterfaceCustomFeature;
import org.switchyard.tools.ui.editor.diagram.CreateServiceTestCustomFeature;
import org.switchyard.tools.ui.editor.diagram.CreateWrapperCustomFeature;
import org.switchyard.tools.ui.editor.diagram.Java2WSDLCustomFeature;
import org.switchyard.tools.ui.editor.diagram.PropertiesDialogFeature;
import org.switchyard.tools.ui.editor.diagram.SCADiagramFeatureProvider;
import org.switchyard.tools.ui.editor.diagram.SCADiagramOpenOnDoubleClickFeature;
import org.switchyard.tools.ui.editor.diagram.SynchronizeGeneratedModelFeature;
import org.switchyard.tools.ui.editor.diagram.ToggleServiceBreakpointFeature;
import org.switchyard.tools.ui.editor.diagram.ToggleTransformBreakpointFeature;
import org.switchyard.tools.ui.editor.diagram.ToggleValidateBreakpointFeature;
import org.switchyard.tools.ui.editor.diagram.WSDL2JavaCustomFeature;
import org.switchyard.tools.ui.editor.diagram.binding.CreateBindingFeature;
import org.switchyard.tools.ui.editor.diagram.component.AbstractComponentFactory;
import org.switchyard.tools.ui.editor.diagram.component.CreateComponentFeature;
import org.switchyard.tools.ui.editor.diagram.componentreference.SCADiagramCreateComponentReferenceFeature;
import org.switchyard.tools.ui.editor.diagram.componentreference.SCADiagramCustomPromoteReferenceFeature;
import org.switchyard.tools.ui.editor.diagram.componentservice.SCADiagramCreateComponentServiceFeature;
import org.switchyard.tools.ui.editor.diagram.compositereference.SCADiagramCreateCompositeReferenceFeature;
import org.switchyard.tools.ui.editor.diagram.connections.SCADiagramCreateComponentServiceLinkFeature;
import org.switchyard.tools.ui.editor.diagram.connections.SCADiagramCreateReferenceLinkFeature;
import org.switchyard.tools.ui.editor.diagram.service.SCADiagramCreateServiceFeature;
import org.switchyard.tools.ui.editor.diagram.service.SCADiagramCustomPromoteServiceFeature;
import org.switchyard.tools.ui.editor.diagram.shared.CompositeCreateConnectionFeature;
import org.switchyard.tools.ui.editor.property.adapters.LabelAdapter;
import org.switchyard.tools.ui.editor.util.GraphitiUtil;
import org.switchyard.tools.ui.validation.ValidationStatusAdapter;

public class SCADiagramToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    public SCADiagramToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
    }

    private ContextMenuEntry addCreateFeatureAContextMenu(ICreateFeature feature, ICustomContext context, List<IContextMenuEntry> menuList) {
        CreateWrapperCustomFeature wrapper = new CreateWrapperCustomFeature(this.getFeatureProvider(), feature);
        ContextMenuEntry newMenu = new ContextMenuEntry((IFeature)wrapper, (IContext)context);
        newMenu.setSubmenu(false);
        if (newMenu.canExecute()) {
            menuList.add((IContextMenuEntry)newMenu);
        }
        return newMenu;
    }

    private IContextMenuEntry addCreateFeatureAsSubMenu(ICreateFeature feature, ICustomContext context, IContextMenuEntry parent) {
        CreateWrapperCustomFeature wrapper = new CreateWrapperCustomFeature(this.getFeatureProvider(), feature);
        ContextMenuEntry newMenu = new ContextMenuEntry((IFeature)wrapper, (IContext)context);
        newMenu.setSubmenu(true);
        if (newMenu.canExecute()) {
            parent.add((IContextMenuEntry)newMenu);
        }
        return newMenu;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        Object bo;
        ArrayList<IContextMenuEntry> menuList = new ArrayList<IContextMenuEntry>();
        if (context.getPictogramElements() != null && (bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(context.getPictogramElements()[0])) != null) {
            IContextMenuEntry addComponentButton;
            AbstractCreateFeature addService;
            ContextMenuEntry addButton;
            ContextMenuEntry openMenu;
            if (bo instanceof Component || bo instanceof Contract) {
                openMenu = new ContextMenuEntry((IFeature)new SCADiagramOpenOnDoubleClickFeature(this.getFeatureProvider()), (IContext)context);
                openMenu.setText(Messages.menu_open);
                openMenu.setSubmenu(false);
                menuList.add((IContextMenuEntry)openMenu);
            }
            if (bo instanceof Component) {
                addButton = this.addCreateFeatureAContextMenu(null, context, menuList);
                addButton.setText(Messages.button_add);
                addButton.setSubmenu(true);
                addService = new SCADiagramCreateComponentServiceFeature(this.getFeatureProvider());
                this.addCreateFeatureAsSubMenu((ICreateFeature)addService, context, (IContextMenuEntry)addButton);
                SCADiagramCreateComponentReferenceFeature addComponentReference = new SCADiagramCreateComponentReferenceFeature(this.getFeatureProvider());
                this.addCreateFeatureAsSubMenu((ICreateFeature)addComponentReference, context, (IContextMenuEntry)addButton);
                addComponentButton = this.addCreateFeatureAsSubMenu(null, context, (IContextMenuEntry)addButton);
                addComponentButton.setText(Messages.button_implementation);
                addComponentButton.setIconId(ImageProvider.IMG_16_COMPONENT);
                for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateComponentFeatures()) {
                    this.addCreateFeatureAsSubMenu(cf, context, addComponentButton);
                }
            }
            if (bo instanceof Contract) {
                if (!(((Contract)bo).eContainer() instanceof Component)) {
                    addButton = this.addCreateFeatureAContextMenu(null, context, menuList);
                    addButton.setText(Messages.button_addBinding);
                    addButton.setIconId(ImageProvider.IMG_16_CHAIN);
                    addButton.setSubmenu(true);
                    for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateBindingFeatures()) {
                        this.addCreateFeatureAsSubMenu(cf, context, (IContextMenuEntry)addButton);
                    }
                }
                openMenu = new ContextMenuEntry((IFeature)new ChangeInterfaceCustomFeature(this.getFeatureProvider()), (IContext)context);
                openMenu.setSubmenu(false);
                menuList.add((IContextMenuEntry)openMenu);
            }
            if (bo instanceof Composite) {
                addButton = this.addCreateFeatureAContextMenu(null, context, menuList);
                addButton.setText(Messages.button_add);
                addButton.setSubmenu(true);
                addService = new SCADiagramCreateServiceFeature(this.getFeatureProvider());
                this.addCreateFeatureAsSubMenu((ICreateFeature)addService, context, (IContextMenuEntry)addButton);
                SCADiagramCreateCompositeReferenceFeature addCompositeReference = new SCADiagramCreateCompositeReferenceFeature(this.getFeatureProvider());
                this.addCreateFeatureAsSubMenu((ICreateFeature)addCompositeReference, context, (IContextMenuEntry)addButton);
                addComponentButton = this.addCreateFeatureAsSubMenu(null, context, (IContextMenuEntry)addButton);
                addComponentButton.setText(Messages.button_component);
                addComponentButton.setIconId(ImageProvider.IMG_16_COMPONENT);
                CreateComponentFeature addComponent2 = new CreateComponentFeature(this.getFeatureProvider(), new AbstractComponentFactory(), Messages.label_component, Messages.description_tool_component);
                this.addCreateFeatureAsSubMenu((ICreateFeature)addComponent2, context, addComponentButton);
                for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateComponentFeatures()) {
                    this.addCreateFeatureAsSubMenu(cf, context, addComponentButton);
                }
            }
        }
        menuList.addAll(Arrays.asList(super.getContextMenu(context)));
        return menuList.toArray(new IContextMenuEntry[menuList.size()]);
    }

    public Location getDecoratorLocationUpperRight(PictogramElement pe) {
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        int x = 4;
        int y = 4;
        EList gaChildren = ga.getGraphicsAlgorithmChildren();
        Object[] objectArray = gaChildren.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object gaChild = objectArray[n2];
            if (gaChild instanceof Polygon) {
                Polygon poly = (Polygon)gaChild;
                EList points = poly.getPoints();
                for (Point point : points) {
                    if (point.getY() >= y || point.getX() <= x) continue;
                    x = point.getX();
                }
                break;
            }
            ++n2;
        }
        return new Location(x, y);
    }

    public Location getDecoratorLocationLowerLeft(PictogramElement pe) {
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        int x = 4;
        int y = 4;
        EList gaChildren = ga.getGraphicsAlgorithmChildren();
        Object[] objectArray = gaChildren.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoundedRectangle rect;
            int rectY;
            Object gaChild = objectArray[n2];
            if (gaChild instanceof Polygon) {
                Polygon poly = (Polygon)gaChild;
                EList points = poly.getPoints();
                for (Point point : points) {
                    if (point.getY() <= y) continue;
                    y = point.getY();
                }
                break;
            }
            if (gaChild instanceof RoundedRectangle && (rectY = (rect = (RoundedRectangle)gaChild).getY()) > y) {
                y = rectY;
            }
            ++n2;
        }
        return new Location(x, y);
    }

    public Location getDecoratorLocationTopLeft(PictogramElement pe) {
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        int x = 30;
        int y = 30;
        EList gaChildren = ga.getGraphicsAlgorithmChildren();
        Object[] objectArray = gaChildren.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object gaChild = objectArray[n2];
            if (gaChild instanceof Polygon) {
                Polygon poly = (Polygon)gaChild;
                EList points = poly.getPoints();
                for (Point point : points) {
                    if (point.getY() < y) {
                        y = point.getY();
                    }
                    if (point.getX() >= x) continue;
                    x = point.getX();
                }
                break;
            }
            if (gaChild instanceof RoundedRectangle) {
                RoundedRectangle rect = (RoundedRectangle)gaChild;
                int rectX = rect.getX();
                int rectY = rect.getY();
                if (rectY < y) {
                    y = rectY;
                }
                if (rectX < x) {
                    x = rectX;
                }
            }
            ++n2;
        }
        return new Location(x, y);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        Component component;
        if (pe instanceof Anchor) {
            return super.getDecorators(pe);
        }
        if (pe instanceof ConnectionDecorator) {
            return this.getDecoratorsForConnection((ConnectionDecorator)pe);
        }
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo == null || !(bo instanceof EObject)) {
            return super.getDecorators(pe);
        }
        boolean needsOffset = false;
        ArrayList<Object> decorators = new ArrayList<Object>();
        if (bo instanceof Service || bo instanceof Reference) {
            needsOffset = true;
            decorators.addAll(this.addDecoratorsForCompositeContract((Contract)bo, pe));
        } else if (bo instanceof Component && (component = (Component)bo).getImplementation() != null) {
            Implementation implementation = component.getImplementation();
            String text = LabelAdapter.getLabel((EObject)implementation);
            IImageDecorator imageRenderingDecorator = ComponentTypeExtensionManager.instance().getExtensionFor(implementation.getClass()).getImageDecorator(implementation);
            if (imageRenderingDecorator == null) {
                imageRenderingDecorator = new ImageDecorator(ImageProvider.IMG_16_UNKNOWN_IMPL);
            }
            imageRenderingDecorator.setMessage(MessageFormat.format(Messages.tooltip_figure_implementation, text));
            Location loc = this.getDecoratorLocationTopLeft(pe);
            imageRenderingDecorator.setX(loc.getX() + 10);
            imageRenderingDecorator.setY(loc.getY() + 4);
            decorators.add(imageRenderingDecorator);
        }
        ValidationStatusAdapter statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)((EObject)bo), ValidationStatusAdapter.class);
        if (statusAdapter != null) {
            IImageDecorator decorator = this.createDecorator(statusAdapter.getValidationStatus());
            GraphicsAlgorithm ga = this.getSelectionBorder(pe);
            if (ga == null) {
                ga = pe.getGraphicsAlgorithm();
            }
            if (decorator != null) {
                if (bo instanceof Composite) {
                    decorator.setX(ga.getX() + 5);
                    decorator.setY(ga.getY() + 5);
                } else {
                    decorator.setX(ga.getWidth() - 10 - (needsOffset ? 28 : 0));
                    decorator.setY(ga.getHeight() - 10 - (needsOffset ? 8 : 0));
                }
                decorators.add(decorator);
            }
            int additionalOffset = 0;
            for (String type : statusAdapter.getBreakpoints()) {
                String imageId;
                if (type.equals("org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker")) {
                    imageId = ImageProvider.IMG_16_SERVICE_WATCH;
                } else if (type.equals("org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker")) {
                    imageId = ImageProvider.IMG_16_TRANSFORM_WATCH;
                } else {
                    if (!type.equals("org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker")) continue;
                    imageId = ImageProvider.IMG_16_VALIDATE_WATCH;
                }
                decorator = new ImageDecorator(imageId);
                decorator.setX(-5 + (bo instanceof Composite ? ga.getWidth() - 20 : (needsOffset ? pe.getGraphicsAlgorithm().getWidth() - 40 : 0)) + additionalOffset);
                decorator.setY(-8 + (bo instanceof Composite ? 43 : (needsOffset ? pe.getGraphicsAlgorithm().getHeight() - 10 : 0)));
                decorators.add(decorator);
                additionalOffset += 25;
            }
        }
        if (this.getDiagramTypeProvider().getDiagramBehavior().getEditingDomain().isReadOnly(((EObject)bo).eResource())) {
            decorators.add(new BorderDecorator(IColorConstant.GRAY, null, Integer.valueOf(2)));
        }
        return decorators.toArray(new IDecorator[decorators.size()]);
    }

    private List<IDecorator> addDecoratorsForCompositeContract(Contract contract, PictogramElement pe) {
        Location loc;
        Object text;
        ArrayList<IDecorator> decorators = new ArrayList<IDecorator>();
        if (!contract.getBinding().isEmpty()) {
            EList bindings = contract.getBinding();
            int x = 15;
            for (Binding binding : bindings) {
                IImageDecorator imageRenderingDecorator = BindingTypeExtensionManager.instance().getExtensionFor(binding.getClass()).getImageDecorator(binding);
                imageRenderingDecorator.setX(x);
                x += 20;
                String text2 = LabelAdapter.getLabel((EObject)binding);
                if (binding instanceof SwitchYardBindingType) {
                    text2 = MessageFormat.format(Messages.tooltip_figure_binding, LabelAdapter.getLabel((EObject)binding));
                }
                if (binding instanceof SOAPBindingType) {
                    SOAPBindingType soapBinding = (SOAPBindingType)binding;
                    text2 = String.valueOf(text2) + "\n" + soapBinding.getWsdl();
                }
                imageRenderingDecorator.setMessage(text2);
                decorators.add((IDecorator)imageRenderingDecorator);
            }
        }
        if (contract.getInterface() != null) {
            ImageDecorator imageRenderingDecorator = LabelAdapter.getImageDecoratorForInterface(contract.getInterface());
            Interface intfc = contract.getInterface();
            text = LabelAdapter.getLabel((EObject)intfc);
            imageRenderingDecorator.setMessage(MessageFormat.format(Messages.tooltip_figure_interface, text));
            loc = this.getDecoratorLocationLowerLeft(pe);
            imageRenderingDecorator.setY(loc.getY() - 18);
            imageRenderingDecorator.setX(15);
            decorators.add((IDecorator)imageRenderingDecorator);
        } else {
            Interface intfc = null;
            if (contract instanceof Service && ((Service)contract).getPromote() != null) {
                intfc = ((Service)contract).getPromote().getInterface();
            } else if (contract instanceof Reference) {
                for (Contract promoted : ((Reference)contract).getPromote()) {
                    if (promoted == null || promoted.getInterface() == null) continue;
                    intfc = promoted.getInterface();
                    break;
                }
            }
            if (intfc != null) {
                ImageDecorator imageRenderingDecorator = LabelAdapter.getImageDecoratorForInterface(intfc);
                text = LabelAdapter.getLabel((EObject)intfc);
                loc = this.getDecoratorLocationLowerLeft(pe);
                imageRenderingDecorator.setY(loc.getY() - 18);
                imageRenderingDecorator.setMessage(MessageFormat.format(Messages.tooltip_figure_inheritedInterface, text));
                decorators.add((IDecorator)imageRenderingDecorator);
            }
        }
        return decorators;
    }

    private IDecorator[] getDecoratorsForConnection(ConnectionDecorator pe) {
        if (pe.getConnection() == null || pe.getConnection().getStart() == null || pe.getConnection().getEnd() == null) {
            return super.getDecorators((PictogramElement)pe);
        }
        Object sourceBO = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pe.getConnection().getStart());
        Object targetBO = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pe.getConnection().getEnd());
        if (sourceBO == null || targetBO == null) {
            return super.getDecorators((PictogramElement)pe);
        }
        ValidationStatusAdapter statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)((EObject)sourceBO), ValidationStatusAdapter.class);
        if (statusAdapter == null) {
            return super.getDecorators((PictogramElement)pe);
        }
        IImageDecorator decorator = this.createDecorator(statusAdapter.getConnectionStatus((EObject)targetBO));
        if (decorator != null) {
            decorator.setX(0);
            decorator.setY(0);
            return new IDecorator[]{decorator};
        }
        return super.getDecorators((PictogramElement)pe);
    }

    private IImageDecorator createDecorator(IStatus status) {
        ImageDecorator decorator;
        switch (status.getSeverity()) {
            case 1: {
                decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.information.tsk");
                break;
            }
            case 2: {
                decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.warning.tsk");
                break;
            }
            case 4: {
                decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.error.tsk");
                break;
            }
            default: {
                decorator = null;
            }
        }
        if (decorator != null) {
            decorator.setMessage(status.getMessage());
        }
        return decorator;
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof Composite) {
            String name2 = ((Composite)bo).getName();
            if (name2 != null && !name2.isEmpty()) {
                return name2;
            }
        } else if (bo instanceof Component) {
            String name3 = ((Component)bo).getName();
            if (name3 != null && !name3.isEmpty()) {
                return name3;
            }
        } else if (bo instanceof Service) {
            String name4 = ((Service)bo).getName();
            if (name4 != null && !name4.isEmpty()) {
                return name4;
            }
        } else if (bo instanceof ComponentService) {
            String name5 = ((ComponentService)bo).getName();
            if (name5 != null && !name5.isEmpty()) {
                return name5;
            }
        } else if (bo instanceof ComponentReference) {
            String name6 = ((ComponentReference)bo).getName();
            if (name6 != null && !name6.isEmpty()) {
                return name6;
            }
        } else if (bo instanceof Reference && (name = ((Reference)bo).getName()) != null && !name.isEmpty()) {
            return name;
        }
        return null;
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList<PaletteCompartmentEntry> ret = new ArrayList<PaletteCompartmentEntry>();
        PaletteCompartmentEntry compositeEntry = new PaletteCompartmentEntry(Messages.category_tool_generic, null);
        for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateGenericFeatures()) {
            compositeEntry.addToolEntry((IToolEntry)new ObjectCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf));
        }
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = this.getFeatureProvider().getCreateConnectionFeatures();
        int n = iCreateConnectionFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature cf;
            cf = iCreateConnectionFeatureArray[n2];
            ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId());
            connectionCreationToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)cf);
            compositeEntry.addToolEntry((IToolEntry)connectionCreationToolEntry);
            ++n2;
        }
        ret.add(compositeEntry);
        PaletteCompartmentEntry componentEntry = new PaletteCompartmentEntry(Messages.category_tool_implementations, null);
        for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateComponentFeatures()) {
            componentEntry.addToolEntry((IToolEntry)new ObjectCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf));
        }
        ret.add(componentEntry);
        PaletteCompartmentEntry bindingsEntry = new PaletteCompartmentEntry(Messages.category_tool_bindings, null);
        for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateBindingFeatures()) {
            bindingsEntry.addToolEntry((IToolEntry)new ObjectCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf));
        }
        ret.add(bindingsEntry);
        PaletteCompartmentEntry miscEntry = new PaletteCompartmentEntry(Messages.category_tool_other, null);
        for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateOtherFeatures()) {
            miscEntry.addToolEntry((IToolEntry)new ObjectCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf));
        }
        if (!miscEntry.getToolEntries().isEmpty()) {
            ret.add(miscEntry);
        }
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    private ContextButtonEntry addCreateFeatureAsButtonToPad(ICreateFeature feature, ICreateContext context, IContextButtonPadData data) {
        ContextButtonEntry newButton = new ContextButtonEntry((IFeature)feature, (IContext)context);
        newButton.setIconId(feature.getCreateImageId());
        newButton.setText(feature.getCreateName());
        newButton.setDescription(feature.getCreateDescription());
        if (newButton.canExecute()) {
            data.getDomainSpecificContextButtons().add(newButton);
        }
        return newButton;
    }

    private ContextButtonEntry addCreateFeatureAsContextButtonToPad(ICreateFeature feature, ICreateContext context, ContextButtonEntry parent) {
        ContextButtonEntry newButton = new ContextButtonEntry((IFeature)feature, (IContext)context);
        newButton.setIconId(feature.getCreateImageId());
        newButton.setText(feature.getCreateName());
        newButton.setDescription(feature.getCreateDescription());
        if (newButton.canExecute()) {
            parent.addContextButtonMenuEntry((IContextButtonEntry)newButton);
        }
        return newButton;
    }

    private ICreateContext adaptCustomContextToCreateContext(ICustomContext customContext) {
        CreateContext createContext = new CreateContext();
        PictogramElement[] picElements = customContext.getPictogramElements();
        if (picElements[0] instanceof ContainerShape) {
            createContext.setTargetContainer((ContainerShape)picElements[0]);
            int x = createContext.getTargetContainer().getGraphicsAlgorithm().getX() + 20;
            int y = createContext.getTargetContainer().getGraphicsAlgorithm().getY() + 20;
            createContext.setLocation(x, y);
        }
        return createContext;
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        CustomContext customContext = new CustomContext(new PictogramElement[]{context.getPictogramElement()});
        ICreateContext createContext = this.adaptCustomContextToCreateContext((ICustomContext)customContext);
        data.getDomainSpecificContextButtons().add(new ContextButtonEntry((IFeature)new PropertiesDialogFeature(this.getFeatureProvider()), (IContext)new CustomContext(new PictogramElement[]{context.getPictogramElement()})));
        if (bo instanceof Composite) {
            this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_UPDATE);
            data.getDomainSpecificContextButtons().add(new ContextButtonEntry((IFeature)new SynchronizeGeneratedModelFeature(this.getFeatureProvider()), (IContext)new CustomContext(new PictogramElement[]{context.getPictogramElement()})));
            AutoLayoutFeature.RecreateDiagramFeature autoLayout = new AutoLayoutFeature.RecreateDiagramFeature(this.getFeatureProvider());
            ContextButtonEntry autoLayoutButton = new ContextButtonEntry((IFeature)autoLayout, (IContext)customContext);
            data.getDomainSpecificContextButtons().add(autoLayoutButton);
            SCADiagramCreateServiceFeature addService = new SCADiagramCreateServiceFeature(this.getFeatureProvider());
            this.addCreateFeatureAsButtonToPad((ICreateFeature)addService, createContext, data);
            SCADiagramCreateCompositeReferenceFeature addCompositeReference = new SCADiagramCreateCompositeReferenceFeature(this.getFeatureProvider());
            this.addCreateFeatureAsButtonToPad((ICreateFeature)addCompositeReference, createContext, data);
            CreateComponentFeature addComponent = new CreateComponentFeature(this.getFeatureProvider(), new AbstractComponentFactory(), Messages.category_menu_component, Messages.tooltip_category_component);
            ContextButtonEntry addComponentButton = this.addCreateFeatureAsButtonToPad((ICreateFeature)addComponent, createContext, data);
            CreateComponentFeature addComponent2 = new CreateComponentFeature(this.getFeatureProvider(), new AbstractComponentFactory(), Messages.label_component, Messages.description_tool_component);
            this.addCreateFeatureAsContextButtonToPad((ICreateFeature)addComponent2, createContext, addComponentButton);
            for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateComponentFeatures()) {
                this.addCreateFeatureAsContextButtonToPad(cf, createContext, addComponentButton);
            }
            this.addBreakpointButtons(data, (ICustomContext)customContext);
        } else {
            ContextButtonEntry button;
            AbstractCustomFeature promote;
            if (bo instanceof ComponentService) {
                promote = new SCADiagramCustomPromoteServiceFeature(this.getFeatureProvider());
                button = new ContextButtonEntry((IFeature)promote, (IContext)customContext);
                data.getDomainSpecificContextButtons().add(button);
                data.getPadLocation().setHeight(30);
                data.getPadLocation().setWidth(data.getPadLocation().getWidth() + 10);
                data.getPadLocation().setX(data.getPadLocation().getX() - 10);
                CreateServiceTestCustomFeature test = new CreateServiceTestCustomFeature(this.getFeatureProvider());
                ContextButtonEntry testButton = new ContextButtonEntry((IFeature)test, (IContext)customContext);
                data.getDomainSpecificContextButtons().add(testButton);
            } else if (bo instanceof ComponentReference) {
                promote = new SCADiagramCustomPromoteReferenceFeature(this.getFeatureProvider());
                button = new ContextButtonEntry((IFeature)promote, (IContext)customContext);
                data.getDomainSpecificContextButtons().add(button);
                data.getPadLocation().setHeight(30);
                data.getPadLocation().setWidth(data.getPadLocation().getWidth() + 10);
                data.getPadLocation().setX(data.getPadLocation().getX() - 10);
            } else if (bo instanceof Component) {
                SCADiagramCreateComponentServiceFeature addComponentService = new SCADiagramCreateComponentServiceFeature(this.getFeatureProvider());
                this.addCreateFeatureAsButtonToPad((ICreateFeature)addComponentService, createContext, data);
                SCADiagramCreateComponentReferenceFeature addComponentReference = new SCADiagramCreateComponentReferenceFeature(this.getFeatureProvider());
                this.addCreateFeatureAsButtonToPad((ICreateFeature)addComponentReference, createContext, data);
                CreateComponentFeature addComponent = new CreateComponentFeature(this.getFeatureProvider(), new AbstractComponentFactory(), Messages.category_menu_implementation, Messages.tooltip_category_implementation);
                ContextButtonEntry addComponentButton = this.addCreateFeatureAsButtonToPad((ICreateFeature)addComponent, createContext, data);
                for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateComponentFeatures()) {
                    this.addCreateFeatureAsContextButtonToPad(cf, createContext, addComponentButton);
                }
                data.getPadLocation().setWidth(data.getPadLocation().getWidth() - 15);
            }
            if (bo instanceof Contract) {
                Java2WSDLCustomFeature java2WSDL;
                ChangeInterfaceCustomFeature intfChangeFeature = new ChangeInterfaceCustomFeature(this.getFeatureProvider());
                button = new ContextButtonEntry((IFeature)intfChangeFeature, (IContext)customContext);
                data.getDomainSpecificContextButtons().add(button);
                if (!(((Contract)bo).eContainer() instanceof Component)) {
                    CreateBindingFeature addBinding = new CreateBindingFeature(this.getFeatureProvider(), null, Messages.category_menu_binding, Messages.tooltip_category_binding);
                    ContextButtonEntry addBindingButton = this.addCreateFeatureAsButtonToPad((ICreateFeature)addBinding, createContext, data);
                    for (ICreateFeature cf : ((SCADiagramFeatureProvider)this.getFeatureProvider()).getCreateBindingFeatures()) {
                        this.addCreateFeatureAsContextButtonToPad(cf, createContext, addBindingButton);
                    }
                }
                CreateConnectionContext ccc = new CreateConnectionContext();
                ccc.setSourcePictogramElement(pe);
                Anchor anchor = null;
                if (pe instanceof Anchor) {
                    anchor = (Anchor)pe;
                } else if (pe instanceof AnchorContainer) {
                    anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
                }
                ccc.setSourceAnchor(anchor);
                ContextButtonEntry linkbutton = new ContextButtonEntry(null, (IContext)context);
                CompositeCreateConnectionFeature linkFeature = new CompositeCreateConnectionFeature(this.getFeatureProvider(), Messages.label_wire, Messages.description_tool_wire, new ICreateConnectionFeature[]{new SCADiagramCreateReferenceLinkFeature(this.getFeatureProvider()), new SCADiagramCreateComponentServiceLinkFeature(this.getFeatureProvider())});
                linkbutton.setText(linkFeature.getCreateName());
                linkbutton.setDescription(linkFeature.getCreateDescription());
                linkbutton.setIconId(linkFeature.getCreateImageId());
                if (linkFeature.isAvailable((IContext)ccc) && linkFeature.canStartConnection((ICreateConnectionContext)ccc)) {
                    linkbutton.addDragAndDropFeature((IFeature)linkFeature);
                }
                if (linkbutton.getDragAndDropFeatures().size() > 0) {
                    data.getDomainSpecificContextButtons().add(linkbutton);
                }
                if ((java2WSDL = new Java2WSDLCustomFeature(this.getFeatureProvider())).canExecute((ICustomContext)customContext)) {
                    data.getDomainSpecificContextButtons().add(new ContextButtonEntry((IFeature)java2WSDL, (IContext)customContext));
                } else {
                    WSDL2JavaCustomFeature wsdl2Java = new WSDL2JavaCustomFeature(this.getFeatureProvider());
                    if (wsdl2Java.canExecute((ICustomContext)customContext)) {
                        data.getDomainSpecificContextButtons().add(new ContextButtonEntry((IFeature)wsdl2Java, (IContext)customContext));
                    }
                }
                ToggleServiceBreakpointFeature toggleBreakpoint = new ToggleServiceBreakpointFeature(this.getFeatureProvider(), (ICustomContext)customContext);
                data.getDomainSpecificContextButtons().add(new ContextButtonEntry((IFeature)toggleBreakpoint, (IContext)customContext));
            }
            this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_DELETE);
        }
        return data;
    }

    private void addBreakpointButtons(IContextButtonPadData data, ICustomContext customContext) {
        ContextButtonEntry toggleBreakpoints = new ContextButtonEntry(null, (IContext)customContext);
        toggleBreakpoints.setIconId(ImageProvider.IMG_16_SERVICE_WATCH);
        toggleBreakpoints.setText("Breakpoints");
        toggleBreakpoints.addContextButtonMenuEntry((IContextButtonEntry)new ContextButtonEntry((IFeature)new ToggleTransformBreakpointFeature(this.getFeatureProvider(), customContext), (IContext)customContext));
        toggleBreakpoints.addContextButtonMenuEntry((IContextButtonEntry)new ContextButtonEntry((IFeature)new ToggleValidateBreakpointFeature(this.getFeatureProvider(), customContext), (IContext)customContext));
        data.getDomainSpecificContextButtons().add(toggleBreakpoints);
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        PictogramElement[] elements;
        if (context.getPictogramElements() != null && (elements = context.getPictogramElements()).length > 0) {
            PictogramElement firstOne = elements[0];
            Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(firstOne);
            if (bo instanceof Component || bo instanceof Service || bo instanceof Reference || bo instanceof ComponentService || bo instanceof ComponentReference) {
                return new SCADiagramOpenOnDoubleClickFeature(this.getFeatureProvider());
            }
        }
        return super.getDoubleClickFeature(context);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (!ga.getFilled().booleanValue()) {
            for (GraphicsAlgorithm childGA : ga.getGraphicsAlgorithmChildren()) {
                if (!childGA.getFilled().booleanValue()) continue;
                return childGA;
            }
        }
        return super.getSelectionBorder(pe);
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        GraphicsAlgorithm ga = this.getSelectionBorder(pe);
        if (ga == null) {
            return super.getClickArea(pe);
        }
        return new GraphicsAlgorithm[]{ga};
    }

    public boolean equalsBusinessObjects(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof EObject && o2 instanceof EObject) {
            EObject eo1 = (EObject)o1;
            EObject eo2 = (EObject)o2;
            if (eo1.eIsProxy()) {
                return eo2.eIsProxy() && ((InternalEObject)eo1).eProxyURI().equals(((InternalEObject)eo2).eProxyURI());
            }
            if (eo2.eIsProxy()) {
                return false;
            }
            return eo1 == eo2;
        }
        return false;
    }

    public boolean isShowMarqueeTool() {
        return false;
    }

    public boolean isShowSelectionTool() {
        return false;
    }

    public ILocationInfo getLocationInfo(PictogramElement pe, ILocationInfo locationInfo) {
        ContainerShape shape;
        GraphicsAlgorithm ga;
        Text text;
        Object bo;
        PictogramElement pictogramElement;
        PictogramElement[] selectedPictogramElements = this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().getSelectedPictogramElements();
        if (selectedPictogramElements != null && selectedPictogramElements.length > 0 && (pictogramElement = selectedPictogramElements[0]) instanceof ContainerShape && ((bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pictogramElement)) instanceof Composite || bo instanceof Component || bo instanceof Service || bo instanceof Reference) && (text = GraphitiUtil.findChildGA(ga = (shape = (ContainerShape)pictogramElement).getGraphicsAlgorithm(), Text.class)) != null) {
            return new LocationInfo((Shape)shape, (GraphicsAlgorithm)text);
        }
        return super.getLocationInfo(pe, locationInfo);
    }

    private class Location {
        private int _x = 0;
        private int _y = 0;

        public Location(int locx, int locy) {
            this._x = locx;
            this._y = locy;
        }

        public int getX() {
            return this._x;
        }

        public int getY() {
            return this._y;
        }
    }
}

