/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.databinding;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.switchyard.tools.ui.editor.Messages;

public class URLValidator
implements IValidator {
    private final String _message;

    public URLValidator(String message) {
        this._message = message;
    }

    public IStatus validate(Object value) {
        String urlString = null;
        if (value != null && value instanceof String && (urlString = (String)value).trim().length() > 0) {
            if (urlString.trim().length() < urlString.length()) {
                return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_spacesInUrl);
            }
            try {
                new URL(urlString);
            }
            catch (MalformedURLException e) {
                return new Status(2, "org.switchyard.tools.ui.editor", String.valueOf(this._message) + " (" + e.getLocalizedMessage() + ")");
            }
        }
        return Status.OK_STATUS;
    }
}

