/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;

public class AccessibleClassValidator
implements IValidator {
    private final IObservableValue _target;
    private final EObject _container;

    public AccessibleClassValidator(IObservableValue target) {
        this._target = target;
        this._container = null;
    }

    public AccessibleClassValidator(IObservableValue target, EObject container) {
        this._target = target;
        this._container = container;
    }

    public IStatus validate(Object value) {
        if (value == null || ((String)value).trim().isEmpty()) {
            return Status.OK_STATUS;
        }
        try {
            IJavaProject project = this.resolveCurrentJavaProject();
            if (project == null || !project.getProject().isAccessible()) {
                return new Status(2, "org.switchyard.tools.ui.editor", "Cannot verify accessibility of specified class.");
            }
            if (project.findType((String)value) != null) {
                return Status.OK_STATUS;
            }
        }
        catch (JavaModelException e) {
            e.fillInStackTrace();
        }
        return new Status(2, "org.switchyard.tools.ui.editor", "Specified class is not on the project's classpath.");
    }

    private IJavaProject resolveCurrentJavaProject() {
        try {
            if (this._container != null) {
                return JavaCore.create((IProject)PlatformResourceAdapterFactory.getContainingProject((Object)this._container));
            }
            return JavaCore.create((IProject)PlatformResourceAdapterFactory.getContainingProject((Object)this._target.getValue()));
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

