/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.http;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.http.HTTPBindingType;
import org.switchyard.tools.models.switchyard1_0.http.HttpPackage;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.binding.OperationSelectorComposite;

public class HttpBindingComposite
extends AbstractSYBindingComposite {
    private org.eclipse.swt.widgets.Composite _panel;
    private Text _nameText;
    private Text _mAddressURLText;
    private ComboViewer _methodCombo;
    private Text _contentTypeText;
    private Text _contextPathText = null;
    private HTTPBindingType _binding = null;
    private OperationSelectorComposite _opSelectorComposite;
    private Text _requestTimeoutText = null;
    private WritableValue _bindingValue;

    HttpBindingComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_httpBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_httpBindingDetails;
    }

    @Override
    public void createContents(org.eclipse.swt.widgets.Composite parent, int style, DataBindingContext context) {
        this._panel = new org.eclipse.swt.widgets.Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getHttpControl(this._panel);
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Service && this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(this.getTargetObject());
        }
        this.bindControls(context);
    }

    private Control getHttpControl(org.eclipse.swt.widgets.Composite tabFolder) {
        org.eclipse.swt.widgets.Composite composite = new org.eclipse.swt.widgets.Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        if (this.getTargetObject() instanceof Service) {
            this._contextPathText = this.createLabelAndText(composite, Messages.label_contextPath);
            this._opSelectorComposite = new OperationSelectorComposite(composite, 0, this);
            this._opSelectorComposite.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this._opSelectorComposite.setLayout((Layout)new GridLayout(2, false));
            this._opSelectorComposite.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HttpBindingComposite.this.handleModify((Control)HttpBindingComposite.this._opSelectorComposite);
                }
            });
            this._opSelectorComposite.setTargetObject(this.getTargetObject());
        }
        if (this.getTargetObject() instanceof Reference) {
            this._mAddressURLText = this.createLabelAndText(composite, Messages.label_address);
            this._methodCombo = this.createLabelAndComboViewer(composite, Messages.label_method, false);
            this._methodCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this._methodCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            String[] methods = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE", "CONNECT"};
            this._methodCombo.setInput((Object)methods);
            this._contentTypeText = this.createLabelAndText(composite, Messages.label_contentType);
            this._requestTimeoutText = this.createLabelAndText(composite, Messages.label_requestTimeout);
        }
        return composite;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals((Object)this._opSelectorComposite)) {
            this.fireChangedEvent((Object)this._opSelectorComposite);
        }
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(target);
        }
    }

    @Override
    public org.eclipse.swt.widgets.Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        if (switchYardBindingType instanceof HTTPBindingType) {
            SwitchYardType rootSwitchYard;
            Composite composite;
            Contract contract;
            this._binding = (HTTPBindingType)switchYardBindingType;
            this._bindingValue.setValue((Object)this._binding);
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this.getTargetObject() != null) {
                this._opSelectorComposite.setTargetObject(this.getTargetObject());
            }
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
                this._opSelectorComposite.setBinding((Binding)this._binding);
            }
            if (this._binding.getContextPath() == null && this._contextPathText != null && !this._contextPathText.isDisposed() && this.getTargetObject() != null && this.getTargetObject() instanceof Contract && (contract = (Contract)this.getTargetObject()).eContainer() != null && contract.eContainer() instanceof Composite && (composite = (Composite)contract.eContainer()).eContainer() != null && composite.eContainer() instanceof SwitchYardType && (rootSwitchYard = (SwitchYardType)composite.eContainer()).getName() != null) {
                this._contextPathText.setText(rootSwitchYard.getName());
                this._contextPathText.notifyListeners(24, null);
                this._contextPathText.notifyListeners(14, null);
                this._contextPathText.setFocus();
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, HTTPBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("HTTP binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("HTTP binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (this.getTargetObject() instanceof Service) {
            if (this._opSelectorComposite != null) {
                this._opSelectorComposite.bindControls(domain, context);
            }
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._contextPathText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__CONTEXT_PATH), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        } else if (this.getTargetObject() instanceof Reference) {
            binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._methodCombo), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__METHOD));
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._mAddressURLText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__ADDRESS), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._contentTypeText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__CONTENT_TYPE), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._requestTimeoutText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__TIMEOUT), new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Request Timeout must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        }
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

