/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.sap;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.sap.CamelSapBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.sap.CamelSapIDocListServerType;
import org.switchyard.tools.models.switchyard1_0.camel.sap.CamelSapSRfcServerType;
import org.switchyard.tools.models.switchyard1_0.camel.sap.CamelSapTRfcServerType;
import org.switchyard.tools.models.switchyard1_0.camel.sap.SapFactory;
import org.switchyard.tools.models.switchyard1_0.camel.sap.SapPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyControlAwareValidator;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class CamelSAPConsumerComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelSapBindingType _binding = null;
    private Text _nameText;
    private Composite _iDocPage;
    private Composite _sRFCPage;
    private Composite _tRFCPage;
    private WritableValue _bindingValue;
    private Text _idocServerText;
    private Text _idocTypeText;
    private Text _idocTypeExtText;
    private Text _systemReleaseText;
    private Text _applicationReleaseText;
    private Text _srfcServerText;
    private Text _srfcRFCNameText;
    private Text _tRFCServerText;
    private Text _trfcRFCNameText;
    private Composite _contentPanel;
    private StackLayout _layout;
    private Combo _typeCombo;
    private org.eclipse.core.databinding.Binding _idocServerTextBinding;
    private org.eclipse.core.databinding.Binding _idocTypeTextBinding;
    private org.eclipse.core.databinding.Binding _tRFCServerTextBinding;
    private org.eclipse.core.databinding.Binding _sRFCServerTextBinding;
    private org.eclipse.core.databinding.Binding _tRFCRFCTextBinding;
    private org.eclipse.core.databinding.Binding _sRFCRFCTextBinding;

    CamelSAPConsumerComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return "SAP Binding Details";
    }

    @Override
    public String getDescription() {
        return "Specify pertinent details for your SAP Binding.";
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelSapBindingType) {
            this._binding = (CamelSapBindingType)impl;
            if (this._binding.getIdoclistServer() == null && this._binding.getTrfcServer() == null && this._binding.getSrfcServer() == null) {
                this._typeCombo.setText("IDoc List");
                this.handleSelection("IDoc List");
            } else if (this._binding.getIdoclistServer() != null) {
                this._typeCombo.setText("IDoc List");
                this.handleSelection("IDoc List");
            } else if (this._binding.getSrfcServer() != null) {
                this._typeCombo.setText("sRFC");
                this.handleSelection("sRFC");
            } else if (this._binding.getTrfcServer() != null) {
                this._typeCombo.setText("tRFC");
                this.handleSelection("tRFC");
            }
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getSAPTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getSAPTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._typeCombo = this.createLabelAndCombo(composite, "SAP Object", true);
        this._typeCombo.add("IDoc List");
        this._typeCombo.add("sRFC");
        this._typeCombo.add("tRFC");
        this._contentPanel = new Composite(composite, 0);
        this._layout = new StackLayout();
        this._contentPanel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this._contentPanel.setLayout((Layout)this._layout);
        this._iDocPage = new Composite(this._contentPanel, 0);
        this._iDocPage.setLayout((Layout)new GridLayout(2, false));
        this._idocServerText = this.createLabelAndText(this._iDocPage, Messages.CamelSAPComposite_Server_name_label);
        this._idocTypeText = this.createLabelAndText(this._iDocPage, "IDoc Type*");
        this._idocTypeExtText = this.createLabelAndText(this._iDocPage, "IDoc Type Extension");
        this._systemReleaseText = this.createLabelAndText(this._iDocPage, "System Release");
        this._applicationReleaseText = this.createLabelAndText(this._iDocPage, "Application Release");
        this._sRFCPage = new Composite(this._contentPanel, 0);
        this._sRFCPage.setLayout((Layout)new GridLayout(2, false));
        this._srfcServerText = this.createLabelAndText(this._sRFCPage, Messages.CamelSAPComposite_Server_name_label);
        this._srfcRFCNameText = this.createLabelAndText(this._sRFCPage, "RFC Name*");
        this._tRFCPage = new Composite(this._contentPanel, 0);
        this._tRFCPage.setLayout((Layout)new GridLayout(2, false));
        this._tRFCServerText = this.createLabelAndText(this._tRFCPage, Messages.CamelSAPComposite_Server_name_label);
        this._trfcRFCNameText = this.createLabelAndText(this._tRFCPage, "RFC Name*");
        this._typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CamelSAPConsumerComposite.this.handleSelection(CamelSAPConsumerComposite.this._typeCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private void selectSAPType(final Class<?> clazz) {
        TransactionalEditingDomain domain = this.getDomain((EObject)this._binding);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    if (clazz.equals(CamelSapIDocListServerType.class)) {
                        if (CamelSAPConsumerComposite.this._binding.getIdoclistServer() == null) {
                            CamelSAPConsumerComposite.this._binding.setIdoclistServer(SapFactory.eINSTANCE.createCamelSapIDocListServerType());
                        }
                        CamelSAPConsumerComposite.this._binding.setSrfcServer(null);
                        CamelSAPConsumerComposite.this._binding.setTrfcServer(null);
                    } else if (clazz.equals(CamelSapSRfcServerType.class)) {
                        CamelSAPConsumerComposite.this._binding.setIdoclistServer(null);
                        if (CamelSAPConsumerComposite.this._binding.getSrfcServer() == null) {
                            CamelSAPConsumerComposite.this._binding.setSrfcServer(SapFactory.eINSTANCE.createCamelSapSRfcServerType());
                        }
                        CamelSAPConsumerComposite.this._binding.setTrfcServer(null);
                    } else if (clazz.equals(CamelSapTRfcServerType.class)) {
                        CamelSAPConsumerComposite.this._binding.setIdoclistServer(null);
                        CamelSAPConsumerComposite.this._binding.setSrfcServer(null);
                        if (CamelSAPConsumerComposite.this._binding.getTrfcServer() == null) {
                            CamelSAPConsumerComposite.this._binding.setTrfcServer(SapFactory.eINSTANCE.createCamelSapTRfcServerType());
                        }
                    }
                    CamelSAPConsumerComposite.this._iDocPage.setEnabled(clazz.equals(CamelSapIDocListServerType.class));
                    CamelSAPConsumerComposite.this._sRFCPage.setEnabled(clazz.equals(CamelSapSRfcServerType.class));
                    CamelSAPConsumerComposite.this._tRFCPage.setEnabled(clazz.equals(CamelSapTRfcServerType.class));
                    CamelSAPConsumerComposite.this._idocServerTextBinding.validateTargetToModel();
                    CamelSAPConsumerComposite.this._idocTypeTextBinding.validateTargetToModel();
                    CamelSAPConsumerComposite.this._tRFCServerTextBinding.validateTargetToModel();
                    CamelSAPConsumerComposite.this._tRFCRFCTextBinding.validateTargetToModel();
                    CamelSAPConsumerComposite.this._sRFCServerTextBinding.validateTargetToModel();
                    CamelSAPConsumerComposite.this._sRFCRFCTextBinding.validateTargetToModel();
                }
            });
        }
    }

    private void handleSelection(String sapType) {
        if (sapType.equals("IDoc List")) {
            this._layout.topControl = this._iDocPage;
            this.selectSAPType(CamelSapIDocListServerType.class);
        } else if (sapType.equals("sRFC")) {
            this._layout.topControl = this._sRFCPage;
            this.selectSAPType(CamelSapSRfcServerType.class);
        } else if (sapType.equals("tRFC")) {
            this._layout.topControl = this._tRFCPage;
            this.selectSAPType(CamelSapTRfcServerType.class);
        }
        this._contentPanel.layout();
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelSapBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.CamelSAPComposite_Binding_name_empty_warning, 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.CamelSAPComposite_Binding_name_empty_warning, 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__IDOCLIST_SERVER, SapPackage.Literals.CAMEL_SAP_IDOC_LIST_SERVER_TYPE__SERVER_NAME});
        this._idocServerTextBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._idocServerText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyControlAwareValidator(Messages.CamelSAPComposite_Server_name_empty_error, (Control)this._idocServerText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._idocServerTextBinding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__IDOCLIST_SERVER, SapPackage.Literals.CAMEL_SAP_IDOC_LIST_SERVER_TYPE__IDOC_TYPE});
        this._idocTypeTextBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._idocTypeText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyControlAwareValidator("IDoc Type cannot be empty.", (Control)this._idocTypeText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._idocTypeTextBinding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__IDOCLIST_SERVER, SapPackage.Literals.CAMEL_SAP_IDOC_LIST_SERVER_TYPE__IDOC_TYPE_EXTENSION});
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._idocTypeExtText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__IDOCLIST_SERVER, SapPackage.Literals.CAMEL_SAP_IDOC_LIST_SERVER_TYPE__SYSTEM_RELEASE});
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._systemReleaseText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__IDOCLIST_SERVER, SapPackage.Literals.CAMEL_SAP_IDOC_LIST_SERVER_TYPE__APPLICATION_RELEASE});
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._applicationReleaseText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__TRFC_SERVER, SapPackage.Literals.CAMEL_SAP_TRFC_SERVER_TYPE__SERVER_NAME});
        this._tRFCServerTextBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._tRFCServerText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyControlAwareValidator(Messages.CamelSAPComposite_Server_name_empty_error, (Control)this._tRFCServerText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._tRFCServerTextBinding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__TRFC_SERVER, SapPackage.Literals.CAMEL_SAP_TRFC_SERVER_TYPE__RFC_NAME});
        this._tRFCRFCTextBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._trfcRFCNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyControlAwareValidator(Messages.CamelSAPComposite_RFC_name_empty_error, (Control)this._trfcRFCNameText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._tRFCRFCTextBinding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__SRFC_SERVER, SapPackage.Literals.CAMEL_SAP_SRFC_SERVER_TYPE__SERVER_NAME});
        this._sRFCServerTextBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._srfcServerText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyControlAwareValidator(Messages.CamelSAPComposite_Server_name_empty_error, (Control)this._srfcServerText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._sRFCServerTextBinding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{SapPackage.Literals.CAMEL_SAP_BINDING_TYPE__SRFC_SERVER, SapPackage.Literals.CAMEL_SAP_SRFC_SERVER_TYPE__RFC_NAME});
        this._sRFCRFCTextBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._srfcRFCNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyControlAwareValidator(Messages.CamelSAPComposite_RFC_name_empty_error, (Control)this._srfcRFCNameText)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._sRFCRFCTextBinding), (int)16512);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

