/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.java;

import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.common.ContractControl;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.Messages;

public class NewCamelRouteClassWizardPage
extends NewClassWizardPage {
    private static final String SERVICE_INTERFACE = "SERVICE_INTERFACE";
    private static final String CLASS_NAME_DEFAULT = "CamelServiceRoute";
    private ContractControl _serviceInterfaceControl;
    private IStatus _serviceInterfaceStatus;

    public NewCamelRouteClassWizardPage() {
        this.setTitle(Messages.title_newCamelRouteService);
        this.setDescription(Messages.description_newCamelRouteService);
        this._serviceInterfaceControl = new ContractControl(ScaPackage.eINSTANCE.getComponentService(), this.getJavaProject(), EnumSet.of(InterfaceControl.InterfaceType.Java, InterfaceControl.InterfaceType.WSDL, InterfaceControl.InterfaceType.ESB));
        this._serviceInterfaceControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewCamelRouteClassWizardPage.this.handleFieldChanged(NewCamelRouteClassWizardPage.SERVICE_INTERFACE);
            }
        });
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.setModifiers(1, false);
        this.setMethodStubSelection(false, false, false, false);
        if (this.getTypeName().length() == 0) {
            this.setTypeName(CLASS_NAME_DEFAULT, true);
        }
        this.setSuperClass("org.apache.camel.builder.RouteBuilder", false);
        this.doStatusUpdate();
    }

    public void forceServiceInterfaceType(Contract serviceInterface) {
        if (serviceInterface == null) {
            return;
        }
        this._serviceInterfaceControl.init(serviceInterface, null);
        this._serviceInterfaceControl.setEnabled(false);
        if (this.getTypeName().length() == 0 || this.getTypeName().equals(CLASS_NAME_DEFAULT)) {
            this.setTypeName(serviceInterface.getName() + "Route", true);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createServiceInterfaceControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        super.createTypeMembers(type, imports, monitor);
        StringBuffer buf = new StringBuffer();
        String lineDelim = this.getJavaProject().getJavaModel().findRecommendedLineSeparator();
        buf.append("/**").append(lineDelim);
        buf.append(" * ").append(Messages.comment_camelConfigureMethod).append(lineDelim);
        buf.append(" */").append(lineDelim);
        buf.append("public void ").append("configure").append("() {");
        buf.append(lineDelim);
        String serviceName = this.getService().getName();
        StringBuffer body = new StringBuffer();
        body.append("from(\"switchyard://").append(serviceName).append("\")");
        body.append(lineDelim);
        body.append(".log(\"Received message for '").append(serviceName).append("' : ${body}\");");
        body.append(lineDelim);
        try {
            buf.append(CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getFullyQualifiedName(), (String)"configure", (boolean)false, (String)body.toString(), (String)lineDelim));
        }
        catch (CoreException coreException) {
            buf.append(body);
        }
        buf.append("}");
        type.createMethod(buf.toString(), null, false, null);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == SERVICE_INTERFACE) {
            this.serviceInterfaceChanged();
        } else if (fieldName == "NewContainerWizardPage.container") {
            this._serviceInterfaceControl.setProject(this.getJavaProject());
            this.serviceInterfaceChanged();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this._serviceInterfaceStatus};
        this.updateStatus(status);
    }

    public ComponentService getService() {
        return (ComponentService)this._serviceInterfaceControl.getContract();
    }

    private void createServiceInterfaceControls(Composite composite, int nColumns) {
        this._serviceInterfaceControl.createControl(composite, nColumns);
    }

    private void serviceInterfaceChanged() {
        this._serviceInterfaceStatus = this._serviceInterfaceControl.getStatus();
    }
}

