/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.validation.SwitchYardProjectValidator;

final class WiringValidationContext {
    private Map<QName, Set<QName>> _transformers = new HashMap<QName, Set<QName>>();
    private Map<String, Set<Contract>> _names = new HashMap<String, Set<Contract>>();
    private Map<Contract, ServiceInterface> _serviceInterfaces = new HashMap<Contract, ServiceInterface>();
    private Map<Contract, Set<Contract>> _wires = new HashMap<Contract, Set<Contract>>();
    private IStatus _contextStatus;
    private List<IStatus> _problems = new ArrayList<IStatus>();
    private SwitchYardProjectValidator.ValidationAdapter _validationAdapter;
    static final ServiceInterface URESOLVABLE_SERVICE_INTERFACE = new ServiceInterface(){

        public String getType() {
            return null;
        }

        public Set<ServiceOperation> getOperations() {
            return Collections.emptySet();
        }

        public ServiceOperation getOperation(String name) {
            return null;
        }
    };
    static final ServiceInterface INVALID_SERVICE_INTERFACE = new ServiceInterface(){

        public String getType() {
            return null;
        }

        public Set<ServiceOperation> getOperations() {
            return Collections.emptySet();
        }

        public ServiceOperation getOperation(String name) {
            return null;
        }
    };

    WiringValidationContext(IValidationContext ctx, SwitchYardType switchyard) {
        this._validationAdapter = (SwitchYardProjectValidator.ValidationAdapter)EcoreUtil.getAdapter((List)switchyard.eResource().eAdapters(), SwitchYardProjectValidator.ValidationAdapter.class);
        this.collectNamesAndWires(switchyard);
        this.collectServiceInterfaces(switchyard);
        this.collectTransformers(switchyard);
        if (!this._problems.isEmpty()) {
            this._contextStatus = ConstraintStatus.createMultiStatus((IValidationContext)ctx, this._problems);
        }
        this._problems.clear();
        this._problems = null;
    }

    Map<String, Set<Contract>> getNames() {
        return this._names;
    }

    Map<Contract, ServiceInterface> getServiceInterfaces() {
        return this._serviceInterfaces;
    }

    Map<Contract, Set<Contract>> getWires() {
        return this._wires;
    }

    Map<QName, Set<QName>> getTranformers() {
        return this._transformers;
    }

    IStatus getContextStatus() {
        return this._contextStatus;
    }

    private void collectTransformers(SwitchYardType switchyard) {
        TreeIterator it = EcoreUtil.getAllContents((Resource)switchyard.eResource(), (boolean)false);
        while (it.hasNext()) {
            EObject nextObject = (EObject)it.next();
            if (!SwitchyardPackage.eINSTANCE.getTransformType().isInstance((Object)nextObject)) continue;
            this.addTransformer((TransformType)nextObject);
            this.addDependency(nextObject);
        }
    }

    private void addDependency(Object object) {
        IFile resource = PlatformResourceAdapterFactory.getFileForObject(object, this._validationAdapter.getProject());
        if (resource != null) {
            this._validationAdapter.addDependency((IResource)resource);
        }
    }

    private void addTransformer(TransformType transformer) {
        if (transformer.getFrom() == null || transformer.getTo() == null) {
            return;
        }
        QName from = QName.valueOf(transformer.getFrom());
        QName to = QName.valueOf(transformer.getTo());
        Set<QName> tos = this._transformers.get(from);
        if (tos == null) {
            tos = new HashSet<QName>();
            this._transformers.put(from, tos);
        }
        tos.add(to);
    }

    private void collectNamesAndWires(SwitchYardType switchyard) {
        if (switchyard == null || switchyard.getComposite() == null) {
            return;
        }
        Composite composite = switchyard.getComposite();
        for (Service service : composite.getService()) {
            this.addWires(service);
            this.addDependency(service);
            if (service.getName() != null) continue;
        }
        for (Reference reference : composite.getReference()) {
            this.addWires(reference);
            this.addDependency(reference);
            if (reference.getName() == null) continue;
            Set<Contract> contracts = this._names.get(reference.getName());
            if (contracts == null) {
                contracts = new LinkedHashSet<Contract>();
                this._names.put(reference.getName(), contracts);
            }
            contracts.add((Contract)reference);
        }
        for (Component component : composite.getComponent()) {
            this.addDependency(component);
            Iterator iterator = component.getService().iterator();
            if (!iterator.hasNext()) continue;
            ComponentService service = (ComponentService)iterator.next();
            this.addDependency(service);
            if (service.getName() == null) continue;
            Set<Contract> contracts = this._names.get(service.getName());
            if (contracts == null) {
                contracts = new LinkedHashSet<Contract>();
                this._names.put(service.getName(), contracts);
            }
            contracts.add((Contract)service);
        }
        for (Component component : composite.getComponent()) {
            for (ComponentReference reference : component.getReference()) {
                this.addDependency(reference);
                if (reference.getName() == null || !this._names.containsKey(reference.getName())) continue;
                this.addWiresForReference(reference, (Collection<Contract>)this._names.get(reference.getName()));
            }
        }
    }

    private void addWires(Service service) {
        if (service.getPromote() == null) {
            return;
        }
        this.addWires((Contract)service, Collections.singleton(service.getPromote()));
        this.addWires((Contract)service.getPromote(), Collections.singleton(service));
    }

    private void addWires(Reference reference) {
        if (reference.getPromote().isEmpty()) {
            return;
        }
        this.addWires((Contract)reference, (Collection<? extends Contract>)reference.getPromote());
        for (ComponentReference promotedReference : reference.getPromote()) {
            this.addWires((Contract)promotedReference, Collections.singleton(reference));
        }
    }

    private void addWiresForReference(ComponentReference reference, Collection<Contract> contracts) {
        this.addWires((Contract)reference, contracts);
        for (Contract contract : contracts) {
            this.addWires(contract, Collections.singleton(reference));
        }
    }

    private void addWires(Contract source, Collection<? extends Contract> targets) {
        Set<Contract> contracts = this._wires.get(source);
        if (contracts == null) {
            contracts = new HashSet<Contract>(targets);
            this._wires.put(source, contracts);
            return;
        }
        contracts.addAll(targets);
    }

    private void collectServiceInterfaces(SwitchYardType switchyard) {
        if (switchyard == null) {
            return;
        }
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader(JavaCore.create((IProject)WorkspaceSynchronizer.getFile((Resource)switchyard.eResource()).getProject()), this.getClass().getClassLoader()));
                TreeIterator it = EcoreUtil.getAllContents((EObject)switchyard, (boolean)true);
                while (it.hasNext()) {
                    Interface intf;
                    EObject eobject = (EObject)it.next();
                    if (!(eobject instanceof Contract) || (intf = ((Contract)eobject).getInterface()) == null) continue;
                    try {
                        ServiceInterface si = SwitchYardModelUtils.getServiceInterface(intf);
                        if (si == null) continue;
                        this._serviceInterfaces.put((Contract)eobject, si);
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            if (e.getMessage().startsWith("SWITCHYARD010004")) {
                                this._serviceInterfaces.put((Contract)eobject, INVALID_SERVICE_INTERFACE);
                                continue;
                            }
                            this._serviceInterfaces.put((Contract)eobject, URESOLVABLE_SERVICE_INTERFACE);
                            continue;
                        }
                        this._serviceInterfaces.put((Contract)eobject, URESOLVABLE_SERVICE_INTERFACE);
                    }
                }
            }
            catch (Exception e) {
                e.fillInStackTrace();
                this._problems.add((IStatus)new Status(2, "org.switchyard.tools.ui", Messages.WiringValidationContext_statusMessage_errorLoadingServiceInterfaceMetadata));
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }
}

