/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProject;
import org.switchyard.tools.ui.i18n.Messages;

public final class SwitchYardProjectManager {
    public static final Object SWITCHYARD_PROJECT_REFRESH_JOB_FAMILY = new Object();
    private static final SwitchYardProjectManager INSTANCE = new SwitchYardProjectManager();
    private Map<IProject, SwitchYardProject> _cache = new HashMap<IProject, SwitchYardProject>();
    private Set<ISwitchYardProjectListener> _listeners = new LinkedHashSet<ISwitchYardProjectListener>();
    private IResourceDeltaVisitor _configFileChangedVisitor = new ConfigFileChangedResourceDeltaVisitor();
    private IResourceDeltaVisitor _projectDeletedVisitor = new ProjectDeletedResourceDeltaVisitor();
    private ConcurrentMap<SwitchYardProject, Set<ISwitchYardProjectListener.Type>> _pendingUpdates = new ConcurrentHashMap<SwitchYardProject, Set<ISwitchYardProjectListener.Type>>();
    private Job _projectUpdateJob = new UpdateMetadataJob();

    public static SwitchYardProjectManager instance() {
        return INSTANCE;
    }

    private SwitchYardProjectManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                try {
                    delta.accept(SwitchYardProjectManager.this._projectDeletedVisitor);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                try {
                    delta.accept(SwitchYardProjectManager.this._configFileChangedVisitor);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }, 16);
    }

    public ISwitchYardProject getSwitchYardProject(IProject project) {
        if (this._cache.containsKey(project)) {
            return this._cache.get(project);
        }
        SwitchYardProject switchYardProject = new SwitchYardProject(this, project);
        this._cache.put(project, switchYardProject);
        if (switchYardProject.needsLoading()) {
            this.scheduleRefresh(switchYardProject, EnumSet.of(ISwitchYardProjectListener.Type.POM, ISwitchYardProjectListener.Type.CONFIG));
        }
        return switchYardProject;
    }

    public synchronized void addListener(ISwitchYardProjectListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void removeListener(ISwitchYardProjectListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(SwitchYardProject project, Set<ISwitchYardProjectListener.Type> types) {
        ArrayList<ISwitchYardProjectListener> listeners;
        SwitchYardProjectManager switchYardProjectManager = this;
        synchronized (switchYardProjectManager) {
            listeners = new ArrayList<ISwitchYardProjectListener>(this._listeners);
        }
        for (ISwitchYardProjectListener listener : listeners) {
            try {
                listener.projectUpdated(project, types);
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
    }

    public boolean refreshScheduled(ISwitchYardProject project) {
        return this._pendingUpdates.containsKey(project);
    }

    private void scheduleRefresh(SwitchYardProject switchYardProject, Set<ISwitchYardProjectListener.Type> updateTypes) {
        Set<ISwitchYardProjectListener.Type> existing = this._pendingUpdates.putIfAbsent(switchYardProject, updateTypes);
        if (existing == null) {
            this._projectUpdateJob.schedule(1000L);
        } else {
            updateTypes.addAll(existing);
            this._pendingUpdates.put(switchYardProject, updateTypes);
        }
    }

    private final class ConfigFileChangedResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private ConfigFileChangedResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResourceDelta configDelta;
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    break;
                }
                default: {
                    return false;
                }
            }
            IProject project = (IProject)resource;
            if (!SwitchYardProjectManager.this._cache.containsKey(project)) {
                return false;
            }
            SwitchYardProject switchYardProject = (SwitchYardProject)SwitchYardProjectManager.this._cache.get(project);
            if (switchYardProject.getOutputSwitchYardConfigurationFile() != null && (configDelta = delta.findMember(switchYardProject.getOutputSwitchYardConfigurationFile().getProjectRelativePath())) != null && (configDelta.getFlags() & 0x20000) != 131072) {
                SwitchYardProjectManager.this.notify(switchYardProject, EnumSet.of(ISwitchYardProjectListener.Type.CONFIG));
            }
            return false;
        }
    }

    public static interface ISwitchYardProjectListener {
        public void projectUpdated(ISwitchYardProject var1, Set<Type> var2);

        public static enum Type {
            POM,
            CONFIG,
            REMOVED;

        }
    }

    private final class ProjectDeletedResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private ProjectDeletedResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    break;
                }
                default: {
                    return false;
                }
            }
            IProject project = (IProject)resource;
            if (!SwitchYardProjectManager.this._cache.containsKey(project)) {
                return false;
            }
            if (delta.getKind() == 2 || (delta.getFlags() & 0x4000) == 16384 && !project.isOpen()) {
                SwitchYardProject syp = (SwitchYardProject)SwitchYardProjectManager.this._cache.remove(project);
                SwitchYardProjectManager.this._pendingUpdates.remove(syp);
                SwitchYardProjectManager.this.notify(syp, EnumSet.of(ISwitchYardProjectListener.Type.REMOVED));
                syp.dispose();
                return false;
            }
            return false;
        }
    }

    private final class UpdateMetadataJob
    extends Job {
        private UpdateMetadataJob() {
            super(Messages.SwitchYardProjectManager_UpdatingProjectMetadataJob);
            this.setPriority(40);
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[DOLOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean belongsTo(Object family) {
            return family == SWITCHYARD_PROJECT_REFRESH_JOB_FAMILY || super.belongsTo(family);
        }

        public boolean shouldRun() {
            return SwitchYardProjectManager.this._pendingUpdates.size() > 0;
        }
    }
}

