/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public final class JavaUtil {
    public static final IJavaElement getInitialJavaElementForResource(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getType() == 8) {
            return null;
        }
        IJavaElement element = JavaCore.create((IResource)resource);
        if (element == null) {
            element = JavaCore.create((IProject)resource.getProject());
        }
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 2) {
            element = JavaUtil.getInitialPackageForProject((IJavaProject)element);
        }
        return element;
    }

    public static IJavaElement getInitialPackageForProject(IJavaProject project) {
        if (project == null) {
            return null;
        }
        try {
            IPackageFragmentRoot sourceRoot = JavaUtil.getFirstJavaSourceRoot(project);
            if (sourceRoot == null) {
                return project;
            }
            IJavaElement[] packages = sourceRoot.getChildren();
            IPackageFragmentRoot element = sourceRoot;
            int i = 0;
            while (i < packages.length) {
                IPackageFragment frag = (IPackageFragment)packages[i];
                element = frag;
                if (!(frag.isDefaultPackage() || frag.hasSubpackages() && !frag.containsJavaResources())) {
                    element = frag;
                    break;
                }
                ++i;
            }
            return element;
        }
        catch (JavaModelException javaModelException) {
            return project;
        }
    }

    public static IPackageFragmentRoot getFirstJavaSourceRoot(IJavaProject project) {
        if (project == null) {
            return null;
        }
        try {
            IPackageFragmentRoot sourceRoot = null;
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
            if (facade == null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot frag = iPackageFragmentRootArray[n2];
                    if (frag.getKind() == 1) {
                        sourceRoot = frag;
                        break;
                    }
                    ++n2;
                }
            } else {
                IPath projectPath = project.getPath();
                IPath[] iPathArray = facade.getCompileSourceLocations();
                int n = iPathArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IPath sourcePath = iPathArray[n3];
                    IPackageFragmentRoot frag = project.findPackageFragmentRoot(projectPath.append(sourcePath));
                    if (frag != null) {
                        sourceRoot = frag;
                        break;
                    }
                    ++n3;
                }
            }
            return sourceRoot;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IResource getFirstResourceRoot(IJavaProject project) {
        if (project == null) {
            return null;
        }
        try {
            IResource sourceRoot = null;
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
            if (facade == null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot frag = iPackageFragmentRootArray[n2];
                    if (frag.getKind() == 1) {
                        sourceRoot = frag.getUnderlyingResource();
                        break;
                    }
                    ++n2;
                }
            } else {
                IProject projectResource = project.getProject();
                IPath[] iPathArray = facade.getResourceLocations();
                int n = iPathArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IPath sourcePath = iPathArray[n3];
                    sourceRoot = projectResource.findMember(sourcePath);
                    if (sourceRoot == null) {
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
            return sourceRoot;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IPath getJavaPathForResource(IResource resource) {
        if (resource == null || resource.getType() == 4 || resource.getType() == 8) {
            return null;
        }
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (project == null) {
            return resource.getFullPath().removeFirstSegments(1);
        }
        IResource container = resource;
        if (container.getType() == 1) {
            container = container.getParent();
        }
        IJavaElement element = null;
        while (element == null && container != null) {
            element = JavaCore.create((IResource)container, (IJavaProject)project);
            container = container.getParent();
        }
        if (element == null) {
            return resource.getFullPath().removeFirstSegments(1);
        }
        if (element.getElementType() == 4) {
            return resource.getFullPath().makeRelativeTo(element.getParent().getPath());
        }
        return resource.getFullPath().makeRelativeTo(element.getPath());
    }

    public static ClassLoader getProjectClassLoader(IJavaProject javaProject, ClassLoader parentClassLoader) throws Exception {
        IProject project = javaProject.getProject();
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 2) {
                IPath projectPath = classpathEntry.getPath();
                IProject otherProject = root.getProject(projectPath.segment(0));
                IJavaProject otherJavaProject = JavaCore.create((IProject)otherProject);
                urls.add(new File(otherProject.getLocation() + "/" + otherJavaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
            } else if (classpathEntry.getEntryKind() == 1) {
                urls.add(new File(classpathEntry.getPath().toOSString()).toURI().toURL());
            }
            ++n2;
        }
        if (parentClassLoader == null) {
            return new URLClassLoader(urls.toArray(new URL[urls.size()]));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader);
    }

    private JavaUtil() {
    }
}

