/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.editor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.features.IShapeFeatureContainer;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.features.JbpmCustomTaskFeatureContainer;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.features.JbpmTaskFeatureContainer;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util.JbpmModelUtil;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.features.activity.task.TaskFeatureContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class SwitchYardCustomTaskFeatureContainer
extends JbpmCustomTaskFeatureContainer {
    public boolean isAvailable(IFeatureProvider fp) {
        return this.isSwitchYardProject(fp);
    }

    protected IShapeFeatureContainer createFeatureContainer(IFeatureProvider fp) {
        return new TaskFeatureContainer(){

            public ICreateFeature getCreateFeature(IFeatureProvider fp) {
                return new SwitchYardServiceTaskCreateFeature(fp);
            }

            public IAddFeature getAddFeature(IFeatureProvider fp) {
                return new JbpmTaskFeatureContainer.JbpmAddTaskFeature(fp);
            }
        };
    }

    private boolean isSwitchYardProject(IFeatureProvider fp) {
        try {
            BPMN2Editor editor = (BPMN2Editor)fp.getDiagramTypeProvider().getDiagramEditor();
            return FacetedProjectFramework.hasProjectFacet((IProject)editor.getModelFile().getProject(), (String)"switchyard.core");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private final class SwitchYardServiceTaskCreateFeature
    extends JbpmCustomTaskFeatureContainer.JbpmCreateCustomTaskFeature {
        private SwitchYardServiceTaskCreateFeature(IFeatureProvider fp) {
            super((JbpmCustomTaskFeatureContainer)SwitchYardCustomTaskFeatureContainer.this, fp);
        }

        public boolean isAvailable(IContext context) {
            return super.isAvailable(context) && SwitchYardCustomTaskFeatureContainer.this.isSwitchYardProject((IFeatureProvider)SwitchYardCustomTaskFeatureContainer.this.fp);
        }

        public Task createBusinessObject(ICreateContext context) {
            Task task = super.createBusinessObject(context);
            Resource resource = ((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer())).eResource();
            for (DataInputAssociation inputAssociation : task.getDataInputAssociations()) {
                DataInput input = (DataInput)inputAssociation.getTargetRef();
                if ("ParameterName".equals(input.getName()) || "ResultName".equals(input.getName())) {
                    this.addInputAssignment(resource, inputAssociation.getAssignment(), input);
                }
                input.setItemSubjectRef(JbpmModelUtil.getDataType((EObject)context.getTargetContainer(), (Object)"String"));
            }
            return task;
        }

        private void addInputAssignment(Resource resource, List<Assignment> assignments, DataInput input) {
            if (assignments == null) {
                return;
            }
            Iterator<Assignment> iterator = assignments.iterator();
            if (iterator.hasNext()) {
                Assignment assignment = iterator.next();
                FormalExpression toExpression = (FormalExpression)assignment.getTo();
                if (toExpression == null) {
                    toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    ModelUtil.setID((EObject)toExpression, (Resource)resource);
                }
                toExpression.setBody(input.getId());
                return;
            }
        }
    }
}

