/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.framework.wiring;

import java.io.IOException;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.osgi.jmx.Item;
import org.osgi.jmx.JmxConstants;

public interface BundleWiringStateMBean {
    public static final String OBJECTNAME = "osgi.core:type=wiringState,version=1.1";
    public static final String KEY = "Key";
    public static final Item KEY_ITEM = new Item("Key", "The directive key", SimpleType.STRING, new String[0]);
    public static final String VALUE = "Value";
    public static final Item VALUE_ITEM = new Item("Value", "The directive value", SimpleType.STRING, new String[0]);
    public static final CompositeType DIRECTIVE_TYPE = Item.compositeType("DIRECTIVE", "Describes a directive of a capability or requirement", KEY_ITEM, VALUE_ITEM);
    public static final TabularType DIRECTIVES_TYPE = Item.tabularType("DIRECTIVES", "Describes the directives of a capability or requirement", DIRECTIVE_TYPE, "Key");
    public static final String DIRECTIVES = "Directives";
    public static final Item DIRECTIVES_ITEM = new Item("Directives", "The directives of a capability or requirement", DIRECTIVES_TYPE, new String[0]);
    public static final TabularType ATTRIBUTES_TYPE = Item.tabularType("ATTRIBUTES", "Describes attributes of a capability or requirement", JmxConstants.PROPERTY_TYPE, "Key");
    public static final String ATTRIBUTES = "Attributes";
    public static final Item ATTRIBUTES_ITEM = new Item("Attributes", "The attributes of a capability or requirement", ATTRIBUTES_TYPE, new String[0]);
    public static final String NAMESPACE = "Namespace";
    public static final Item NAMESPACE_ITEM = new Item("Namespace", "The namespace of a capability or requirement", SimpleType.STRING, new String[0]);
    public static final CompositeType BUNDLE_REQUIREMENT_TYPE = Item.compositeType("BUNDLE_REQUIREMENT", "Describes the requirement of a bundle", ATTRIBUTES_ITEM, DIRECTIVES_ITEM, NAMESPACE_ITEM);
    public static final CompositeType BUNDLE_CAPABILITY_TYPE = Item.compositeType("BUNDLE_CAPABILITY", "Describes the capability of a bundle", ATTRIBUTES_ITEM, DIRECTIVES_ITEM, NAMESPACE_ITEM);
    public static final String PROVIDER_BUNDLE_ID = "ProviderBundleId";
    public static final Item PROVIDER_BUNDLE_ID_ITEM = new Item("ProviderBundleId", "The identifier of the bundle that is the provider of the capability", SimpleType.LONG, new String[0]);
    public static final String REQUIRER_BUNDLE_ID = "RequirerBundleId";
    public static final Item REQUIRER_BUNDLE_ID_ITEM = new Item("RequirerBundleId", "The identifier of the bundle that is the requirer of the requirement", SimpleType.LONG, new String[0]);
    public static final String BUNDLE_REQUIREMENT = "BundleRequirement";
    public static final Item BUNDLE_REQUIREMENT_ITEM = new Item("BundleRequirement", "The wired requirements of a bundle", BUNDLE_REQUIREMENT_TYPE, new String[0]);
    public static final String BUNDLE_CAPABILITY = "BundleCapability";
    public static final Item BUNDLE_CAPABILITY_ITEM = new Item("BundleCapability", "The wired capabilities of a bundle", BUNDLE_CAPABILITY_TYPE, new String[0]);
    public static final String PROVIDER_BUNDLE_REVISION_ID = "ProviderBundleRevisionId";
    public static final Item PROVIDER_BUNDLE_REVISION_ID_ITEM = new Item("ProviderBundleRevisionId", "A local id for the bundle revision that is the provider of the capability", SimpleType.INTEGER, new String[0]);
    public static final String REQUIRER_BUNDLE_REVISION_ID = "RequirerBundleRevisionId";
    public static final Item REQUIRER_BUNDLE_REVISION_ID_ITEM = new Item("RequirerBundleRevisionId", "A local id for the bundle revision that is the requirer of the requirement", SimpleType.INTEGER, new String[0]);
    public static final CompositeType BUNDLE_WIRE_TYPE = Item.compositeType("BUNDLE_WIRE", "Describes the live association between a provider and a requirer", BUNDLE_REQUIREMENT_ITEM, BUNDLE_CAPABILITY_ITEM, PROVIDER_BUNDLE_ID_ITEM, PROVIDER_BUNDLE_REVISION_ID_ITEM, REQUIRER_BUNDLE_ID_ITEM, REQUIRER_BUNDLE_REVISION_ID_ITEM);
    public static final ArrayType<CompositeData> BUNDLE_WIRES_TYPE_ARRAY = Item.arrayType(1, BUNDLE_WIRE_TYPE);
    public static final String BUNDLE_REVISION_ID = "BundleRevisionId";
    public static final Item BUNDLE_REVISION_ID_ITEM = new Item("BundleRevisionId", "The local identifier of the bundle revision", SimpleType.INTEGER, new String[0]);
    public static final String BUNDLE_ID = "BundleId";
    public static final Item BUNDLE_ID_ITEM = new Item("BundleId", "The bundle identifier of the bundle revision", SimpleType.LONG, new String[0]);
    public static final ArrayType<CompositeData> REQUIREMENT_TYPE_ARRAY = Item.arrayType(1, BUNDLE_REQUIREMENT_TYPE);
    public static final ArrayType<CompositeData> CAPABILITY_TYPE_ARRAY = Item.arrayType(1, BUNDLE_CAPABILITY_TYPE);
    public static final String REQUIREMENTS = "Requirements";
    public static final Item REQUIREMENTS_ITEM = new Item("Requirements", "The bundle requirements of a bundle revision wiring", REQUIREMENT_TYPE_ARRAY, new String[0]);
    public static final CompositeType REVISION_REQUIREMENTS_TYPE = Item.compositeType("REVISION_REQUIREMENTS", "Describes the requirements for a bundle revision", BUNDLE_REVISION_ID_ITEM, REQUIREMENTS_ITEM);
    public static final TabularType REVISIONS_REQUIREMENTS_TYPE = Item.tabularType("REVISIONS_REQUIREMENTS", "The bundle requirements for all bundle revisions", REVISION_REQUIREMENTS_TYPE, "BundleRevisionId");
    public static final String CAPABILITIES = "Capabilities";
    public static final Item CAPABILITIES_ITEM = new Item("Capabilities", "The bundle capabilities of a bundle revision wiring", CAPABILITY_TYPE_ARRAY, new String[0]);
    public static final CompositeType REVISION_CAPABILITIES_TYPE = Item.compositeType("REVISION_CAPABILITIES", "Describes the capabilities for a bundle revision", BUNDLE_REVISION_ID_ITEM, CAPABILITIES_ITEM);
    public static final TabularType REVISIONS_CAPABILITIES_TYPE = Item.tabularType("REVISIONS_CAPABILITIES", "The bundle capabilities for all bundle revisions", REVISION_CAPABILITIES_TYPE, "BundleRevisionId");
    public static final String PROVIDED_WIRES = "ProvidedWires";
    public static final Item PROVIDED_WIRES_ITEM = new Item("ProvidedWires", "The bundle wires to the capabilities provided by this bundle wiring.", BUNDLE_WIRES_TYPE_ARRAY, new String[0]);
    public static final String REQUIRED_WIRES = "RequiredWires";
    public static final Item REQUIRED_WIRES_ITEM = new Item("RequiredWires", "The bundle wires to requirements in use by this bundle wiring", BUNDLE_WIRES_TYPE_ARRAY, new String[0]);
    public static final CompositeType BUNDLE_WIRING_TYPE = Item.compositeType("BUNDLE_WIRING", "Describes the runtime association between a provider and a requirer", BUNDLE_ID_ITEM, BUNDLE_REVISION_ID_ITEM, REQUIREMENTS_ITEM, CAPABILITIES_ITEM, REQUIRED_WIRES_ITEM, PROVIDED_WIRES_ITEM);
    public static final TabularType BUNDLES_WIRING_TYPE = Item.tabularType("BUNDLES_WIRING", "The bundle wiring for all bundle revisions", BUNDLE_WIRING_TYPE, "BundleId", "BundleRevisionId");

    public CompositeData[] getCurrentRevisionDeclaredRequirements(long var1, String var3) throws IOException, JMException;

    public CompositeData[] getCurrentRevisionDeclaredCapabilities(long var1, String var3) throws IOException, JMException;

    public CompositeData getCurrentWiring(long var1, String var3) throws IOException, JMException;

    public TabularData getCurrentWiringClosure(long var1, String var3) throws IOException, JMException;

    public TabularData getRevisionsDeclaredRequirements(long var1, String var3) throws IOException, JMException;

    public TabularData getRevisionsDeclaredCapabilities(long var1, String var3) throws IOException, JMException;

    public TabularData getRevisionsWiring(long var1, String var3) throws IOException, JMException;

    public TabularData getRevisionsWiringClosure(long var1, String var3) throws IOException, JMException;
}

