/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OperationType implements Enumerator
{
    EXECUTE(0, "EXECUTE", "EXECUTE"),
    INSERT(1, "INSERT", "INSERT"),
    FIREALLRULES(2, "FIREALLRULES", "FIRE_ALL_RULES"),
    FIREUNTILHALT(3, "FIREUNTILHALT", "FIRE_UNTIL_HALT");

    public static final int EXECUTE_VALUE = 0;
    public static final int INSERT_VALUE = 1;
    public static final int FIREALLRULES_VALUE = 2;
    public static final int FIREUNTILHALT_VALUE = 3;
    private static final OperationType[] VALUES_ARRAY;
    public static final List<OperationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperationType[]{EXECUTE, INSERT, FIREALLRULES, FIREUNTILHALT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationType get(int value) {
        switch (value) {
            case 0: {
                return EXECUTE;
            }
            case 1: {
                return INSERT;
            }
            case 2: {
                return FIREALLRULES;
            }
            case 3: {
                return FIREUNTILHALT;
            }
        }
        return null;
    }

    private OperationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

