/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.core.query;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.teiid.designer.query.sql.lang.ICommand;

/** 
 * ValidationResult, utility containign the status of validating sql.
 *
 * @since 8.0
 */
public interface QueryValidationResult {

    /**
     * Get the Parsable status
     * @return 'true' if parsable, 'false' if not
     */
    boolean isParsable();
    
    /**
     * Get the Resolvable status
     * @return 'true' if resolvable, 'false' if not
     */
    boolean isResolvable();
    
    /**
     * Get the Validatable status
     * @return 'true' if validatable, 'false' if not
     */
    boolean isValidatable();
    
	/**
	 * Get the Command language object.  This will be null if the
	 * SQL String was not parsable.
	 * @return the SQL command
	 */
	ICommand getCommand();
	
    /**
     * Get the status List indicating the success/ failure of validation
     * @return the Collection of IStatus objects
     */
    Collection<IStatus> getStatusList();
    
    /**
     * Get the status List indicating the success/ failure of update SQL validation
     * @return the Collection of IStatus objects
     */
    Collection<IStatus> getUpdateStatusList();
    
    /**
     * Get the status List indicating the success/ failure of update SQL validation for the given
     * command type, INSERT, UPDATE, DELETE (see QueryValidator constants)
     * 
     * @param cmdType
     * @return the Collection of IStatus objects
     */
    Collection<IStatus> getUpdateStatusList(int cmdType);
}
