/*
 * JBoss, Home of Professional Open Source.
*
* See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
*
* See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
*/
package org.teiid.designer.query.sql;

import java.util.Collection;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IFunction;

/**
 *
 */
public interface IFunctionCollectorVisitor<LO extends ILanguageObject, F extends IFunction> {

    /**
     * Get the functions from the given language object
     * 
     * @param obj Language object
     * @param removeDuplicates remove duplicates
     * @param deep collect deeply
     * 
     * @return collection of functions
     */
    Collection<F> findFunctions(LO obj, boolean deep);
}
