/* Generated By:JJTree&JavaCC: Do not edit this line. Teiid8Parser.java */
package org.teiid.query.parser.v8;
import org.teiid.query.sql.lang.*;


import java.math.BigInteger;
import java.util.*;
import java.util.regex.Matcher;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion.Version;
import org.teiid.designer.query.sql.lang.IMatchCriteria.MatchMode;
import org.teiid.designer.query.sql.lang.IJoinType;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.runtime.client.Messages;
import org.teiid.language.SortSpecification.NullOrdering;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.BaseColumn.NullType;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.query.parser.AbstractTeiidParser;
import org.teiid.query.parser.ParsedDataType;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidNodeFactory.ASTNodes;
import org.teiid.query.sql.lang.*;
import org.teiid.query.sql.lang.CriteriaOperator.Operator;
import org.teiid.query.sql.lang.SubqueryCompareCriteria.PredicateQuantifier;
import org.teiid.query.sql.proc.*;
import org.teiid.query.sql.symbol.*;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.StringUtil;

/** 
 * <p>The SQLParser is a JavaCC-generated parser that reads a SQL string and produces a 
 * Query object.  The SQLParser.java file is generated by JavaCC from the SQLParser.jj
 * file.  <B>WARNING:</B> DO NOT MODIFY the SQLParser.java file as it will be 
 * regenerated from the .jj file and your changes will be lost!</p>
 */
@SuppressWarnings({"nls", "unused", "javadoc"})
public class Teiid8Parser extends AbstractTeiidParser/*@bgen(jjtree)*/implements Teiid8ParserTreeConstants, Teiid8ParserConstants {/*@bgen(jjtree)*/
  protected JJTTeiid8ParserState jjtree = new JJTTeiid8ParserState();
    private String getHintComment(Token t) {
        Token optToken = t.specialToken;
        if (optToken == null) {
            return ""; //$NON-NLS-1$
        }

        //handle nested comments
        String image = optToken.image;
        while (optToken.specialToken != null) {
            optToken = optToken.specialToken;
            image = optToken.image + image;
        }

        String hint = image.substring(2, image.length() - 2);
        if (hint.startsWith("+")) { //$NON-NLS-1$
            hint = hint.substring(1);
        }

        return hint;
    }

    private boolean isNonStrictHint(Token t) {
        String[] parts = getHintComment(t).split("\u005c\u005cs"); //$NON-NLS-1$
        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equalsIgnoreCase(Limit.NON_STRICT)) {
                return true;
            }
        }
        return false;
    }

    private SourceHint getSourceHint(Token t) {
        String comment = getHintComment(t);
        Matcher matcher = SOURCE_HINT.matcher(comment);
        if (!matcher.find()) {
            return null;
        }

        SourceHint sourceHint = new SourceHint();
        if (matcher.group(1) != null) {
            sourceHint.setUseAliases(true);
        }

        String generalHint = matcher.group(2);
        if (generalHint != null) {
            sourceHint.setGeneralHint(normalizeStringLiteral(generalHint));
        }

        int end = matcher.end();
        matcher = SOURCE_HINT_ARG.matcher(comment);
        while (matcher.find(end)) {
            end = matcher.end();
            sourceHint.setSourceHint(matcher.group(1), normalizeStringLiteral(matcher.group(3)), matcher.group(2) != null);
        }

        return sourceHint;
    }

    private SourceHint getSourceHint(Teiid8Parser parser) {
       int index = 1;
       //scan for the first keyword
       Token t = null;
       do {
           t = parser.getToken(index++);
       } while (t != null && t.kind == LPAREN);
       t = parser.getToken(index);
       if (t == null) {
           return null;
       }

       return getSourceHint(t);
    }

    private SubqueryHint getSubqueryHint(Token t) {
        SubqueryHint hint = new SubqueryHint();
        String[] parts = getHintComment(t).split("\u005c\u005cs"); //$NON-NLS-1$
        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equalsIgnoreCase(SubqueryHint.MJ)) {
                hint.setMergeJoin(true);
            } else if (parts[i].equalsIgnoreCase(SubqueryHint.NOUNNEST)) {
                hint.setNoUnnest(true);
            } else if (parts[i].equalsIgnoreCase(SubqueryHint.DJ)) {
                hint.setDepJoin();
            }
        }
        return hint;
    }

    private void setFromClauseOptions(Token groupID, FromClause fromClause){
        String[] parts = getHintComment(groupID).split("\u005c\u005cs"); //$NON-NLS-1$

        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equalsIgnoreCase(Option.OPTIONAL)) {
                fromClause.setOptional(true);
            } else if (parts[i].equalsIgnoreCase(Option.MAKEDEP)) {
                fromClause.setMakeDep(true);
            } else if (parts[i].equalsIgnoreCase(Option.MAKENOTDEP)) {
                fromClause.setMakeNotDep(true);
            } else if (parts[i].equalsIgnoreCase(FromClause.MAKEIND)) {
                fromClause.setMakeInd(true);
            } else if (parts[i].equalsIgnoreCase(SubqueryHint.NOUNNEST)) {
                fromClause.setNoUnnest(true);
            } else if (parts[i].equalsIgnoreCase(FromClause.PRESERVE)) {
                fromClause.setPreserve(true);
            }
        }
    }

    @Override
    public ITeiidServerVersion getVersion() {
        if (version == null)
            version = new TeiidServerVersion("8.x.x");

        return version;
    }

    private void requires(boolean condition) throws ParseException {
        if (!condition)
            throw new ParseException(Messages.getString(
                Messages.TeiidParser.teiid_version_failure, getVersion().toString()));
    }

    private void requiresVersionAtLeast(Version version) throws ParseException {
        if (! versionAtLeast(version))
            throw new ParseException(Messages.getString(
                Messages.TeiidParser.teiid_version_atleast_failure, version.get().toString(), getVersion().toString()));
    }

/*
name=string
description=A string literal value.  Use '' to escape ' in the string.  
example={code:sql}'a string'{code}\n{code:sql}'it''s a string'{code}
*/
  final public String stringVal() throws ParseException {
        Token t = null;
    t = jj_consume_token(STRINGVAL);
                {if (true) return normalizeStringLiteral(t.image);}
    throw new Error("Missing return statement in function");
  }

/*
name=non-reserved identifier
description=Allows non-reserved keywords to be parsed as identifiers  
example=SELECT *COUNT* FROM ...
*/
  final public Token nonReserved() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTEAD:
      jj_consume_token(INSTEAD);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case ENABLED:
      jj_consume_token(ENABLED);
      break;
    case DISABLED:
      jj_consume_token(DISABLED);
      break;
    case KEY:
      jj_consume_token(KEY);
      break;
    case SERIAL:
      jj_consume_token(SERIAL);
      break;
    case TEXTAGG:
      jj_consume_token(TEXTAGG);
      break;
    case COUNT:
      jj_consume_token(COUNT);
      break;
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    case SUM:
      jj_consume_token(SUM);
      break;
    case AVG:
      jj_consume_token(AVG);
      break;
    case MIN:
      jj_consume_token(MIN);
      break;
    case MAX:
      jj_consume_token(MAX);
      break;
    case EVERY:
      jj_consume_token(EVERY);
      break;
    case STDDEV_POP:
      jj_consume_token(STDDEV_POP);
      break;
    case STDDEV_SAMP:
      jj_consume_token(STDDEV_SAMP);
      break;
    case VAR_SAMP:
      jj_consume_token(VAR_SAMP);
      break;
    case VAR_POP:
      jj_consume_token(VAR_POP);
      break;
    case DOCUMENT:
      jj_consume_token(DOCUMENT);
      break;
    case CONTENT:
      jj_consume_token(CONTENT);
      break;
    case TRIM:
      jj_consume_token(TRIM);
      break;
    case EMPTY:
      jj_consume_token(EMPTY);
      break;
    case ORDINALITY:
      jj_consume_token(ORDINALITY);
      break;
    case PATH:
      jj_consume_token(PATH);
      break;
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case LAST:
      jj_consume_token(LAST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
      break;
    case EXTRACT:
      jj_consume_token(EXTRACT);
      break;
    case TO_CHARS:
      jj_consume_token(TO_CHARS);
      break;
    case TO_BYTES:
      jj_consume_token(TO_BYTES);
      break;
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      break;
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      break;
    case QUERYSTRING:
      jj_consume_token(QUERYSTRING);
      break;
    case NAMESPACE:
      jj_consume_token(NAMESPACE);
      break;
    case RESULT:
      jj_consume_token(RESULT);
      break;
    case INDEX:
      jj_consume_token(INDEX);
      break;
    case ACCESSPATTERN:
      jj_consume_token(ACCESSPATTERN);
      break;
    case AUTO_INCREMENT:
      jj_consume_token(AUTO_INCREMENT);
      break;
    case WELLFORMED:
      jj_consume_token(WELLFORMED);
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
      break;
    case TEXTTABLE:
      jj_consume_token(TEXTTABLE);
      break;
    case ARRAYTABLE:
      jj_consume_token(ARRAYTABLE);
      break;
    case SELECTOR:
      jj_consume_token(SELECTOR);
      break;
    case SKIP_KEYWORD:
      jj_consume_token(SKIP_KEYWORD);
      break;
    case WIDTH:
      jj_consume_token(WIDTH);
      break;
    case PASSING:
      jj_consume_token(PASSING);
      break;
    case NAME:
      jj_consume_token(NAME);
      break;
    case ENCODING:
      jj_consume_token(ENCODING);
      break;
    case COLUMNS:
      jj_consume_token(COLUMNS);
      break;
    case DELIMITER:
      jj_consume_token(DELIMITER);
      break;
    case QUOTE:
      jj_consume_token(QUOTE);
      break;
    case HEADER:
      jj_consume_token(HEADER);
      break;
    case NULLS:
      jj_consume_token(NULLS);
      break;
    case OBJECTTABLE:
      jj_consume_token(OBJECTTABLE);
      break;
    case VERSION:
      jj_consume_token(VERSION);
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      break;
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      break;
    case XMLDECLARATION:
      jj_consume_token(XMLDECLARATION);
      break;
    case VARIADIC:
      jj_consume_token(VARIADIC);
      break;
    case RAISE:
      jj_consume_token(RAISE);
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      break;
    case CHAIN:
      jj_consume_token(CHAIN);
      break;
    case JSONARRAY_AGG:
      jj_consume_token(JSONARRAY_AGG);
      break;
    case JSONOBJECT:
      jj_consume_token(JSONOBJECT);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

/*
name=identifier
description=Partial or full name of a single entity.
example={code:sql}tbl.col{code}\n{code:sql}"tbl"."col"{code}
*/
  final public String id(Boolean validate) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
      break;
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
      nonReserved();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                String id = normalizeId(getToken(0).image);
                if (validate != null) {
                    try {
                           {if (true) return validateName(id, validate);}
                         } catch (Exception ex) {
                           {if (true) throw new ParseException(ex.getLocalizedMessage());}
                     }
                }
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

/* TODO: createProcedure should not be here, but is due to all of the legacy tests
unused=true
*/
  final public Command command(ParseInfo info) throws ParseException {
    Command command = null;
    if (jj_2_1(2)) {
      command = createProcedure(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        command = userCommand(info);
        break;
      case LBRACE:
        command = callableStatement(info);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/*
unused=true
*/
  final public Command designerCommand(ParseInfo info) throws ParseException {
        Command command = null;
    if (jj_2_2(2)) {
      command = createProcedure(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        command = forEachRowTriggerAction(info);
        break;
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        command = userCommand(info);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/*
name=create trigger
description=Creates a trigger action on the given target.
example={code:sql}CREATE TRIGGER ON vw INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC ... END{code}
*/
  final public Command createTrigger(ParseInfo info) throws ParseException {
        String target = null;
        TriggerAction triggerAction = null;
        Token event = null;
    jj_consume_token(CREATE);
    jj_consume_token(TRIGGER);
    jj_consume_token(ON);
    target = id(null);
    jj_consume_token(INSTEAD);
    jj_consume_token(OF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      event = jj_consume_token(INSERT);
      break;
    case UPDATE:
      event = jj_consume_token(UPDATE);
      break;
    case DELETE:
      event = jj_consume_token(DELETE);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    triggerAction = forEachRowTriggerAction(info);
                AlterTrigger alterTrigger = alterTrigger();
                alterTrigger.setTarget(groupSymbol(target));
                alterTrigger.setDefinition(triggerAction);
                alterTrigger.setEvent(Table.TriggerEvent.valueOf(event.image.toUpperCase()));
                alterTrigger.setCreate(true);
                {if (true) return alterTrigger;}
    throw new Error("Missing return statement in function");
  }

/*
name=alter
description=Alter the given target.
example={code:sql}ALTER VIEW vw AS SELECT col FROM tbl{code}
*/
  final public Command alter(ParseInfo info) throws ParseException {
        String target = null;
        QueryCommand command = null;
        Statement stmt = null;
        TriggerAction triggerAction = null;
        Token comment = null;
        Token event = null;
        Boolean enabled = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VIEW:
      jj_consume_token(VIEW);
      target = id(null);
      jj_consume_token(AS);
                                                 comment = getToken(1).specialToken;
      command = queryExpression(info);
                    if (comment != null) {
                            command.setCacheHint(getQueryCacheOption(comment.image));
                    }


            AlterView alterView = alterView();
                        alterView.setTarget(groupSymbol(target));
                        alterView.setDefinition(command);
                        {if (true) return alterView;}
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      target = id(null);
      jj_consume_token(AS);
                                                        comment = getToken(1).specialToken;
      stmt = statement(info);
                        CreateProcedureCommand cup = createASTNode(ASTNodes.CREATE_PROCEDURE_COMMAND);
                        cup.setBlock(asBlock(stmt));

                        if (comment != null) {
                            cup.setCacheHint(getQueryCacheOption(comment.image));
                    }

            AlterProcedure alterProc = alterProcedure();
                        alterProc.setTarget(groupSymbol(target));
                        alterProc.setDefinition(cup);
                        {if (true) return alterProc;}
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      jj_consume_token(ON);
      target = id(null);
      jj_consume_token(INSTEAD);
      jj_consume_token(OF);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
        event = jj_consume_token(INSERT);
        break;
      case UPDATE:
        event = jj_consume_token(UPDATE);
        break;
      case DELETE:
        event = jj_consume_token(DELETE);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        triggerAction = forEachRowTriggerAction(info);
        break;
      case ENABLED:
        jj_consume_token(ENABLED);
                              enabled=true;
        break;
      case DISABLED:
        jj_consume_token(DISABLED);
                                                          enabled=false;
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    AlterTrigger alterTrigger = alterTrigger();
                        alterTrigger.setTarget(groupSymbol(target));
                        alterTrigger.setDefinition(triggerAction);
                        alterTrigger.setEvent(Table.TriggerEvent.valueOf(event.image.toUpperCase()));
                        if (enabled != null) {
                                alterTrigger.setEnabled(enabled);
                        }
                        {if (true) return alterTrigger;}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=for each row trigger action
description=Defines an action to perform on each row.
example={code:sql}FOR EACH ROW BEGIN ATOMIC ... END{code}
*/
  final public TriggerAction forEachRowTriggerAction(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TriggerAction */
        TriggerAction jjtn000 = (TriggerAction)TeiidNodeFactory.jjtCreate(this, JJTTRIGGERACTION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Block b = block();
        b.setAtomic(true);
        Statement stmt = null;
    try {
      jj_consume_token(FOR);
      jj_consume_token(EACH);
      jj_consume_token(ROW);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEGIN:
        jj_consume_token(BEGIN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ATOMIC:
          jj_consume_token(ATOMIC);
          break;
        default:
          jj_la1[10] = jj_gen;
          ;
        }
        label_1:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ALTER:
          case BEGIN:
          case BREAK:
          case CALL:
          case CONTINUE:
          case CREATE:
          case DECLARE:
          case DELETE:
          case DROP:
          case ERROR:
          case EXEC:
          case EXECUTE:
          case IF:
          case INSERT:
          case LEAVE:
          case LOOP:
          case MERGE:
          case RETURN:
          case SELECT:
          case TABLE:
          case UPDATE:
          case VALUES:
          case WITH:
          case WHILE:
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case ID:
          case LPAREN:
            ;
            break;
          default:
            jj_la1[11] = jj_gen;
            break label_1;
          }
          stmt = statement(info);
            b.addStatement(stmt);
        }
        jj_consume_token(END);
        break;
      case ALTER:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case DROP:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case LOOP:
      case MERGE:
      case RETURN:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case WHILE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case LPAREN:
        stmt = statement(info);
       b = asBlock(stmt);
       b.setAtomic(true);
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setBlock(b);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=directly executable statement
description=A statement that can be executed at runtime.
example={code:sql}SELECT * FROM tbl{code}
index=true
*/
  final public Command userCommand(ParseInfo info) throws ParseException {
        Command command = null;
        SourceHint sourceHint = null;
        Block block = null;
      if (versionLessThan(Version.TEIID_8_4)) {
        int index = 1;
        Token t = null;
        do
          t = getToken(index++);
        while (t != null && t.kind == LPAREN);
        t = getToken(index);
        if (t != null)
          sourceHint = getSourceHint(t);
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      command = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      command = storedProcedure(info, 1);
      break;
    case INSERT:
    case MERGE:
      if (versionAtLeast(Version.TEIID_8_4)) sourceHint = getSourceHint(this);
      command = insert(info);
      break;
    case UPDATE:
      if (versionAtLeast(Version.TEIID_8_4)) sourceHint = getSourceHint(this);
      command = update(info);
      break;
    case DELETE:
      if (versionAtLeast(Version.TEIID_8_4)) sourceHint = getSourceHint(this);
      command = delete(info);
      break;
    case DROP:
      command = dropTable(info);
      break;
    default:
      jj_la1[13] = jj_gen;
      if (jj_2_3(2)) {
        command = createTempTable(info);
      } else if (jj_2_4(2)) {
        command = createForeignTempTable(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
          command = alter(info);
          break;
        case CREATE:
          command = createTrigger(info);
          break;
        case BEGIN:
      requiresVersionAtLeast(Version.TEIID_8_4);
          block = compoundStatement(info);
      CreateProcedureCommand procCommand = createASTNode(ASTNodes.CREATE_PROCEDURE_COMMAND);
      procCommand.setBlock(block);
      command = procCommand;
          break;
        default:
          jj_la1[14] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
            setSourceHint(sourceHint, command);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/*
name=drop table
description=Creates a trigger action on the given target.
example={code:sql}CREATE TRIGGER ON vw INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC ... END{code}
*/
  final public Drop dropTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Drop */
        Drop jjtn000 = (Drop)TeiidNodeFactory.jjtCreate(this, JJTDROP);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String table = null;
    try {
      jj_consume_token(DROP);
      jj_consume_token(TABLE);
      table = id(null);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setTable(groupSymbol(table));
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=create temporary table
description=Creates a temporary table.
example={code:sql}CREATE LOCAL TEMPORARY TABLE tmp (col integer){code}
*/
  final public Command createTempTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Create */
    Create jjtn000 = (Create)TeiidNodeFactory.jjtCreate(this, JJTCREATE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String table = null;
    String pkId = null;
    Column col = null;
    List<ElementSymbol> pk = null;
    boolean localToken = false;
    try {
      jj_consume_token(CREATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOCAL:
        jj_consume_token(LOCAL);
        localToken = true;
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      jj_consume_token(TEMPORARY);
      if(! localToken)
        // LOCAL is only optional for Teiid 8.5+
        requiresVersionAtLeast(Version.TEIID_8_5);
      jj_consume_token(TABLE);
      table = id(null);
      jj_consume_token(LPAREN);
        jjtn000.setTable(groupSymbol(table));
      col = tableElement(info);
      jjtn000.getColumns().add(col);
      label_2:
      while (true) {
        if (jj_2_5(2)) {
          ;
        } else {
          break label_2;
        }
        jj_consume_token(COMMA);
        col = tableElement(info);
        jjtn000.getColumns().add(col);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(PRIMARY);
        jj_consume_token(KEY);
        pk = columnList(true, true);
        jjtn000.getPrimaryKey().addAll(pk);
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=temporary table element
description=Defines a temporary table column.
example={code:sql}col string NOT NULL{code}
*/
  final public Column tableElement(ParseInfo info) throws ParseException {
    String element = null;
    ParsedDataType type = null;
    boolean autoIncrement = false;
    //TODO: once we support udts, then this will need to inherit the nullability from the type
    boolean notNull = false;
    element = id(Boolean.TRUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
      type = parseDataType();
      break;
    case SERIAL:
      jj_consume_token(SERIAL);
        type = new ParsedDataType("INTEGER");
        autoIncrement = true;
        notNull = true;
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                     notNull = true;
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
        Column c = new Column(getVersion());
        c.setName(element);
        c.setRuntimeType(type.getType());
        c.setAutoIncremented(autoIncrement);
        c.setNullType(notNull?NullType.No_Nulls:NullType.Nullable);
        {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

/*
name=raise error statement
description=Raises an error with the given message.
example={code:sql}ERROR 'something went wrong'{code}
*/
  final public RaiseStatement errorStatement(ParseInfo info) throws ParseException {
    Expression errMsg = null;
    jj_consume_token(ERROR);
    errMsg = expression(info);
        ExceptionExpression ee = exceptionExpression();
        ee.setMessage(errMsg);
        {if (true) return raiseStatementFromExpression(ee);}
    throw new Error("Missing return statement in function");
  }

/*
name=raise statement
description=Raises an error or warning with the given message.
example={code:sql}RAISE SQLEXCEPTION 'something went wrong'{code}
*/
  final public RaiseStatement raiseStatement(ParseInfo info) throws ParseException {
    RaiseStatement stmt = null;
    Expression err = null;
    boolean warning = false;
    jj_consume_token(RAISE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLWARNING:
      jj_consume_token(SQLWARNING);
                   warning = true;
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    err = exceptionReference(info);
        stmt = raiseStatementFromExpression(err);
        stmt.setWarning(warning);
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public RaiseStatement raiseStatementFromExpression(Expression expression) throws ParseException {
 /*@bgen(jjtree) RaiseStatement */
  RaiseStatement jjtn000 = (RaiseStatement)TeiidNodeFactory.jjtCreate(this, JJTRAISESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.setExpression(expression);
      {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=exception reference
description=a reference to an exception
example={code:sql}SQLEXCEPTION 'something went wrong' SQLSTATE '00X', 2{code}
*/
  final public Expression exceptionReference(ParseInfo info) throws ParseException {
        String id = null;
        Expression ex;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
      id = id(null);
                       {if (true) return elementSymbol(id);}
      break;
    case SQLEXCEPTION:
      ex = exception(info);
                {if (true) return ex;}
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=sql exception
description=creates a sql exception or warning with the specified message, state, and code
example={code:sql}SQLEXCEPTION 'something went wrong' SQLSTATE '00X', 2{code}
*/
  final public Expression exception(ParseInfo info) throws ParseException {
        Expression err = null;
        Expression sqlState = null;
        Expression errCode = null;
        Expression parent = null;
    jj_consume_token(SQLEXCEPTION);
    err = commonValueExpression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLSTATE:
      jj_consume_token(SQLSTATE);
      sqlState = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        errCode = commonValueExpression(info);
        break;
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAIN:
      jj_consume_token(CHAIN);
      parent = exceptionReference(info);
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
                ExceptionExpression ee = exceptionExpression();
                ee.setMessage(err);
                ee.setSqlState(sqlState);
                ee.setErrorCode(errCode);
                ee.setParent(parent);
                {if (true) return ee;}
    throw new Error("Missing return statement in function");
  }

  final public ExceptionExpression exceptionExpression() throws ParseException {
 /*@bgen(jjtree) ExceptionExpression */
  ExceptionExpression jjtn000 = (ExceptionExpression)TeiidNodeFactory.jjtCreate(this, JJTEXCEPTIONEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=statement
description=A procedure statement.
example={code:sql}IF (x = 5) BEGIN ... END{code}
*/
  final public Statement statement(ParseInfo info) throws ParseException {
    Statement stmt;
    String label = null;
    if (jj_2_6(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
        label = id(null);
        jj_consume_token(COLON);
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOOP:
        stmt = loopStatement(info);
        break;
      case WHILE:
        stmt = whileStatement(info);
        break;
      case BEGIN:
        stmt = compoundStatement(info);
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                ((Labeled)stmt).setLabel(label);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case DROP:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case MERGE:
      case RETURN:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IF:
          stmt = ifStatement(info);
          break;
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case DROP:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case INSERT:
        case LEAVE:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case LPAREN:
          stmt = delimitedStatement(info);
          break;
        default:
          jj_la1[26] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=delimited statement
description=A procedure statement terminated by ;.
example={code:sql}SELECT * FROM tbl;{code}
*/
  final public Statement delimitedStatement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    if (jj_2_7(2)) {
      stmt = assignStatement(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        stmt = sqlStatement(info);
        break;
      case ERROR:
        stmt = errorStatement(info);
        break;
      case RAISE:
        stmt = raiseStatement(info);
        break;
      case DECLARE:
        stmt = declareStatement(info);
        break;
      case BREAK:
      case CONTINUE:
      case LEAVE:
        stmt = branchingStatement(info);
        break;
      case RETURN:
        stmt = returnStatement(info);
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
             {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=compound statement
description=A procedure statement block contained in BEGIN END.
example={code:sql}BEGIN NOT ATOMIC ... END{code}
*/
  final public Block compoundStatement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    Block block = block();
    Boolean atomic = null;
    String eId = null;
    jj_consume_token(BEGIN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATOMIC:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                     atomic = Boolean.FALSE;
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      jj_consume_token(ATOMIC);
                                                         if (atomic == null) {atomic = Boolean.TRUE;}
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      if (jj_2_8(2)) {
        ;
      } else {
        break label_3;
      }
      stmt = statement(info);
        block.addStatement(stmt, false);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      eId = id(Boolean.FALSE);
                                              block.setExceptionGroup(eId);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case DROP:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case IF:
        case INSERT:
        case LEAVE:
        case LOOP:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case WHILE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case LPAREN:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_4;
        }
        stmt = statement(info);
         block.addStatement(stmt, true);
      }
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(END);
        if (atomic != null) {
                block.setAtomic(atomic);
        }
        {if (true) return block;}
    throw new Error("Missing return statement in function");
  }

/*
name=branching statement
description=A procedure branching control statement, which typically specifies a label to return control to.
example={code:sql}BREAK x{code}
*/
  final public BranchingStatement branchingStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) BranchingStatement */
    BranchingStatement jjtn000 = (BranchingStatement)TeiidNodeFactory.jjtCreate(this, JJTBRANCHINGSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token mode = null;
    String label = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BREAK:
      case CONTINUE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BREAK:
          mode = jj_consume_token(BREAK);
          break;
        case CONTINUE:
          mode = jj_consume_token(CONTINUE);
          break;
        default:
          jj_la1[33] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
          label = id(null);
          break;
        default:
          jj_la1[34] = jj_gen;
          ;
        }
        break;
      case LEAVE:
        mode = jj_consume_token(LEAVE);
        label = id(null);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setMode(BranchingStatement.BranchingMode.valueOf(mode.image.toUpperCase()));
            jjtn000.setLabel(label);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=return statement
description=A return statement.
example={code:sql}RETURN 1{code}
*/
  final public ReturnStatement returnStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ReturnStatement */
    ReturnStatement jjtn000 = (ReturnStatement)TeiidNodeFactory.jjtCreate(this, JJTRETURNSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression ex = null;
    try {
      jj_consume_token(RETURN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        ex = expression(info);
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setExpression(ex);
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=while statement
description=A procedure while statement that executes until its condition is false.
example={code:sql}WHILE (var) BEGIN ... END{code}
*/
  final public WhileStatement whileStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) WhileStatement */
    WhileStatement jjtn000 = (WhileStatement)TeiidNodeFactory.jjtCreate(this, JJTWHILESTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Criteria criteria = null;
    Statement stmt = null;
    try {
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      criteria = criteria(info);
      jj_consume_token(RPAREN);
      stmt = statement(info);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCondition(criteria);
        jjtn000.setBlock(asBlock(stmt));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=loop statement
description=A procedure loop statement that executes over the given cursor.
example={code:sql}LOOP ON (SELECT * FROM tbl) AS x BEGIN ... END{code}
*/
  final public LoopStatement loopStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) LoopStatement */
    LoopStatement jjtn000 = (LoopStatement)TeiidNodeFactory.jjtCreate(this, JJTLOOPSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String cursor = null;
    QueryCommand query = null;
    Statement stmt = null;
    try {
      jj_consume_token(LOOP);
      jj_consume_token(ON);
      jj_consume_token(LPAREN);
      query = queryExpression(info);
      jj_consume_token(RPAREN);
      jj_consume_token(AS);
      cursor = id(null);
      stmt = statement(info);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setBlock(asBlock(stmt));
        jjtn000.setCommand(query);
        jjtn000.setCursorName(cursor);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=if statement
description=A procedure loop statement that executes over the given cursor.
example={code:sql}IF (boolVal) BEGIN variables.x = 1 END ELSE BEGIN variables.x = 2 END{code}
*/
  final public IfStatement ifStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) IfStatement */
    IfStatement jjtn000 = (IfStatement)TeiidNodeFactory.jjtCreate(this, JJTIFSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Criteria criteria = null;
    Statement ifStatement = null;
    Statement elseStatement = null;
    try {
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      criteria = criteria(info);
      jj_consume_token(RPAREN);
      ifStatement = statement(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elseStatement = statement(info);
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCondition(criteria);
        jjtn000.setIfBlock(asBlock(ifStatement));
        jjtn000.setElseBlock(asBlock(elseStatement));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=declare statement
description=A procedure declaration statement that creates a variable and optionally assigns a value.
example={code:sql}DECLARE STRING x = 'a'{code}
*/
  final public DeclareStatement declareStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) DeclareStatement */
    DeclareStatement jjtn000 = (DeclareStatement)TeiidNodeFactory.jjtCreate(this, JJTDECLARESTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String var = null;
    ParsedDataType type = null;
    ElementSymbol variableID = null;
    LanguageObject value = null;
    try {
      jj_consume_token(DECLARE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
      case VARBINARY:
      case VARCHAR:
      case BOOLEAN:
      case BYTE:
      case TINYINT:
      case SHORT:
      case SMALLINT:
      case CHAR:
      case INTEGER:
      case LONG:
      case BIGINT:
      case BIGINTEGER:
      case FLOAT:
      case REAL:
      case DOUBLE:
      case BIGDECIMAL:
      case DECIMAL:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case OBJECT:
      case BLOB:
      case CLOB:
      case XML:
        type = parseDataType();
        break;
      case EXCEPTION:
        jj_consume_token(EXCEPTION);
                                           type = new ParsedDataType(getToken(0).image);
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      var = id(null);
        variableID = elementSymbol(var);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
        value = assignStatementOperand(info);
        break;
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setVariable(variableID);
        jjtn000.setVariableType(type.getType());
        if (value instanceof Expression) {
            jjtn000.setExpression((Expression)value);
        }
        else if (value instanceof QueryCommand) {
            jjtn000.setExpression(scalarSubquery((QueryCommand)value));
        }
        else {
            jjtn000.setCommand((Command)value);
        }

        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=assignment statement
description=Assigns a variable a value in a procedure.
example={code:sql}x = 'b'{code}
*/
  final public Statement assignStatement(ParseInfo info) throws ParseException {
    LanguageObject value = null;
    String var = null;
    ElementSymbol elementID = null;
    boolean returnable=true;
    var = id(null);
        elementID = elementSymbol(var);
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case DELETE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MERGE:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SELECT:
    case SOME:
    case SQLEXCEPTION:
    case TABLE:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case UPDATE:
    case VALUES:
    case WITH:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      value = assignStatementOperand(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      value = storedProcedure(info, 2);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
      case WITHOUT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          break;
        case WITHOUT:
          jj_consume_token(WITHOUT);
                                                           returnable = false;
          break;
        default:
          jj_la1[40] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RETURN);
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
                StoredProcedure storedProcedure = (StoredProcedure)value;
            SPParameter parameter = new SPParameter(this, 1, SPParameter.RETURN_VALUE, "return"); //$NON-NLS-1$
            parameter.setExpression(elementID);
                storedProcedure.setParameter(parameter);
                storedProcedure.setCalledWithReturn(true);
                CommandStatement cs = createASTNode(ASTNodes.COMMAND_STATEMENT);
                cs.setCommand(storedProcedure);
                cs.setReturnable(returnable);
                {if (true) return cs;}
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return assignmentStatement(elementID, value);}
    throw new Error("Missing return statement in function");
  }

/*
name=assignment statement operand
description=A value or command that can be used in an assignment.  {note}All assigments except for expression are deprecated.{note}
*/
  final public LanguageObject assignStatementOperand(ParseInfo info) throws ParseException {
    LanguageObject value = null;
    if (jj_2_9(2147483647)) {
      value = insert(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        //deprecated
              value = update(info);
        break;
      case DELETE:
        //deprecated
              value = delete(info);
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        value = expression(info);
        break;
      case SELECT:
      case TABLE:
      case VALUES:
      case WITH:
        value = queryExpression(info);
        break;
      case SQLEXCEPTION:
        //deprecated should be a scalar subquery
              value = exception(info);
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/*
name=data statement
description=A procedure statement that executes a SQL statement.  An update statement can have its update count accessed via the ROWCOUNT variable. 
*/
  final public CommandStatement sqlStatement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CommandStatement */
    CommandStatement jjtn000 = (CommandStatement)TeiidNodeFactory.jjtCreate(this, JJTCOMMANDSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Command cmd = null;
    String var = null;
    ElementSymbol elementID = null;
    StoredProcedure storedProcedure = null;
    boolean returnable = true;
    try {
      if (jj_2_10(2)) {
        cmd = userCommand(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXEC:
        case EXECUTE:
          cmd = dynamicCommand(info);
          break;
        default:
          jj_la1[44] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
      case WITHOUT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          break;
        case WITHOUT:
          jj_consume_token(WITHOUT);
                          returnable = false;
          break;
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RETURN);
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCommand(cmd);
        jjtn000.setReturnable(returnable);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
unused=true
*/
  final public CreateProcedureCommand createProcedure(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CreateProcedureCommand */
     CreateProcedureCommand jjtn000 = (CreateProcedureCommand)TeiidNodeFactory.jjtCreate(this, JJTCREATEPROCEDURECOMMAND);
     boolean jjtc000 = true;
     jjtree.openNodeScope(jjtn000);Statement stmt = null;
    try {
      jj_consume_token(CREATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      jj_consume_token(PROCEDURE);
      stmt = statement(info);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setBlock(asBlock(stmt));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=procedure body definition
description=Defines a procedure body on a Procedure metadata object.
example={code:sql}BEGIN ... END{code} // Teiid 8.5+
example={code:sql}CREATE VIRTUAL PROCEDURE BEGIN ... END{code} Teiid 8.4-
index=true
*/
  final public CreateProcedureCommand procedureBodyCommand(ParseInfo info) throws ParseException {
    CreateProcedureCommand procCmd = createASTNode(ASTNodes.CREATE_PROCEDURE_COMMAND);
    Statement stmt = null;
    if (jj_2_11(2)) {
      jj_consume_token(CREATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      jj_consume_token(PROCEDURE);
    } else {
      ;
    }
    stmt = statement(info);
        procCmd.setBlock(asBlock(stmt));
        {if (true) return procCmd;}
    throw new Error("Missing return statement in function");
  }

/*
name=dynamic data statement
description=A procedure statement that can execute arbitrary sql.
example={code:sql}EXECUTE IMMEDIATE 'SELECT * FROM tbl' AS x STRING INTO #temp{code}
*/
  final public DynamicCommand dynamicCommand(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) DynamicCommand */
    DynamicCommand jjtn000 = (DynamicCommand)TeiidNodeFactory.jjtCreate(this, JJTDYNAMICCOMMAND);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression sql = null;
    String groupID = null;
        GroupSymbol group = null;
        int updateCount = 0;
        List<ProjectedColumn> elements = null;
        SetClauseList using = null;
        SetClauseList setClauseList = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXECUTE:
        jj_consume_token(EXECUTE);
        break;
      case EXEC:
        jj_consume_token(EXEC);
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
      case IMMEDIATE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING:
          jj_consume_token(STRING);
          break;
        case IMMEDIATE:
          jj_consume_token(IMMEDIATE);
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      sql = expression(info);
        jjtn000.setSql(sql);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        elements = createElementsWithTypes(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTO:
          jj_consume_token(INTO);
          groupID = id(null);
         group = groupSymbol(groupID);
          break;
        default:
          jj_la1[52] = jj_gen;
          ;
        }
         jjtn000.setIntoGroup(group);
         List<ElementSymbol> symbols = new ArrayList(elements.size());
         for (ProjectedColumn col : elements) {
                symbols.add(col.getSymbol());
         }
         jjtn000.setAsColumns(symbols);
         jjtn000.setAsClauseSet(true);
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        using = setClauseList(true, info);
             jjtn000.setUsing(using);
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        jj_consume_token(UPDATE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNSIGNEDINTEGER:
          updateCount = intVal();
          break;
        case STAR:
          jj_consume_token(STAR);
        updateCount = 2;
          break;
        default:
          jj_la1[55] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setUpdatingModelCount(updateCount);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=set clause list
description=A list of value assignments.
example={code:sql}col1 = 'x', col2 = 'y' ...{code}
*/
  final public SetClauseList setClauseList(boolean shortName, ParseInfo info) throws ParseException {
 /*@bgen(jjtree) SetClauseList */
        SetClauseList jjtn000 = (SetClauseList)TeiidNodeFactory.jjtCreate(this, JJTSETCLAUSELIST);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String element = null;
        Expression value = null;
    try {
      element = id(shortName?Boolean.TRUE:null);
      jj_consume_token(EQ);
      value = expression(info);
        ElementSymbol symbol = elementSymbol(element);
        jjtn000.addClause(setClause(symbol, value));
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_5;
        }
        jj_consume_token(COMMA);
        element = id(null);
        jj_consume_token(EQ);
        value = expression(info);
          symbol = elementSymbol(element);
          jjtn000.addClause(setClause(symbol, value));
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SetClause setClause(ElementSymbol symbol, Expression value) throws ParseException {
 /*@bgen(jjtree) SetClause */
  SetClause jjtn000 = (SetClause)TeiidNodeFactory.jjtCreate(this, JJTSETCLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setSymbol(symbol);
        jjtn000.setValue(value);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=typed element list
description=A list of typed elements.
example={code:sql}col1 string, col2 integer ...{code}
*/
  final public List<ProjectedColumn> createElementsWithTypes(ParseInfo info) throws ParseException {
        String element = null;
        ParsedDataType type = null;
        List<ProjectedColumn> elements = new ArrayList<ProjectedColumn>();
    element = id(Boolean.TRUE);
    type = parseDataType();
            ProjectedColumn symbol = projectedColumn(element, type.getType());
                elements.add(symbol);
    label_6:
    while (true) {
      if (jj_2_12(2)) {
        ;
      } else {
        break label_6;
      }
      jj_consume_token(COMMA);
      element = id(Boolean.TRUE);
      type = parseDataType();
              symbol = projectedColumn(element, type.getType());
                  elements.add(symbol);
    }
                {if (true) return elements;}
    throw new Error("Missing return statement in function");
  }

  final public ProjectedColumn projectedColumn(String name, String type) throws ParseException {
 /*@bgen(jjtree) ProjectedColumn */
  ProjectedColumn jjtn000 = (ProjectedColumn)TeiidNodeFactory.jjtCreate(this, JJTPROJECTEDCOLUMN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(name);
        jjtn000.setType(type);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=callable statement
description=A callable statement defined using JDBC escape syntax.
example={code:sql}{? = CALL proc}{code}
index=true
*/
  final public StoredProcedure callableStatement(ParseInfo info) throws ParseException {
        StoredProcedure storedProcedure = newStoredProcedure();
        storedProcedure.setCallableStatement(true);
        String procName = null;
        Option option = null;
        SPParameter parameter = null;
        int parameterIndex = 1;
        List<Expression> values = null;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
      jj_consume_token(EQ);
           parameter = new SPParameter(this, parameterIndex++, SPParameter.RETURN_VALUE, "return"); //$NON-NLS-1$
           storedProcedure.setParameter(parameter);
           storedProcedure.setCalledWithReturn(true);
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    jj_consume_token(CALL);
    procName = id(null);
                storedProcedure.setProcedureName(procName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      if (jj_2_13(2)) {
        executeNamedParams(info, storedProcedure, parameterIndex);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR:
        case CAST:
        case CONVERT:
        case ANY:
        case ARRAY_AGG:
        case CASE:
        case EXISTS:
        case FALSE:
        case HOUR:
        case INSERT:
        case LEFT:
        case MINUTE:
        case MONTH:
        case NOT:
        case NULL:
        case RIGHT:
        case SECOND:
        case SOME:
        case TRANSLATE:
        case TRUE:
        case UNKNOWN:
        case USER:
        case YEAR:
        case XMLAGG:
        case XMLCONCAT:
        case XMLCOMMENT:
        case XMLELEMENT:
        case XMLFOREST:
        case XMLPARSE:
        case XMLPI:
        case XMLQUERY:
        case XMLSERIALIZE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
        case ESCAPEDFUNCTION:
        case ESCAPEDTYPE:
        case DECIMALVAL:
        case FLOATVAL:
        case STRINGVAL:
        case UNSIGNEDINTEGER:
        case BINARYSTRINGVAL:
        case LPAREN:
        case PLUS:
        case MINUS:
        case QMARK:
        case DOLLAR:
          values = expressionList(info);
                                         convertToParameters(values, storedProcedure, parameterIndex);
          break;
        default:
          jj_la1[59] = jj_gen;
          ;
        }
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           storedProcedure.setOption(option);
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

/*
name=call statement
description=Executes the procedure with the given parameters.
example={code:sql}CALL proc('a', 1){code}
*/
  final public StoredProcedure storedProcedure(ParseInfo info, int startIndex) throws ParseException {
        String procName = null;
        Option option = null;
        List<Expression> values = null;
        StoredProcedure storedProcedure = newStoredProcedure();
        SourceHint sourceHint = null;
      if (versionAtLeast(Version.TEIID_8_4)) sourceHint = getSourceHint(this);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXEC:
      jj_consume_token(EXEC);
      break;
    case EXECUTE:
      jj_consume_token(EXECUTE);
      break;
    case CALL:
      jj_consume_token(CALL);
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    procName = id(null);
                        storedProcedure.setProcedureName(procName);
    jj_consume_token(LPAREN);
    if (jj_2_14(2)) {
      executeNamedParams(info, storedProcedure, startIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        values = expressionList(info);
                                                  convertToParameters(values, storedProcedure, startIndex);
        break;
      default:
        jj_la1[63] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           storedProcedure.setOption(option);
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
            if (versionAtLeast(Version.TEIID_8_4))
              storedProcedure.setSourceHint(sourceHint);

                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

  final public StoredProcedure newStoredProcedure() throws ParseException {
 /*@bgen(jjtree) StoredProcedure */
  StoredProcedure jjtn000 = (StoredProcedure)TeiidNodeFactory.jjtCreate(this, JJTSTOREDPROCEDURE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=named parameter list
description=A list of named parameters.
example={code:sql}param1 => 'x', param2 => 1{code}
*/
  final public void executeNamedParams(ParseInfo info, StoredProcedure storedProcedure, int parameterIndex) throws ParseException {
        String name = null;
    Expression value = null;
        SPParameter parameter = null;
                storedProcedure.setDisplayNamedParameters(true);
    name = id(null);
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GT:
      jj_consume_token(GT);
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    value = expression(info);
                        parameter = new SPParameter(this, parameterIndex++, value);
                        parameter.setName(name);
                        parameter.setParameterType(SPParameter.IN);
                        storedProcedure.setParameter(parameter);
                        parameter = null;
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      name = id(null);
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        jj_consume_token(GT);
        break;
      default:
        jj_la1[67] = jj_gen;
        ;
      }
      value = expression(info);
                                parameter = new SPParameter(this, parameterIndex++, value);
                                parameter.setName(name);
                                parameter.setParameterType(SPParameter.IN);
                                storedProcedure.setParameter(parameter);
                                parameter = null;
    }
  }

/*
name=insert statement
description=Inserts values into the given target.
example={code:sql}INSERT INTO tbl (col1, col2) VALUES ('a', 1){code}
*/
  final public Insert insert(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Insert */
        Insert jjtn000 = (Insert)TeiidNodeFactory.jjtCreate(this, JJTINSERT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);boolean merge = false;
        String group = null;
        List values = null;
        List<ElementSymbol> columns = null;
        Option option = null;
        QueryCommand query = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
        jj_consume_token(INSERT);
        break;
      case MERGE:
        jj_consume_token(MERGE);
                          merge=true;
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(INTO);
      group = id(null);
      if (jj_2_15(2147483647)) {
        columns = columnList(false, true);
          jjtn000.setVariables(columns);
      } else {
        ;
      }
      query = queryExpression(info);
        jjtn000.setQueryExpression(query);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTION:
        option = option(info);
            jjtn000.setOption(option);
        break;
      default:
        jj_la1[69] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Store group
                jjtn000.setGroup(groupSymbol(group) );
                jjtn000.setMerge(merge);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=expression list
description=A list of expressions.
example={code:sql}col1, 'a', ...{code}
*/
  final public ArrayList<Expression> expressionList(ParseInfo info) throws ParseException {
        ArrayList<Expression> rowVals = new ArrayList<Expression>(4);
        Expression value = null;
    value = expression(info);
        rowVals.add(value);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      value = expression(info);
            rowVals.add(value);
    }
                {if (true) return rowVals;}
    throw new Error("Missing return statement in function");
  }

/*
name=update statement
description=Update values in the given target.
example={code:sql}UPDATE tbl SET (col1 = 'a') WHERE col2 = 1{code}
*/
  final public Update update(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Update */
        Update jjtn000 = (Update)TeiidNodeFactory.jjtCreate(this, JJTUPDATE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String group = null;
        SetClauseList setClauseList = null;
        Criteria criteria = null;
        Option option = null;
    try {
      jj_consume_token(UPDATE);
      group = id(null);
      jj_consume_token(SET);
      setClauseList = setClauseList(false, info);
                jjtn000.setChangeList(setClauseList);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        criteria = where(info);
        break;
      default:
        jj_la1[71] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTION:
        option = option(info);
           jjtn000.setOption(option);
        break;
      default:
        jj_la1[72] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Store group
                jjtn000.setGroup(groupSymbol( group) );

                // Store optional criteria
                if(criteria != null) {
                        jjtn000.setCriteria(criteria);
                }

                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=delete statement
description=Delete rows from the given target.
example={code:sql}DELETE FROM tbl WHERE col2 = 1{code}
*/
  final public Delete delete(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Delete */
        Delete jjtn000 = (Delete)TeiidNodeFactory.jjtCreate(this, JJTDELETE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String group = null;
        Criteria criteria = null;
        Option option = null;
    try {
      jj_consume_token(DELETE);
      jj_consume_token(FROM);
      group = id(null);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        criteria = where(info);
        break;
      default:
        jj_la1[73] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTION:
        option = option(info);
           jjtn000.setOption(option);
        break;
      default:
        jj_la1[74] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setGroup(groupSymbol(group));
                jjtn000.setCriteria(criteria);

        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=query expression
description=A declarative query for data.
example={code:sql}SELECT * FROM tbl WHERE col2 = 1{code}
*/
  final public QueryCommand queryExpression(ParseInfo info) throws ParseException {
    QueryCommand queryCommand = null;
        List<WithQueryCommand> withList = null;
        WithQueryCommand withQueryCommand = null;
        SourceHint sourceHint = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      withQueryCommand = withListElement(info);
            withList = new LinkedList<WithQueryCommand>();
            withList.add(withQueryCommand);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[75] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        withQueryCommand = withListElement(info);
            withList.add(withQueryCommand);
      }
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
          if (versionAtLeast(Version.TEIID_8_4)) sourceHint = getSourceHint(this);
    queryCommand = queryExpressionBody(info);
                queryCommand.setWith(withList);

                if (versionAtLeast(Version.TEIID_8_4))
                  setSourceHint(sourceHint, queryCommand);

                {if (true) return queryCommand;}
    throw new Error("Missing return statement in function");
  }

/*
name=with list element
description=A query expression for use in the enclosing query. 
example={code:sql}X (Y, Z) AS (SELECT 1, 2){code}
*/
  final public WithQueryCommand withListElement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) WithQueryCommand */
   WithQueryCommand jjtn000 = (WithQueryCommand)TeiidNodeFactory.jjtCreate(this, JJTWITHQUERYCOMMAND);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);String name = null;
   List<ElementSymbol> columns = null;
   QueryCommand queryExpression = null;
    try {
      name = id(Boolean.FALSE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        columns = columnList(true, true);
        break;
      default:
        jj_la1[77] = jj_gen;
        ;
      }
      jj_consume_token(AS);
      jj_consume_token(LPAREN);
      queryExpression = queryExpression(info);
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setGroupSymbol(groupSymbol(name));
            jjtn000.setColumns(columns);
            jjtn000.setQueryExpression(queryExpression);
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=query expression body
description=The body of a query expression, which can optionally be ordered and limited.
example={code:sql}SELECT * FROM tbl ORDER BY col1 LIMIT 1{code}
*/
  final public QueryCommand queryExpressionBody(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    QueryCommand rightQuery = null;
    boolean all = false;
    Option option = null;
        OrderBy orderby = null;
        Limit limit = null;
        ISetQuery.Operation type;
    query = queryTerm(info);
    label_10:
    while (true) {
      if (jj_2_16(1)) {
        ;
      } else {
        break label_10;
      }
      if (jj_2_17(2147483647) && (getToken(2).kind != JOIN)) {
        jj_consume_token(UNION);
                                                                              type = ISetQuery.Operation.UNION;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCEPT:
          jj_consume_token(EXCEPT);
                                                                                                                               type = ISetQuery.Operation.EXCEPT;
          break;
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                         all = true;
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[79] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[80] = jj_gen;
        ;
      }
      rightQuery = queryTerm(info);
                        query = setQuery(type, all, query, rightQuery);
                all = false;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby = orderby(info);
                               query.setOrderBy( orderby );
      break;
    default:
      jj_la1[81] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
    case LIMIT:
    case OFFSET:
      limit = limit(info);
                             query.setLimit( limit );
      break;
    default:
      jj_la1[82] = jj_gen;
      ;
    }
    if (jj_2_18(2147483647)) {
      option = option(info);
                                                 query.setOption(option);
    } else {
      ;
    }
                {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=query term
description=Used to establish INTERSECT precedence.
example={code:sql}SELECT * FROM tbl{code}\n{code:sql}SELECT * FROM tbl1 INTERSECT SELECT * FROM tbl2{code}
*/
  final public QueryCommand queryTerm(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    QueryCommand rightQuery = null;
    boolean all = false;
    query = queryPrimary(info);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERSECT:
        ;
        break;
      default:
        jj_la1[83] = jj_gen;
        break label_11;
      }
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                         all = true;
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[84] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[85] = jj_gen;
        ;
      }
      rightQuery = queryPrimary(info);
                        query = setQuery(ISetQuery.Operation.INTERSECT, all, query, rightQuery);
                all = false;
    }
        {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

  final public SetQuery setQuery(ISetQuery.Operation operation, boolean all, QueryCommand leftQuery, QueryCommand rightQuery) throws ParseException {
 /*@bgen(jjtree) SetQuery */
  SetQuery jjtn000 = (SetQuery)TeiidNodeFactory.jjtCreate(this, JJTSETQUERY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setOperation(operation);
        jjtn000.setAll(all);
        jjtn000.setLeftQuery(leftQuery);
        jjtn000.setRightQuery(rightQuery);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=query primary
description=A declarative source of rows.
example={code:sql}TABLE tbl{code}\n{code:sql}SELECT * FROM tbl1{code}
*/
  final public QueryCommand queryPrimary(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    Query q = null;
    Select select = null;
    String name = null;
    List<Expression> expr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      query = query(info);
      break;
    case VALUES:
      jj_consume_token(VALUES);
      jj_consume_token(LPAREN);
      expr = expressionList(info);
           select = createASTNode(ASTNodes.SELECT);
           select.setSymbols(expr);

           q = createASTNode(ASTNodes.QUERY);
           q.setSelect(select);
           q.setRowConstructor(true);
           query = q;
      jj_consume_token(RPAREN);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[86] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        jj_consume_token(LPAREN);
        expr = expressionList(info);
             requiresVersionAtLeast(Version.TEIID_8_6);

             select = createASTNode(ASTNodes.SELECT);
             select.setSymbols(expr);

             q = createASTNode(ASTNodes.QUERY);
             q.setSelect(select);
             q.setRowConstructor(true);

             query = setQuery(ISetQuery.Operation.UNION, true, query, q);
        jj_consume_token(RPAREN);
      }
      break;
    case TABLE:
      jj_consume_token(TABLE);
      name = id(null);
           MultipleElementSymbol multipleElementSymbol = createASTNode(ASTNodes.MULTIPLE_ELEMENT_SYMBOL);

           select = createASTNode(ASTNodes.SELECT);
           select.setSymbols(Arrays.asList(multipleElementSymbol));

           UnaryFromClause unaryFromClause = createASTNode(ASTNodes.UNARY_FROM_CLAUSE);
           unaryFromClause.setGroup(groupSymbol(name));

           From from = createASTNode(ASTNodes.FROM);
           from.setClauses(Arrays.asList(unaryFromClause));

           q = createASTNode(ASTNodes.QUERY);
           q.setSelect(select);
           q.setFrom(from);
           query = q;
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      query = queryExpressionBody(info);
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=query
description=A SELECT query.
example={code:sql}SELECT col1, max(col2) FROM tbl GROUP BY col1{code}
*/
  final public Query query(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Query */
        Query jjtn000 = (Query)TeiidNodeFactory.jjtCreate(this, JJTQUERY);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Select   select         = null;
        From     from           = null;
        Into     into                   = null;
        Criteria criteria       = null;
        GroupBy  groupBy        = null;
        Criteria having         = null;
    try {
      select = select(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTO:
        into = into(info);
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        from = from(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHERE:
          criteria = where(info);
          break;
        default:
          jj_la1[89] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GROUP:
          groupBy = groupBy(info);
          break;
        default:
          jj_la1[90] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HAVING:
          having = having(info);
          break;
        default:
          jj_la1[91] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[92] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Build query from parsed pieces
                jjtn000.setSelect( select );
                jjtn000.setFrom( from );
                jjtn000.setInto( into );
                jjtn000.setCriteria(criteria);
                jjtn000.setGroupBy(groupBy);
                jjtn000.setHaving(having);

                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=into clause
description=Used to direct the query into a table.  {note}This is deprecated.  Use INSERT INTO with a query expression instead.{note}
example={code:sql}INTO tbl{code}
*/
  final public Into into(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Into */
        Into jjtn000 = (Into)TeiidNodeFactory.jjtCreate(this, JJTINTO);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String groupID = null;
    try {
      jj_consume_token(INTO);
      groupID = id(null);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setGroup(groupSymbol(groupID));
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=select clause
description=The columns returned by a query.  Can optionally be distinct.
example={code:sql}SELECT *{code}\n{code:sql}SELECT DISTINCT a, b, c{code}
 */
  final public Select select(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Select */
        Select jjtn000 = (Select)TeiidNodeFactory.jjtCreate(this, JJTSELECT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);boolean isDistinct = false;             // unless DISTINCT keyword in SELECT
        Expression symbol = null;
    try {
      jj_consume_token(SELECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                              isDistinct=true;
          break;
        default:
          jj_la1[93] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
                    MultipleElementSymbol multipleElementSymbol = createASTNode(ASTNodes.MULTIPLE_ELEMENT_SYMBOL);
                        jjtn000.addSymbol(multipleElementSymbol);
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ALL_IN_GROUP:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        symbol = selectSymbol(info);
                                                         jjtn000.addSymbol(symbol);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[95] = jj_gen;
            break label_13;
          }
          jj_consume_token(COMMA);
          symbol = selectSymbol(info);
                                                             jjtn000.addSymbol(symbol);
        }
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setDistinct(isDistinct);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public ExpressionSymbol expressionSymbol() throws ParseException {
 /*@bgen(jjtree) ExpressionSymbol */
  ExpressionSymbol jjtn000 = (ExpressionSymbol)TeiidNodeFactory.jjtCreate(this, JJTEXPRESSIONSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=select sublist
description=An element in the select clause
example={code:sql}tbl.*{code}\n{code:sql}tbl.col AS x{code}
*/
  final public Expression selectSymbol(ParseInfo info) throws ParseException {
        Expression symbol = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      symbol = selectExpression(info);
      break;
    case ALL_IN_GROUP:
      symbol = allInGroupSymbol();
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return symbol;}
    throw new Error("Missing return statement in function");
  }

/*
name=select derived column
description=A select clause item that selects a single column. {note}This is slightly different than a derived column in that the AS keyword is optional.{note}
example={code:sql}tbl.col AS x{code}
*/
  final public Expression selectExpression(ParseInfo info) throws ParseException {
        Expression expression = null;
    String alias = null;
    // Expression
                    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[98] = jj_gen;
        ;
      }
      alias = id(Boolean.FALSE);
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
                if(alias != null) {
                        {if (true) return aliasSymbol(alias, expression);}
                }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=derived column
description=An optionally named expression.
example={code:sql}tbl.col AS x{code}
*/
  final public DerivedColumn derivedColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) DerivedColumn */
        DerivedColumn jjtn000 = (DerivedColumn)TeiidNodeFactory.jjtCreate(this, JJTDERIVEDCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expression = null;
    String alias = null;
    try {
      // Expression
                      expression = expression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        alias = id(Boolean.FALSE);
        break;
      default:
        jj_la1[100] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setAlias(alias);
            jjtn000.setExpression(expression);
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=all in group 
description=A select sublist that can select all columns from the given group.
example={code:sql}tbl.*{code}
*/
  final public MultipleElementSymbol allInGroupSymbol() throws ParseException {
 /*@bgen(jjtree) MultipleElementSymbol */
        MultipleElementSymbol jjtn000 = (MultipleElementSymbol)TeiidNodeFactory.jjtCreate(this, JJTMULTIPLEELEMENTSYMBOL);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token allInGroupToken = null;
    try {
      allInGroupToken = jj_consume_token(ALL_IN_GROUP);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        String name = normalizeId(allInGroupToken.image.substring(0, allInGroupToken.image.length() - 2));
        jjtn000.setName(name);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=ordered aggreate function
description=An aggregate function that can optionally be ordered.
example={code:sql}XMLAGG(col1) ORDER BY col2{code}\n{code:sql}ARRAY_AGG(col1){code}
*/
  final public AggregateSymbol orderedAgg(ParseInfo info) throws ParseException {
    Token t = null;
        Expression expression = null;
        OrderBy orderBy = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLAGG:
      t = jj_consume_token(XMLAGG);
      break;
    case ARRAY_AGG:
      t = jj_consume_token(ARRAY_AGG);
      break;
    case JSONARRAY_AGG:
      t = jj_consume_token(JSONARRAY_AGG);
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                String aggName = t.image.toUpperCase();
                AggregateSymbol agg = newAggregateSymbol(aggName, false, new Expression[] {expression});
                agg.setOrderBy(orderBy);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

/*
name=text aggreate function
description=An aggregate function for creating separated value clobs.
example={code:sql}TEXTAGG (col1 as t1, col2 as t2 DELIMITER ',' HEADER){code}
*/
  final public AggregateSymbol textAgg(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        Character delimiter = null;
        Character quote = null;
        boolean header = false;
        List<DerivedColumn> expressions = new ArrayList<DerivedColumn>();
        OrderBy orderBy = null;
        String encoding = null;
    jj_consume_token(TEXTAGG);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    expression = derivedColumn(info);
                expressions.add(expression);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[104] = jj_gen;
        break label_14;
      }
      jj_consume_token(COMMA);
      expression = derivedColumn(info);
                        expressions.add(expression);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELIMITER:
      jj_consume_token(DELIMITER);
      delimiter = charVal(info, "DELMITER");
      break;
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTE:
      jj_consume_token(QUOTE);
      quote = charVal(info, "QUOTE");
      break;
    default:
      jj_la1[106] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEADER:
      jj_consume_token(HEADER);
            header = true;
      break;
    default:
      jj_la1[107] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENCODING:
      jj_consume_token(ENCODING);
      encoding = id(null);
      break;
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                TextLine tf = textLine();
                tf.setDelimiter(delimiter);
                tf.setQuote(quote);
                tf.setIncludeHeader(header);
                tf.setExpressions(expressions);
                tf.setEncoding(encoding);
                AggregateSymbol agg = newAggregateSymbol("TEXTAGG", false, new Expression[] {tf});
                agg.setOrderBy(orderBy);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

/*
name=standard aggregate function
description=A standard aggregate function.
example={code:sql}COUNT(*){code}
*/
  final public AggregateSymbol aggregateSymbol(ParseInfo info) throws ParseException {
        Token func = null;
        Token starToken = null;
    AggregateSymbol agg = null;
        boolean isDistinct = false;
        Expression expression = null;
    if (jj_2_19(3)) {
      func = jj_consume_token(COUNT);
      jj_consume_token(LPAREN);
      starToken = jj_consume_token(STAR);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case SOME:
      case COUNT:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COUNT:
          jj_consume_token(COUNT);
          break;
        case SUM:
          jj_consume_token(SUM);
          break;
        case AVG:
          jj_consume_token(AVG);
          break;
        case MIN:
          jj_consume_token(MIN);
          break;
        case MAX:
          jj_consume_token(MAX);
          break;
        case EVERY:
          jj_consume_token(EVERY);
          break;
        case STDDEV_POP:
          jj_consume_token(STDDEV_POP);
          break;
        case STDDEV_SAMP:
          jj_consume_token(STDDEV_SAMP);
          break;
        case VAR_SAMP:
          jj_consume_token(VAR_SAMP);
          break;
        case VAR_POP:
          jj_consume_token(VAR_POP);
          break;
        case SOME:
          jj_consume_token(SOME);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        default:
          jj_la1[110] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                                                                                                                      func = getToken(0);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
        case DISTINCT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DISTINCT:
            jj_consume_token(DISTINCT);
                                      isDistinct=true;
            break;
          case ALL:
            jj_consume_token(ALL);
            break;
          default:
            jj_la1[111] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[112] = jj_gen;
          ;
        }
        expression = expression(info);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                String name = func.image.toUpperCase();
                if(starToken == null) {
                        // Aggregate
                        agg = newAggregateSymbol(name, isDistinct, new Expression[] {expression});
                } else {
                        // COUNT(*)
                        agg = newAggregateSymbol(name, false, null);
                }
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

/*
name=analytic aggregate function
description=An analytic aggregate function.
example={code:sql}ROW_NUMBER(){code}
*/
  final public AggregateSymbol analyticAggregateSymbol(ParseInfo info) throws ParseException {
        Token func = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                func = getToken(0);
    jj_consume_token(LPAREN);
    jj_consume_token(RPAREN);
                {if (true) return newAggregateSymbol(func.image.toUpperCase(), false, null);}
    throw new Error("Missing return statement in function");
  }

/*
name=filter clause
description=An aggregate filter clause applied prior to accumulating the value.
example={code:sql}FILTER (WHERE col1='a'){code}
*/
  final public Expression filterClause(ParseInfo info) throws ParseException {
        Expression condition = null;
    jj_consume_token(FILTER);
    jj_consume_token(LPAREN);
    jj_consume_token(WHERE);
    condition = booleanPrimary(info);
    jj_consume_token(RPAREN);
                {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

/*
name=from clause
description=A query from clause containing a list of table references.
example={code:sql}FROM a, b{code}\n{code:sql}FROM a right outer join b, c, d join e".</p>{code}
*/
  final public From from(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) From */
        From jjtn000 = (From)TeiidNodeFactory.jjtCreate(this, JJTFROM);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);FromClause clause = null;
        List clauseList = new LinkedList();
    try {
      jj_consume_token(FROM);
      clause = tableReference(info);
                        clauseList.add(clause);
                        clause = null;
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[115] = jj_gen;
          break label_15;
        }
        jj_consume_token(COMMA);
        clause = tableReference(info);
                                clauseList.add(clause);
                                clause = null;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setClauses(clauseList);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=table reference
description=An optionally escaped joined table.
example={code:sql}a{code}\n{code:sql}a inner join b{code}
*/
  final public FromClause tableReference(ParseInfo info) throws ParseException {
        FromClause result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPEDJOIN:
      jj_consume_token(ESCAPEDJOIN);
      result = joinedTable(info);
      jj_consume_token(RBRACE);
      break;
    case TABLE:
    case LATERAL:
    case XMLTABLE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case LPAREN:
      result = joinedTable(info);
      break;
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=joined table
description=A table or join.
example={code:sql}a{code}\n{code:sql}a inner join b{code}
*/
  final public FromClause joinedTable(ParseInfo info) throws ParseException {
        FromClause result = null;
        JoinPredicate jp = null;
    result = tablePrimary(info);
    label_16:
    while (true) {
      if (jj_2_20(2)) {
        ;
      } else {
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CROSS:
      case UNION:
        jp = crossJoin(info);
        break;
      case FULL:
      case INNER:
      case JOIN:
      case LEFT:
      case RIGHT:
        jp = qualifiedJoin(info);
        break;
      default:
        jj_la1[117] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        jp.setLeftClause(result);
                        result = jp;
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=cross join
description=A cross join.
example={code:sql}a CROSS JOIN b{code}
*/
  final public JoinPredicate crossJoin(ParseInfo info) throws ParseException {
    JoinPredicate result = joinPredicate();
        FromClause clause = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CROSS:
      jj_consume_token(CROSS);
                          result.setJoinType(joinType(IJoinType.Types.JOIN_CROSS));
      break;
    case UNION:
      jj_consume_token(UNION);
                                                                                              result.setJoinType(joinType(IJoinType.Types.JOIN_UNION));
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(JOIN);
    clause = tablePrimary(info);
                                             result.setRightClause(clause);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=qualified table
description=An INNER or OUTER join.
example={code:sql}a inner join b{code}
*/
  final public JoinPredicate qualifiedJoin(ParseInfo info) throws ParseException {
        JoinPredicate result = joinPredicate();
        FromClause clause = null;
        Criteria onCriteria = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL:
    case INNER:
    case LEFT:
    case RIGHT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT:
        jj_consume_token(RIGHT);
                                  result.setJoinType(joinType(IJoinType.Types.JOIN_RIGHT_OUTER));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[119] = jj_gen;
          ;
        }
        break;
      case LEFT:
        jj_consume_token(LEFT);
                           result.setJoinType(joinType(IJoinType.Types.JOIN_LEFT_OUTER));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[120] = jj_gen;
          ;
        }
        break;
      case FULL:
        jj_consume_token(FULL);
                            result.setJoinType(joinType(IJoinType.Types.JOIN_FULL_OUTER));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[121] = jj_gen;
          ;
        }
        break;
      case INNER:
        jj_consume_token(INNER);
        break;
      default:
        jj_la1[122] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    jj_consume_token(JOIN);
    clause = tableReference(info);
                                               result.setRightClause(clause);
    jj_consume_token(ON);
    onCriteria = criteria(info);
                                             result.setJoinCriteria(Criteria.separateCriteriaByAnd(onCriteria));
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public JoinPredicate joinPredicate() throws ParseException {
 /*@bgen(jjtree) JoinPredicate */
  JoinPredicate jjtn000 = (JoinPredicate)TeiidNodeFactory.jjtCreate(this, JJTJOINPREDICATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public JoinType joinType(IJoinType.Types kind) throws ParseException {
 /*@bgen(jjtree) JoinType */
  JoinType jjtn000 = (JoinType)TeiidNodeFactory.jjtCreate(this, JJTJOINTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setKind(kind);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=table primary
description=A single source of rows.
example={code:sql}a{code}
*/
  final public FromClause tablePrimary(ParseInfo info) throws ParseException {
        FromClause clause = null;
        Token lparen = null;
    if (jj_2_21(2)) {
      clause = textTable(info);
    } else if (jj_2_22(2)) {
      clause = arrayTable(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLTABLE:
        clause = xmlTable(info);
        break;
      default:
        jj_la1[124] = jj_gen;
        if (jj_2_23(2)) {
          clause = objectTable(info);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case ID:
            clause = unaryFromClause(info);
            break;
          default:
            jj_la1[125] = jj_gen;
            if (jj_2_24(2147483647)) {
              clause = subqueryFromClause(info);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LPAREN:
                lparen = jj_consume_token(LPAREN);
                clause = joinedTable(info);
                        setFromClauseOptions(lparen, clause);
                jj_consume_token(RPAREN);
                break;
              default:
                jj_la1[126] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAKEDEP:
    case MAKENOTDEP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
        jj_consume_token(MAKEDEP);
                              clause.setMakeDep(true);
        break;
      case MAKENOTDEP:
        jj_consume_token(MAKENOTDEP);
                                   clause.setMakeNotDep(true);
        break;
      default:
        jj_la1[127] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[128] = jj_gen;
      ;
    }
                {if (true) return clause;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml serialize
description=Serializes an XML value.
example={code:sql}XMLSERIALIZE(col1 AS CLOB){code}
*/
  final public XMLSerialize xmlSerialize(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLSerialize */
        XMLSerialize jjtn000 = (XMLSerialize)TeiidNodeFactory.jjtCreate(this, JJTXMLSERIALIZE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expr = null;
        Boolean doc = null;
        Token t = null;
        String enc = null;
        Boolean declr = null;
        String ver = null;
    try {
      jj_consume_token(XMLSERIALIZE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOCUMENT:
      case CONTENT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOCUMENT:
          jj_consume_token(DOCUMENT);
                                   doc = true;
          break;
        case CONTENT:
          jj_consume_token(CONTENT);
                                                            doc = false;
          break;
        default:
          jj_la1[129] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[130] = jj_gen;
        ;
      }
      expr = expression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING:
          jj_consume_token(STRING);
          break;
        case VARCHAR:
          jj_consume_token(VARCHAR);
          break;
        case CLOB:
          jj_consume_token(CLOB);
          break;
        case VARBINARY:
          jj_consume_token(VARBINARY);
          break;
        case BLOB:
          jj_consume_token(BLOB);
          break;
        default:
          jj_la1[131] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                                              t = getToken(0);
        break;
      default:
        jj_la1[132] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENCODING:
        jj_consume_token(ENCODING);
        enc = id(null);
        break;
      default:
        jj_la1[133] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VERSION:
        jj_consume_token(VERSION);
        ver = stringVal();
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCLUDING:
      case EXCLUDING:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INCLUDING:
          jj_consume_token(INCLUDING);
                         declr = true;
          break;
        case EXCLUDING:
          jj_consume_token(EXCLUDING);
                                                      declr = false;
          break;
        default:
          jj_la1[135] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(XMLDECLARATION);
        break;
      default:
        jj_la1[136] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setEncoding(enc);
                jjtn000.setVersion(ver);
                jjtn000.setDeclaration(declr);
                jjtn000.setExpression(expr);
                if (doc != null) {
                        jjtn000.setDocument(doc);
                }
                if (t != null) {
                        jjtn000.setTypeString(t.image);
                }
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=array table
description=The ARRAYTABLE table function creates tabular results from arrays.  It can be used as a nested table reference.
example={code:sql}ARRAYTABLE (col1 COLUMNS x STRING) AS y{code}
*/
  final public ArrayTable arrayTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ArrayTable */
        ArrayTable jjtn000 = (ArrayTable)TeiidNodeFactory.jjtCreate(this, JJTARRAYTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression array = null;
        List<ProjectedColumn> columns;
        String aliasID = null;
    try {
      jj_consume_token(ARRAYTABLE);
      jj_consume_token(LPAREN);
      array = valueExpressionPrimary(info);
      jj_consume_token(COLUMNS);
      columns = createElementsWithTypes(info);
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[137] = jj_gen;
        ;
      }
      aliasID = id(Boolean.FALSE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setArrayValue(array);
                jjtn000.setColumns(columns);
                jjtn000.setName(aliasID);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=text table
description=The TEXTTABLE table function creates tabular results from text.  It can be used as a nested table reference.
example={code:sql}TEXTTABLE (file COLUMNS x STRING) AS y{code}
*/
  final public TextTable textTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TextTable */
        TextTable jjtn000 = (TextTable)TeiidNodeFactory.jjtCreate(this, JJTTEXTTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression file = null;
        TextColumn column = null;
        List<TextColumn> columns = new ArrayList<TextColumn>();
        boolean useRowDelimiter = true;
        Character delimiter = null;
        boolean escape = false;
        Character quote = null;
        Integer header = null;
        Integer skip = null;
        String selector = null;
        String aliasID = null;
    try {
      jj_consume_token(TEXTTABLE);
      jj_consume_token(LPAREN);
      file = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECTOR:
        jj_consume_token(SELECTOR);
        selector = stringVal();
        break;
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      jj_consume_token(COLUMNS);
      column = textColumn(info);
                columns.add(column);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[139] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        column = textColumn(info);
                        columns.add(column);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NO:
        jj_consume_token(NO);
        jj_consume_token(ROW);
        jj_consume_token(DELIMITER);
            useRowDelimiter = false;
        break;
      default:
        jj_la1[140] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DELIMITER:
        jj_consume_token(DELIMITER);
        delimiter = charVal(info, "DELMITER");
        break;
      default:
        jj_la1[141] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
      case QUOTE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ESCAPE:
          jj_consume_token(ESCAPE);
          quote = charVal(info, "ESCAPE");
                                                        escape = true;
          break;
        case QUOTE:
          jj_consume_token(QUOTE);
          quote = charVal(info, "QUOTE");
          break;
        default:
          jj_la1[142] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HEADER:
        jj_consume_token(HEADER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNSIGNEDINTEGER:
          header = intVal();
          break;
        default:
          jj_la1[144] = jj_gen;
          ;
        }
                if (header == null) {
                        header = 1;
                }
        break;
      default:
        jj_la1[145] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SKIP_KEYWORD:
        jj_consume_token(SKIP_KEYWORD);
        skip = intVal();
        break;
      default:
        jj_la1[146] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[147] = jj_gen;
        ;
      }
      aliasID = id(Boolean.FALSE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setFile(file);
                jjtn000.setColumns(columns);
                jjtn000.setDelimiter(delimiter);
                jjtn000.setEscape(escape);
                jjtn000.setHeader(header);
                jjtn000.setSkip(skip);
                jjtn000.setName(aliasID);
                jjtn000.setQuote(quote);
                jjtn000.setUsingRowDelimiter(useRowDelimiter);
                jjtn000.setSelector(selector);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=text table column
description=A text table column.
example={code:sql}x INTEGER WIDTH 6{code}
*/
  final public TextColumn textColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) TextColumn */
        TextColumn jjtn000 = (TextColumn)TeiidNodeFactory.jjtCreate(this, JJTTEXTCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        ParsedDataType datatype = null;
        Integer width = null;
        boolean noTrim = false;
        String selector = null;
        Integer position = null;
    try {
      name = id(Boolean.TRUE);
          jjtn000.setName(name);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        jj_consume_token(ORDINALITY);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          requiresVersionAtLeast(Version.TEIID_8_7);
          jjtn000.setOrdinal(true);
          {if (true) return jjtn000;}
        break;
      case STRING:
      case VARBINARY:
      case VARCHAR:
      case BOOLEAN:
      case BYTE:
      case TINYINT:
      case SHORT:
      case SMALLINT:
      case CHAR:
      case INTEGER:
      case LONG:
      case BIGINT:
      case BIGINTEGER:
      case FLOAT:
      case REAL:
      case DOUBLE:
      case BIGDECIMAL:
      case DECIMAL:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case OBJECT:
      case BLOB:
      case CLOB:
      case XML:
        datatype = parseDataType();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WIDTH:
          jj_consume_token(WIDTH);
          width = intVal();
          if (jj_2_25(2)) {
            jj_consume_token(NO);
            jj_consume_token(TRIM);
                          noTrim = true;
          } else {
            ;
          }
          break;
        default:
          jj_la1[148] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SELECTOR:
          jj_consume_token(SELECTOR);
          selector = stringVal();
          position = intVal();
          break;
        default:
          jj_la1[149] = jj_gen;
          ;
        }
              jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              jjtn000.setType(datatype.getType());
              jjtn000.setWidth(width);
              jjtn000.setNoTrim(noTrim);
                  jjtn000.setSelector(selector);
                  jjtn000.setPosition(position);
          {if (true) return jjtn000;}
        break;
      default:
        jj_la1[150] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml query
description=Executes an XQuery to return an XML result.
example={code:sql}XMLQUERY('<a>...</a>' PASSING doc){code}
*/
  final public XMLQuery xmlQuery(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLQuery */
        XMLQuery jjtn000 = (XMLQuery)TeiidNodeFactory.jjtCreate(this, JJTXMLQUERY);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String xquery = null;
        XMLNamespaces xmlNamespaces = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        Boolean content = null;
        Boolean empty = null;
    try {
      jj_consume_token(XMLQUERY);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLNAMESPACES:
        xmlNamespaces = xmlNamespaces(info);
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[151] = jj_gen;
        ;
      }
      xquery = stringVal();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PASSING:
        jj_consume_token(PASSING);
        passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[152] = jj_gen;
            break label_18;
          }
          jj_consume_token(COMMA);
          passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
        }
        break;
      default:
        jj_la1[153] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL:
      case EMPTY:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                    empty = false;
          break;
        case EMPTY:
          jj_consume_token(EMPTY);
                     empty = true;
          break;
        default:
          jj_la1[154] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(ON);
        jj_consume_token(EMPTY);
        break;
      default:
        jj_la1[155] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setXquery(xquery);
                jjtn000.setNamespaces(xmlNamespaces);
                jjtn000.setPassing(passingValues);
                jjtn000.setEmptyOnEmpty(empty);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=object table
description=Returns table results by processing a script.
example={code:sql}OBJECTTABLE('z' PASSING val AS z COLUMNS col OBJECT 'teiid_row') AS X{code}
*/
  final public ObjectTable objectTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ObjectTable */
        ObjectTable jjtn000 = (ObjectTable)TeiidNodeFactory.jjtCreate(this, JJTOBJECTTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String rowScript = null;
        String lang = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        ObjectColumn column = null;
        ArrayList<ObjectColumn> columns = new ArrayList<ObjectColumn>();
        String aliasID = null;
    try {
      jj_consume_token(OBJECTTABLE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LANGUAGE:
        jj_consume_token(LANGUAGE);
        lang = stringVal();
        break;
      default:
        jj_la1[156] = jj_gen;
        ;
      }
      rowScript = stringVal();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PASSING:
        jj_consume_token(PASSING);
        passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
        label_19:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[157] = jj_gen;
            break label_19;
          }
          jj_consume_token(COMMA);
          passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
        }
        break;
      default:
        jj_la1[158] = jj_gen;
        ;
      }
      jj_consume_token(COLUMNS);
      column = objectColumn(info);
      columns.add(column);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[159] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        column = objectColumn(info);
        columns.add(column);
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[160] = jj_gen;
        ;
      }
      aliasID = id(Boolean.FALSE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setScriptingLanguage(lang);
                jjtn000.setRowScript(rowScript);
                jjtn000.setPassing(passingValues);
                jjtn000.setColumns(columns);
                jjtn000.setName(aliasID);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=object table column
description=object table column.
example={code:sql}y integer 'teiid_row_number'{code}
*/
  final public ObjectColumn objectColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ObjectColumn */
        ObjectColumn jjtn000 = (ObjectColumn)TeiidNodeFactory.jjtCreate(this, JJTOBJECTCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        ParsedDataType datatype = null;
        String path = null;
        Expression defaultExpr = null;
    try {
      name = id(null);
      datatype = parseDataType();
      path = stringVal();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_KEYWORD:
        jj_consume_token(DEFAULT_KEYWORD);
        defaultExpr = expression(info);
        break;
      default:
        jj_la1[161] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.setName(name);
          jjtn000.setType(datatype.getType());
          jjtn000.setPath(path);
          jjtn000.setDefaultExpression(defaultExpr);
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml table
description=Returns table results by processing an XQuery.
example={code:sql}XMLTABLE('/a/b' PASSING doc COLUMNS col XML PATH '.') AS X{code}
*/
  final public XMLTable xmlTable(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLTable */
        XMLTable jjtn000 = (XMLTable)TeiidNodeFactory.jjtCreate(this, JJTXMLTABLE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String xquery = null;
        XMLNamespaces xmlNamespaces = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        XMLColumn column = null;
        ArrayList<XMLColumn> columns = new ArrayList<XMLColumn>();
        String aliasID = null;
    try {
      jj_consume_token(XMLTABLE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLNAMESPACES:
        xmlNamespaces = xmlNamespaces(info);
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[162] = jj_gen;
        ;
      }
      xquery = stringVal();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PASSING:
        jj_consume_token(PASSING);
        passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[163] = jj_gen;
            break label_21;
          }
          jj_consume_token(COMMA);
          passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
        }
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLUMNS:
        jj_consume_token(COLUMNS);
        column = xmlColumn(info);
            columns.add(column);
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[165] = jj_gen;
            break label_22;
          }
          jj_consume_token(COMMA);
          column = xmlColumn(info);
              columns.add(column);
        }
        break;
      default:
        jj_la1[166] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[167] = jj_gen;
        ;
      }
      aliasID = id(Boolean.FALSE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setXquery(xquery);
                jjtn000.setNamespaces(xmlNamespaces);
                jjtn000.setPassing(passingValues);
                jjtn000.setColumns(columns);
                jjtn000.setName(aliasID);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml table column
description=XML table column.
example={code:sql}y FOR ORDINALITY{code}
*/
  final public XMLColumn xmlColumn(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLColumn */
        XMLColumn jjtn000 = (XMLColumn)TeiidNodeFactory.jjtCreate(this, JJTXMLCOLUMN);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        ParsedDataType datatype = null;
        String path = null;
        Expression defaultExpr = null;
    try {
      name = id(null);
           jjtn000.setName(name);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        jj_consume_token(ORDINALITY);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.setOrdinal(true);
            {if (true) return jjtn000;}
        break;
      case STRING:
      case VARBINARY:
      case VARCHAR:
      case BOOLEAN:
      case BYTE:
      case TINYINT:
      case SHORT:
      case SMALLINT:
      case CHAR:
      case INTEGER:
      case LONG:
      case BIGINT:
      case BIGINTEGER:
      case FLOAT:
      case REAL:
      case DOUBLE:
      case BIGDECIMAL:
      case DECIMAL:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case OBJECT:
      case BLOB:
      case CLOB:
      case XML:
        datatype = parseDataType();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DEFAULT_KEYWORD:
          jj_consume_token(DEFAULT_KEYWORD);
          defaultExpr = expression(info);
          break;
        default:
          jj_la1[168] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PATH:
          jj_consume_token(PATH);
          path = stringVal();
          break;
        default:
          jj_la1[169] = jj_gen;
          ;
        }
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.setType(datatype.getType());
            jjtn000.setPath(path);
            jjtn000.setDefaultExpression(defaultExpr);
            {if (true) return jjtn000;}
        break;
      default:
        jj_la1[170] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=unsigned integer
description=An unsigned interger value.
example={code:sql}12345{code}
*/
  final public int intVal() throws ParseException {
        Token t;
    t = jj_consume_token(UNSIGNEDINTEGER);
                try {
                        {if (true) return Integer.valueOf(t.image);}
                } catch(NumberFormatException e1) {
                        {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.Integer_parse, t.image));}
                }
    throw new Error("Missing return statement in function");
  }

/*
name=table subquery
description=A table defined by a subquery.
example={code:sql}(SELECT * FROM tbl) AS x{code}
*/
  final public SubqueryFromClause subqueryFromClause(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) SubqueryFromClause */
    SubqueryFromClause jjtn000 = (SubqueryFromClause)TeiidNodeFactory.jjtCreate(this, JJTSUBQUERYFROMCLAUSE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String aliasID = null;
        Command command = null;
        Token lparen = null;
        boolean table = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
      case LATERAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TABLE:
          jj_consume_token(TABLE);
          break;
        case LATERAL:
          jj_consume_token(LATERAL);
          break;
        default:
          jj_la1[171] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                      table = true;
        break;
      default:
        jj_la1[172] = jj_gen;
        ;
      }
      lparen = jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECT:
      case TABLE:
      case VALUES:
      case WITH:
      case LPAREN:
        command = queryExpression(info);
        break;
      case CALL:
      case EXEC:
      case EXECUTE:
        command = storedProcedure(info, 1);
        break;
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[174] = jj_gen;
        ;
      }
      aliasID = id(Boolean.FALSE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setName(aliasID);
            jjtn000.setCommand(command);
        setFromClauseOptions(lparen, jjtn000);
        jjtn000.setTable(table);
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=table name
description=A table named in the FROM clause.
example={code:sql}tbl AS x{code}
*/
  final public UnaryFromClause unaryFromClause(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) UnaryFromClause */
        UnaryFromClause jjtn000 = (UnaryFromClause)TeiidNodeFactory.jjtCreate(this, JJTUNARYFROMCLAUSE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);GroupSymbol group = null;
        String groupID = null;
        Token groupToken = null;
    String aliasID = null;
    try {
      groupID = id(null);
                           groupToken = getToken(0);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AS:
          jj_consume_token(AS);
          break;
        default:
          jj_la1[175] = jj_gen;
          ;
        }
        aliasID = id(Boolean.FALSE);
        break;
      default:
        jj_la1[176] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
        if(aliasID != null) {
            group = groupSymbol(aliasID, groupID);
        } else {
                        group = groupSymbol(groupID);
        }
        jjtn000.setGroup(group);
        setFromClauseOptions(groupToken, jjtn000);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=where clause
description=Specifies a search condition
example={code:sql}WHERE x = 'a'{code}
*/
  final public Criteria where(ParseInfo info) throws ParseException {
    Criteria criteria = null;
    jj_consume_token(WHERE);
    criteria = criteria(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=condition
description=A boolean expression.
*/
  final public Criteria criteria(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Criteria */
  Criteria jjtn000 = (Criteria)TeiidNodeFactory.jjtCreate(this, JJTCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtn000 = compoundCritOr(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean value expression
description=An optionally ORed boolean expression.
*/
  final public Criteria compoundCritOr(ParseInfo info) throws ParseException {
    ArrayList logicList = null;
    Criteria logicPart = null;
    Criteria logicPart1 = null;
    logicPart = compoundCritAnd(info);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[177] = jj_gen;
        break label_23;
      }
      jj_consume_token(OR);
      logicPart1 = compoundCritAnd(info);
        if (logicList == null) {
          logicList = new ArrayList(2);
          logicList.add(logicPart);
        }

        logicList.add(logicPart1);
    }
                if(logicList == null) {
                        {if (true) return logicPart;}
                } else {
                CompoundCriteria cc = createASTNode(ASTNodes.COMPOUND_CRITERIA);
                cc.setOperator(CompoundCriteria.OR);
                cc.setCriteria(logicList);
                {if (true) return cc;}
                }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean term
description=An optional ANDed boolean factor.
*/
  final public Criteria compoundCritAnd(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CompoundCriteria */
    CompoundCriteria jjtn000 = (CompoundCriteria)TeiidNodeFactory.jjtCreate(this, JJTCOMPOUNDCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);ArrayList logicList = null;
    Criteria logicPart = null;
    Criteria logicPart1 = null;
    try {
      logicPart = notCrit(info);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          ;
          break;
        default:
          jj_la1[178] = jj_gen;
          break label_24;
        }
        jj_consume_token(AND);
        logicPart1 = notCrit(info);
        if (logicList == null) {
          logicList = new ArrayList(2);
          logicList.add(logicPart);
        }

        logicList.add(logicPart1);
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                if(logicList == null) {
                        {if (true) return logicPart;}
                } else {
                    jjtn000.setOperator(CompoundCriteria.AND);
                    jjtn000.setCriteria(logicList);
                {if (true) return jjtn000;}
                }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean factor
description=A boolean factor.
example={code:sql}NOT x = 'a'{code}
*/
  final public Criteria notCrit(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) NotCriteria */
    NotCriteria jjtn000 = (NotCriteria)TeiidNodeFactory.jjtCreate(this, JJTNOTCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression ex = null;
        boolean isNot = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                isNot=true;
        break;
      default:
        jj_la1[179] = jj_gen;
        ;
      }
      ex = booleanPrimary(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            Criteria crit = null;
            if (ex instanceof Criteria) {
              crit = (Criteria)ex;
            } else {
              crit = expressionCriteria(ex);
            }
                if(isNot) {
                    jjtn000.setCriteria(crit);
                        {if (true) return jjtn000;}
                } else {
                        {if (true) return crit;}
                }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean primary
description=A boolean predicate or simple expression.
example={code:sql}col LIKE 'a%'{code}
*/
  final public Expression booleanPrimary(ParseInfo info) throws ParseException {
    Expression ex = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      ex = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
      case IN:
      case IS:
      case LIKE:
      case LIKE_REGEX:
      case NOT:
      case SIMILAR:
      case EQ:
      case NE:
      case NE2:
      case LT:
      case LE:
      case GT:
      case GE:
        if (jj_2_26(2)) {
          ex = betweenCrit(info, ex);
        } else if (jj_2_27(2)) {
          ex = matchCrit(info, ex);
        } else if (jj_2_28(2)) {
          ex = regexMatchCrit(info, ex);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IN:
          case NOT:
            ex = setCrit(info, ex);
            break;
          case IS:
            ex = isNullCrit(info, ex);
            break;
          default:
            jj_la1[180] = jj_gen;
            if (jj_2_29(2147483647)) {
              ex = subqueryCompareCriteria(info, ex);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case EQ:
              case NE:
              case NE2:
              case LT:
              case LE:
              case GT:
              case GE:
                ex = compareCrit(info, ex);
                break;
              default:
                jj_la1[181] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        break;
      default:
        jj_la1[182] = jj_gen;
        ;
      }
      break;
    case EXISTS:
      ex = existsCriteria(info);
      break;
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

/*
name=comparison operator
description=A comparison operator.
example={code:sql}={code}
*/
  final public Token operator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      operator = jj_consume_token(EQ);
      break;
    case NE:
      operator = jj_consume_token(NE);
      break;
    case NE2:
      operator = jj_consume_token(NE2);
      break;
    case LT:
      operator = jj_consume_token(LT);
      break;
    case LE:
      operator = jj_consume_token(LE);
      break;
    case GT:
      operator = jj_consume_token(GT);
      break;
    case GE:
      operator = jj_consume_token(GE);
      break;
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return operator;}
    throw new Error("Missing return statement in function");
  }

/*
name=comparison predicate
description=A value comparison.
example={code:sql}= 'a'{code}
*/
  final public CompareCriteria compareCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) CompareCriteria */
    CompareCriteria jjtn000 = (CompareCriteria)TeiidNodeFactory.jjtCreate(this, JJTCOMPARECRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression value = null;
    Token operator = null;
    try {
      operator = operator();
      value = commonValueExpression(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                // Set left expression
                jjtn000.setLeftExpression(expression);

                jjtn000.setOperator(Operator.getOperator(getVersion(), operator.image));

                // Set value
                jjtn000.setRightExpression(value);

            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=subquery
description=A subquery.
example={code:sql}(SELECT * FROM tbl){code}
*/
  final public QueryCommand subquery(ParseInfo info) throws ParseException {
    QueryCommand subquery = null;
    StoredProcedure proc = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      subquery = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      proc = storedProcedure(info, 1);
            MultipleElementSymbol multipleElementSymbol = createASTNode(ASTNodes.MULTIPLE_ELEMENT_SYMBOL);

        Select select = createASTNode(ASTNodes.SELECT);
        select.setSymbols(Arrays.asList(multipleElementSymbol));

        SubqueryFromClause subqueryFromClause = createASTNode(ASTNodes.SUBQUERY_FROM_CLAUSE);
        subqueryFromClause.setName("x");
        subqueryFromClause.setCommand(proc);

        From from = createASTNode(ASTNodes.FROM);
        from.setClauses(Arrays.asList(subqueryFromClause));

        Query query = createASTNode(ASTNodes.QUERY);
        query.setSelect(select);
        query.setFrom(from);
        subquery = query;
      break;
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
                {if (true) return subquery;}
    throw new Error("Missing return statement in function");
  }

/*
name=quantified comparison predicate
description=A subquery comparison.
example={code:sql}= ANY (SELECT col FROM tbl){code}
*/
  final public SubqueryCompareCriteria subqueryCompareCriteria(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) SubqueryCompareCriteria */
    SubqueryCompareCriteria jjtn000 = (SubqueryCompareCriteria)TeiidNodeFactory.jjtCreate(this, JJTSUBQUERYCOMPARECRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);QueryCommand subquery = null;
    Token operator = null;
    Token quantifier = null;
    try {
      operator = operator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
        quantifier = jj_consume_token(ANY);
        break;
      case SOME:
        quantifier = jj_consume_token(SOME);
        break;
      case ALL:
        quantifier = jj_consume_token(ALL);
        break;
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      subquery = subquery(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setLeftExpression(expression);
            jjtn000.setCommand(subquery);

                // Set operator
                jjtn000.setOperator(Operator.getOperator(getVersion(), operator.image));

                // Set predicate quantifier
                if(quantifier.image.equalsIgnoreCase("any")) { //$NON-NLS-1$
                        jjtn000.setPredicateQuantifier(PredicateQuantifier.ANY);
                } else if(quantifier.image.equalsIgnoreCase("some")) { //$NON-NLS-1$
                        jjtn000.setPredicateQuantifier(PredicateQuantifier.SOME);
                } else if(quantifier.image.equalsIgnoreCase("all")) { //$NON-NLS-1$
                        jjtn000.setPredicateQuantifier(PredicateQuantifier.ALL);
                }

            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=match predicate
description=Matches based upon a pattern.
example={code:sql}LIKE 'a_'{code}
*/
  final public MatchCriteria matchCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) MatchCriteria */
    MatchCriteria jjtn000 = (MatchCriteria)TeiidNodeFactory.jjtCreate(this, JJTMATCHCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Character esc = null;
        Expression value = null;
        boolean negated = false;
        boolean similar = false;
        Token t = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                negated = true;
        break;
      default:
        jj_la1[187] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIKE:
        jj_consume_token(LIKE);
        break;
      case SIMILAR:
        jj_consume_token(SIMILAR);
        jj_consume_token(TO);
                             similar = true;
        break;
      default:
        jj_la1[188] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
     t = getToken(1);
      value = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
      case LBRACE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ESCAPE:
          jj_consume_token(ESCAPE);
          esc = charVal(info, "LIKE/SIMILAR TO ESCAPE");
          break;
        case LBRACE:
          jj_consume_token(LBRACE);
          jj_consume_token(ESCAPE);
          esc = charVal(info, "LIKE/SIMILAR TO ESCAPE");
          jj_consume_token(RBRACE);
          break;
        default:
          jj_la1[189] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[190] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setLeftExpression(expression);
            jjtn000.setRightExpression(value);
                jjtn000.setNegated(negated);
            if(esc != null) {
                        jjtn000.setEscapeChar(esc.charValue());
                } else if (!similar && value instanceof Constant) {
                        if (t.image != null && t.image.startsWith("E'")) {
                                jjtn000.setEscapeChar('\u005c\u005c');
                        }
                }
                jjtn000.setMode(similar?MatchMode.SIMILAR:MatchMode.LIKE);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=like regex predicate
description=A regular expression match.
example={code:sql}LIKE_REGEX 'a.*b'{code}
*/
  final public MatchCriteria regexMatchCrit(ParseInfo info, Expression expression) throws ParseException {
        Expression value = null;
        boolean negated = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[191] = jj_gen;
      ;
    }
    jj_consume_token(LIKE_REGEX);
    value = commonValueExpression(info);
        MatchCriteria matchcriteria = createASTNode(ASTNodes.MATCH_CRITERIA);
        matchcriteria.setLeftExpression(expression);
        matchcriteria.setRightExpression(value);
                matchcriteria.setNegated(negated);
                matchcriteria.setMode(MatchMode.REGEX);
                {if (true) return matchcriteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=character
description=A single character.
example={code:sql}'a'{code}
*/
  final public Character charVal(ParseInfo info, String type) throws ParseException {
        String escStr = null;
    escStr = stringVal();
                if (escStr.length() != 1) {
                        {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.char_val));}
                }
                {if (true) return Character.valueOf(escStr.charAt(0));}
    throw new Error("Missing return statement in function");
  }

/*
name=between predicate
description=A comparison between two values.
example={code:sql}BETWEEN 1 AND 5{code}
*/
  final public BetweenCriteria betweenCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) BetweenCriteria */
        BetweenCriteria jjtn000 = (BetweenCriteria)TeiidNodeFactory.jjtCreate(this, JJTBETWEENCRITERIA);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression lowerExpression = null, upperExpression = null;
        boolean negated = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                negated=true;
        break;
      default:
        jj_la1[192] = jj_gen;
        ;
      }
      jj_consume_token(BETWEEN);
      lowerExpression = commonValueExpression(info);
      jj_consume_token(AND);
      upperExpression = commonValueExpression(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setExpression(expression);
                jjtn000.setLowerExpression(lowerExpression);
                jjtn000.setUpperExpression(upperExpression);
                jjtn000.setNegated(negated);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=is null predicate
description=A null test.
example={code:sql}IS NOT NULL{code}
*/
  final public IsNullCriteria isNullCrit(ParseInfo info, Expression expression) throws ParseException {
 /*@bgen(jjtree) IsNullCriteria */
        IsNullCriteria jjtn000 = (IsNullCriteria)TeiidNodeFactory.jjtCreate(this, JJTISNULLCRITERIA);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);boolean negated = false;
    try {
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                negated = true;
        break;
      default:
        jj_la1[193] = jj_gen;
        ;
      }
      jj_consume_token(NULL);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
           jjtn000.setExpression(expression);
           jjtn000.setNegated(negated);
           {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=in predicate
description=A comparison with multiple values.
example={code:sql}IN (1, 5){code}
*/
  final public AbstractSetCriteria setCrit(ParseInfo info, Expression expression) throws ParseException {
        Expression value = null;
        List setList = new ArrayList();
        QueryCommand command = null;
        SubqueryHint hint = null;
        boolean negated = false;
        AbstractSetCriteria criteria = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[194] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    if (jj_2_30(2147483647)) {
                                            hint = getSubqueryHint(getToken(1));
      command = subquery(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        value = commonValueExpression(info);
                                setList.add(value);
        label_25:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[195] = jj_gen;
            break label_25;
          }
          jj_consume_token(COMMA);
          value = commonValueExpression(info);
                                        setList.add(value);
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[196] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
            if (command != null) {
                        SubquerySetCriteria ssc = subquerySetCriteria(expression, command);
                        ssc.setSubqueryHint(hint);
                        criteria = ssc;
                } else {
                    criteria = setCriteria(expression, setList);
                }
            criteria.setNegated(negated);
            {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

  final public SubquerySetCriteria subquerySetCriteria(Expression expression, QueryCommand command) throws ParseException {
 /*@bgen(jjtree) SubquerySetCriteria */
  SubquerySetCriteria jjtn000 = (SubquerySetCriteria)TeiidNodeFactory.jjtCreate(this, JJTSUBQUERYSETCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setExpression(expression);
        jjtn000.setCommand(command);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SetCriteria setCriteria(Expression expression, List<Expression> values) throws ParseException {
 /*@bgen(jjtree) SetCriteria */
  SetCriteria jjtn000 = (SetCriteria)TeiidNodeFactory.jjtCreate(this, JJTSETCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setExpression(expression);
        jjtn000.setValues(values);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=exists predicate
description=A test if rows exist.
example={code:sql}EXISTS (SELECT col FROM tbl){code}
*/
  final public ExistsCriteria existsCriteria(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) ExistsCriteria */
    ExistsCriteria jjtn000 = (ExistsCriteria)TeiidNodeFactory.jjtCreate(this, JJTEXISTSCRITERIA);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);QueryCommand subquery = null;
    SubqueryHint hint = null;
    try {
      jj_consume_token(EXISTS);
                   hint = getSubqueryHint(getToken(1));
      subquery = subquery(info);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setCommand(subquery);
                jjtn000.setSubqueryHint(hint);
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=group by clause
description=Defines the grouping columns
example={code:sql}GROUP BY col1, col2{code}
*/
  final public GroupBy groupBy(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) GroupBy */
        GroupBy jjtn000 = (GroupBy)TeiidNodeFactory.jjtCreate(this, JJTGROUPBY);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);List<Expression> expressions = null;
        boolean rollup = false;
    try {
      jj_consume_token(GROUP);
      jj_consume_token(BY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROLLUP:
        jj_consume_token(ROLLUP);
        jj_consume_token(LPAREN);
        expressions = expressionList(info);
        jj_consume_token(RPAREN);
        requiresVersionAtLeast(Version.TEIID_8_5);
        rollup = true;
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        expressions = expressionList(info);
        break;
      default:
        jj_la1[197] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setSymbols(expressions);
            jjtn000.setRollup(rollup);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=having clause
description=Search condition applied after grouping.
example={code:sql}HAVING max(col1) = 5{code}
*/
  final public Criteria having(ParseInfo info) throws ParseException {
    Criteria criteria = null;
    jj_consume_token(HAVING);
    criteria = criteria(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=order by clause
description=Specifices row ordering.
example={code:sql}ORDER BY x, y DESC{code}
*/
  final public OrderBy orderby(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) OrderBy */
    OrderBy jjtn000 = (OrderBy)TeiidNodeFactory.jjtCreate(this, JJTORDERBY);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);OrderByItem item = null;
    try {
      jj_consume_token(ORDER);
      jj_consume_token(BY);
      item = sortSpecification(info);
        jjtn000.getOrderByItems().add(item);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[198] = jj_gen;
          break label_26;
        }
        jj_consume_token(COMMA);
        item = sortSpecification(info);
                jjtn000.getOrderByItems().add(item);
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=sort specification
description=Defines how to sort on a particular expression
example={code:sql}col1 NULLS FIRST{code}
*/
  final public OrderByItem sortSpecification(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) OrderByItem */
    OrderByItem jjtn000 = (OrderByItem)TeiidNodeFactory.jjtCreate(this, JJTORDERBYITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Expression ex = null;
    boolean ascending = true;
    NullOrdering nullOrdering = null;
    try {
      ex = sortKey(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
      case DESC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASC:
          jj_consume_token(ASC);
          break;
        case DESC:
          jj_consume_token(DESC);
                         ascending=false;
          break;
        default:
          jj_la1[199] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[200] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULLS:
        jj_consume_token(NULLS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FIRST:
          jj_consume_token(FIRST);
                           nullOrdering=NullOrdering.FIRST;
          break;
        case LAST:
          jj_consume_token(LAST);
                                                                       nullOrdering=NullOrdering.LAST;
          break;
        default:
          jj_la1[201] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[202] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setSymbol(ex);
            jjtn000.setAscending(ascending);
        if (nullOrdering != null) {
                jjtn000.setNullOrdering(nullOrdering);
        }
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=sort key
description=A sort expression.
example={code:sql}col1{code}
*/
  final public Expression sortKey(ParseInfo info) throws ParseException {
    Expression ex = null;
    ex = expression(info);
        //legacy support check for positional constants
        if (ex instanceof Constant) {
                boolean valid = false;
            Constant c = (Constant)ex;
            if (c.getValue() instanceof Integer) {
                Integer val = (Integer)c.getValue();
                valid = val.intValue() > 0;
            }
            if (!valid) {
                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.non_position_constant, ex));}
            }
        }
        {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

/*
name=integer parameter
description=A literal integer or parameter reference to an integer.
example={code:sql}?{code}
*/
  final public Expression intParam(ParseInfo info) throws ParseException {
   Expression ex = null;
   Integer val = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNEDINTEGER:
      val = intVal();
     {if (true) return constant(val, DataTypeManagerService.DefaultDataTypes.INTEGER);}
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case LPAREN:
    case QMARK:
    case DOLLAR:
      ex = unsignedValueExpressionPrimary(info);
     {if (true) return ex;}
      break;
    default:
      jj_la1[203] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=limit clause
description=Limits and/or offsets the resultant rows.
example={code:sql}LIMIT 2{code}
*/
  final public Limit limit(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Limit */
        Limit jjtn000 = (Limit)TeiidNodeFactory.jjtCreate(this, JJTLIMIT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression limit = null;
        Expression offset = null;
        Token t = null;
    try {
     t = getToken(1);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMIT:
        jj_consume_token(LIMIT);
        offset = intParam(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          limit = intParam(info);
          break;
        default:
          jj_la1[204] = jj_gen;
          ;
        }
          if (limit == null) {
            limit = offset;
            offset = null;
          }
        break;
      case OFFSET:
        jj_consume_token(OFFSET);
        offset = intParam(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ROW:
          jj_consume_token(ROW);
          break;
        case ROWS:
          jj_consume_token(ROWS);
          break;
        default:
          jj_la1[205] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FETCH:
          limit = fetchLimit(info);
          break;
        default:
          jj_la1[206] = jj_gen;
          ;
        }
        break;
      case FETCH:
        limit = fetchLimit(info);
        break;
      default:
        jj_la1[207] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setOffset(offset);
            jjtn000.setRowLimit(limit);
                jjtn000.setStrict(!isNonStrictHint(t));
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=fetch clause
description=ANSI limit.
example={code:sql}FETCH FIRST 1 ROWS ONLY{code}
*/
  final public Expression fetchLimit(ParseInfo info) throws ParseException {
    Expression limit = null;
    jj_consume_token(FETCH);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    default:
      jj_la1[208] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case UNSIGNEDINTEGER:
    case LPAREN:
    case QMARK:
    case DOLLAR:
      limit = intParam(info);
      break;
    default:
      jj_la1[209] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
      jj_consume_token(ROW);
      break;
    case ROWS:
      jj_consume_token(ROWS);
      break;
    default:
      jj_la1[210] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
      if (limit == null) {
        {if (true) return constant(1, DataTypeManagerService.DefaultDataTypes.INTEGER);}
      }
      {if (true) return limit;}
    throw new Error("Missing return statement in function");
  }

/*
name=option clause
description=Specifies query options.
example={code:sql}OPTION MAKEDEP tbl{code}
*/
  final public Option option(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Option */
        Option jjtn000 = (Option)TeiidNodeFactory.jjtCreate(this, JJTOPTION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String id = null;
        Token nocache = null;
    try {
      jj_consume_token(OPTION);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MAKEDEP:
        case MAKENOTDEP:
        case NOCACHE:
          ;
          break;
        default:
          jj_la1[211] = jj_gen;
          break label_27;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MAKEDEP:
          jj_consume_token(MAKEDEP);
          id = id(null);
            jjtn000.addDependentGroup(id);
          label_28:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[212] = jj_gen;
              break label_28;
            }
            jj_consume_token(COMMA);
            id = id(null);
                jjtn000.addDependentGroup(id);
          }
          break;
        case MAKENOTDEP:
          jj_consume_token(MAKENOTDEP);
          id = id(null);
            jjtn000.addNotDependentGroup(id);
          label_29:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[213] = jj_gen;
              break label_29;
            }
            jj_consume_token(COMMA);
            id = id(null);
                jjtn000.addNotDependentGroup(id);
          }
          break;
        case NOCACHE:
          nocache = jj_consume_token(NOCACHE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case ID:
            id = id(null);
            jjtn000.addNoCacheGroup(id);
            label_30:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case COMMA:
                ;
                break;
              default:
                jj_la1[214] = jj_gen;
                break label_30;
              }
              jj_consume_token(COMMA);
              id = id(null);
                jjtn000.addNoCacheGroup(id);
            }
            break;
          default:
            jj_la1[215] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[216] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setNoCache( (nocache != null) );
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=expression
description=A value.
example={code:sql}col1{code}
*/
  final public Expression expression(ParseInfo info) throws ParseException {
  Expression expression = null;
    expression = criteria(info);
                if (expression instanceof ExpressionCriteria) {
                        {if (true) return ((ExpressionCriteria)expression).getExpression();}
                }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=common value expression
description=Establishes the precedence of concat.
example={code:sql}'a' || 'b'{code}
*/
  final public Expression commonValueExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
    leftExpression = plusExpression(info);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT_OP:
        ;
        break;
      default:
        jj_la1[217] = jj_gen;
        break label_31;
      }
      jj_consume_token(CONCAT_OP);
      rightExpression = plusExpression(info);
                            Function function = createASTNode(ASTNodes.FUNCTION);
                            function.setName("||"); //$NON-NLS-1$
                            function.setArgs(new Expression[] {leftExpression, rightExpression});
                            leftExpression = function;
                                rightExpression = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/*
name=numeric value expression
example={code:sql}1 + 2{code}
*/
  final public Expression plusExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        String operator = null;
    leftExpression = timesExpression(info);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[218] = jj_gen;
        break label_32;
      }
      operator = plusMinus();
      rightExpression = timesExpression(info);
                            Function function = createASTNode(ASTNodes.FUNCTION);
                            function.setName(operator);
                            function.setArgs(new Expression[] { leftExpression, rightExpression });
                            leftExpression = function;
                                rightExpression = null;
                                operator = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/*
name=plus or minus
description=The + or - operator.
example={code:sql}+{code}
*/
  final public String plusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

/*
name=term
description=A numeric term
example={code:sql}1 * 2{code}
*/
  final public Expression timesExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        String operator = null;
    leftExpression = valueExpressionPrimary(info);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
        ;
        break;
      default:
        jj_la1[220] = jj_gen;
        break label_33;
      }
      operator = timesOperator();
      rightExpression = valueExpressionPrimary(info);
                            Function function = createASTNode(ASTNodes.FUNCTION);
                            function.setName(operator);
                            function.setArgs(new Expression[] {leftExpression, rightExpression});
                            leftExpression = function;
                                rightExpression = null;
                                operator = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/*
name=star or slash
description=The * or / operator.
example={code:sql}/{code}
*/
  final public String timesOperator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      operator = jj_consume_token(STAR);
      break;
    case SLASH:
      operator = jj_consume_token(SLASH);
      break;
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return operator.image;}
    throw new Error("Missing return statement in function");
  }

/*
name=value expression primary
description=A simple value expression.
example={code:sql}+col1{code}
*/
  final public Expression valueExpressionPrimary(ParseInfo info) throws ParseException {
        String strVal = null;
        Expression ex = null;
        Expression indexExpr = null;
        List<Expression> indexExprs = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
    case ESCAPEDTYPE:
    case STRINGVAL:
    case BINARYSTRINGVAL:
      ex = nonNumericLiteral();
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case DECIMALVAL:
    case FLOATVAL:
    case UNSIGNEDINTEGER:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        strVal = plusMinus();
        break;
      default:
        jj_la1[222] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMALVAL:
      case FLOATVAL:
      case UNSIGNEDINTEGER:
        ex = unsignedNumericLiteral(strVal);
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case ID:
      case ESCAPEDFUNCTION:
      case LPAREN:
      case QMARK:
      case DOLLAR:
        ex = unsignedValueExpressionPrimary(info);
        label_34:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LSBRACE:
            ;
            break;
          default:
            jj_la1[223] = jj_gen;
            break label_34;
          }
          jj_consume_token(LSBRACE);
          indexExpr = plusExpression(info);
          jj_consume_token(RSBRACE);
              indexExprs = arrayExpressions(indexExprs, indexExpr);
        }
            if (indexExprs != null) {
              for (Expression expr : indexExprs) {
                Function function = createASTNode(ASTNodes.FUNCTION);
                function.setName("array_get"); //$NON-NLS-1$
                function.setArgs(new Expression[] {ex, expr});
                ex = function;
              }
            }
          if (strVal != null && strVal.charAt(0) == '-') {
            Function function = createASTNode(ASTNodes.FUNCTION);
            function.setName("*"); //$NON-NLS-1$
            function.setArgs(new Expression[] { constant(-1), ex });
            ex = function;
          }
        break;
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[225] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

/*
name=parameter reference
description=A parameter reference to be bound later.
example={code:sql}?{code}
*/
  final public Reference parameterReference(ParseInfo info) throws ParseException {
    Integer index = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
             {if (true) return reference(info.incrementReferenceCount());}
      break;
    case DOLLAR:
      jj_consume_token(DOLLAR);
      index = intVal();
                                {if (true) return reference(index -1);}
      break;
    default:
      jj_la1[226] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression unescapedFunction(ParseInfo info) throws ParseException {
    Expression expression = null;
    Expression condition = null;
    if (jj_2_31(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXTAGG:
        expression = textAgg(info);
        break;
      case ANY:
      case SOME:
      case COUNT:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
        expression = aggregateSymbol(info);
        break;
      case ARRAY_AGG:
      case XMLAGG:
      case JSONARRAY_AGG:
        expression = orderedAgg(info);
        break;
      default:
        jj_la1[227] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FILTER:
        condition = filterClause(info);
        break;
      default:
        jj_la1[228] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OVER:
        expression = windowSpecification(expression, info);
        break;
      default:
        jj_la1[229] = jj_gen;
        ;
      }
    } else if (jj_2_32(2)) {
      expression = analyticAggregateSymbol(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FILTER:
        condition = filterClause(info);
        break;
      default:
        jj_la1[230] = jj_gen;
        ;
      }
      expression = windowSpecification(expression, info);
    } else if (jj_2_33(2)) {
      expression = function(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OVER:
        expression = windowSpecification(expression, info);
        break;
      default:
        jj_la1[231] = jj_gen;
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (condition != null) {
            if (expression instanceof WindowFunction) {
                ((WindowFunction)expression).getFunction().setCondition(condition);
            } else {
                ((AggregateSymbol)expression).setCondition(condition);
            }
        }
        {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=nested expression
description=An expression nested in parens
example={code:sql}(1){code}
*/
  final public Expression nestedExpression(ParseInfo info) throws ParseException {
    Expression expression = null;
    Expression arrayExpression = null;
    List<Expression> arrayExpressions = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      expression = expression(info);
      label_35:
      while (true) {
        if (jj_2_34(2)) {
          ;
        } else {
          break label_35;
        }
        jj_consume_token(COMMA);
        arrayExpression = expression(info);
          requiresVersionAtLeast(Version.TEIID_8_5);
          if (expression != null) {
             arrayExpressions = arrayExpressions(arrayExpressions, expression);
             expression = null;
          }
          arrayExpressions = arrayExpressions(arrayExpressions, arrayExpression);
      }
      break;
    default:
      jj_la1[232] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
            requiresVersionAtLeast(Version.TEIID_8_5);
            arrayExpressions = arrayExpressions(arrayExpressions, expression);
      break;
    default:
      jj_la1[233] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        if (arrayExpressions != null) {
          Array array = array();
          array.setExpressions(arrayExpressions);
          expression = array;
        } else if (expression == null) {
          Array array = array();
          array.setExpressions(new ArrayList<Expression>(0));
          expression = array;
        }
        {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=unsigned value expression primary
description=An unsigned simple value expression.
example={code:sql}col1{code}
*/
  final public Expression unsignedValueExpressionPrimary(ParseInfo info) throws ParseException {
        Expression expression = null;
        Token symbol = null;
        QueryCommand subquery = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
    case DOLLAR:
      // Reference
                      expression = parameterReference(info);
      break;
    case ESCAPEDFUNCTION:
      jj_consume_token(ESCAPEDFUNCTION);
      expression = function(info);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[235] = jj_gen;
      if (jj_2_35(2)) {
        expression = unescapedFunction(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case ID:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ID:
            symbol = jj_consume_token(ID);
                                String symbolImage = symbol.image;
                                if(isStringLiteral(symbolImage, info)) {
                                    {if (true) return constant(normalizeStringLiteral(symbolImage));}
                                }
            break;
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
            symbol = nonReserved();
            break;
          default:
            jj_la1[234] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                                                   expression = elementSymbol(normalizeId(symbol.image));
          break;
        default:
          jj_la1[236] = jj_gen;
          if (jj_2_36(2147483647)) {
            subquery = subquery(info);
                                                                     expression = scalarSubquery(subquery);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPAREN:
              expression = nestedExpression(info);
              break;
            default:
              jj_la1[237] = jj_gen;
              if (jj_2_37(2)) {
                expression = searchedCaseExpression(info);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case CASE:
                  // Non-searched CASE expressions
                                  expression = caseExpression(info);
                  break;
                default:
                  jj_la1[238] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

  final public Reference reference(int referenceIndex) throws ParseException {
 /*@bgen(jjtree) Reference */
  Reference jjtn000 = (Reference)TeiidNodeFactory.jjtCreate(this, JJTREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setIndex(referenceIndex);
        jjtn000.setPositional(true);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=window specification
description=The window specification for an analytical or windowed aggregate function.
example={code:sql}OVER (PARTION BY col1){code}
*/
  final public Expression windowSpecification(Expression agg, ParseInfo info) throws ParseException {
        List<Expression> partitionList = null;
        OrderBy orderBy = null;
    jj_consume_token(OVER);
          if (!(agg instanceof AggregateSymbol)) {
            if (!(agg instanceof Function)) {
          {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.invalid_window, agg));}
        }
        Function f = (Function)agg;
        AggregateSymbol aggSymbol = createASTNode(ASTNodes.AGGREGATE_SYMBOL);
        aggSymbol.setAggregateFunction(f.getName());
        aggSymbol.setDistinct(false);
        aggSymbol.setArgs(f.getArgs());
        agg = aggSymbol;
      }
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = expressionList(info);
      break;
    default:
      jj_la1[239] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[240] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        WindowFunction result = windowFunction();
        WindowSpecification ws = newWindowSpecification();
        result.setFunction((AggregateSymbol)agg);
        ws.setPartition(partitionList);
        ws.setOrderBy(orderBy);
        result.setWindowSpecification(ws);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=case expression
description=If/then/else chain using a common search predicand.
example={code:sql}CASE col1 WHEN 'a' THEN 1 ELSE 2{code}
*/
  final public CaseExpression caseExpression(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) CaseExpression */
        CaseExpression jjtn000 = (CaseExpression)TeiidNodeFactory.jjtCreate(this, JJTCASEEXPRESSION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expression = null, whenExpression = null, thenExpression = null, elseExpression = null;
        ArrayList whenExpressions = new ArrayList(2);
        ArrayList thenExpressions = new ArrayList(2);
    try {
      jj_consume_token(CASE);
      expression = expression(info);
      label_36:
      while (true) {
        jj_consume_token(WHEN);
        whenExpression = expression(info);
        jj_consume_token(THEN);
        thenExpression = expression(info);
                        whenExpressions.add(whenExpression);
                        thenExpressions.add(thenExpression);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHEN:
          ;
          break;
        default:
          jj_la1[241] = jj_gen;
          break label_36;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elseExpression = expression(info);
        break;
      default:
        jj_la1[242] = jj_gen;
        ;
      }
      jj_consume_token(END);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setExpression(expression);
            jjtn000.setWhen(whenExpressions, thenExpressions);
                jjtn000.setElseExpression(elseExpression);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=searched case expression
description=If/then/else chain using multiple search conditions.
example={code:sql}CASE WHEN x = 'a' THEN 1 WHEN y = 'b' THEN 2{code}
*/
  final public SearchedCaseExpression searchedCaseExpression(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) SearchedCaseExpression */
        SearchedCaseExpression jjtn000 = (SearchedCaseExpression)TeiidNodeFactory.jjtCreate(this, JJTSEARCHEDCASEEXPRESSION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression thenExpression = null, elseExpression = null;
        Criteria whenCriteria = null;
        List<Criteria> whenCriteriaList = new ArrayList<Criteria>(2);
    List<Expression> thenExpressions = new ArrayList<Expression>(2);
    try {
      jj_consume_token(CASE);
      label_37:
      while (true) {
        jj_consume_token(WHEN);
        whenCriteria = criteria(info);
        jj_consume_token(THEN);
        thenExpression = expression(info);
                        whenCriteriaList.add(whenCriteria);
                        thenExpressions.add(thenExpression);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHEN:
          ;
          break;
        default:
          jj_la1[243] = jj_gen;
          break label_37;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elseExpression = expression(info);
        break;
      default:
        jj_la1[244] = jj_gen;
        ;
      }
      jj_consume_token(END);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setWhen(whenCriteriaList, thenExpressions);
                jjtn000.setElseExpression(elseExpression);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=function
description=Calls a scalar function.
example={code:sql}func('1', col1){code}
*/
  final public Expression function(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) Function */
        Function jjtn000 = (Function)TeiidNodeFactory.jjtCreate(this, JJTFUNCTION);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String funcName = null;

        Expression expression = null;
        ArrayList args = new ArrayList(2);
        ArrayList otherArgs = null;
        Token funcToken = null;
        Boolean distinct = null;
        OrderBy orderBy = null;
        Expression condition = null;
        String literal = null;
        ParsedDataType type = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONVERT:
        funcToken = jj_consume_token(CONVERT);
        jj_consume_token(LPAREN);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(COMMA);
        type = parseDataType();
                        args.add(constant(type.getType()));
        jj_consume_token(RPAREN);
        break;
      case CAST:
        funcToken = jj_consume_token(CAST);
        jj_consume_token(LPAREN);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(AS);
        type = parseDataType();
                        args.add(constant(type.getType()));
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[265] = jj_gen;
        if (jj_2_39(2)) {
          funcToken = jj_consume_token(SUBSTRING);
          jj_consume_token(LPAREN);
          expression = expression(info);
              args.add(expression);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FROM:
            jj_consume_token(FROM);
            expression = expression(info);
              args.add(expression);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case FOR:
              jj_consume_token(FOR);
              expression = expression(info);
              args.add(expression);
              break;
            default:
              jj_la1[245] = jj_gen;
              ;
            }
            break;
          case COMMA:
            jj_consume_token(COMMA);
            otherArgs = expressionList(info);
                                                          args.addAll(otherArgs);
            break;
          default:
            jj_la1[246] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(RPAREN);
        } else if (jj_2_40(2)) {
          funcToken = jj_consume_token(EXTRACT);
          jj_consume_token(LPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case YEAR:
            funcToken = jj_consume_token(YEAR);
            break;
          case MONTH:
            funcToken = jj_consume_token(MONTH);
            break;
          case DAY:
            funcToken = jj_consume_token(DAY);
            break;
          case HOUR:
            funcToken = jj_consume_token(HOUR);
            break;
          case MINUTE:
            funcToken = jj_consume_token(MINUTE);
            break;
          case SECOND:
            funcToken = jj_consume_token(SECOND);
            break;
          default:
            jj_la1[247] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(FROM);
          expression = expression(info);
                  if (funcToken.image.equalsIgnoreCase("DAY")) {
                 funcName = "DAYOFMONTH";
              }
              args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_41(2)) {
          funcToken = jj_consume_token(TRIM);
          jj_consume_token(LPAREN);
             funcName = funcToken.image; funcToken = null; expression = null;
          if (jj_2_38(2)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BOTH:
            case LEADING:
            case TRAILING:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LEADING:
                funcToken = jj_consume_token(LEADING);
                break;
              case TRAILING:
                funcToken = jj_consume_token(TRAILING);
                break;
              case BOTH:
                funcToken = jj_consume_token(BOTH);
                break;
              default:
                jj_la1[248] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case CHAR:
              case CAST:
              case CONVERT:
              case ANY:
              case ARRAY_AGG:
              case CASE:
              case EXISTS:
              case FALSE:
              case HOUR:
              case INSERT:
              case LEFT:
              case MINUTE:
              case MONTH:
              case NOT:
              case NULL:
              case RIGHT:
              case SECOND:
              case SOME:
              case TRANSLATE:
              case TRUE:
              case UNKNOWN:
              case USER:
              case YEAR:
              case XMLAGG:
              case XMLCONCAT:
              case XMLCOMMENT:
              case XMLELEMENT:
              case XMLFOREST:
              case XMLPARSE:
              case XMLPI:
              case XMLQUERY:
              case XMLSERIALIZE:
              case INSTEAD:
              case ENABLED:
              case DISABLED:
              case VIEW:
              case KEY:
              case SERIAL:
              case TEXTAGG:
              case COUNT:
              case ROW_NUMBER:
              case RANK:
              case DENSE_RANK:
              case SUM:
              case AVG:
              case MIN:
              case MAX:
              case EVERY:
              case STDDEV_POP:
              case STDDEV_SAMP:
              case VAR_SAMP:
              case VAR_POP:
              case DOCUMENT:
              case CONTENT:
              case TRIM:
              case EMPTY:
              case ORDINALITY:
              case PATH:
              case FIRST:
              case LAST:
              case NEXT:
              case SUBSTRING:
              case EXTRACT:
              case TO_CHARS:
              case TO_BYTES:
              case TIMESTAMPADD:
              case TIMESTAMPDIFF:
              case QUERYSTRING:
              case NAMESPACE:
              case RESULT:
              case INDEX:
              case ACCESSPATTERN:
              case AUTO_INCREMENT:
              case WELLFORMED:
              case SQL_TSI_FRAC_SECOND:
              case SQL_TSI_SECOND:
              case SQL_TSI_MINUTE:
              case SQL_TSI_HOUR:
              case SQL_TSI_DAY:
              case SQL_TSI_WEEK:
              case SQL_TSI_MONTH:
              case SQL_TSI_QUARTER:
              case SQL_TSI_YEAR:
              case TEXTTABLE:
              case ARRAYTABLE:
              case SELECTOR:
              case SKIP_KEYWORD:
              case WIDTH:
              case PASSING:
              case NAME:
              case ENCODING:
              case COLUMNS:
              case DELIMITER:
              case QUOTE:
              case HEADER:
              case NULLS:
              case OBJECTTABLE:
              case VERSION:
              case INCLUDING:
              case EXCLUDING:
              case XMLDECLARATION:
              case VARIADIC:
              case EXCEPTION:
              case RAISE:
              case CHAIN:
              case JSONARRAY_AGG:
              case JSONOBJECT:
              case ID:
              case ESCAPEDFUNCTION:
              case ESCAPEDTYPE:
              case DECIMALVAL:
              case FLOATVAL:
              case STRINGVAL:
              case UNSIGNEDINTEGER:
              case BINARYSTRINGVAL:
              case LPAREN:
              case PLUS:
              case MINUS:
              case QMARK:
              case DOLLAR:
                expression = expression(info);
                break;
              default:
                jj_la1[249] = jj_gen;
                ;
              }
              break;
            case CHAR:
            case CAST:
            case CONVERT:
            case ANY:
            case ARRAY_AGG:
            case CASE:
            case EXISTS:
            case FALSE:
            case HOUR:
            case INSERT:
            case LEFT:
            case MINUTE:
            case MONTH:
            case NOT:
            case NULL:
            case RIGHT:
            case SECOND:
            case SOME:
            case TRANSLATE:
            case TRUE:
            case UNKNOWN:
            case USER:
            case YEAR:
            case XMLAGG:
            case XMLCONCAT:
            case XMLCOMMENT:
            case XMLELEMENT:
            case XMLFOREST:
            case XMLPARSE:
            case XMLPI:
            case XMLQUERY:
            case XMLSERIALIZE:
            case INSTEAD:
            case ENABLED:
            case DISABLED:
            case VIEW:
            case KEY:
            case SERIAL:
            case TEXTAGG:
            case COUNT:
            case ROW_NUMBER:
            case RANK:
            case DENSE_RANK:
            case SUM:
            case AVG:
            case MIN:
            case MAX:
            case EVERY:
            case STDDEV_POP:
            case STDDEV_SAMP:
            case VAR_SAMP:
            case VAR_POP:
            case DOCUMENT:
            case CONTENT:
            case TRIM:
            case EMPTY:
            case ORDINALITY:
            case PATH:
            case FIRST:
            case LAST:
            case NEXT:
            case SUBSTRING:
            case EXTRACT:
            case TO_CHARS:
            case TO_BYTES:
            case TIMESTAMPADD:
            case TIMESTAMPDIFF:
            case QUERYSTRING:
            case NAMESPACE:
            case RESULT:
            case INDEX:
            case ACCESSPATTERN:
            case AUTO_INCREMENT:
            case WELLFORMED:
            case SQL_TSI_FRAC_SECOND:
            case SQL_TSI_SECOND:
            case SQL_TSI_MINUTE:
            case SQL_TSI_HOUR:
            case SQL_TSI_DAY:
            case SQL_TSI_WEEK:
            case SQL_TSI_MONTH:
            case SQL_TSI_QUARTER:
            case SQL_TSI_YEAR:
            case TEXTTABLE:
            case ARRAYTABLE:
            case SELECTOR:
            case SKIP_KEYWORD:
            case WIDTH:
            case PASSING:
            case NAME:
            case ENCODING:
            case COLUMNS:
            case DELIMITER:
            case QUOTE:
            case HEADER:
            case NULLS:
            case OBJECTTABLE:
            case VERSION:
            case INCLUDING:
            case EXCLUDING:
            case XMLDECLARATION:
            case VARIADIC:
            case EXCEPTION:
            case RAISE:
            case CHAIN:
            case JSONARRAY_AGG:
            case JSONOBJECT:
            case ID:
            case ESCAPEDFUNCTION:
            case ESCAPEDTYPE:
            case DECIMALVAL:
            case FLOATVAL:
            case STRINGVAL:
            case UNSIGNEDINTEGER:
            case BINARYSTRINGVAL:
            case LPAREN:
            case PLUS:
            case MINUS:
            case QMARK:
            case DOLLAR:
              expression = expression(info);
              break;
            default:
              jj_la1[250] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(FROM);
          } else {
            ;
          }
              if (funcToken == null) {
                  args.add(constant("BOTH"));
              } else {
                  args.add(constant(funcToken.image));
              }
              if (expression == null) {
                  args.add(constant(" "));
              } else {
                  if (expression instanceof Constant) {
                      Object value = ((Constant)expression).getValue();
                      if (value instanceof String && ((String)value).length() != 1) {
                                      {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.char_val));}
                      }
                  }
                  args.add(expression);
              }
          expression = expression(info);
              args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_42(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TO_CHARS:
            funcToken = jj_consume_token(TO_CHARS);
            break;
          case TO_BYTES:
            funcToken = jj_consume_token(TO_BYTES);
            break;
          default:
            jj_la1[251] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(LPAREN);
          expression = expression(info);
                        args.add(expression);
          jj_consume_token(COMMA);
          literal = stringVal();
                        args.add(constant(literal));
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
            expression = expression(info);
                   requiresVersionAtLeast(Version.TEIID_8_6);
                   args.add(expression);
            break;
          default:
            jj_la1[252] = jj_gen;
            ;
          }
          jj_consume_token(RPAREN);
        } else if (jj_2_43(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TIMESTAMPADD:
            funcToken = jj_consume_token(TIMESTAMPADD);
            break;
          case TIMESTAMPDIFF:
            funcToken = jj_consume_token(TIMESTAMPDIFF);
            break;
          default:
            jj_la1[253] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(LPAREN);
          expression = intervalType();
                        args.add(expression);
          jj_consume_token(COMMA);
          expression = expression(info);
                        args.add(expression);
          jj_consume_token(COMMA);
          expression = expression(info);
                        args.add(expression);
          jj_consume_token(RPAREN);
        } else if (jj_2_44(2)) {
          expression = queryString(info);
                {if (true) return expression;}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR:
          case HOUR:
          case LEFT:
          case MINUTE:
          case MONTH:
          case RIGHT:
          case SECOND:
          case USER:
          case YEAR:
          case XMLCONCAT:
          case XMLCOMMENT:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LEFT:
              funcToken = jj_consume_token(LEFT);
              break;
            case RIGHT:
              funcToken = jj_consume_token(RIGHT);
              break;
            case CHAR:
              funcToken = jj_consume_token(CHAR);
              break;
            case USER:
              funcToken = jj_consume_token(USER);
              break;
            case YEAR:
              funcToken = jj_consume_token(YEAR);
              break;
            case MONTH:
              funcToken = jj_consume_token(MONTH);
              break;
            case HOUR:
              funcToken = jj_consume_token(HOUR);
              break;
            case MINUTE:
              funcToken = jj_consume_token(MINUTE);
              break;
            case SECOND:
              funcToken = jj_consume_token(SECOND);
              break;
            case XMLCONCAT:
              funcToken = jj_consume_token(XMLCONCAT);
              break;
            case XMLCOMMENT:
              funcToken = jj_consume_token(XMLCOMMENT);
              break;
            default:
              jj_la1[254] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(LPAREN);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case CHAR:
            case CAST:
            case CONVERT:
            case ANY:
            case ARRAY_AGG:
            case CASE:
            case EXISTS:
            case FALSE:
            case HOUR:
            case INSERT:
            case LEFT:
            case MINUTE:
            case MONTH:
            case NOT:
            case NULL:
            case RIGHT:
            case SECOND:
            case SOME:
            case TRANSLATE:
            case TRUE:
            case UNKNOWN:
            case USER:
            case YEAR:
            case XMLAGG:
            case XMLCONCAT:
            case XMLCOMMENT:
            case XMLELEMENT:
            case XMLFOREST:
            case XMLPARSE:
            case XMLPI:
            case XMLQUERY:
            case XMLSERIALIZE:
            case INSTEAD:
            case ENABLED:
            case DISABLED:
            case VIEW:
            case KEY:
            case SERIAL:
            case TEXTAGG:
            case COUNT:
            case ROW_NUMBER:
            case RANK:
            case DENSE_RANK:
            case SUM:
            case AVG:
            case MIN:
            case MAX:
            case EVERY:
            case STDDEV_POP:
            case STDDEV_SAMP:
            case VAR_SAMP:
            case VAR_POP:
            case DOCUMENT:
            case CONTENT:
            case TRIM:
            case EMPTY:
            case ORDINALITY:
            case PATH:
            case FIRST:
            case LAST:
            case NEXT:
            case SUBSTRING:
            case EXTRACT:
            case TO_CHARS:
            case TO_BYTES:
            case TIMESTAMPADD:
            case TIMESTAMPDIFF:
            case QUERYSTRING:
            case NAMESPACE:
            case RESULT:
            case INDEX:
            case ACCESSPATTERN:
            case AUTO_INCREMENT:
            case WELLFORMED:
            case SQL_TSI_FRAC_SECOND:
            case SQL_TSI_SECOND:
            case SQL_TSI_MINUTE:
            case SQL_TSI_HOUR:
            case SQL_TSI_DAY:
            case SQL_TSI_WEEK:
            case SQL_TSI_MONTH:
            case SQL_TSI_QUARTER:
            case SQL_TSI_YEAR:
            case TEXTTABLE:
            case ARRAYTABLE:
            case SELECTOR:
            case SKIP_KEYWORD:
            case WIDTH:
            case PASSING:
            case NAME:
            case ENCODING:
            case COLUMNS:
            case DELIMITER:
            case QUOTE:
            case HEADER:
            case NULLS:
            case OBJECTTABLE:
            case VERSION:
            case INCLUDING:
            case EXCLUDING:
            case XMLDECLARATION:
            case VARIADIC:
            case EXCEPTION:
            case RAISE:
            case CHAIN:
            case JSONARRAY_AGG:
            case JSONOBJECT:
            case ID:
            case ESCAPEDFUNCTION:
            case ESCAPEDTYPE:
            case DECIMALVAL:
            case FLOATVAL:
            case STRINGVAL:
            case UNSIGNEDINTEGER:
            case BINARYSTRINGVAL:
            case LPAREN:
            case PLUS:
            case MINUS:
            case QMARK:
            case DOLLAR:
              args = expressionList(info);
              break;
            default:
              jj_la1[255] = jj_gen;
              ;
            }
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[266] = jj_gen;
            if (jj_2_45(2147483647)) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case TRANSLATE:
                funcToken = jj_consume_token(TRANSLATE);
                break;
              case INSERT:
                funcToken = jj_consume_token(INSERT);
                break;
              default:
                jj_la1[256] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              jj_consume_token(LPAREN);
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case CHAR:
              case CAST:
              case CONVERT:
              case ANY:
              case ARRAY_AGG:
              case CASE:
              case EXISTS:
              case FALSE:
              case HOUR:
              case INSERT:
              case LEFT:
              case MINUTE:
              case MONTH:
              case NOT:
              case NULL:
              case RIGHT:
              case SECOND:
              case SOME:
              case TRANSLATE:
              case TRUE:
              case UNKNOWN:
              case USER:
              case YEAR:
              case XMLAGG:
              case XMLCONCAT:
              case XMLCOMMENT:
              case XMLELEMENT:
              case XMLFOREST:
              case XMLPARSE:
              case XMLPI:
              case XMLQUERY:
              case XMLSERIALIZE:
              case INSTEAD:
              case ENABLED:
              case DISABLED:
              case VIEW:
              case KEY:
              case SERIAL:
              case TEXTAGG:
              case COUNT:
              case ROW_NUMBER:
              case RANK:
              case DENSE_RANK:
              case SUM:
              case AVG:
              case MIN:
              case MAX:
              case EVERY:
              case STDDEV_POP:
              case STDDEV_SAMP:
              case VAR_SAMP:
              case VAR_POP:
              case DOCUMENT:
              case CONTENT:
              case TRIM:
              case EMPTY:
              case ORDINALITY:
              case PATH:
              case FIRST:
              case LAST:
              case NEXT:
              case SUBSTRING:
              case EXTRACT:
              case TO_CHARS:
              case TO_BYTES:
              case TIMESTAMPADD:
              case TIMESTAMPDIFF:
              case QUERYSTRING:
              case NAMESPACE:
              case RESULT:
              case INDEX:
              case ACCESSPATTERN:
              case AUTO_INCREMENT:
              case WELLFORMED:
              case SQL_TSI_FRAC_SECOND:
              case SQL_TSI_SECOND:
              case SQL_TSI_MINUTE:
              case SQL_TSI_HOUR:
              case SQL_TSI_DAY:
              case SQL_TSI_WEEK:
              case SQL_TSI_MONTH:
              case SQL_TSI_QUARTER:
              case SQL_TSI_YEAR:
              case TEXTTABLE:
              case ARRAYTABLE:
              case SELECTOR:
              case SKIP_KEYWORD:
              case WIDTH:
              case PASSING:
              case NAME:
              case ENCODING:
              case COLUMNS:
              case DELIMITER:
              case QUOTE:
              case HEADER:
              case NULLS:
              case OBJECTTABLE:
              case VERSION:
              case INCLUDING:
              case EXCLUDING:
              case XMLDECLARATION:
              case VARIADIC:
              case EXCEPTION:
              case RAISE:
              case CHAIN:
              case JSONARRAY_AGG:
              case JSONOBJECT:
              case ID:
              case ESCAPEDFUNCTION:
              case ESCAPEDTYPE:
              case DECIMALVAL:
              case FLOATVAL:
              case STRINGVAL:
              case UNSIGNEDINTEGER:
              case BINARYSTRINGVAL:
              case LPAREN:
              case PLUS:
              case MINUS:
              case QMARK:
              case DOLLAR:
                args = expressionList(info);
                break;
              default:
                jj_la1[257] = jj_gen;
                ;
              }
              jj_consume_token(RPAREN);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case XMLPARSE:
                expression = xmlParse(info);
                {if (true) return expression;}
                break;
              case XMLELEMENT:
                expression = xmlElement(info);
                {if (true) return expression;}
                break;
              case XMLPI:
                funcToken = jj_consume_token(XMLPI);
                jj_consume_token(LPAREN);
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case NAME:
                  jj_consume_token(NAME);
                  break;
                default:
                  jj_la1[258] = jj_gen;
                  ;
                }
                literal = id(null);
                        args.add(constant(literal));
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case COMMA:
                  jj_consume_token(COMMA);
                  expression = expression(info);
                                args.add(expression);
                  break;
                default:
                  jj_la1[259] = jj_gen;
                  ;
                }
                jj_consume_token(RPAREN);
                break;
              case XMLFOREST:
                expression = xmlForest(info);
                        {if (true) return expression;}
                break;
              default:
                jj_la1[267] = jj_gen;
                if (jj_2_46(2147483647)) {
                  expression = jsonObject(info);
                        {if (true) return expression;}
                } else {
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case XMLSERIALIZE:
                    expression = xmlSerialize(info);
                        {if (true) return expression;}
                    break;
                  case XMLQUERY:
                    expression = xmlQuery(info);
                        {if (true) return expression;}
                    break;
                  case INSTEAD:
                  case ENABLED:
                  case DISABLED:
                  case VIEW:
                  case KEY:
                  case SERIAL:
                  case TEXTAGG:
                  case COUNT:
                  case ROW_NUMBER:
                  case RANK:
                  case DENSE_RANK:
                  case SUM:
                  case AVG:
                  case MIN:
                  case MAX:
                  case EVERY:
                  case STDDEV_POP:
                  case STDDEV_SAMP:
                  case VAR_SAMP:
                  case VAR_POP:
                  case DOCUMENT:
                  case CONTENT:
                  case TRIM:
                  case EMPTY:
                  case ORDINALITY:
                  case PATH:
                  case FIRST:
                  case LAST:
                  case NEXT:
                  case SUBSTRING:
                  case EXTRACT:
                  case TO_CHARS:
                  case TO_BYTES:
                  case TIMESTAMPADD:
                  case TIMESTAMPDIFF:
                  case QUERYSTRING:
                  case NAMESPACE:
                  case RESULT:
                  case INDEX:
                  case ACCESSPATTERN:
                  case AUTO_INCREMENT:
                  case WELLFORMED:
                  case SQL_TSI_FRAC_SECOND:
                  case SQL_TSI_SECOND:
                  case SQL_TSI_MINUTE:
                  case SQL_TSI_HOUR:
                  case SQL_TSI_DAY:
                  case SQL_TSI_WEEK:
                  case SQL_TSI_MONTH:
                  case SQL_TSI_QUARTER:
                  case SQL_TSI_YEAR:
                  case TEXTTABLE:
                  case ARRAYTABLE:
                  case SELECTOR:
                  case SKIP_KEYWORD:
                  case WIDTH:
                  case PASSING:
                  case NAME:
                  case ENCODING:
                  case COLUMNS:
                  case DELIMITER:
                  case QUOTE:
                  case HEADER:
                  case NULLS:
                  case OBJECTTABLE:
                  case VERSION:
                  case INCLUDING:
                  case EXCLUDING:
                  case XMLDECLARATION:
                  case VARIADIC:
                  case EXCEPTION:
                  case RAISE:
                  case CHAIN:
                  case JSONARRAY_AGG:
                  case JSONOBJECT:
                  case ID:
                    funcName = id(null);
                    jj_consume_token(LPAREN);
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case ALL:
                    case DISTINCT:
                      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                      case ALL:
                        jj_consume_token(ALL);
                         distinct = false;
                        break;
                      case DISTINCT:
                        jj_consume_token(DISTINCT);
                                                           distinct = true;
                        break;
                      default:
                        jj_la1[260] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                      }
                      break;
                    default:
                      jj_la1[261] = jj_gen;
                      ;
                    }
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case CHAR:
                    case CAST:
                    case CONVERT:
                    case ANY:
                    case ARRAY_AGG:
                    case CASE:
                    case EXISTS:
                    case FALSE:
                    case HOUR:
                    case INSERT:
                    case LEFT:
                    case MINUTE:
                    case MONTH:
                    case NOT:
                    case NULL:
                    case RIGHT:
                    case SECOND:
                    case SOME:
                    case TRANSLATE:
                    case TRUE:
                    case UNKNOWN:
                    case USER:
                    case YEAR:
                    case XMLAGG:
                    case XMLCONCAT:
                    case XMLCOMMENT:
                    case XMLELEMENT:
                    case XMLFOREST:
                    case XMLPARSE:
                    case XMLPI:
                    case XMLQUERY:
                    case XMLSERIALIZE:
                    case INSTEAD:
                    case ENABLED:
                    case DISABLED:
                    case VIEW:
                    case KEY:
                    case SERIAL:
                    case TEXTAGG:
                    case COUNT:
                    case ROW_NUMBER:
                    case RANK:
                    case DENSE_RANK:
                    case SUM:
                    case AVG:
                    case MIN:
                    case MAX:
                    case EVERY:
                    case STDDEV_POP:
                    case STDDEV_SAMP:
                    case VAR_SAMP:
                    case VAR_POP:
                    case DOCUMENT:
                    case CONTENT:
                    case TRIM:
                    case EMPTY:
                    case ORDINALITY:
                    case PATH:
                    case FIRST:
                    case LAST:
                    case NEXT:
                    case SUBSTRING:
                    case EXTRACT:
                    case TO_CHARS:
                    case TO_BYTES:
                    case TIMESTAMPADD:
                    case TIMESTAMPDIFF:
                    case QUERYSTRING:
                    case NAMESPACE:
                    case RESULT:
                    case INDEX:
                    case ACCESSPATTERN:
                    case AUTO_INCREMENT:
                    case WELLFORMED:
                    case SQL_TSI_FRAC_SECOND:
                    case SQL_TSI_SECOND:
                    case SQL_TSI_MINUTE:
                    case SQL_TSI_HOUR:
                    case SQL_TSI_DAY:
                    case SQL_TSI_WEEK:
                    case SQL_TSI_MONTH:
                    case SQL_TSI_QUARTER:
                    case SQL_TSI_YEAR:
                    case TEXTTABLE:
                    case ARRAYTABLE:
                    case SELECTOR:
                    case SKIP_KEYWORD:
                    case WIDTH:
                    case PASSING:
                    case NAME:
                    case ENCODING:
                    case COLUMNS:
                    case DELIMITER:
                    case QUOTE:
                    case HEADER:
                    case NULLS:
                    case OBJECTTABLE:
                    case VERSION:
                    case INCLUDING:
                    case EXCLUDING:
                    case XMLDECLARATION:
                    case VARIADIC:
                    case EXCEPTION:
                    case RAISE:
                    case CHAIN:
                    case JSONARRAY_AGG:
                    case JSONOBJECT:
                    case ID:
                    case ESCAPEDFUNCTION:
                    case ESCAPEDTYPE:
                    case DECIMALVAL:
                    case FLOATVAL:
                    case STRINGVAL:
                    case UNSIGNEDINTEGER:
                    case BINARYSTRINGVAL:
                    case LPAREN:
                    case PLUS:
                    case MINUS:
                    case QMARK:
                    case DOLLAR:
                      args = expressionList(info);
                      break;
                    default:
                      jj_la1[262] = jj_gen;
                      ;
                    }
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case ORDER:
                      orderBy = orderby(info);
                      break;
                    default:
                      jj_la1[263] = jj_gen;
                      ;
                    }
                    jj_consume_token(RPAREN);
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case FILTER:
                      condition = filterClause(info);
                      break;
                    default:
                      jj_la1[264] = jj_gen;
                      ;
                    }
                    break;
                  default:
                    jj_la1[268] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                }
              }
            }
          }
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                if(funcName == null) {
                        funcName = funcToken.image;
                }
                if (distinct != null || orderBy != null || condition != null || "string_agg".equalsIgnoreCase(funcName)) {
                    AggregateSymbol as = newAggregateSymbol(funcName, distinct!=null?distinct:false, (Expression[])args.toArray(new Expression[args.size()]));
                    as.setOrderBy(orderBy);
                        as.setCondition(condition);
                        {if (true) return as;}
        }
        jjtn000.setName(funcName);
        jjtn000.setArgs((Expression[])args.toArray(new Expression[args.size()]));
        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml parse
description=Parses the given value as XML.
example={code:sql}XMLPARSE(DOCUMENT doc WELLFORMED){code}
*/
  final public XMLParse xmlParse(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLParse */
        XMLParse jjtn000 = (XMLParse)TeiidNodeFactory.jjtCreate(this, JJTXMLPARSE);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression expr = null;
        boolean doc = false;
        boolean wellformed = false;
    try {
      jj_consume_token(XMLPARSE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOCUMENT:
        jj_consume_token(DOCUMENT);
                     doc = true;
        break;
      case CONTENT:
        jj_consume_token(CONTENT);
                                              doc = false;
        break;
      default:
        jj_la1[269] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = expression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WELLFORMED:
        jj_consume_token(WELLFORMED);
           wellformed = true;
        break;
      default:
        jj_la1[270] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setDocument(doc);
                jjtn000.setExpression(expr);
                jjtn000.setWellFormed(wellformed);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=querystring function
description=Produces a URL query string from the given arguments.
example={code:sql}QUERYSTRING(col1 AS opt, col2 AS val){code}
*/
  final public QueryString queryString(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) QueryString */
        QueryString jjtn000 = (QueryString)TeiidNodeFactory.jjtCreate(this, JJTQUERYSTRING);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Expression path = null;
        DerivedColumn arg = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    try {
      jj_consume_token(QUERYSTRING);
      jj_consume_token(LPAREN);
      path = expression(info);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[271] = jj_gen;
          break label_38;
        }
        jj_consume_token(COMMA);
        arg = derivedColumn(info);
                args.add(arg);
                arg = null;
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setPath(path);
            jjtn000.setArgs(args);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml element
description=Creates an XML element.
example={code:sql}XMLELEMENT(NAME "root", child){code}
*/
  final public XMLElement xmlElement(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLElement */
        XMLElement jjtn000 = (XMLElement)TeiidNodeFactory.jjtCreate(this, JJTXMLELEMENT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);String name = null;
        ArrayList content = new ArrayList(2);
        XMLNamespaces xmlNamespaces = null;
        XMLAttributes xmlAttributes = null;
        Expression expression = null;
    try {
      jj_consume_token(XMLELEMENT);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
        jj_consume_token(NAME);
        break;
      default:
        jj_la1[272] = jj_gen;
        ;
      }
      name = id(null);
      if (jj_2_47(2)) {
        jj_consume_token(COMMA);
        xmlNamespaces = xmlNamespaces(info);
      } else {
        ;
      }
      if (jj_2_48(2)) {
        jj_consume_token(COMMA);
        xmlAttributes = xmlAttributes(info);
      } else {
        ;
      }
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[273] = jj_gen;
          break label_39;
        }
        jj_consume_token(COMMA);
        expression = expression(info);
                content.add(expression);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setName(name);
            jjtn000.setContent(content);
                jjtn000.setNamespaces(xmlNamespaces);
                jjtn000.setAttributes(xmlAttributes);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml attributes
description=Creates attributes for the containing element.
example={code:sql}XMLATTRIBUTES(col1 AS attr1, col2 AS attr2){code}
*/
  final public XMLAttributes xmlAttributes(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLAttributes */
        XMLAttributes jjtn000 = (XMLAttributes)TeiidNodeFactory.jjtCreate(this, JJTXMLATTRIBUTES);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);DerivedColumn expression = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    try {
      jj_consume_token(XMLATTRIBUTES);
      jj_consume_token(LPAREN);
      expression = derivedColumn(info);
                args.add(expression);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[274] = jj_gen;
          break label_40;
        }
        jj_consume_token(COMMA);
        expression = derivedColumn(info);
                args.add(expression);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
           jjtn000.setArgs(args);
           {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=json object
description=Produces a JSON object containing name value pairs.
example={code:sql}JSONOBJECT(col1 AS val1, col2 AS val2){code}
*/
  final public JSONObject jsonObject(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) JSONObject */
        JSONObject jjtn000 = (JSONObject)TeiidNodeFactory.jjtCreate(this, JJTJSONOBJECT);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);ArrayList<DerivedColumn> args = null;
    try {
      jj_consume_token(JSONOBJECT);
      jj_consume_token(LPAREN);
      args = derivedColumnList(info);
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setArgs(args);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=derived column list
description=a list of name value pairs
example={code:sql}col1 AS val1, col2 AS val2{code}
*/
  final public ArrayList<DerivedColumn> derivedColumnList(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    expression = derivedColumn(info);
                args.add(expression);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[275] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      expression = derivedColumn(info);
                args.add(expression);
    }
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml forest
description=Produces an element for each derived column.
example={code:sql}XMLFOREST(col1 AS ELEM1, col2 AS ELEM2){code}
*/
  final public XMLForest xmlForest(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLForest */
        XMLForest jjtn000 = (XMLForest)TeiidNodeFactory.jjtCreate(this, JJTXMLFOREST);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);DerivedColumn expression = null;
        XMLNamespaces xmlNamespaces = null;
        ArrayList<DerivedColumn> args = null;
    try {
      jj_consume_token(XMLFOREST);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLNAMESPACES:
        xmlNamespaces = xmlNamespaces(info);
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[276] = jj_gen;
        ;
      }
      args = derivedColumnList(info);
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setArguments(args);
                jjtn000.setNamespaces(xmlNamespaces);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml namespaces
description=Defines XML namespace URI/prefix combinations
example={code:sql}XMLNAMESPACES('http://foo' AS foo){code}
*/
  final public XMLNamespaces xmlNamespaces(ParseInfo info) throws ParseException {
 /*@bgen(jjtree) XMLNamespaces */
        XMLNamespaces jjtn000 = (XMLNamespaces)TeiidNodeFactory.jjtCreate(this, JJTXMLNAMESPACES);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);List<NamespaceItem> namespaces = new ArrayList<NamespaceItem >(2);
        NamespaceItem item = null;
    try {
      jj_consume_token(XMLNAMESPACES);
      jj_consume_token(LPAREN);
      item = namespaceItem();
                namespaces.add(item);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[277] = jj_gen;
          break label_42;
        }
        jj_consume_token(COMMA);
        item = namespaceItem();
                 namespaces.add(item);
      }
      jj_consume_token(RPAREN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.setNamespaces(namespaces);
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml namespace element
description=An xml namespace
example={code:sql}NO DEFAULT{code}
*/
  final public NamespaceItem namespaceItem() throws ParseException {
        String uri = null;
        String prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      uri = stringVal();
      jj_consume_token(AS);
      prefix = id(null);
                        {if (true) return new NamespaceItem(uri, prefix);}
      break;
    case NO:
      jj_consume_token(NO);
      jj_consume_token(DEFAULT_KEYWORD);
                        {if (true) return new NamespaceItem();}
      break;
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      uri = stringVal();
                        {if (true) return new NamespaceItem(uri);}
      break;
    default:
      jj_la1[278] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=simple data type
description=A non-collection data type.
example={code:sql}STRING{code}
*/
  final public ParsedDataType parseDataTypePrimary() throws ParseException {
        Token typeToken = null;
        Integer length = null;
        Integer scale = null;
        boolean precision = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      typeToken = jj_consume_token(STRING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[279] = jj_gen;
        ;
      }
                                                                           precision = false;
      break;
    case VARCHAR:
      typeToken = jj_consume_token(VARCHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[280] = jj_gen;
        ;
      }
                                                                            precision = false;
      break;
    case BOOLEAN:
      typeToken = jj_consume_token(BOOLEAN);
      break;
    case BYTE:
      typeToken = jj_consume_token(BYTE);
      break;
    case TINYINT:
      typeToken = jj_consume_token(TINYINT);
      break;
    case SHORT:
      typeToken = jj_consume_token(SHORT);
      break;
    case SMALLINT:
      typeToken = jj_consume_token(SMALLINT);
      break;
    case CHAR:
      typeToken = jj_consume_token(CHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[281] = jj_gen;
        ;
      }
                                                                         precision = false;
      break;
    case INTEGER:
      typeToken = jj_consume_token(INTEGER);
      break;
    case LONG:
      typeToken = jj_consume_token(LONG);
      break;
    case BIGINT:
      typeToken = jj_consume_token(BIGINT);
      break;
    case BIGINTEGER:
      typeToken = jj_consume_token(BIGINTEGER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[282] = jj_gen;
        ;
      }
      break;
    case FLOAT:
      typeToken = jj_consume_token(FLOAT);
      break;
    case REAL:
      typeToken = jj_consume_token(REAL);
      break;
    case DOUBLE:
      typeToken = jj_consume_token(DOUBLE);
      break;
    case BIGDECIMAL:
      typeToken = jj_consume_token(BIGDECIMAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          scale = intVal();
          break;
        default:
          jj_la1[283] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[284] = jj_gen;
        ;
      }
      break;
    case DECIMAL:
      typeToken = jj_consume_token(DECIMAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          scale = intVal();
          break;
        default:
          jj_la1[285] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[286] = jj_gen;
        ;
      }
      break;
    case DATE:
      typeToken = jj_consume_token(DATE);
      break;
    case TIME:
      typeToken = jj_consume_token(TIME);
      break;
    case TIMESTAMP:
      typeToken = jj_consume_token(TIMESTAMP);
      break;
    case OBJECT:
      typeToken = jj_consume_token(OBJECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[287] = jj_gen;
        ;
      }
                                                                           precision = false;
      break;
    case BLOB:
      typeToken = jj_consume_token(BLOB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[288] = jj_gen;
        ;
      }
                                                                         precision = false;
      break;
    case CLOB:
      typeToken = jj_consume_token(CLOB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[289] = jj_gen;
        ;
      }
                                                                         precision = false;
      break;
    case VARBINARY:
      typeToken = jj_consume_token(VARBINARY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[290] = jj_gen;
        ;
      }
                                                                              precision = false;
      break;
    case XML:
      typeToken = jj_consume_token(XML);
      break;
    default:
      jj_la1[291] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            String typeName = typeToken.image;
                if (scale != null){
                        {if (true) return new ParsedDataType(typeName, length, scale, precision);}
                }
                else if (length != null){
                        {if (true) return new ParsedDataType(typeName, length, precision);}
                }
                {if (true) return new ParsedDataType(typeName);}
    throw new Error("Missing return statement in function");
  }

/*
name=data type
description=A data type.
example={code:sql}STRING[]{code}
*/
  final public ParsedDataType parseDataType() throws ParseException {
    int arraySuffixes = 0;
    ParsedDataType type = null;
    type = parseDataTypePrimary();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSBRACE:
        ;
        break;
      default:
        jj_la1[292] = jj_gen;
        break label_43;
      }
      jj_consume_token(LSBRACE);
      jj_consume_token(RSBRACE);
                         requiresVersionAtLeast(Version.TEIID_8_5); arraySuffixes++;
    }
        if (arraySuffixes > 0) {
           type.setType(type.getType() + StringUtil.join(Collections.nCopies(arraySuffixes, "[]"), ""));
        }
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

/*
name=time interval
description=A time interval keyword.
example={code:sql}SQL_TSI_HOUR{code}
*/
  final public Constant intervalType() throws ParseException {
        Token type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQL_TSI_FRAC_SECOND:
      type = jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      type = jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      type = jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      type = jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      type = jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      type = jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      type = jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      type = jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      type = jj_consume_token(SQL_TSI_YEAR);
      break;
    default:
      jj_la1[293] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return constant(type.image);}
    throw new Error("Missing return statement in function");
  }

/*
name=non numeric literal
description=An escaped or simple non numeric literal.
example={code:sql}'a'{code}
*/
  final public Constant nonNumericLiteral() throws ParseException {
    Token t = null;
    String strVal = "";
    DataTypeManagerService.DefaultDataTypes escapeType = null;
    Constant constant = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      strVal = stringVal();
                        constant = constant(strVal, DataTypeManagerService.DefaultDataTypes.STRING);
      break;
    case BINARYSTRINGVAL:
      t = jj_consume_token(BINARYSTRINGVAL);
                                      constant = constant(new BinaryType(javax.xml.bind.DatatypeConverter.parseHexBinary(t.image.substring(2, t.image.length() - 1))), DataTypeManagerService.DefaultDataTypes.VARBINARY);
      break;
    case FALSE:
      t = jj_consume_token(FALSE);
                               constant = constant(Boolean.FALSE, DataTypeManagerService.DefaultDataTypes.BOOLEAN);
      break;
    case TRUE:
      t = jj_consume_token(TRUE);
                               constant = constant(Boolean.TRUE, DataTypeManagerService.DefaultDataTypes.BOOLEAN);
      break;
    case UNKNOWN:
      t = jj_consume_token(UNKNOWN);
                       constant = constant(null, DataTypeManagerService.DefaultDataTypes.BOOLEAN);
      break;
    case NULL:
      t = jj_consume_token(NULL);
                       constant = constant(null);
      break;
    case ESCAPEDTYPE:
      jj_consume_token(ESCAPEDTYPE);
            String image = getToken(0).image;
                if (StringUtil.endsWithIgnoreCase(image, "b")) {
                        escapeType=DataTypeManagerService.DefaultDataTypes.BOOLEAN;
                } else if (StringUtil.endsWithIgnoreCase(image, "ts")) {
                        escapeType=DataTypeManagerService.DefaultDataTypes.TIMESTAMP;
                } else if (StringUtil.endsWithIgnoreCase(image, "d")) {
                        escapeType=DataTypeManagerService.DefaultDataTypes.DATE;
                } else {
                        escapeType=DataTypeManagerService.DefaultDataTypes.TIME;
                }
      strVal = stringVal();
                        try {
                                constant = constant(getDataTypeService().transformValue(strVal, escapeType), escapeType);
                        } catch (Exception e) {
                                {if (true) throw new ParseException(e.getMessage());}
                        }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[294] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return constant;}
    throw new Error("Missing return statement in function");
  }

/*
name=unsigned numeric literal
description=An unsigned numeric literal value.
example={code:sql}1.234{code}
*/
  final public Constant unsignedNumericLiteral(String strVal) throws ParseException {
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNEDINTEGER:
      t = jj_consume_token(UNSIGNEDINTEGER);
                        try {
                            strVal = prependSign(strVal, t.image);
                                // First try as integer - this should nearly always work
                                {if (true) return constant(Integer.valueOf(strVal), DataTypeManagerService.DefaultDataTypes.INTEGER);}
                        } catch(NumberFormatException e1) {
                                try {
                                        // Second try as a long
                                        {if (true) return constant(Long.valueOf(strVal), DataTypeManagerService.DefaultDataTypes.LONG);}
                                } catch(NumberFormatException e2) {
                                        try {
                                                // Third try as a biginteger
                                                {if (true) return constant(new BigInteger(strVal), DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);}
                                        } catch(NumberFormatException e3) {
                                                Object[] params = new Object[] { strVal };
                                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.Integer_parse, params));}
                                        }
                                }
                        }
      break;
    case FLOATVAL:
      t = jj_consume_token(FLOATVAL);
                    strVal = prependSign(strVal, t.image);
                        try {
                                {if (true) return constant(Double.valueOf(strVal), DataTypeManagerService.DefaultDataTypes.DOUBLE);}
                        } catch(NumberFormatException e) {
                                Object[] params = new Object[] { strVal };
                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.Float_parse, params));}
                        }
      break;
    case DECIMALVAL:
      t = jj_consume_token(DECIMALVAL);
                strVal = prependSign(strVal, t.image);
                        try {
                            if (getDataTypeService().isDecimalAsDouble()) {
                                {if (true) return constant(Double.valueOf(strVal), DataTypeManagerService.DefaultDataTypes.DOUBLE);}
                                } else {
                                {if (true) return constant(new java.math.BigDecimal(strVal), DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);}
                                }
                        } catch(NumberFormatException e) {
                                Object[] params = new Object[] { t.image };
                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.decimal_parse, params));}
                        }
      break;
    default:
      jj_la1[295] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
unused=true
*/
  final public void parseMetadata(MetadataFactory factory) throws ParseException {
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case CREATE:
      case SET:
        ;
        break;
      default:
        jj_la1[296] = jj_gen;
        break label_44;
      }
      ddlStmt(factory);
    }
    jj_consume_token(0);
  }

/*
name=ddl statement
description=A data definition statement.
example={code:sql}CREATE FOREIGN TABLE X (Y STRING){code}
index=true
*/
  final public void ddlStmt(MetadataFactory factory) throws ParseException {
        Command command = null;
    if (jj_2_49(3)) {
      createTable(factory);
    } else if (jj_2_50(4)) {
      createDDLProcedure(factory, ParseInfo.DEFAULT_INSTANCE);
    } else if (jj_2_51(2)) {
      createNameSpace(factory);
    } else if (jj_2_52(4)) {
      alterStatement(factory);
    } else if (jj_2_53(4)) {
      command = createTrigger(ParseInfo.DEFAULT_INSTANCE);
                createDDLTrigger(factory, (AlterTrigger)command);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[297] = jj_gen;
      ;
    }
  }

/*
name=option namespace
description=A namespace used to shorten the full name of an option key.
example={code:sql}SET NAMESPACE 'http://foo' AS foo{code}
*/
  final public void createNameSpace(MetadataFactory factory) throws ParseException {
        String uri = null;
        String prefix = null;
    jj_consume_token(SET);
    jj_consume_token(NAMESPACE);
    uri = stringVal();
    jj_consume_token(AS);
    prefix = id(Boolean.FALSE);
                factory.addNamespace(prefix, uri);
  }

/*
name=create procedure
description=Defines a procedure or function invocation.
example={code:sql}CREATE FOREIGN PROCEDURE proc (param STRING) RETURNS STRING{code}
*/
  final public CreateProcedureCommand createDDLProcedure(MetadataFactory factory, ParseInfo info) throws ParseException {
        boolean virtual = true;
        boolean function = false;
        Procedure proc = null;
        String procName = null;
    CreateProcedureCommand procCmd = createASTNode(ASTNodes.CREATE_PROCEDURE_COMMAND);
    Statement stmt = null;
    ParsedDataType returnDataType = null;
    Token comment = null;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOREIGN:
    case VIRTUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      case FOREIGN:
        jj_consume_token(FOREIGN);
                                         virtual = false;
        break;
      default:
        jj_la1[298] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[299] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
                                                                                       function = true;
      break;
    default:
      jj_la1[300] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    procName = id(null);
                        proc = factory.addProcedure(procName);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case INOUT:
    case OUT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case ID:
      procedureParameter(factory, proc);
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[301] = jj_gen;
          break label_45;
        }
        jj_consume_token(COMMA);
        procedureParameter(factory, proc);
      }
      break;
    default:
      jj_la1[302] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNS:
      jj_consume_token(RETURNS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TABLE:
          jj_consume_token(TABLE);
          break;
        default:
          jj_la1[303] = jj_gen;
          ;
        }
        jj_consume_token(LPAREN);
        procedureRsColumn(factory, proc);
        label_46:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[304] = jj_gen;
            break label_46;
          }
          jj_consume_token(COMMA);
          procedureRsColumn(factory, proc);
        }
        jj_consume_token(RPAREN);
        break;
      case STRING:
      case VARBINARY:
      case VARCHAR:
      case BOOLEAN:
      case BYTE:
      case TINYINT:
      case SHORT:
      case SMALLINT:
      case CHAR:
      case INTEGER:
      case LONG:
      case BIGINT:
      case BIGINTEGER:
      case FLOAT:
      case REAL:
      case DOUBLE:
      case BIGDECIMAL:
      case DECIMAL:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case OBJECT:
      case BLOB:
      case CLOB:
      case XML:
        returnDataType = parseDataType();
        break;
      default:
        jj_la1[305] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[306] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(proc, factory);
                      setProcedureOptions(proc);
      break;
    default:
      jj_la1[307] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                        comment = getToken(1).specialToken;
      stmt = statement(info);
      break;
    default:
      jj_la1[308] = jj_gen;
      ;
    }
                        proc.setVirtual(virtual);
                        proc.setFunction(function);
                        if (stmt != null){
                            if (function || !virtual) {
                                 {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.function_def, procName));}
                            }
                                proc.setQueryPlan((comment != null?comment.image+" ":"") + stmt.toString());
                        }

                if (returnDataType != null){
                                addProcColumn(factory, proc, "return", returnDataType, false);
                }
                if (function) {
                        replaceProcedureWithFunction(factory, proc);
                }
                {if (true) return procCmd;}
    throw new Error("Missing return statement in function");
  }

/*
name=procedure parameter
description=A procedure or function parameter
example={code:sql}OUT x INTEGER{code}
*/
  final public void procedureParameter(MetadataFactory factory, Procedure proc) throws ParseException {
        String name = null;
        ParsedDataType type = null;
        ProcedureParameter.Type ppType = ProcedureParameter.Type.In;
        ProcedureParameter param = null;
        String defaultValue = null;
        boolean notNull = false;
        boolean vararg = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case INOUT:
    case OUT:
    case VARIADIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IN:
        jj_consume_token(IN);
                              ppType = ProcedureParameter.Type.In ;
        break;
      case OUT:
        jj_consume_token(OUT);
                  ppType = ProcedureParameter.Type.Out;
        break;
      case INOUT:
        jj_consume_token(INOUT);
                    ppType = ProcedureParameter.Type.InOut;
        break;
      case VARIADIC:
        jj_consume_token(VARIADIC);
                       ppType = ProcedureParameter.Type.In ; vararg = true;
        break;
      default:
        jj_la1[309] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[310] = jj_gen;
      ;
    }
    name = id(Boolean.TRUE);
    type = parseDataType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                       notNull = true;
      break;
    default:
      jj_la1[311] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RESULT:
      jj_consume_token(RESULT);
            if (ppType != ProcedureParameter.Type.Out) {
                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.param_out, proc.getName(), name));}
            }
            ppType = ProcedureParameter.Type.ReturnValue;
      break;
    default:
      jj_la1[312] = jj_gen;
      ;
    }
                param = factory.addProcedureParameter(name, type.getType(), ppType, proc);
                setTypeInfo(type, param);
                if (notNull) {
                        param.setNullType(Column.NullType.No_Nulls);
                }
                if (vararg) {
                        param.setVarArg(vararg);
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      defaultValue = stringVal();
                                                       param.setDefaultValue(defaultValue);
      break;
    default:
      jj_la1[313] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(param, factory);
              setColumnOptions(param);
      break;
    default:
      jj_la1[314] = jj_gen;
      ;
    }
  }

/*
name=procedure result column
description=A procedure result column.
example={code:sql}x INTEGER{code}
*/
  final public void procedureRsColumn(MetadataFactory factory, Procedure proc) throws ParseException {
        String name = null;
        ParsedDataType type = null;
        boolean notNull = false;
        BaseColumn column = null;
    name = id(Boolean.TRUE);
    type = parseDataType();
                column = addProcColumn(factory, proc, name, type, true);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                         column.setNullType(Column.NullType.No_Nulls);
      break;
    default:
      jj_la1[315] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(column, factory);
              setColumnOptions(column);
      break;
    default:
      jj_la1[316] = jj_gen;
      ;
    }
  }

/*
name=create table
description=Defines a table or view.
example={code:sql}CREATE VIEW vw AS SELECT 1{code}
*/
  final public void createTable(MetadataFactory factory) throws ParseException {
        boolean view = false;
        boolean globalTemp = false;
        String tableName = null;
        Table table = null;
        Token comment = null;
        Command query = null;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOREIGN:
      jj_consume_token(FOREIGN);
      jj_consume_token(TABLE);
      break;
    case VIRTUAL:
    case VIEW:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      default:
        jj_la1[317] = jj_gen;
        ;
      }
      jj_consume_token(VIEW);
                             view = true;
      break;
    case GLOBAL:
      jj_consume_token(GLOBAL);
      jj_consume_token(TEMPORARY);
      jj_consume_token(TABLE);
                                        requiresVersionAtLeast(Version.TEIID_8_5); globalTemp = true; view = true;
      break;
    default:
      jj_la1[318] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tableName = id(null);
            table = factory.addTable(tableName);
            table.setVirtual(view);
            if (globalTemp) {
          table.setTableType(Table.Type.TemporaryTable);
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      createTableBody(table, factory);
      break;
    default:
      jj_la1[320] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIONS:
        optionsClause(table, factory);
              setTableOptions(table);
        break;
      default:
        jj_la1[319] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                comment = getToken(1).specialToken;
      query = queryExpression(ParseInfo.DEFAULT_INSTANCE);
                   if (!view || globalTemp) {
                   {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.view_def, table.getName()));}
                   }
                   table.setSelectTransformation((comment != null?comment.image+" ":"") + query.toString());
      break;
    default:
      jj_la1[321] = jj_gen;
      ;
    }
  }

/*
name=create foreign temp table
description=Defines a foreign temp table
example={code:sql}CREATE FOREIGN TEMPORARY TABLE t (x string) ON z{code}
*/
  final public Create createForeignTempTable(ParseInfo info) throws ParseException {
        Table table = null;
        String tableName = null;
        String model = null;
        MetadataFactory factory = getTempMetadataFactory();
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCAL:
      jj_consume_token(LOCAL);
      break;
    default:
      jj_la1[322] = jj_gen;
      ;
    }
    jj_consume_token(FOREIGN);
    jj_consume_token(TEMPORARY);
    jj_consume_token(TABLE);
    tableName = id(null);
                table = new Table();
                //need to set a dummy/stable uuid
                table.setUUID("tid:0");
                table.setTableType(Table.Type.TemporaryTable);
                table.setName(tableName);
    createTableBody(table, factory);
    jj_consume_token(ON);
    model = id(null);
                Create create = createASTNode(ASTNodes.CREATE);
                create.setTableMetadata(table);
                create.setOn(model);
                {if (true) return create;}
    throw new Error("Missing return statement in function");
  }

/*
name=create table body
description=Defines a table.
example={code:sql}(x string) OPTIONS (CARDINALITY 100){code}
*/
  final public void createTableBody(Table table, MetadataFactory factory) throws ParseException {
        String name = null;
        AbstractMetadataRecord constraint = null;
    jj_consume_token(LPAREN);
    createColumn(factory, table);
    label_47:
    while (true) {
      if (jj_2_54(3)) {
        ;
      } else {
        break label_47;
      }
      jj_consume_token(COMMA);
      createColumn(factory, table);
    }
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[323] = jj_gen;
        break label_48;
      }
      jj_consume_token(COMMA);
             name=null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONSTRAINT:
        jj_consume_token(CONSTRAINT);
        name = id(null);
        break;
      default:
        jj_la1[324] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIMARY:
        constraint = primaryKey(factory, table, name);
        break;
      case UNIQUE:
      case INDEX:
      case ACCESSPATTERN:
        constraint = constraint(factory, table, name, ParseInfo.DEFAULT_INSTANCE);
        break;
      case FOREIGN:
        constraint = foreignKey(factory, table, name);
        break;
      default:
        jj_la1[325] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIONS:
        optionsClause(constraint, factory);
              setCommonProperties(constraint, constraint.getProperties());
        break;
      default:
        jj_la1[326] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(table, factory);
              setTableOptions(table);
      break;
    default:
      jj_la1[327] = jj_gen;
      ;
    }
                if (table.getColumns() != null && !table.supportsUpdate()) {
                        for (Column c : table.getColumns()) {
                                c.setUpdatable(false);
                        }
                }
  }

/*
name=foreign key
description=Defines the foreign key referential constraint.
example={code:sql}FOREIGN KEY (a, b) REFERENCES tbl (x, y){code}
*/
  final public AbstractMetadataRecord foreignKey(MetadataFactory factory, Table table, String name) throws ParseException {
        List<String> columnNames = null;
        String viewName = null;
        Table reference = null;
        KeyRecord pk = null;
        Column column = null;
        List<String> pkColumnNames = null;
        KeyRecord key = null;
    jj_consume_token(FOREIGN);
    jj_consume_token(KEY);
    columnNames = columnList(true, false);
    jj_consume_token(REFERENCES);
    viewName = id(null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      pkColumnNames = columnList(true, false);
      break;
    default:
      jj_la1[328] = jj_gen;
      ;
    }
            {if (true) return factory.addForiegnKey(name != null?name:("FK"+table.getForeignKeys().size()), columnNames, pkColumnNames, viewName, table);}
    throw new Error("Missing return statement in function");
  }

/*
name=primary key
description=Defines the primary key.
example={code:sql}PRIMARY KEY (a, b){code}
*/
  final public AbstractMetadataRecord primaryKey(MetadataFactory factory, Table table, String name) throws ParseException {
        List<String> columnNames = null;
        Column column = null;
        KeyRecord key = null;
    jj_consume_token(PRIMARY);
    jj_consume_token(KEY);
    columnNames = columnList(true, false);
            if (table.getPrimaryKey() != null){
                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.pk_exists, table.getName()));}
                }
                {if (true) return factory.addPrimaryKey(name!=null?name:"PK", columnNames, table);}
    throw new Error("Missing return statement in function");
  }

/*
name=other constraints
description=Defines ACCESSPATTERN and UNIQUE constraints and INDEXes. 
example={code:sql}UNIQUE (a){code}
*/
  final public AbstractMetadataRecord constraint(MetadataFactory factory, Table table, String name, ParseInfo info) throws ParseException {
        KeyRecord keyrecord = null;
        Column column = null;
        List<String> columnNames = null;
        Token type = null;
        KeyRecord key = null;
        List<Expression> expressions = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
    case ACCESSPATTERN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIQUE:
        type = jj_consume_token(UNIQUE);
        break;
      case ACCESSPATTERN:
        type = jj_consume_token(ACCESSPATTERN);
        break;
      default:
        jj_la1[329] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      columnNames = columnList(true, false);
                if (type.image.equalsIgnoreCase("UNIQUE")) {
                {if (true) return factory.addIndex(name != null?name:("UNIQUE"+table.getUniqueKeys().size()), false, columnNames, table);}
        } else if (type.image.equalsIgnoreCase("ACCESSPATTERN")) {
                {if (true) return factory.addAccessPattern(name != null?name:("AP"+table.getAccessPatterns().size()), columnNames, table);}
        }
      break;
    case INDEX:
      type = jj_consume_token(INDEX);
      jj_consume_token(LPAREN);
      expressions = expressionList(info);
      jj_consume_token(RPAREN);
                {if (true) return addFBI(factory, expressions, table, name);}
      break;
    default:
      jj_la1[330] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=column list
description=A list of column names.
example={code:sql}(a, b){code}
*/
  final public List columnList(boolean validate, boolean asElementSymbols) throws ParseException {
        ArrayList list = new ArrayList();
        String id = null;
    jj_consume_token(LPAREN);
    id = id(validate?Boolean.TRUE:null);
                if (asElementSymbols) {
                        list.add(elementSymbol(id));
                } else {
                        list.add(id);
                }
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[331] = jj_gen;
        break label_49;
      }
      jj_consume_token(COMMA);
      id = id(validate?Boolean.TRUE:null);
                if (asElementSymbols) {
                        list.add(elementSymbol(id));
                } else {
                        list.add(id);
                }
    }
    jj_consume_token(RPAREN);
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/*
name=table element
description=Defines a table column.
example={code:sql}x INTEGER NOT NULL{code}
*/
  final public void createColumn(MetadataFactory factory, Table table) throws ParseException {
        String element = null;
        ParsedDataType type = null;
        boolean autoIncrement = false;
        boolean notNull = false;
        String defalt = null;
        Column column = null;
        List<String> columnName = new ArrayList<String>();
        boolean index = false;
        boolean unique = false;
        boolean pk = false;
        Token word = null;
    element = id(Boolean.TRUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SERIAL:
      jj_consume_token(SERIAL);
         requiresVersionAtLeast(Version.TEIID_8_5);
         type = new ParsedDataType("INTEGER");
         autoIncrement = true;
         notNull = true;
      break;
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
      type = parseDataType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
        jj_consume_token(NULL);
                         notNull = true;
        break;
      default:
        jj_la1[332] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTO_INCREMENT:
        jj_consume_token(AUTO_INCREMENT);
                              autoIncrement = true;
        break;
      default:
        jj_la1[333] = jj_gen;
        ;
      }
         column = factory.addColumn(element, type.getType(), table);
         column.setUpdatable(true);
         setTypeInfo(type, column);
         columnName.add(element);
      break;
    default:
      jj_la1[334] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
                             pk = true;
      break;
    default:
      jj_la1[337] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIQUE:
        jj_consume_token(UNIQUE);
                                                          unique = true;
        break;
      default:
        jj_la1[335] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INDEX:
        jj_consume_token(INDEX);
                                                                                        index = true;
        break;
      default:
        jj_la1[336] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      defalt = stringVal();
                                                  column.setDefaultValue(defalt);
      break;
    default:
      jj_la1[338] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(column, factory);
              setColumnOptions(column);
      break;
    default:
      jj_la1[339] = jj_gen;
      ;
    }
            if (index){
                        factory.addIndex("INDEX"+table.getIndexes().size(), true, columnName, table);
                } else if (unique){
                        factory.addIndex("UNIQUE"+table.getIndexes().size(), false, columnName, table);
                } else if (pk) {
                if (table.getPrimaryKey() != null) {
                        {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.pk_exists, table.getName()));}
                }
                        factory.addPrimaryKey("PK", columnName, table);
                }

        if (notNull) {
          column.setNullType(Column.NullType.No_Nulls);
        }
            column.setAutoIncremented(autoIncrement);
  }

/*
name=options clause
description=A list of statement options.
example={code:sql}OPTIONS ('x' 'y', 'a' 'b'){code}
*/
  final public void optionsClause(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
    jj_consume_token(OPTIONS);
    jj_consume_token(LPAREN);
    optionPair(record, factory);
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[340] = jj_gen;
        break label_50;
      }
      jj_consume_token(COMMA);
      optionPair(record, factory);
    }
    jj_consume_token(RPAREN);
  }

/*
name=option pair
description=An option key/value pair.
example={code:sql}'key' 'value'{code}
*/
  final public void optionPair(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
        Constant value = null;
        String key = null;
        Token t = null;
        String strVal = null;
    key = id(null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
    case ESCAPEDTYPE:
    case STRINGVAL:
    case BINARYSTRINGVAL:
      value = nonNumericLiteral();
      break;
    case DECIMALVAL:
    case FLOATVAL:
    case UNSIGNEDINTEGER:
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        strVal = plusMinus();
        break;
      default:
        jj_la1[341] = jj_gen;
        ;
      }
      value = unsignedNumericLiteral(strVal);
      break;
    default:
      jj_la1[342] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                key = resolvePropertyKey(factory, key);
                String val = null;
                if (value.getValue() != null) {
                        val = value.getValue().toString();
                }
                record.setProperty(key, val);
  }

/*
name=alter options
description=alters options of tables/procedure
example={code:sql}ALTER FOREIGN TABLE foo OPTIONS (ADD cardinality 100){code}
*/
  final public void alterStatement(MetadataFactory factory) throws ParseException {
        boolean table = false;
        boolean proc = false;
        boolean func = false;
        String objectName = null;
        AbstractMetadataRecord record = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOREIGN:
    case VIRTUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      case FOREIGN:
        jj_consume_token(FOREIGN);
        break;
      default:
        jj_la1[343] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[344] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      jj_consume_token(TABLE);
                                                  table = true;
      break;
    case VIEW:
      jj_consume_token(VIEW);
                                                                           table = true;
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
                                                                                                         proc=true;
      break;
    default:
      jj_la1[345] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    objectName = id(null);
                if (table){
                        record = factory.getSchema().getTable(objectName);
                        if (record == null){
                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.alter_table_doesnot_exist, objectName));}
                        }
                }
                if (proc){
                        record = factory.getSchema().getProcedure(objectName);
                        if (record == null){
                                {if (true) throw new ParseException(Messages.getString(Messages.TeiidParser.alter_procedure_doesnot_exist, objectName));}
                        }
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      alterOptionsList(record, factory);
      break;
    case ALTER:
      alterColumn(record, factory);
      break;
    default:
      jj_la1[346] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
name=alter options list
description=a list of alterations to options
example={code:sql}OPTIONS (ADD updatable true){code}
*/
  final public void alterOptionsList(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
    jj_consume_token(OPTIONS);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
    case SET:
      addSetOption(record, factory);
      break;
    case DROP:
      dropOption(record);
      break;
    default:
      jj_la1[347] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[348] = jj_gen;
        break label_51;
      }
      jj_consume_token(COMMA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ADD:
      case SET:
        addSetOption(record, factory);
        break;
      case DROP:
        dropOption(record);
        break;
      default:
        jj_la1[349] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
                setOptions(record);
  }

/*
name=drop option
description=drop option
example={code:sql}DROP updatable{code}
*/
  final public void dropOption(AbstractMetadataRecord record) throws ParseException {
        String key = null;
    jj_consume_token(DROP);
    key = id(null);
                removeOption(key, record);
  }

/*
name=add set option
description=add or set an option pair
example={code:sql}ADD updatable true{code}
*/
  final public void addSetOption(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
      jj_consume_token(ADD);
      break;
    case SET:
      jj_consume_token(SET);
      break;
    default:
      jj_la1[350] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    optionPair(record, factory);
  }

/*
name=alter column options
description=alters a set of column options
example={code:sql}ALTER COLUMN bar OPTIONS (ADD updatable true){code}
*/
  final public void alterColumn(AbstractMetadataRecord parent, MetadataFactory factory) throws ParseException {
        boolean param = false;
        String objectName = null;
        AbstractMetadataRecord record = null;
        String key = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLUMN:
    case PARAMETER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLUMN:
        jj_consume_token(COLUMN);
        break;
      case PARAMETER:
        jj_consume_token(PARAMETER);
                                      param=true;
        break;
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[352] = jj_gen;
      ;
    }
    objectName = id(null);
                record = getChild(objectName, parent, param);
    alterOptionsList(record, factory);
  }

  final public AssignmentStatement assignmentStatement(ElementSymbol elementSymbol, LanguageObject value) throws ParseException {
 /*@bgen(jjtree) AssignmentStatement */
  AssignmentStatement jjtn000 = (AssignmentStatement)TeiidNodeFactory.jjtCreate(this, JJTASSIGNMENTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setVariable(elementSymbol);

        if (value instanceof Expression)
            jjtn000.setExpression((Expression) value);
        else if (value instanceof QueryCommand)
            jjtn000.setExpression(scalarSubquery((QueryCommand) value));
        else
            jjtn000.setCommand((Command) value);

        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ScalarSubquery scalarSubquery(QueryCommand queryCommand) throws ParseException {
 /*@bgen(jjtree) ScalarSubquery */
  ScalarSubquery jjtn000 = (ScalarSubquery)TeiidNodeFactory.jjtCreate(this, JJTSCALARSUBQUERY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setCommand(queryCommand);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public GroupSymbol groupSymbol(String... args) throws ParseException {
 /*@bgen(jjtree) GroupSymbol */
  GroupSymbol jjtn000 = (GroupSymbol)TeiidNodeFactory.jjtCreate(this, JJTGROUPSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         * Expectation is that group symbol args should be
         * name then definition (or alias).
         */
        jjtn000.setName(args[0]);
        if (args.length == 2)
            jjtn000.setDefinition(args[1]);

        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Constant constant(Object... args) throws ParseException {
 /*@bgen(jjtree) Constant */
  Constant jjtn000 = (Constant)TeiidNodeFactory.jjtCreate(this, JJTCONSTANT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        if (args == null)
            {if (true) return jjtn000;}

        /*
         * Expectation is that constant args should be
         * value of type Object and type of type Class.
         */
        for (Object arg : args) {
            if (arg instanceof Class) {
                jjtn000.setType((Class) arg);
            } else if (arg instanceof DataTypeManagerService.DefaultDataTypes) {
                DataTypeManagerService.DefaultDataTypes dataType = (DataTypeManagerService.DefaultDataTypes) arg;
                jjtn000.setType(dataType.getTypeClass());
            } else {
                jjtn000.setValue(arg);
            }
        }
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ElementSymbol elementSymbol(String name) throws ParseException {
 /*@bgen(jjtree) ElementSymbol */
  ElementSymbol jjtn000 = (ElementSymbol)TeiidNodeFactory.jjtCreate(this, JJTELEMENTSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(name);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Block block() throws ParseException {
 /*@bgen(jjtree) Block */
  Block jjtn000 = (Block)TeiidNodeFactory.jjtCreate(this, JJTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Block asBlock(Statement stmt) throws ParseException {
  Block b = null;
        if (stmt == null)
            {if (true) return null;}

        if (stmt instanceof Block)
            {if (true) return (Block) stmt;}

        b = block();
        b.addStatement(stmt);
        {if (true) return b;}
    throw new Error("Missing return statement in function");
  }

  final public ExpressionCriteria expressionCriteria(Expression expression) throws ParseException {
 /*@bgen(jjtree) ExpressionCriteria */
  ExpressionCriteria jjtn000 = (ExpressionCriteria)TeiidNodeFactory.jjtCreate(this, JJTEXPRESSIONCRITERIA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setExpression(expression);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AliasSymbol aliasSymbol(String alias, Expression expression) throws ParseException {
 /*@bgen(jjtree) AliasSymbol */
  AliasSymbol jjtn000 = (AliasSymbol)TeiidNodeFactory.jjtCreate(this, JJTALIASSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(alias);
        jjtn000.setSymbol(expression);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AggregateSymbol newAggregateSymbol(String name, boolean isDistinct, Expression[] arguments) throws ParseException {
 /*@bgen(jjtree) AggregateSymbol */
  AggregateSymbol jjtn000 = (AggregateSymbol)TeiidNodeFactory.jjtCreate(this, JJTAGGREGATESYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(name);
        jjtn000.setDistinct(isDistinct);
        jjtn000.setArgs(arguments);
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public WindowFunction windowFunction() throws ParseException {
 /*@bgen(jjtree) WindowFunction */
  WindowFunction jjtn000 = (WindowFunction)TeiidNodeFactory.jjtCreate(this, JJTWINDOWFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public WindowSpecification newWindowSpecification() throws ParseException {
 /*@bgen(jjtree) WindowSpecification */
  WindowSpecification jjtn000 = (WindowSpecification)TeiidNodeFactory.jjtCreate(this, JJTWINDOWSPECIFICATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public TextLine textLine() throws ParseException {
 /*@bgen(jjtree) TextLine */
  TextLine jjtn000 = (TextLine)TeiidNodeFactory.jjtCreate(this, JJTTEXTLINE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AlterTrigger alterTrigger() throws ParseException {
 /*@bgen(jjtree) AlterTrigger */
  AlterTrigger jjtn000 = (AlterTrigger)TeiidNodeFactory.jjtCreate(this, JJTALTERTRIGGER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AlterProcedure alterProcedure() throws ParseException {
 /*@bgen(jjtree) AlterProcedure */
  AlterProcedure jjtn000 = (AlterProcedure)TeiidNodeFactory.jjtCreate(this, JJTALTERPROCEDURE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public AlterView alterView() throws ParseException {
 /*@bgen(jjtree) AlterView */
  AlterView jjtn000 = (AlterView)TeiidNodeFactory.jjtCreate(this, JJTALTERVIEW);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Array array() throws ParseException {
 /*@bgen(jjtree) Array */
  Array jjtn000 = (Array)TeiidNodeFactory.jjtCreate(this, JJTARRAY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return jjtn000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_3_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_392()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_496() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    return false;
  }

  private boolean jj_3R_465() {
    if (jj_3R_63()) return true;
    if (jj_3R_184()) return true;
    if (jj_3R_330()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_496()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_330()) return true;
    xsp = jj_scanpos;
    if (jj_3R_391()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_142()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) return true;
    }
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_466() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_465()) return true;
    return false;
  }

  private boolean jj_3R_495() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(TRIM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_464() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_431()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_495()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_463() {
    if (jj_scan_token(LANGUAGE)) return true;
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(OBJECTTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_463()) jj_scanpos = xsp;
    if (jj_3R_330()) return true;
    xsp = jj_scanpos;
    if (jj_3R_464()) jj_scanpos = xsp;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_465()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_466()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_63()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) return true;
    }
    }
    }
    }
    }
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_407() {
    if (jj_scan_token(FOR)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_scan_token(EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_83()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_407()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_scan_token(SUBSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_83()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_439() {
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_438() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_422() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) {
    jj_scanpos = xsp;
    if (jj_3R_439()) return true;
    }
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_437() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(CAST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_184()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(DECLARE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    }
    return false;
  }

  private boolean jj_3R_421() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_431()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_437()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_420() {
    if (jj_3R_90()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(XMLQUERY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) jj_scanpos = xsp;
    if (jj_3R_330()) return true;
    xsp = jj_scanpos;
    if (jj_3R_421()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_422()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_scan_token(CONVERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_184()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_504() {
    if (jj_scan_token(SELECTOR)) return true;
    if (jj_3R_330()) return true;
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(TRIM)) return true;
    return false;
  }

  private boolean jj_3R_503() {
    if (jj_scan_token(WIDTH)) return true;
    if (jj_3R_349()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_140()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    if (jj_3R_141()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_141()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_384()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_488() {
    if (jj_3R_184()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_503()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_504()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(LOOP)) return true;
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_487() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(ORDINALITY)) return true;
    return false;
  }

  private boolean jj_3R_452() {
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_487()) {
    jj_scanpos = xsp;
    if (jj_3R_488()) return true;
    }
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_83()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_83()) return true;
    Token xsp;
    if (jj_3R_385()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_385()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_386()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_260()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_458() {
    if (jj_scan_token(SKIP_KEYWORD)) return true;
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_491() {
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_457() {
    if (jj_scan_token(HEADER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_491()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(LEAVE)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_490() {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_290()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_489() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_456() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_489()) {
    jj_scanpos = xsp;
    if (jj_3R_490()) return true;
    }
    return false;
  }

  private boolean jj_3R_427() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) return true;
    }
    return false;
  }

  private boolean jj_3R_426() {
    if (jj_scan_token(PARTITION)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_455() {
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3R_454() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(ROW)) return true;
    if (jj_scan_token(DELIMITER)) return true;
    return false;
  }

  private boolean jj_3R_403() {
    if (jj_scan_token(OVER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_426()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_427()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_453() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_452()) return true;
    return false;
  }

  private boolean jj_3R_451() {
    if (jj_scan_token(SELECTOR)) return true;
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_scan_token(EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(TEXTTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_119()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_451()) jj_scanpos = xsp;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_452()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_453()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_456()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_457()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_458()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) jj_scanpos = xsp;
    if (jj_scan_token(ATOMIC)) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3_37() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(BEGIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_8()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_157()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_3R_425()) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_353()) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_336() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) return true;
    }
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_434() {
    if (jj_scan_token(CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_436() {
    if (jj_scan_token(EXCLUDING)) return true;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_scan_token(ESCAPEDFUNCTION)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(ARRAYTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_219()) return true;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_459()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_3R_350()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) return true;
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_316() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_63()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_102() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) return true;
    }
    return false;
  }

  private boolean jj_3R_433() {
    if (jj_scan_token(DOCUMENT)) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_scan_token(AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_435() {
    if (jj_scan_token(INCLUDING)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_419() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) {
    jj_scanpos = xsp;
    if (jj_3R_436()) return true;
    }
    if (jj_scan_token(XMLDECLARATION)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_418() {
    if (jj_scan_token(VERSION)) return true;
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_3R_425()) return true;
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_scan_token(ENCODING)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_415() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_433()) {
    jj_scanpos = xsp;
    if (jj_3R_434()) return true;
    }
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_scan_token(XMLSERIALIZE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_415()) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    xsp = jj_scanpos;
    if (jj_3R_416()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_417()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_418()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_419()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    }
    return false;
  }

  private boolean jj_3R_404() {
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3R_383() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_430() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_3R_83()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_34()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_405() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_429()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) return true;
    }
    return false;
  }

  private boolean jj_3R_429() {
    if (jj_scan_token(MAKEDEP)) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_382()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_383()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_212()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_293()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_292()) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_scan_token(SQLEXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_239() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_405()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_82()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_404()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_81()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_402()) jj_scanpos = xsp;
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_400()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_401()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_319()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) return true;
    }
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_350() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) return true;
    }
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(RIGHT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_170() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(FULL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(OPTIONS)) return true;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_scan_token(SQLWARNING)) return true;
    return false;
  }

  private boolean jj_3R_114() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_171()) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_scan_token(RAISE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_428() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_3R_172()) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_148() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) return true;
    }
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_scan_token(CROSS)) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_3R_314()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_3R_316()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_428()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_249() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    }
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) return true;
    }
    }
    if (jj_3R_63()) return true;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    return false;
  }

  private boolean jj_3R_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_scan_token(ERROR)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_387() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(400)) return true;
    }
    return false;
  }

  private boolean jj_3_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_3R_239()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_3R_387()) return true;
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(ESCAPEDJOIN)) return true;
    if (jj_3R_212()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_219()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_378()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_171() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_171()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(401)) {
    jj_scanpos = xsp;
    if (jj_scan_token(402)) return true;
    }
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_3R_314()) return true;
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_171()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_363()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(LOCAL)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) jj_scanpos = xsp;
    if (jj_scan_token(TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_201()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_369()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_425() {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(SERIAL)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_scan_token(DROP)) return true;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_scan_token(CONCAT_OP)) return true;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_172()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_355()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_502() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_483() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_502()) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_483()) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_294()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) return true;
    }
    return false;
  }

  private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_329()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_scan_token(NOCACHE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_306()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_445() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_305()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_444() {
    if (jj_scan_token(ENCODING)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(MAKEDEP)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_304()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_443() {
    if (jj_scan_token(HEADER)) return true;
    return false;
  }

  private boolean jj_3R_442() {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3R_441() {
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(OPTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_440() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(TRIGGER)) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_scan_token(TEXTAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(99)) jj_scanpos = xsp;
    if (jj_3R_431()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_440()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_441()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_443()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_444()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_445()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_328()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) return true;
    }
    if (jj_scan_token(ONLY)) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_446() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(367)) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_83()) return true;
    xsp = jj_scanpos;
    if (jj_3R_446()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_scan_token(OFFSET)) return true;
    if (jj_3R_300()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_302()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(LIMIT)) return true;
    if (jj_3R_300()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_244() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_scan_token(ALL_IN_GROUP)) return true;
    return false;
  }

  private boolean jj_3_54() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_scan_token(LAST)) return true;
    return false;
  }

  private boolean jj_3R_478() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_3R_316()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(TRIGGER)) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_300() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) return true;
    }
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_431() {
    if (jj_3R_83()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(136)) jj_scanpos = xsp;
    if (jj_scan_token(FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_388() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_3R_83()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_scan_token(DESC)) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_3R_381()) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_scan_token(NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) return true;
    }
    return false;
  }

  private boolean jj_3R_298() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_3R_323()) return true;
    }
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_3R_297()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_299()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_361() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) return true;
    }
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_scan_token(GLOBAL)) return true;
    if (jj_scan_token(TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(225)) jj_scanpos = xsp;
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(FOREIGN)) return true;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) return true;
    }
    }
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(370)) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_361()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_272()) return true;
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_3R_361()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_362()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_272()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_273()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_167() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(297)) {
    jj_scanpos = xsp;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(300)) {
    jj_scanpos = xsp;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(326)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(334)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) {
    jj_scanpos = xsp;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(357)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(359)) {
    jj_scanpos = xsp;
    if (jj_scan_token(360)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) {
    jj_scanpos = xsp;
    if (jj_scan_token(363)) {
    jj_scanpos = xsp;
    if (jj_scan_token(365)) {
    jj_scanpos = xsp;
    if (jj_scan_token(364)) {
    jj_scanpos = xsp;
    if (jj_scan_token(366)) {
    jj_scanpos = xsp;
    if (jj_scan_token(367)) {
    jj_scanpos = xsp;
    if (jj_scan_token(368)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_341() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_3R_360()) return true;
    }
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_scan_token(SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_341()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) return true;
    }
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_scan_token(HAVING)) return true;
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_scan_token(STRINGVAL)) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_scan_token(INTO)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_scan_token(BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) return true;
    }
    return false;
  }

  private boolean jj_3R_376() {
    if (jj_scan_token(ROLLUP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_246()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(FUNCTION)) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_345()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_3R_366()) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_3R_365()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_3R_344()) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_320()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_189()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(TABLE)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_486() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_246()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_146()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_3R_147()) return true;
    }
    if (jj_3R_63()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_449() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_119()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_486()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_448() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(VALUES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_246()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_295()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_370() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3R_449()) return true;
    }
    return false;
  }

  private boolean jj_3R_238() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(NAMESPACE)) return true;
    return false;
  }

  private boolean jj_3R_450() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_270() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3_53() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(INTERSECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_270()) jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3_51() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_49() {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_238()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_241()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_scan_token(OPTION)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_119()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_scan_token(DECIMALVAL)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3_16() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind != JOIN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_242()) jj_scanpos = xsp;
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_scan_token(FLOATVAL)) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_244()) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_3R_211()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_16()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_214()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_215()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_482() {
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_scan_token(UNSIGNEDINTEGER)) return true;
    return false;
  }

  private boolean jj_3R_315() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_240()) jj_scanpos = xsp;
    if (jj_scan_token(AS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_160()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    if (jj_scan_token(LIKE_REGEX)) return true;
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_485() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_482()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_scan_token(SIMILAR)) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_484() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_447() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_484()) {
    jj_scanpos = xsp;
    if (jj_3R_485()) return true;
    }
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_3R_121()) return true;
    }
    if (jj_3R_119()) return true;
    xsp = jj_scanpos;
    if (jj_3R_447()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_210()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_scan_token(BINARYSTRINGVAL)) return true;
    return false;
  }

  private boolean jj_3R_160() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(ESCAPEDTYPE)) return true;
    if (jj_3R_330()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_scan_token(UNKNOWN)) return true;
    return false;
  }

  private boolean jj_3R_281() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_497() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_498() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_3R_76()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    }
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_392() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_477() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_476() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_474() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_475() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_472() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_497()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_473() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_498()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_471() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_3R_203()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_406()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_470() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_469() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_468() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(VARBINARY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(CLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_scan_token(BLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_475()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_scan_token(OBJECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_scan_token(DECIMAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_scan_token(BIGDECIMAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(BIGINTEGER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_471()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_3R_83()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_277()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(CHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_470()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_scan_token(VARCHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(STRING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_468()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_3R_76()) return true;
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_15() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(MERGE)) return true;
    return false;
  }

  private boolean jj_3R_501() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_76()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    }
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_500() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(392)) {
    jj_scanpos = xsp;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(394)) {
    jj_scanpos = xsp;
    if (jj_scan_token(395)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(398)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_162() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_3R_190()) return true;
    }
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_3R_373()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_3R_370()) return true;
    return false;
  }

  private boolean jj_3R_499() {
    if (jj_3R_330()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_479() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) {
    jj_scanpos = xsp;
    if (jj_3R_500()) {
    jj_scanpos = xsp;
    if (jj_3R_501()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_63()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(397)) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_340() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_3R_119()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_480() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_479()) return true;
    return false;
  }

  private boolean jj_3R_251() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(XMLNAMESPACES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_479()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_480()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_3R_63()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(397)) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_245()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_3R_90()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_220() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_250()) jj_scanpos = xsp;
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(XMLFOREST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_413()) jj_scanpos = xsp;
    if (jj_3R_414()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_199() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_217()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_432() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_3R_431()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_432()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_220()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_252()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_161() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    if (jj_3R_63()) return true;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_200()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(JSONOBJECT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_414()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_3R_202()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_221()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_481() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(XMLATTRIBUTES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_431()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_481()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_467() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3_47() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(XMLELEMENT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(351)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_412()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_467()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_63()) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_459() {
    if (jj_3R_63()) return true;
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(QUERYSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_83()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_408()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_scan_token(CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_115() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) return true;
    }
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) jj_scanpos = xsp;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_424() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_scan_token(WELLFORMED)) return true;
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_scan_token(DOCUMENT)) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_scan_token(XMLPARSE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_409()) {
    jj_scanpos = xsp;
    if (jj_3R_410()) return true;
    }
    if (jj_3R_83()) return true;
    xsp = jj_scanpos;
    if (jj_3R_411()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(UNSIGNEDINTEGER)) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_3R_425()) return true;
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_396() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) {
    jj_scanpos = xsp;
    if (jj_3R_424()) return true;
    }
    return false;
  }

  private boolean jj_3R_423() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_508() {
    if (jj_scan_token(PATH)) return true;
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_507() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_46() {
    if (jj_scan_token(JSONOBJECT)) return true;
    return false;
  }

  private boolean jj_3R_506() {
    if (jj_3R_184()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_507()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_508()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_63()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_396()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_397()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_398()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_399()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_505() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(ORDINALITY)) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_493() {
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_505()) {
    jj_scanpos = xsp;
    if (jj_3R_506()) return true;
    }
    return false;
  }

  private boolean jj_3R_318() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) return true;
    }
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_scan_token(XMLPI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(351)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    xsp = jj_scanpos;
    if (jj_3R_395()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_318()) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_175()) return true;
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_3R_89()) return true;
    }
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_494() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_493()) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_462() {
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_493()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_494()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_394()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_492() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(225)) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(267)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_393()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_461() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_431()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_492()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_44() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_460() {
    if (jj_3R_90()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(XMLTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_460()) jj_scanpos = xsp;
    if (jj_3R_330()) return true;
    xsp = jj_scanpos;
    if (jj_3R_461()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_462()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(225)) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public Teiid8ParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[353];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
      jj_la1_init_7();
      jj_la1_init_8();
      jj_la1_init_9();
      jj_la1_init_10();
      jj_la1_init_11();
      jj_la1_init_12();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0xfffffe00,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000e00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x20000,0x20000,0x0,0x20000,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x208040,0x0,0x208040,0x0,0x0,0x0,0x800,0x0,0x2000,0x288040,0x288040,0x200000,0x8040,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x288040,0x288040,0x288040,0x0,0x2000,0x288040,0x0,0x80000,0x0,0x80000,0x100050c,0x0,0x3,0x0,0x0,0x0,0x120050c,0x100050c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x100050c,0x0,0x0,0x200000,0x100050c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x100050c,0x100050c,0x800,0x800,0x800,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x20,0x20,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x800,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x3,0x0,0x0,0x200000,0x800,0x800,0x800,0x0,0x80,0x0,0x0,0x0,0x10000,0x100050c,0x0,0x200000,0x120,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100050c,0x0,0x1000,0x1000,0x0,0x0,0x100050c,0x0,0x0,0x0,0x0,0x0,0x100050c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100050c,0x100050c,0x0,0x500,0x0,0x0,0x0,0x0,0x100050c,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x100050c,0x104050c,0x0,0x0,0x0,0x0,0x100050c,0x0,0x100050c,0x0,0x0,0x20,0x20,0x100050c,0x0,0x0,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x10,0x0,0x10,0x10,0x20000000,0x20000000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x30208080,0x0,0x30208080,0x0,0x8000,0x8000,0x0,0x0,0x0,0x3220c082,0x3220c082,0x30208000,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3220c082,0x3220c082,0x3220c082,0x0,0x0,0x3220c082,0x0,0x2,0x0,0x2,0x80000000,0x800000,0x0,0x0,0x0,0x0,0xb0008000,0x80008000,0x30000000,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x30000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x100000,0x100000,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x30000000,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x10000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x800,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x100000,0x100000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x2000000,0x0,0x2000008,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x2010000,0x2010000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2010000,0x2010000,0x2000000,0x0,0x0,0x2010000,0x0,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x0,0x0,0x2008001,0x2008001,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x4000000,0x0,0x0,0x0,0x0,0x10000000,0x0,0x800,0x2000,0x20,0x0,0x0,0x0,0x2008001,0x2008001,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80200040,0x0,0x0,0x0,0x0,0x200040,0x200040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20080000,0x0,0x20080000,0x2008001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2008001,0x0,0x0,0x0,0x0,0x0,0x2008000,0x0,0x0,0x2,0x2,0x0,0x2008000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2008000,0x2008001,0x0,0x0,0x4,0x0,0x4,0x0,0x2008001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x20,0x8000,0x0,0x2008001,0x2008001,0x0,0x0,0x0,0x8000,0x2008001,0x2000000,0x2008001,0x0,0x0,0x0,0x0,0x2008001,0x0,0x4,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x10,0x10,0x80,0x0,0x880000,0x0,0x0,0x0,0x0,0x0,0x0,0x880000,0x880000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x210,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x2210,0x2210,0x2000,0x0,0x100,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x2010,0x2010,0x2010,0x1000000,0x1000000,0x2210,0x0,0x0,0x0,0x10,0x3048001,0x0,0x0,0x0,0x0,0x0,0x304a001,0x3048001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3048001,0x3048001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0xc00,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x1000060,0x2048001,0x0,0x0,0x0,0x1000000,0x20,0x0,0x0,0x1000000,0x1000000,0x1000000,0x1000000,0x0,0x0,0x3048001,0x0,0x0,0x0,0x0,0x0,0x48001,0x0,0x0,0x0,0x8000080,0x0,0x48001,0x0,0x200c00,0x0,0x0,0x0,0x0,0x200c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48001,0x2048001,0x0,0x0,0x0,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48000,0x8,0x3048001,0x3048009,0x0,0x0,0x0,0x48001,0x3048001,0x0,0x3048001,0x0,0x0,0x0,0x0,0x3048001,0x0,0x0,0x0,0x48001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x80800000,0x0,0x0,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80800000,0x0,0x1,0x0,0x80800000,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x20,0x20,0x20,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82800000,0x0,0x0,0x0,0x0,0x0,0x80800000,0x0,0xc000000,0x0,0x0,0x0,0x80800000,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x80,0x0,0x80,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80800000,0x80800000,0x0,0x0,0x0,0x80800000,0x80800000,0x0,0x80800000,0x0,0x0,0x0,0x0,0x80800000,0x8,0x0,0x0,0x80800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x10,0x0,0x0,0x0,0x200000,0x2,0x0,0x10,0x10,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2000,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x4000,0x2,0x0,0x0,0x0,0x0,0x200,0x200,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x20008001,0x0,0x20008001,0x0,0x20000000,0x20000000,0x0,0x800000,0x0,0x20008001,0x20008001,0x20008001,0x0,0x0,0x0,0x0,0x0,0x400,0x100,0x0,0x200,0x0,0x0,0x0,0x20008001,0x20008001,0x20008001,0x0,0x0,0x20008001,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x39408141,0x39408141,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x20000000,0x0,0x0,0x19400040,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x19400040,0x19400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x40,0x0,0x0,0x8000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x8001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x19400040,0x0,0x8001,0x40,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x10400040,0x0,0x0,0x0,0x0,0x0,0x10400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10400040,0x19400040,0x0,0x40,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x19400040,0x19600040,0x0,0x0,0x0,0x10000000,0x19400040,0x400000,0x19400040,0x0,0x0,0x0,0x0,0x19400040,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9000000,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x9000000,0x0,0x0,0x8000,0x0,0x8,0x0,0x8,0x8,0x0,0x0,};
   }
   private static void jj_la1_init_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x21,0x0,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x61,0x61,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x21,0x21,0x21,0x0,0x0,0x61,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x220,0x220,0x421,0x421,0x0,0x220,0x220,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x400,0x0,0x400,0x400,0x0,0x0,0x0,0x400,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x40,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3cac40,0x3cac40,0x0,0x0,0x0,0xc00,0x3cac40,0x0,0x3cac40,0x0,0x0,0x0,0x0,0x3cac40,0x0,0x0,0x0,0xc00,0xca000,0x300000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_9() {
      jj_la1_9 = new int[] {0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x180,0x200,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fe2000,0x0,0x0,0x3fe2000,0x1c000,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0xc000000,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0x3fe3000,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xffffffc0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0xc000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_10() {
      jj_la1_10 = new int[] {0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x20000000,0x8000000,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x3,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x5,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x60,0x0,0x180,0x0,0xffffffff,0x0,0xffffffff,0x80000000,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x8000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000,0x0,0x0,0x0,0x2000,0x3000,0x0,0x0,0x4000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_11() {
      jj_la1_11 = new int[] {0x1ffff,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x4000,0x5ffff,0x0,0x5ffff,0x5ffff,0x2000,0x0,0x0,0x5ffff,0x1000,0x0,0x5ffff,0x0,0x67a5ffff,0x0,0x1000,0x0,0x0,0x0,0x67a5ffff,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67a7ffff,0x67a7ffff,0x0,0x5ffff,0x0,0x8000,0x0,0x0,0x0,0x4,0x8,0x10,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x45ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x80,0x300,0x300,0x0,0x0,0x0,0x0,0x4,0x8,0x8,0x20000000,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x20,0x2025ffff,0x0,0x0,0x0,0x0,0x0,0x2025ffff,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2325ffff,0x67a5ffff,0x0,0x8000,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x5ffff,0x200000,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67a5ffff,0x67a5ffff,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x67a5ffff,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44800000,0x23000000,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x67800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_12() {
      jj_la1_12 = new int[] {0x0,0x0,0x14,0x200000,0x4,0x200000,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x1e0004,0x0,0x0,0x100,0x0,0x0,0x1e0004,0x1e0004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x1,0x80000,0x1e0004,0x4,0x0,0x0,0x1e0004,0x0,0x2000,0x1,0x2000,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1e8004,0x1e0004,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f00,0x7f00,0x1e0004,0x7f00,0x4,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x1,0x4,0x1e0004,0x1,0x0,0x0,0x0,0x0,0x180004,0x1,0x0,0x0,0x0,0x0,0x180004,0x0,0x0,0x1,0x1,0x1,0x0,0x0,0x800000,0x60000,0x60000,0x18000,0x18000,0x60000,0x40,0x180004,0x1e0004,0x180000,0x0,0x0,0x0,0x0,0x0,0x1e0004,0x1,0x0,0x180000,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1e0004,0x1e0004,0x0,0x1,0x0,0x0,0x1e0004,0x0,0x1e0004,0x0,0x1,0x0,0x0,0x1e0004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x1,0x1,0x0,0x1,0x0,0x4,0x4,0x4,0x4,0x1,0x4,0x1,0x4,0x4,0x4,0x4,0x4,0x0,0x40,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x60000,0x60000,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[54];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Teiid8Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Teiid8Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new Teiid8ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 353; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 353; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Teiid8Parser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new Teiid8ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 353; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 353; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Teiid8Parser(Teiid8ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 353; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(Teiid8ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 353; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[408];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 353; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 408; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 54; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
