/**
 * <copyright>
 * 
 * Copyright (c) 2010 SAP AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Reiner Hille-Doering (SAP AG) - initial API and implementation and/or initial documentation
 * 
 * </copyright>
 *
 */
package org.eclipse.bpmn2.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.bpmn2.util.Bpmn2AdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class Bpmn2ItemProviderAdapterFactory extends Bpmn2AdapterFactory implements
        ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Bpmn2ItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DocumentRoot} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DocumentRootItemProvider documentRootItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DocumentRoot}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDocumentRootAdapter() {
        if (documentRootItemProvider == null) {
            documentRootItemProvider = new DocumentRootItemProvider(this);
        }

        return documentRootItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Activity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ActivityItemProvider activityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Activity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createActivityAdapter() {
        if (activityItemProvider == null) {
            activityItemProvider = new ActivityItemProvider(this);
        }

        return activityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.AdHocSubProcess} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AdHocSubProcessItemProvider adHocSubProcessItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.AdHocSubProcess}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAdHocSubProcessAdapter() {
        if (adHocSubProcessItemProvider == null) {
            adHocSubProcessItemProvider = new AdHocSubProcessItemProvider(this);
        }

        return adHocSubProcessItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Artifact} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ArtifactItemProvider artifactItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Artifact}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createArtifactAdapter() {
        if (artifactItemProvider == null) {
            artifactItemProvider = new ArtifactItemProvider(this);
        }

        return artifactItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Assignment} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AssignmentItemProvider assignmentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Assignment}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAssignmentAdapter() {
        if (assignmentItemProvider == null) {
            assignmentItemProvider = new AssignmentItemProvider(this);
        }

        return assignmentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Association} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AssociationItemProvider associationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Association}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAssociationAdapter() {
        if (associationItemProvider == null) {
            associationItemProvider = new AssociationItemProvider(this);
        }

        return associationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Auditing} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AuditingItemProvider auditingItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Auditing}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAuditingAdapter() {
        if (auditingItemProvider == null) {
            auditingItemProvider = new AuditingItemProvider(this);
        }

        return auditingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.BaseElement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BaseElementItemProvider baseElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.BaseElement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBaseElementAdapter() {
        if (baseElementItemProvider == null) {
            baseElementItemProvider = new BaseElementItemProvider(this);
        }

        return baseElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.BoundaryEvent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BoundaryEventItemProvider boundaryEventItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.BoundaryEvent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBoundaryEventAdapter() {
        if (boundaryEventItemProvider == null) {
            boundaryEventItemProvider = new BoundaryEventItemProvider(this);
        }

        return boundaryEventItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.BusinessRuleTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BusinessRuleTaskItemProvider businessRuleTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.BusinessRuleTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBusinessRuleTaskAdapter() {
        if (businessRuleTaskItemProvider == null) {
            businessRuleTaskItemProvider = new BusinessRuleTaskItemProvider(this);
        }

        return businessRuleTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CallActivity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CallActivityItemProvider callActivityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CallActivity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCallActivityAdapter() {
        if (callActivityItemProvider == null) {
            callActivityItemProvider = new CallActivityItemProvider(this);
        }

        return callActivityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CallChoreography} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CallChoreographyItemProvider callChoreographyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CallChoreography}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCallChoreographyAdapter() {
        if (callChoreographyItemProvider == null) {
            callChoreographyItemProvider = new CallChoreographyItemProvider(this);
        }

        return callChoreographyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CallConversation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CallConversationItemProvider callConversationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CallConversation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCallConversationAdapter() {
        if (callConversationItemProvider == null) {
            callConversationItemProvider = new CallConversationItemProvider(this);
        }

        return callConversationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CallableElement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CallableElementItemProvider callableElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CallableElement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCallableElementAdapter() {
        if (callableElementItemProvider == null) {
            callableElementItemProvider = new CallableElementItemProvider(this);
        }

        return callableElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CancelEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CancelEventDefinitionItemProvider cancelEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CancelEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCancelEventDefinitionAdapter() {
        if (cancelEventDefinitionItemProvider == null) {
            cancelEventDefinitionItemProvider = new CancelEventDefinitionItemProvider(this);
        }

        return cancelEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Category} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CategoryItemProvider categoryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Category}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCategoryAdapter() {
        if (categoryItemProvider == null) {
            categoryItemProvider = new CategoryItemProvider(this);
        }

        return categoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CategoryValue} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CategoryValueItemProvider categoryValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CategoryValue}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCategoryValueAdapter() {
        if (categoryValueItemProvider == null) {
            categoryValueItemProvider = new CategoryValueItemProvider(this);
        }

        return categoryValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Choreography} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChoreographyItemProvider choreographyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Choreography}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createChoreographyAdapter() {
        if (choreographyItemProvider == null) {
            choreographyItemProvider = new ChoreographyItemProvider(this);
        }

        return choreographyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ChoreographyTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChoreographyTaskItemProvider choreographyTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ChoreographyTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createChoreographyTaskAdapter() {
        if (choreographyTaskItemProvider == null) {
            choreographyTaskItemProvider = new ChoreographyTaskItemProvider(this);
        }

        return choreographyTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Collaboration} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CollaborationItemProvider collaborationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Collaboration}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCollaborationAdapter() {
        if (collaborationItemProvider == null) {
            collaborationItemProvider = new CollaborationItemProvider(this);
        }

        return collaborationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CompensateEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CompensateEventDefinitionItemProvider compensateEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CompensateEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCompensateEventDefinitionAdapter() {
        if (compensateEventDefinitionItemProvider == null) {
            compensateEventDefinitionItemProvider = new CompensateEventDefinitionItemProvider(this);
        }

        return compensateEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ComplexBehaviorDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComplexBehaviorDefinitionItemProvider complexBehaviorDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ComplexBehaviorDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createComplexBehaviorDefinitionAdapter() {
        if (complexBehaviorDefinitionItemProvider == null) {
            complexBehaviorDefinitionItemProvider = new ComplexBehaviorDefinitionItemProvider(this);
        }

        return complexBehaviorDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ComplexGateway} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComplexGatewayItemProvider complexGatewayItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ComplexGateway}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createComplexGatewayAdapter() {
        if (complexGatewayItemProvider == null) {
            complexGatewayItemProvider = new ComplexGatewayItemProvider(this);
        }

        return complexGatewayItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ConditionalEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConditionalEventDefinitionItemProvider conditionalEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ConditionalEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConditionalEventDefinitionAdapter() {
        if (conditionalEventDefinitionItemProvider == null) {
            conditionalEventDefinitionItemProvider = new ConditionalEventDefinitionItemProvider(
                    this);
        }

        return conditionalEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Conversation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConversationItemProvider conversationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Conversation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConversationAdapter() {
        if (conversationItemProvider == null) {
            conversationItemProvider = new ConversationItemProvider(this);
        }

        return conversationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ConversationAssociation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConversationAssociationItemProvider conversationAssociationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ConversationAssociation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConversationAssociationAdapter() {
        if (conversationAssociationItemProvider == null) {
            conversationAssociationItemProvider = new ConversationAssociationItemProvider(this);
        }

        return conversationAssociationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ConversationLink} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConversationLinkItemProvider conversationLinkItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ConversationLink}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConversationLinkAdapter() {
        if (conversationLinkItemProvider == null) {
            conversationLinkItemProvider = new ConversationLinkItemProvider(this);
        }

        return conversationLinkItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ConversationNode} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConversationNodeItemProvider conversationNodeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ConversationNode}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConversationNodeAdapter() {
        if (conversationNodeItemProvider == null) {
            conversationNodeItemProvider = new ConversationNodeItemProvider(this);
        }

        return conversationNodeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CorrelationKey} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CorrelationKeyItemProvider correlationKeyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CorrelationKey}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCorrelationKeyAdapter() {
        if (correlationKeyItemProvider == null) {
            correlationKeyItemProvider = new CorrelationKeyItemProvider(this);
        }

        return correlationKeyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CorrelationProperty} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CorrelationPropertyItemProvider correlationPropertyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CorrelationProperty}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCorrelationPropertyAdapter() {
        if (correlationPropertyItemProvider == null) {
            correlationPropertyItemProvider = new CorrelationPropertyItemProvider(this);
        }

        return correlationPropertyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CorrelationPropertyBinding} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CorrelationPropertyBindingItemProvider correlationPropertyBindingItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CorrelationPropertyBinding}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCorrelationPropertyBindingAdapter() {
        if (correlationPropertyBindingItemProvider == null) {
            correlationPropertyBindingItemProvider = new CorrelationPropertyBindingItemProvider(
                    this);
        }

        return correlationPropertyBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CorrelationPropertyRetrievalExpression} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CorrelationPropertyRetrievalExpressionItemProvider correlationPropertyRetrievalExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CorrelationPropertyRetrievalExpression}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCorrelationPropertyRetrievalExpressionAdapter() {
        if (correlationPropertyRetrievalExpressionItemProvider == null) {
            correlationPropertyRetrievalExpressionItemProvider = new CorrelationPropertyRetrievalExpressionItemProvider(
                    this);
        }

        return correlationPropertyRetrievalExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.CorrelationSubscription} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CorrelationSubscriptionItemProvider correlationSubscriptionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.CorrelationSubscription}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCorrelationSubscriptionAdapter() {
        if (correlationSubscriptionItemProvider == null) {
            correlationSubscriptionItemProvider = new CorrelationSubscriptionItemProvider(this);
        }

        return correlationSubscriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataAssociation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataAssociationItemProvider dataAssociationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataAssociation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataAssociationAdapter() {
        if (dataAssociationItemProvider == null) {
            dataAssociationItemProvider = new DataAssociationItemProvider(this);
        }

        return dataAssociationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataInput} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataInputItemProvider dataInputItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataInput}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataInputAdapter() {
        if (dataInputItemProvider == null) {
            dataInputItemProvider = new DataInputItemProvider(this);
        }

        return dataInputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataInputAssociation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataInputAssociationItemProvider dataInputAssociationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataInputAssociation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataInputAssociationAdapter() {
        if (dataInputAssociationItemProvider == null) {
            dataInputAssociationItemProvider = new DataInputAssociationItemProvider(this);
        }

        return dataInputAssociationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataObject} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataObjectItemProvider dataObjectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataObject}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataObjectAdapter() {
        if (dataObjectItemProvider == null) {
            dataObjectItemProvider = new DataObjectItemProvider(this);
        }

        return dataObjectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataObjectReference} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataObjectReferenceItemProvider dataObjectReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataObjectReference}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataObjectReferenceAdapter() {
        if (dataObjectReferenceItemProvider == null) {
            dataObjectReferenceItemProvider = new DataObjectReferenceItemProvider(this);
        }

        return dataObjectReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataOutput} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataOutputItemProvider dataOutputItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataOutput}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataOutputAdapter() {
        if (dataOutputItemProvider == null) {
            dataOutputItemProvider = new DataOutputItemProvider(this);
        }

        return dataOutputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataOutputAssociation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataOutputAssociationItemProvider dataOutputAssociationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataOutputAssociation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataOutputAssociationAdapter() {
        if (dataOutputAssociationItemProvider == null) {
            dataOutputAssociationItemProvider = new DataOutputAssociationItemProvider(this);
        }

        return dataOutputAssociationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataState} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataStateItemProvider dataStateItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataState}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataStateAdapter() {
        if (dataStateItemProvider == null) {
            dataStateItemProvider = new DataStateItemProvider(this);
        }

        return dataStateItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataStore} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataStoreItemProvider dataStoreItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataStore}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataStoreAdapter() {
        if (dataStoreItemProvider == null) {
            dataStoreItemProvider = new DataStoreItemProvider(this);
        }

        return dataStoreItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.DataStoreReference} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataStoreReferenceItemProvider dataStoreReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.DataStoreReference}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataStoreReferenceAdapter() {
        if (dataStoreReferenceItemProvider == null) {
            dataStoreReferenceItemProvider = new DataStoreReferenceItemProvider(this);
        }

        return dataStoreReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Definitions} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DefinitionsItemProvider definitionsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Definitions}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDefinitionsAdapter() {
        if (definitionsItemProvider == null) {
            definitionsItemProvider = new DefinitionsItemProvider(this);
        }

        return definitionsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Documentation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DocumentationItemProvider documentationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Documentation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDocumentationAdapter() {
        if (documentationItemProvider == null) {
            documentationItemProvider = new DocumentationItemProvider(this);
        }

        return documentationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.EndEvent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EndEventItemProvider endEventItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.EndEvent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEndEventAdapter() {
        if (endEventItemProvider == null) {
            endEventItemProvider = new EndEventItemProvider(this);
        }

        return endEventItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.EndPoint} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EndPointItemProvider endPointItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.EndPoint}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEndPointAdapter() {
        if (endPointItemProvider == null) {
            endPointItemProvider = new EndPointItemProvider(this);
        }

        return endPointItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Error} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ErrorItemProvider errorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Error}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createErrorAdapter() {
        if (errorItemProvider == null) {
            errorItemProvider = new ErrorItemProvider(this);
        }

        return errorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ErrorEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ErrorEventDefinitionItemProvider errorEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ErrorEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createErrorEventDefinitionAdapter() {
        if (errorEventDefinitionItemProvider == null) {
            errorEventDefinitionItemProvider = new ErrorEventDefinitionItemProvider(this);
        }

        return errorEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Escalation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EscalationItemProvider escalationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Escalation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEscalationAdapter() {
        if (escalationItemProvider == null) {
            escalationItemProvider = new EscalationItemProvider(this);
        }

        return escalationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.EscalationEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EscalationEventDefinitionItemProvider escalationEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.EscalationEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEscalationEventDefinitionAdapter() {
        if (escalationEventDefinitionItemProvider == null) {
            escalationEventDefinitionItemProvider = new EscalationEventDefinitionItemProvider(this);
        }

        return escalationEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.EventBasedGateway} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventBasedGatewayItemProvider eventBasedGatewayItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.EventBasedGateway}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventBasedGatewayAdapter() {
        if (eventBasedGatewayItemProvider == null) {
            eventBasedGatewayItemProvider = new EventBasedGatewayItemProvider(this);
        }

        return eventBasedGatewayItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.EventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventDefinitionItemProvider eventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.EventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventDefinitionAdapter() {
        if (eventDefinitionItemProvider == null) {
            eventDefinitionItemProvider = new EventDefinitionItemProvider(this);
        }

        return eventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ExclusiveGateway} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExclusiveGatewayItemProvider exclusiveGatewayItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ExclusiveGateway}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExclusiveGatewayAdapter() {
        if (exclusiveGatewayItemProvider == null) {
            exclusiveGatewayItemProvider = new ExclusiveGatewayItemProvider(this);
        }

        return exclusiveGatewayItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Expression} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExpressionItemProvider expressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Expression}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExpressionAdapter() {
        if (expressionItemProvider == null) {
            expressionItemProvider = new ExpressionItemProvider(this);
        }

        return expressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Extension} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExtensionItemProvider extensionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Extension}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExtensionAdapter() {
        if (extensionItemProvider == null) {
            extensionItemProvider = new ExtensionItemProvider(this);
        }

        return extensionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ExtensionAttributeDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExtensionAttributeDefinitionItemProvider extensionAttributeDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ExtensionAttributeDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExtensionAttributeDefinitionAdapter() {
        if (extensionAttributeDefinitionItemProvider == null) {
            extensionAttributeDefinitionItemProvider = new ExtensionAttributeDefinitionItemProvider(
                    this);
        }

        return extensionAttributeDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ExtensionAttributeValue} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExtensionAttributeValueItemProvider extensionAttributeValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ExtensionAttributeValue}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExtensionAttributeValueAdapter() {
        if (extensionAttributeValueItemProvider == null) {
            extensionAttributeValueItemProvider = new ExtensionAttributeValueItemProvider(this);
        }

        return extensionAttributeValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ExtensionDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExtensionDefinitionItemProvider extensionDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ExtensionDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExtensionDefinitionAdapter() {
        if (extensionDefinitionItemProvider == null) {
            extensionDefinitionItemProvider = new ExtensionDefinitionItemProvider(this);
        }

        return extensionDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.FormalExpression} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FormalExpressionItemProvider formalExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.FormalExpression}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFormalExpressionAdapter() {
        if (formalExpressionItemProvider == null) {
            formalExpressionItemProvider = new FormalExpressionItemProvider(this);
        }

        return formalExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalBusinessRuleTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalBusinessRuleTaskItemProvider globalBusinessRuleTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalBusinessRuleTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalBusinessRuleTaskAdapter() {
        if (globalBusinessRuleTaskItemProvider == null) {
            globalBusinessRuleTaskItemProvider = new GlobalBusinessRuleTaskItemProvider(this);
        }

        return globalBusinessRuleTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalChoreographyTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalChoreographyTaskItemProvider globalChoreographyTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalChoreographyTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalChoreographyTaskAdapter() {
        if (globalChoreographyTaskItemProvider == null) {
            globalChoreographyTaskItemProvider = new GlobalChoreographyTaskItemProvider(this);
        }

        return globalChoreographyTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalConversation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalConversationItemProvider globalConversationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalConversation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalConversationAdapter() {
        if (globalConversationItemProvider == null) {
            globalConversationItemProvider = new GlobalConversationItemProvider(this);
        }

        return globalConversationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalManualTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalManualTaskItemProvider globalManualTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalManualTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalManualTaskAdapter() {
        if (globalManualTaskItemProvider == null) {
            globalManualTaskItemProvider = new GlobalManualTaskItemProvider(this);
        }

        return globalManualTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalScriptTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalScriptTaskItemProvider globalScriptTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalScriptTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalScriptTaskAdapter() {
        if (globalScriptTaskItemProvider == null) {
            globalScriptTaskItemProvider = new GlobalScriptTaskItemProvider(this);
        }

        return globalScriptTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalTaskItemProvider globalTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalTaskAdapter() {
        if (globalTaskItemProvider == null) {
            globalTaskItemProvider = new GlobalTaskItemProvider(this);
        }

        return globalTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.GlobalUserTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalUserTaskItemProvider globalUserTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.GlobalUserTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalUserTaskAdapter() {
        if (globalUserTaskItemProvider == null) {
            globalUserTaskItemProvider = new GlobalUserTaskItemProvider(this);
        }

        return globalUserTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Group} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GroupItemProvider groupItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Group}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGroupAdapter() {
        if (groupItemProvider == null) {
            groupItemProvider = new GroupItemProvider(this);
        }

        return groupItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.HumanPerformer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected HumanPerformerItemProvider humanPerformerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.HumanPerformer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createHumanPerformerAdapter() {
        if (humanPerformerItemProvider == null) {
            humanPerformerItemProvider = new HumanPerformerItemProvider(this);
        }

        return humanPerformerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ImplicitThrowEvent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ImplicitThrowEventItemProvider implicitThrowEventItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ImplicitThrowEvent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createImplicitThrowEventAdapter() {
        if (implicitThrowEventItemProvider == null) {
            implicitThrowEventItemProvider = new ImplicitThrowEventItemProvider(this);
        }

        return implicitThrowEventItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Import} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ImportItemProvider importItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Import}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createImportAdapter() {
        if (importItemProvider == null) {
            importItemProvider = new ImportItemProvider(this);
        }

        return importItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.InclusiveGateway} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InclusiveGatewayItemProvider inclusiveGatewayItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.InclusiveGateway}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInclusiveGatewayAdapter() {
        if (inclusiveGatewayItemProvider == null) {
            inclusiveGatewayItemProvider = new InclusiveGatewayItemProvider(this);
        }

        return inclusiveGatewayItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.InputOutputBinding} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InputOutputBindingItemProvider inputOutputBindingItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.InputOutputBinding}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInputOutputBindingAdapter() {
        if (inputOutputBindingItemProvider == null) {
            inputOutputBindingItemProvider = new InputOutputBindingItemProvider(this);
        }

        return inputOutputBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.InputOutputSpecification} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InputOutputSpecificationItemProvider inputOutputSpecificationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.InputOutputSpecification}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInputOutputSpecificationAdapter() {
        if (inputOutputSpecificationItemProvider == null) {
            inputOutputSpecificationItemProvider = new InputOutputSpecificationItemProvider(this);
        }

        return inputOutputSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.InputSet} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InputSetItemProvider inputSetItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.InputSet}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInputSetAdapter() {
        if (inputSetItemProvider == null) {
            inputSetItemProvider = new InputSetItemProvider(this);
        }

        return inputSetItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.InteractionNode} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InteractionNodeItemProvider interactionNodeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.InteractionNode}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInteractionNodeAdapter() {
        if (interactionNodeItemProvider == null) {
            interactionNodeItemProvider = new InteractionNodeItemProvider(this);
        }

        return interactionNodeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Interface} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InterfaceItemProvider interfaceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Interface}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInterfaceAdapter() {
        if (interfaceItemProvider == null) {
            interfaceItemProvider = new InterfaceItemProvider(this);
        }

        return interfaceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.IntermediateCatchEvent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IntermediateCatchEventItemProvider intermediateCatchEventItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.IntermediateCatchEvent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createIntermediateCatchEventAdapter() {
        if (intermediateCatchEventItemProvider == null) {
            intermediateCatchEventItemProvider = new IntermediateCatchEventItemProvider(this);
        }

        return intermediateCatchEventItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.IntermediateThrowEvent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IntermediateThrowEventItemProvider intermediateThrowEventItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.IntermediateThrowEvent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createIntermediateThrowEventAdapter() {
        if (intermediateThrowEventItemProvider == null) {
            intermediateThrowEventItemProvider = new IntermediateThrowEventItemProvider(this);
        }

        return intermediateThrowEventItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ItemAwareElement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemAwareElementItemProvider itemAwareElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ItemAwareElement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemAwareElementAdapter() {
        if (itemAwareElementItemProvider == null) {
            itemAwareElementItemProvider = new ItemAwareElementItemProvider(this);
        }

        return itemAwareElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ItemDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemDefinitionItemProvider itemDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ItemDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemDefinitionAdapter() {
        if (itemDefinitionItemProvider == null) {
            itemDefinitionItemProvider = new ItemDefinitionItemProvider(this);
        }

        return itemDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Lane} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LaneItemProvider laneItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Lane}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createLaneAdapter() {
        if (laneItemProvider == null) {
            laneItemProvider = new LaneItemProvider(this);
        }

        return laneItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.LaneSet} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LaneSetItemProvider laneSetItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.LaneSet}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createLaneSetAdapter() {
        if (laneSetItemProvider == null) {
            laneSetItemProvider = new LaneSetItemProvider(this);
        }

        return laneSetItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.LinkEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LinkEventDefinitionItemProvider linkEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.LinkEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createLinkEventDefinitionAdapter() {
        if (linkEventDefinitionItemProvider == null) {
            linkEventDefinitionItemProvider = new LinkEventDefinitionItemProvider(this);
        }

        return linkEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ManualTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ManualTaskItemProvider manualTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ManualTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createManualTaskAdapter() {
        if (manualTaskItemProvider == null) {
            manualTaskItemProvider = new ManualTaskItemProvider(this);
        }

        return manualTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Message} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MessageItemProvider messageItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Message}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMessageAdapter() {
        if (messageItemProvider == null) {
            messageItemProvider = new MessageItemProvider(this);
        }

        return messageItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.MessageEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MessageEventDefinitionItemProvider messageEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.MessageEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMessageEventDefinitionAdapter() {
        if (messageEventDefinitionItemProvider == null) {
            messageEventDefinitionItemProvider = new MessageEventDefinitionItemProvider(this);
        }

        return messageEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.MessageFlow} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MessageFlowItemProvider messageFlowItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.MessageFlow}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMessageFlowAdapter() {
        if (messageFlowItemProvider == null) {
            messageFlowItemProvider = new MessageFlowItemProvider(this);
        }

        return messageFlowItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.MessageFlowAssociation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MessageFlowAssociationItemProvider messageFlowAssociationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.MessageFlowAssociation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMessageFlowAssociationAdapter() {
        if (messageFlowAssociationItemProvider == null) {
            messageFlowAssociationItemProvider = new MessageFlowAssociationItemProvider(this);
        }

        return messageFlowAssociationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Monitoring} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MonitoringItemProvider monitoringItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Monitoring}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMonitoringAdapter() {
        if (monitoringItemProvider == null) {
            monitoringItemProvider = new MonitoringItemProvider(this);
        }

        return monitoringItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.MultiInstanceLoopCharacteristics} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MultiInstanceLoopCharacteristicsItemProvider multiInstanceLoopCharacteristicsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.MultiInstanceLoopCharacteristics}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMultiInstanceLoopCharacteristicsAdapter() {
        if (multiInstanceLoopCharacteristicsItemProvider == null) {
            multiInstanceLoopCharacteristicsItemProvider = new MultiInstanceLoopCharacteristicsItemProvider(
                    this);
        }

        return multiInstanceLoopCharacteristicsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Operation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OperationItemProvider operationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Operation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createOperationAdapter() {
        if (operationItemProvider == null) {
            operationItemProvider = new OperationItemProvider(this);
        }

        return operationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.OutputSet} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OutputSetItemProvider outputSetItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.OutputSet}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createOutputSetAdapter() {
        if (outputSetItemProvider == null) {
            outputSetItemProvider = new OutputSetItemProvider(this);
        }

        return outputSetItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ParallelGateway} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ParallelGatewayItemProvider parallelGatewayItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ParallelGateway}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createParallelGatewayAdapter() {
        if (parallelGatewayItemProvider == null) {
            parallelGatewayItemProvider = new ParallelGatewayItemProvider(this);
        }

        return parallelGatewayItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Participant} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ParticipantItemProvider participantItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Participant}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createParticipantAdapter() {
        if (participantItemProvider == null) {
            participantItemProvider = new ParticipantItemProvider(this);
        }

        return participantItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ParticipantAssociation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ParticipantAssociationItemProvider participantAssociationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ParticipantAssociation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createParticipantAssociationAdapter() {
        if (participantAssociationItemProvider == null) {
            participantAssociationItemProvider = new ParticipantAssociationItemProvider(this);
        }

        return participantAssociationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ParticipantMultiplicity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ParticipantMultiplicityItemProvider participantMultiplicityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ParticipantMultiplicity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createParticipantMultiplicityAdapter() {
        if (participantMultiplicityItemProvider == null) {
            participantMultiplicityItemProvider = new ParticipantMultiplicityItemProvider(this);
        }

        return participantMultiplicityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.PartnerEntity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PartnerEntityItemProvider partnerEntityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.PartnerEntity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPartnerEntityAdapter() {
        if (partnerEntityItemProvider == null) {
            partnerEntityItemProvider = new PartnerEntityItemProvider(this);
        }

        return partnerEntityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.PartnerRole} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PartnerRoleItemProvider partnerRoleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.PartnerRole}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPartnerRoleAdapter() {
        if (partnerRoleItemProvider == null) {
            partnerRoleItemProvider = new PartnerRoleItemProvider(this);
        }

        return partnerRoleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Performer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PerformerItemProvider performerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Performer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPerformerAdapter() {
        if (performerItemProvider == null) {
            performerItemProvider = new PerformerItemProvider(this);
        }

        return performerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.PotentialOwner} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PotentialOwnerItemProvider potentialOwnerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.PotentialOwner}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPotentialOwnerAdapter() {
        if (potentialOwnerItemProvider == null) {
            potentialOwnerItemProvider = new PotentialOwnerItemProvider(this);
        }

        return potentialOwnerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Process} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProcessItemProvider processItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Process}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProcessAdapter() {
        if (processItemProvider == null) {
            processItemProvider = new ProcessItemProvider(this);
        }

        return processItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Property} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PropertyItemProvider propertyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Property}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPropertyAdapter() {
        if (propertyItemProvider == null) {
            propertyItemProvider = new PropertyItemProvider(this);
        }

        return propertyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ReceiveTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ReceiveTaskItemProvider receiveTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ReceiveTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createReceiveTaskAdapter() {
        if (receiveTaskItemProvider == null) {
            receiveTaskItemProvider = new ReceiveTaskItemProvider(this);
        }

        return receiveTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Relationship} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RelationshipItemProvider relationshipItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Relationship}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRelationshipAdapter() {
        if (relationshipItemProvider == null) {
            relationshipItemProvider = new RelationshipItemProvider(this);
        }

        return relationshipItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Rendering} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RenderingItemProvider renderingItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Rendering}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRenderingAdapter() {
        if (renderingItemProvider == null) {
            renderingItemProvider = new RenderingItemProvider(this);
        }

        return renderingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Resource} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ResourceItemProvider resourceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Resource}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createResourceAdapter() {
        if (resourceItemProvider == null) {
            resourceItemProvider = new ResourceItemProvider(this);
        }

        return resourceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ResourceAssignmentExpression} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ResourceAssignmentExpressionItemProvider resourceAssignmentExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ResourceAssignmentExpression}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createResourceAssignmentExpressionAdapter() {
        if (resourceAssignmentExpressionItemProvider == null) {
            resourceAssignmentExpressionItemProvider = new ResourceAssignmentExpressionItemProvider(
                    this);
        }

        return resourceAssignmentExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ResourceParameter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ResourceParameterItemProvider resourceParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ResourceParameter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createResourceParameterAdapter() {
        if (resourceParameterItemProvider == null) {
            resourceParameterItemProvider = new ResourceParameterItemProvider(this);
        }

        return resourceParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ResourceParameterBinding} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ResourceParameterBindingItemProvider resourceParameterBindingItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ResourceParameterBinding}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createResourceParameterBindingAdapter() {
        if (resourceParameterBindingItemProvider == null) {
            resourceParameterBindingItemProvider = new ResourceParameterBindingItemProvider(this);
        }

        return resourceParameterBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ResourceRole} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ResourceRoleItemProvider resourceRoleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ResourceRole}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createResourceRoleAdapter() {
        if (resourceRoleItemProvider == null) {
            resourceRoleItemProvider = new ResourceRoleItemProvider(this);
        }

        return resourceRoleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.RootElement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RootElementItemProvider rootElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.RootElement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRootElementAdapter() {
        if (rootElementItemProvider == null) {
            rootElementItemProvider = new RootElementItemProvider(this);
        }

        return rootElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ScriptTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScriptTaskItemProvider scriptTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ScriptTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScriptTaskAdapter() {
        if (scriptTaskItemProvider == null) {
            scriptTaskItemProvider = new ScriptTaskItemProvider(this);
        }

        return scriptTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.SendTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SendTaskItemProvider sendTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.SendTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSendTaskAdapter() {
        if (sendTaskItemProvider == null) {
            sendTaskItemProvider = new SendTaskItemProvider(this);
        }

        return sendTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.SequenceFlow} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SequenceFlowItemProvider sequenceFlowItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.SequenceFlow}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSequenceFlowAdapter() {
        if (sequenceFlowItemProvider == null) {
            sequenceFlowItemProvider = new SequenceFlowItemProvider(this);
        }

        return sequenceFlowItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.ServiceTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ServiceTaskItemProvider serviceTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.ServiceTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createServiceTaskAdapter() {
        if (serviceTaskItemProvider == null) {
            serviceTaskItemProvider = new ServiceTaskItemProvider(this);
        }

        return serviceTaskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Signal} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SignalItemProvider signalItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Signal}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSignalAdapter() {
        if (signalItemProvider == null) {
            signalItemProvider = new SignalItemProvider(this);
        }

        return signalItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.SignalEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SignalEventDefinitionItemProvider signalEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.SignalEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSignalEventDefinitionAdapter() {
        if (signalEventDefinitionItemProvider == null) {
            signalEventDefinitionItemProvider = new SignalEventDefinitionItemProvider(this);
        }

        return signalEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.StandardLoopCharacteristics} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StandardLoopCharacteristicsItemProvider standardLoopCharacteristicsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.StandardLoopCharacteristics}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createStandardLoopCharacteristicsAdapter() {
        if (standardLoopCharacteristicsItemProvider == null) {
            standardLoopCharacteristicsItemProvider = new StandardLoopCharacteristicsItemProvider(
                    this);
        }

        return standardLoopCharacteristicsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.StartEvent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StartEventItemProvider startEventItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.StartEvent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createStartEventAdapter() {
        if (startEventItemProvider == null) {
            startEventItemProvider = new StartEventItemProvider(this);
        }

        return startEventItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.SubChoreography} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SubChoreographyItemProvider subChoreographyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.SubChoreography}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSubChoreographyAdapter() {
        if (subChoreographyItemProvider == null) {
            subChoreographyItemProvider = new SubChoreographyItemProvider(this);
        }

        return subChoreographyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.SubConversation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SubConversationItemProvider subConversationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.SubConversation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSubConversationAdapter() {
        if (subConversationItemProvider == null) {
            subConversationItemProvider = new SubConversationItemProvider(this);
        }

        return subConversationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.SubProcess} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SubProcessItemProvider subProcessItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.SubProcess}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSubProcessAdapter() {
        if (subProcessItemProvider == null) {
            subProcessItemProvider = new SubProcessItemProvider(this);
        }

        return subProcessItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Task} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TaskItemProvider taskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Task}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTaskAdapter() {
        if (taskItemProvider == null) {
            taskItemProvider = new TaskItemProvider(this);
        }

        return taskItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.TerminateEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TerminateEventDefinitionItemProvider terminateEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.TerminateEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTerminateEventDefinitionAdapter() {
        if (terminateEventDefinitionItemProvider == null) {
            terminateEventDefinitionItemProvider = new TerminateEventDefinitionItemProvider(this);
        }

        return terminateEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.TextAnnotation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TextAnnotationItemProvider textAnnotationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.TextAnnotation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTextAnnotationAdapter() {
        if (textAnnotationItemProvider == null) {
            textAnnotationItemProvider = new TextAnnotationItemProvider(this);
        }

        return textAnnotationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.TimerEventDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TimerEventDefinitionItemProvider timerEventDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.TimerEventDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTimerEventDefinitionAdapter() {
        if (timerEventDefinitionItemProvider == null) {
            timerEventDefinitionItemProvider = new TimerEventDefinitionItemProvider(this);
        }

        return timerEventDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.Transaction} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TransactionItemProvider transactionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.Transaction}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTransactionAdapter() {
        if (transactionItemProvider == null) {
            transactionItemProvider = new TransactionItemProvider(this);
        }

        return transactionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.bpmn2.UserTask} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UserTaskItemProvider userTaskItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.bpmn2.UserTask}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUserTaskAdapter() {
        if (userTaskItemProvider == null) {
            userTaskItemProvider = new UserTaskItemProvider(this);
        }

        return userTaskItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose() {
        if (documentRootItemProvider != null)
            documentRootItemProvider.dispose();
        if (activityItemProvider != null)
            activityItemProvider.dispose();
        if (adHocSubProcessItemProvider != null)
            adHocSubProcessItemProvider.dispose();
        if (artifactItemProvider != null)
            artifactItemProvider.dispose();
        if (assignmentItemProvider != null)
            assignmentItemProvider.dispose();
        if (associationItemProvider != null)
            associationItemProvider.dispose();
        if (auditingItemProvider != null)
            auditingItemProvider.dispose();
        if (baseElementItemProvider != null)
            baseElementItemProvider.dispose();
        if (boundaryEventItemProvider != null)
            boundaryEventItemProvider.dispose();
        if (businessRuleTaskItemProvider != null)
            businessRuleTaskItemProvider.dispose();
        if (callActivityItemProvider != null)
            callActivityItemProvider.dispose();
        if (callChoreographyItemProvider != null)
            callChoreographyItemProvider.dispose();
        if (callConversationItemProvider != null)
            callConversationItemProvider.dispose();
        if (callableElementItemProvider != null)
            callableElementItemProvider.dispose();
        if (cancelEventDefinitionItemProvider != null)
            cancelEventDefinitionItemProvider.dispose();
        if (categoryItemProvider != null)
            categoryItemProvider.dispose();
        if (categoryValueItemProvider != null)
            categoryValueItemProvider.dispose();
        if (choreographyItemProvider != null)
            choreographyItemProvider.dispose();
        if (choreographyTaskItemProvider != null)
            choreographyTaskItemProvider.dispose();
        if (collaborationItemProvider != null)
            collaborationItemProvider.dispose();
        if (compensateEventDefinitionItemProvider != null)
            compensateEventDefinitionItemProvider.dispose();
        if (complexBehaviorDefinitionItemProvider != null)
            complexBehaviorDefinitionItemProvider.dispose();
        if (complexGatewayItemProvider != null)
            complexGatewayItemProvider.dispose();
        if (conditionalEventDefinitionItemProvider != null)
            conditionalEventDefinitionItemProvider.dispose();
        if (conversationItemProvider != null)
            conversationItemProvider.dispose();
        if (conversationAssociationItemProvider != null)
            conversationAssociationItemProvider.dispose();
        if (conversationLinkItemProvider != null)
            conversationLinkItemProvider.dispose();
        if (conversationNodeItemProvider != null)
            conversationNodeItemProvider.dispose();
        if (correlationKeyItemProvider != null)
            correlationKeyItemProvider.dispose();
        if (correlationPropertyItemProvider != null)
            correlationPropertyItemProvider.dispose();
        if (correlationPropertyBindingItemProvider != null)
            correlationPropertyBindingItemProvider.dispose();
        if (correlationPropertyRetrievalExpressionItemProvider != null)
            correlationPropertyRetrievalExpressionItemProvider.dispose();
        if (correlationSubscriptionItemProvider != null)
            correlationSubscriptionItemProvider.dispose();
        if (dataAssociationItemProvider != null)
            dataAssociationItemProvider.dispose();
        if (dataInputItemProvider != null)
            dataInputItemProvider.dispose();
        if (dataInputAssociationItemProvider != null)
            dataInputAssociationItemProvider.dispose();
        if (dataObjectItemProvider != null)
            dataObjectItemProvider.dispose();
        if (dataObjectReferenceItemProvider != null)
            dataObjectReferenceItemProvider.dispose();
        if (dataOutputItemProvider != null)
            dataOutputItemProvider.dispose();
        if (dataOutputAssociationItemProvider != null)
            dataOutputAssociationItemProvider.dispose();
        if (dataStateItemProvider != null)
            dataStateItemProvider.dispose();
        if (dataStoreItemProvider != null)
            dataStoreItemProvider.dispose();
        if (dataStoreReferenceItemProvider != null)
            dataStoreReferenceItemProvider.dispose();
        if (definitionsItemProvider != null)
            definitionsItemProvider.dispose();
        if (documentationItemProvider != null)
            documentationItemProvider.dispose();
        if (endEventItemProvider != null)
            endEventItemProvider.dispose();
        if (endPointItemProvider != null)
            endPointItemProvider.dispose();
        if (errorItemProvider != null)
            errorItemProvider.dispose();
        if (errorEventDefinitionItemProvider != null)
            errorEventDefinitionItemProvider.dispose();
        if (escalationItemProvider != null)
            escalationItemProvider.dispose();
        if (escalationEventDefinitionItemProvider != null)
            escalationEventDefinitionItemProvider.dispose();
        if (eventBasedGatewayItemProvider != null)
            eventBasedGatewayItemProvider.dispose();
        if (eventDefinitionItemProvider != null)
            eventDefinitionItemProvider.dispose();
        if (exclusiveGatewayItemProvider != null)
            exclusiveGatewayItemProvider.dispose();
        if (expressionItemProvider != null)
            expressionItemProvider.dispose();
        if (extensionItemProvider != null)
            extensionItemProvider.dispose();
        if (extensionAttributeDefinitionItemProvider != null)
            extensionAttributeDefinitionItemProvider.dispose();
        if (extensionAttributeValueItemProvider != null)
            extensionAttributeValueItemProvider.dispose();
        if (extensionDefinitionItemProvider != null)
            extensionDefinitionItemProvider.dispose();
        if (formalExpressionItemProvider != null)
            formalExpressionItemProvider.dispose();
        if (globalBusinessRuleTaskItemProvider != null)
            globalBusinessRuleTaskItemProvider.dispose();
        if (globalChoreographyTaskItemProvider != null)
            globalChoreographyTaskItemProvider.dispose();
        if (globalConversationItemProvider != null)
            globalConversationItemProvider.dispose();
        if (globalManualTaskItemProvider != null)
            globalManualTaskItemProvider.dispose();
        if (globalScriptTaskItemProvider != null)
            globalScriptTaskItemProvider.dispose();
        if (globalTaskItemProvider != null)
            globalTaskItemProvider.dispose();
        if (globalUserTaskItemProvider != null)
            globalUserTaskItemProvider.dispose();
        if (groupItemProvider != null)
            groupItemProvider.dispose();
        if (humanPerformerItemProvider != null)
            humanPerformerItemProvider.dispose();
        if (implicitThrowEventItemProvider != null)
            implicitThrowEventItemProvider.dispose();
        if (importItemProvider != null)
            importItemProvider.dispose();
        if (inclusiveGatewayItemProvider != null)
            inclusiveGatewayItemProvider.dispose();
        if (inputOutputBindingItemProvider != null)
            inputOutputBindingItemProvider.dispose();
        if (inputOutputSpecificationItemProvider != null)
            inputOutputSpecificationItemProvider.dispose();
        if (inputSetItemProvider != null)
            inputSetItemProvider.dispose();
        if (interactionNodeItemProvider != null)
            interactionNodeItemProvider.dispose();
        if (interfaceItemProvider != null)
            interfaceItemProvider.dispose();
        if (intermediateCatchEventItemProvider != null)
            intermediateCatchEventItemProvider.dispose();
        if (intermediateThrowEventItemProvider != null)
            intermediateThrowEventItemProvider.dispose();
        if (itemAwareElementItemProvider != null)
            itemAwareElementItemProvider.dispose();
        if (itemDefinitionItemProvider != null)
            itemDefinitionItemProvider.dispose();
        if (laneItemProvider != null)
            laneItemProvider.dispose();
        if (laneSetItemProvider != null)
            laneSetItemProvider.dispose();
        if (linkEventDefinitionItemProvider != null)
            linkEventDefinitionItemProvider.dispose();
        if (manualTaskItemProvider != null)
            manualTaskItemProvider.dispose();
        if (messageItemProvider != null)
            messageItemProvider.dispose();
        if (messageEventDefinitionItemProvider != null)
            messageEventDefinitionItemProvider.dispose();
        if (messageFlowItemProvider != null)
            messageFlowItemProvider.dispose();
        if (messageFlowAssociationItemProvider != null)
            messageFlowAssociationItemProvider.dispose();
        if (monitoringItemProvider != null)
            monitoringItemProvider.dispose();
        if (multiInstanceLoopCharacteristicsItemProvider != null)
            multiInstanceLoopCharacteristicsItemProvider.dispose();
        if (operationItemProvider != null)
            operationItemProvider.dispose();
        if (outputSetItemProvider != null)
            outputSetItemProvider.dispose();
        if (parallelGatewayItemProvider != null)
            parallelGatewayItemProvider.dispose();
        if (participantItemProvider != null)
            participantItemProvider.dispose();
        if (participantAssociationItemProvider != null)
            participantAssociationItemProvider.dispose();
        if (participantMultiplicityItemProvider != null)
            participantMultiplicityItemProvider.dispose();
        if (partnerEntityItemProvider != null)
            partnerEntityItemProvider.dispose();
        if (partnerRoleItemProvider != null)
            partnerRoleItemProvider.dispose();
        if (performerItemProvider != null)
            performerItemProvider.dispose();
        if (potentialOwnerItemProvider != null)
            potentialOwnerItemProvider.dispose();
        if (processItemProvider != null)
            processItemProvider.dispose();
        if (propertyItemProvider != null)
            propertyItemProvider.dispose();
        if (receiveTaskItemProvider != null)
            receiveTaskItemProvider.dispose();
        if (relationshipItemProvider != null)
            relationshipItemProvider.dispose();
        if (renderingItemProvider != null)
            renderingItemProvider.dispose();
        if (resourceItemProvider != null)
            resourceItemProvider.dispose();
        if (resourceAssignmentExpressionItemProvider != null)
            resourceAssignmentExpressionItemProvider.dispose();
        if (resourceParameterItemProvider != null)
            resourceParameterItemProvider.dispose();
        if (resourceParameterBindingItemProvider != null)
            resourceParameterBindingItemProvider.dispose();
        if (resourceRoleItemProvider != null)
            resourceRoleItemProvider.dispose();
        if (rootElementItemProvider != null)
            rootElementItemProvider.dispose();
        if (scriptTaskItemProvider != null)
            scriptTaskItemProvider.dispose();
        if (sendTaskItemProvider != null)
            sendTaskItemProvider.dispose();
        if (sequenceFlowItemProvider != null)
            sequenceFlowItemProvider.dispose();
        if (serviceTaskItemProvider != null)
            serviceTaskItemProvider.dispose();
        if (signalItemProvider != null)
            signalItemProvider.dispose();
        if (signalEventDefinitionItemProvider != null)
            signalEventDefinitionItemProvider.dispose();
        if (standardLoopCharacteristicsItemProvider != null)
            standardLoopCharacteristicsItemProvider.dispose();
        if (startEventItemProvider != null)
            startEventItemProvider.dispose();
        if (subChoreographyItemProvider != null)
            subChoreographyItemProvider.dispose();
        if (subConversationItemProvider != null)
            subConversationItemProvider.dispose();
        if (subProcessItemProvider != null)
            subProcessItemProvider.dispose();
        if (taskItemProvider != null)
            taskItemProvider.dispose();
        if (terminateEventDefinitionItemProvider != null)
            terminateEventDefinitionItemProvider.dispose();
        if (textAnnotationItemProvider != null)
            textAnnotationItemProvider.dispose();
        if (timerEventDefinitionItemProvider != null)
            timerEventDefinitionItemProvider.dispose();
        if (transactionItemProvider != null)
            transactionItemProvider.dispose();
        if (userTaskItemProvider != null)
            userTaskItemProvider.dispose();
    }

}
