/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ddl.importer.ui.DdlImportDifferencesPage;
import org.teiid.designer.teiidimporter.ui.Activator;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.wizard.SelectDataSourcePage;
import org.teiid.designer.teiidimporter.ui.wizard.SelectTargetPage;
import org.teiid.designer.teiidimporter.ui.wizard.SelectTranslatorPage;
import org.teiid.designer.teiidimporter.ui.wizard.ShowDDLPage;
import org.teiid.designer.teiidimporter.ui.wizard.TeiidImportManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class TeiidImportWizard
extends AbstractWizard
implements IImportWizard,
IPropertiesContext,
UiConstants {
    private static final ImageDescriptor IMAGE = Activator.getDefault().getImageDescriptor("icons/importTeiidMetadataWiz.gif");
    private TeiidImportManager importManager;
    private SelectDataSourcePage selectDataSourcePage;
    private SelectTranslatorPage selectTranslatorPage;
    private SelectTargetPage selectTargetPage;
    private ShowDDLPage showDDLPage;
    private DdlImportDifferencesPage differencesPage;
    IContainer targetContainer = null;
    private Properties designerProperties;
    private boolean openProjectExists = true;
    private IProject newProject;

    public TeiidImportWizard() {
        super((AbstractUIPlugin)Activator.getDefault(), Messages.TeiidImportWizard_title, IMAGE);
        IDialogSettings pluginSettings = Activator.getDefault().getDialogSettings();
        String sectionName = TeiidImportWizard.class.getSimpleName();
        IDialogSettings section = pluginSettings.getSection(sectionName);
        if (section == null) {
            section = pluginSettings.addNewSection(sectionName);
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection inputSelection) {
        IStructuredSelection finalSelection = inputSelection;
        this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
        if (!this.openProjectExists) {
            this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (this.newProject != null) {
                finalSelection = new StructuredSelection((Object)this.newProject);
                this.openProjectExists = true;
            } else {
                this.openProjectExists = false;
            }
        }
        Collection projects = DotProjectUtils.getOpenModelProjects();
        IProject[] projectArray = projects.toArray(new IProject[0]);
        this.getImportManager().initDdlImporter(projectArray);
        Object selectedObj = finalSelection.getFirstElement();
        this.targetContainer = null;
        boolean isRelationalSourceModel = false;
        try {
            if (selectedObj instanceof IFile) {
                ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                isRelationalSourceModel = ModelIdentifier.isRelationalSourceModel((ModelResource)modelResource);
            }
        }
        catch (Exception e) {
            UTIL.log((Throwable)e);
        }
        if (selectedObj != null) {
            this.targetContainer = ModelUtil.getContainer((Object)selectedObj);
            try {
                if (this.targetContainer != null && this.targetContainer.getProject().getNature("org.teiid.designer.core.modelNature") == null) {
                    this.targetContainer = null;
                }
            }
            catch (CoreException err) {
                UTIL.log((Throwable)err);
                WidgetUtil.showError((Throwable)err);
            }
        }
        if (this.targetContainer != null) {
            this.getImportManager().setTargetModelLocation(this.targetContainer.getFullPath());
        }
        if (isRelationalSourceModel) {
            this.getImportManager().setTargetModelName(((IFile)selectedObj).getName());
        }
    }

    private TeiidImportManager getImportManager() {
        if (this.importManager != null) {
            return this.importManager;
        }
        this.importManager = new TeiidImportManager();
        return this.importManager;
    }

    public void addPages() {
        this.selectDataSourcePage = new SelectDataSourcePage(this.importManager);
        this.addPage((IWizardPage)this.selectDataSourcePage);
        this.selectTranslatorPage = new SelectTranslatorPage(this.importManager);
        this.addPage((IWizardPage)this.selectTranslatorPage);
        this.selectTargetPage = new SelectTargetPage(this.importManager);
        this.addPage((IWizardPage)this.selectTargetPage);
        this.showDDLPage = new ShowDDLPage(this.importManager);
        this.addPage((IWizardPage)this.showDDLPage);
        this.differencesPage = new DdlImportDifferencesPage(this.importManager.getDdlImporter());
        this.addPage((IWizardPage)this.differencesPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.updateForProperties();
    }

    public boolean performCancel() {
        this.importManager.undeployDynamicVdb();
        return true;
    }

    public boolean finish() {
        this.importManager.setCreateConnectionProfile(this.selectTargetPage.isCreateConnectionProfile());
        this.importManager.saveUsingDdlDiffReport(this.getShell());
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage pg = iWizardPageArray[n2];
            if (pg instanceof IPersistentWizardPage) {
                ((IPersistentWizardPage)pg).saveSettings();
            }
            ++n2;
        }
        this.importManager.undeployDynamicVdb();
        this.importManager.deleteDdlTempFile();
        this.openModelInEditor();
        return true;
    }

    private void openModelInEditor() {
        String modelName = this.importManager.getTargetModelName();
        IPath modelLocation = this.importManager.getTargetModelLocation();
        if (!CoreStringUtil.isEmpty((String)modelName) && modelLocation != null) {
            ModelResource targetModelResc;
            IFile targetModel;
            IPath modelPath = new Path(modelLocation.toOSString()).append(modelName);
            if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                modelPath = modelPath.addFileExtension("xmi");
            }
            if ((targetModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)) != null && (targetModelResc = ModelUtilities.getModelResourceForIFile((IFile)targetModel, (boolean)false)) != null) {
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ModelEditorManager.openInEditMode((Object)targetModelResc, (boolean)true, (int)0);
                    }
                }, (boolean)true);
            }
        }
    }

    public void setProperties(Properties properties) {
        this.designerProperties = properties;
    }

    protected boolean openProjectExists() {
        return this.openProjectExists;
    }

    protected void updateForProperties() {
        if (this.designerProperties == null || this.designerProperties.isEmpty()) {
            return;
        }
        if (this.targetContainer == null) {
            IProject project = DesignerPropertiesUtil.getProject((Properties)this.designerProperties);
            IContainer srcFolderResrc = DesignerPropertiesUtil.getSourcesFolder((Properties)this.designerProperties);
            if (srcFolderResrc != null) {
                this.getImportManager().setTargetModelLocation(srcFolderResrc.getFullPath());
            } else if (project != null) {
                this.getImportManager().setTargetModelLocation(project.getFullPath());
            }
        }
        if (!this.openProjectExists) {
            DesignerPropertiesUtil.setProjectStatus((Properties)this.designerProperties, (String)"noOpenProject");
        }
    }
}

