/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.translators.TranslatorOverride;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.ddl.importer.DdlImporter;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.connection.TranslatorUtils;
import org.teiid.designer.runtime.importer.ImportManager;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TeiidImportManager
implements ITeiidImportServer,
UiConstants {
    private static final String PREVIEW_DATASOURCE_PREFIX = "PREVIEW_";
    private IPath targetModelLocation = null;
    private String targetModelName = null;
    private String translatorName = null;
    private String dataSourceName = null;
    private String dataSourceJndiName = null;
    private String dataSourceDriverName = null;
    private Properties dataSourceProps = null;
    private Map<String, String> optionalImportProps = new HashMap<String, String>();
    private boolean createConnectionProfile = true;
    private TranslatorOverride translatorOverride;
    IStatus vdbDeploymentStatus = null;
    private ConnectionInfoHelper connectionInfoHelper = new ConnectionInfoHelper();
    private DdlImporter ddlImporter;
    private File ddlFile;
    private String uniqueImportVdbName;
    private boolean redeploy = false;

    public void setDataSourceName(String dsName) {
        if (this.areDifferent(this.dataSourceName, dsName)) {
            this.vdbDeploymentStatus = null;
        }
        this.dataSourceName = dsName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceJndiName(String dsJndiName) {
        this.dataSourceJndiName = dsJndiName;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceDriverName(String driverName) {
        if (this.areDifferent(this.dataSourceDriverName, driverName)) {
            this.vdbDeploymentStatus = null;
        }
        this.dataSourceDriverName = driverName;
    }

    public String getDataSourceDriverName() {
        return this.dataSourceDriverName;
    }

    public void setDataSourceProperties(Properties props) {
        this.dataSourceProps = props;
        this.vdbDeploymentStatus = null;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProps;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public void setTranslatorName(String translatorName) {
        if (this.areDifferent(this.translatorName, translatorName)) {
            this.vdbDeploymentStatus = null;
            this.translatorOverride = translatorName != null ? this.createTranslatorOverride(translatorName, new Properties()) : null;
        }
        this.translatorName = translatorName;
    }

    public void addOptionalImportProperty(String name, String value) {
        this.optionalImportProps.put(name, value);
        this.vdbDeploymentStatus = null;
    }

    public void removeOptionalImportProperty(String name) {
        this.optionalImportProps.remove(name);
        this.vdbDeploymentStatus = null;
    }

    public Map<String, String> getOptionalImportProps() {
        HashMap<String, String> allProps = new HashMap<String, String>();
        for (String key : this.optionalImportProps.keySet()) {
            allProps.put(key, this.optionalImportProps.get(key));
        }
        if (this.translatorOverride != null && this.translatorOverride.getProperties().length > 0) {
            TranslatorOverrideProperty[] translatorOverridePropertyArray = this.translatorOverride.getProperties();
            int n = translatorOverridePropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                TranslatorOverrideProperty prop = translatorOverridePropertyArray[n2];
                if (prop.hasOverridenValue()) {
                    String value = prop.getOverriddenValue();
                    String key = prop.getDefinition().getId();
                    allProps.put(key, value);
                }
                ++n2;
            }
        }
        return allProps;
    }

    public boolean isValidImportServer() {
        return this.getServerImportManager().isValidImportServer();
    }

    public IStatus deployDynamicVdb() {
        this.vdbDeploymentStatus = null;
        final String translatorName = this.getTranslatorName();
        final String dataSourceName = this.getDataSourceName();
        final Map<String, String> optionalImportPropMap = this.getOptionalImportProps();
        boolean infoGood = false;
        if (translatorName != null && dataSourceName != null) {
            infoGood = true;
        }
        if (this.isValidImportServer() && infoGood) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            monitor.beginTask(NLS.bind((String)Messages.TeiidImportManager_deployVdbMsg, (Object)TeiidImportManager.this.getTimeoutPrefSecs()), 100);
                            TeiidImportManager.this.vdbDeploymentStatus = TeiidImportManager.this.getServerImportManager().deployDynamicVdb(TeiidImportManager.this.getCurrentImportVdbName(), dataSourceName, translatorName, optionalImportPropMap, monitor);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                this.vdbDeploymentStatus = new Status(4, UiConstants.PLUGIN_ID, 0, cause.getLocalizedMessage(), cause);
                UTIL.log(this.vdbDeploymentStatus);
            }
            catch (InterruptedException interruptedException) {
                this.vdbDeploymentStatus = new Status(4, UiConstants.PLUGIN_ID, Messages.TeiidImportManager_deployVdbInterruptedMsg);
                UTIL.log(this.vdbDeploymentStatus);
            }
        }
        return this.vdbDeploymentStatus;
    }

    public String getDynamicVdbString() {
        return this.getServerImportManager().createDynamicVdbString(this.getCurrentImportVdbName(), this.dataSourceName, this.translatorName, this.getOptionalImportProps());
    }

    private String getTimeoutPrefSecs() {
        String timeoutStr = DqpPlugin.getInstance().getPreferences().get("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", "120");
        try {
            Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException numberFormatException) {
            timeoutStr = "120";
        }
        return timeoutStr;
    }

    public IStatus undeployDynamicVdb() {
        this.vdbDeploymentStatus = null;
        String undeployVdbName = this.getCurrentImportVdbName();
        this.uniqueImportVdbName = null;
        return this.getServerImportManager().undeployVdb(undeployVdbName);
    }

    private boolean injectProfileIntoTarget(IProgressMonitor monitor) {
        IFile targetModel;
        ModelResource targetModelResc;
        if (this.targetModelLocation == null) {
            return false;
        }
        IPath modelPath = new Path(this.targetModelLocation.toOSString()).append(this.targetModelName);
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((targetModelResc = ModelUtilities.getModelResourceForIFile((IFile)(targetModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null) {
            ConnectionInfoProviderFactory manager = new ConnectionInfoProviderFactory();
            IConnectionInfoProvider connInfoProvider = manager.getProviderFromProfileID("org.teiid.designer.datatools.profiles.jbossds.JBossDsConnectionProfile");
            ProfileManager pm = ProfileManager.getInstance();
            Properties props = new Properties();
            props.put("JBossDsJndi", this.getDataSourceJndiName());
            props.put("JBossDsTranslator", this.getTranslatorName());
            try {
                String dsName = this.getDataSourceName();
                String cpName = "TeiidImportCP_" + dsName;
                IConnectionProfile cp = pm.getProfileByName(cpName);
                if (cp != null) {
                    pm.deleteProfile(cp);
                }
                cp = pm.createProfile(cpName, "JBoss DS Profile", "org.teiid.designer.datatools.profiles.jbossds.JBossDsConnectionProfile", props);
                connInfoProvider.setConnectionInfo(targetModelResc, cp);
            }
            catch (Exception ex) {
                UTIL.log((Throwable)ex);
            }
            try {
                targetModelResc.save(monitor, true);
            }
            catch (Exception error) {
                ErrorHandler.toExceptionDialog((Throwable)error);
            }
            return true;
        }
        return false;
    }

    public String getDdl() {
        boolean success = true;
        String ddl = null;
        try {
            ddl = this.getServerImportManager().getSchema(this.getCurrentImportVdbName());
        }
        catch (Exception ex) {
            UTIL.log((Throwable)ex);
            ddl = Messages.TeiidImportManager_getDdlErrorMsg;
            success = false;
        }
        String modifiedDdl = null;
        try {
            if (success) {
                if (ddl != null) {
                    String importVdbSourceModel = String.valueOf(this.getCurrentImportVdbName()) + "SrcModel" + ".";
                    modifiedDdl = ddl.replaceAll(importVdbSourceModel, "");
                }
                this.writeDdlToTempFile(modifiedDdl);
            } else {
                this.writeDdlToTempFile("");
            }
        }
        catch (Exception ex) {
            UTIL.log((Throwable)ex);
            WidgetUtil.showError((Throwable)ex);
        }
        return modifiedDdl;
    }

    private boolean areDifferent(String str1, String str2) {
        if (CoreStringUtil.isEmpty((String)str1) && !CoreStringUtil.isEmpty((String)str2)) {
            return true;
        }
        if (CoreStringUtil.isEmpty((String)str2) && !CoreStringUtil.isEmpty((String)str1)) {
            return true;
        }
        if (CoreStringUtil.isEmpty((String)str1) && CoreStringUtil.isEmpty((String)str2)) {
            return false;
        }
        return !str1.equalsIgnoreCase(str2);
    }

    public String getTemporaryDDL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ACCOUNT\n");
        sb.append("(\n");
        sb.append("ACCOUNT_ID   NUMBER(10) DEFAULT ('0') NOT NULL,\n");
        sb.append("SSN          CHAR(10),\n");
        sb.append("STATUS       CHAR(10),\n");
        sb.append("TYPE         CHAR(10),\n");
        sb.append("DATEOPENED   DATE DEFAULT ('CURRENT_TIMESTAMP') NOT NULL,\n");
        sb.append("DATECLOSED   DATE DEFAULT ('0000-00-00 00:00:00') NOT NULL\n");
        sb.append(");\n");
        sb.append("\n");
        sb.append("CREATE TABLE HOLDINGS\n");
        sb.append("(\n");
        sb.append("TRANSACTION_ID   NUMBER(10) NOT NULL,\n");
        sb.append("ACCOUNT_ID       NUMBER(10),\n");
        sb.append("PRODUCT_ID       NUMBER(10),\n");
        sb.append("PURCHASE_DATE    DATE DEFAULT ('CURRENT_TIMESTAMP') NOT NULL,\n");
        sb.append("SHARES_COUNT     NUMBER(10)\n");
        sb.append(");\n");
        sb.append("\n");
        return sb.toString();
    }

    public ImportManager getServerImportManager() {
        return ImportManager.getInstance();
    }

    public boolean isVdbDeployed() {
        return this.vdbDeploymentStatus != null && this.vdbDeploymentStatus.isOK();
    }

    public IStatus getVdbDeploymentStatus() {
        return this.vdbDeploymentStatus;
    }

    public void setTargetModelLocation(IPath targetPath) {
        this.targetModelLocation = targetPath;
        if (this.ddlImporter != null) {
            this.ddlImporter.setModelFolder(targetPath.toString());
        }
    }

    public IPath getTargetModelLocation() {
        return this.targetModelLocation;
    }

    public void setTargetModelName(String targetModelName) {
        this.targetModelName = targetModelName;
        if (this.ddlImporter != null) {
            this.ddlImporter.setModelName(targetModelName);
        }
    }

    public String getTargetModelName() {
        return this.targetModelName;
    }

    public boolean targetModelExists() {
        ModelWorkspaceItem item;
        if (this.targetModelLocation == null || this.targetModelName == null) {
            return false;
        }
        IPath modelPath = new Path(this.targetModelLocation.toOSString()).append(this.targetModelName);
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    public boolean isCreateConnectionProfile() {
        return this.createConnectionProfile;
    }

    public void setCreateConnectionProfile(boolean createConnectionProfile) {
        this.createConnectionProfile = createConnectionProfile;
    }

    public boolean isTargetModelConnectionProfileCompatible() {
        IFile targetModel;
        ModelResource targetModelResc;
        if (this.targetModelLocation == null) {
            return false;
        }
        IPath modelPath = new Path(this.targetModelLocation.toOSString()).append(this.targetModelName);
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((targetModelResc = ModelUtilities.getModelResourceForIFile((IFile)(targetModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null) {
            IConnectionProfile profile = this.connectionInfoHelper.getConnectionProfile(targetModelResc);
            if (profile == null) {
                return true;
            }
            Properties profileProps = profile.getBaseProperties();
            String targetModelUrl = profileProps.getProperty("connection-url");
            if (targetModelUrl == null) {
                targetModelUrl = profileProps.getProperty("EndPoint");
            }
            Properties importDsProps = this.getDataSourceProperties();
            String importDsUrl = null;
            if (importDsProps != null && (importDsUrl = importDsProps.getProperty("connection-url")) == null) {
                importDsUrl = importDsProps.getProperty("EndPoint");
            }
            if (importDsUrl != null && importDsUrl.equalsIgnoreCase(targetModelUrl)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void deleteDataSource(String jndiName) throws Exception {
        this.getServerImportManager().deleteDataSource(jndiName);
    }

    @Override
    public void deployDriver(File jarOrRarFile) throws Exception {
        this.getServerImportManager().deployDriver(jarOrRarFile);
    }

    @Override
    public String getSchema(String vdbName, int vdbVersion, String modelName) throws Exception {
        return this.getServerImportManager().getSchema(vdbName, vdbVersion, modelName);
    }

    @Override
    public Collection<ITeiidDataSource> getDataSources() throws Exception {
        ArrayList<ITeiidDataSource> resultSources = new ArrayList<ITeiidDataSource>();
        Collection teiidSources = this.getServerImportManager().getDataSources();
        for (ITeiidDataSource dSource : teiidSources) {
            String sourceName = dSource.getName();
            if (sourceName == null || sourceName.startsWith(PREVIEW_DATASOURCE_PREFIX)) continue;
            resultSources.add(dSource);
        }
        return resultSources;
    }

    @Override
    public Set<String> getDataSourceTemplateNames() throws Exception {
        return this.getServerImportManager().getDataSourceTemplateNames();
    }

    @Override
    public Collection<TeiidPropertyDefinition> getTemplatePropertyDefns(String templateName) throws Exception {
        return this.getServerImportManager().getTemplatePropertyDefns(templateName);
    }

    @Override
    public ITeiidDataSource getOrCreateDataSource(String displayName, String jndiName, String typeName, Properties properties) throws Exception {
        return this.getServerImportManager().getOrCreateDataSource(displayName, jndiName, typeName, properties);
    }

    @Override
    public Collection<ITeiidTranslator> getTranslators() throws Exception {
        return this.getServerImportManager().getTranslators();
    }

    @Override
    public String getDisplayName() throws Exception {
        return this.getServerImportManager().getDisplayName();
    }

    @Override
    public void undeployDynamicVdb(String vdbName) throws Exception {
        this.getServerImportManager().undeployDynamicVdb(vdbName);
    }

    @Override
    public Properties getDataSourceProperties(String sourceName) throws Exception {
        return this.getServerImportManager().getDataSourceProperties(sourceName);
    }

    @Override
    public ITeiidServerVersion getTeiidServerVersion() throws Exception {
        return this.getServerImportManager().getServerVersion();
    }

    public void initDdlImporter(IProject[] projects) {
        this.ddlImporter = new DdlImporter(projects);
        this.ddlImporter.setModelType(ModelType.PHYSICAL_LITERAL);
        try {
            this.ddlFile = File.createTempFile("DdlTemp", ".ddl");
        }
        catch (IOException ex) {
            UTIL.log((Throwable)ex);
        }
        this.ddlImporter.setDdlFileName(this.ddlFile.getAbsolutePath().toString());
        this.ddlImporter.setSpecifiedParser("TEIID");
    }

    public DdlImporter getDdlImporter() {
        return this.ddlImporter;
    }

    public TranslatorOverride getTranslatorOverride() {
        return this.translatorOverride;
    }

    private void writeDdlToTempFile(String ddl) throws Exception {
        if (this.ddlFile != null && this.ddlFile.canWrite()) {
            FileOutputStream tempOutputStream = new FileOutputStream(this.ddlFile);
            PrintStream out = null;
            try {
                out = new PrintStream(tempOutputStream);
                out.print(ddl);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void deleteDdlTempFile() {
        if (this.ddlFile != null && this.ddlFile.exists()) {
            this.ddlFile.delete();
        }
    }

    public boolean saveUsingDdlDiffReport(Shell shell) {
        block5: {
            if (this.ddlImporter.getDifferenceReport() != null) break block5;
            return false;
        }
        try {
            final Exception[] saveException = new Exception[1];
            new ProgressMonitorDialog(shell).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.TeiidImportManager_ImportingMsg, 100);
                    monitor.worked(50);
                    try {
                        TeiidImportManager.this.ddlImporter.save(monitor, 50);
                    }
                    catch (Exception ex) {
                        saveException[0] = ex;
                    }
                    if (TeiidImportManager.this.isCreateConnectionProfile()) {
                        TeiidImportManager.this.injectProfileIntoTarget(monitor);
                    }
                    monitor.done();
                }
            });
            if (saveException[0] != null) {
                throw saveException[0];
            }
        }
        catch (InterruptedException interruptedException) {
            this.undeployDynamicVdb();
            return false;
        }
        catch (Exception error) {
            ErrorHandler.toExceptionDialog((Throwable)error);
            this.undeployDynamicVdb();
            return false;
        }
        return true;
    }

    private TranslatorOverride createTranslatorOverride(String translatorName, Properties existingProperties) {
        Properties importerProperties = new Properties();
        TranslatorOverride override = new TranslatorOverride(translatorName, importerProperties);
        try {
            ITeiidTranslator translator = this.getServerImportManager().getTranslator(translatorName);
            if (translator != null) {
                PropertyDefinition[] propertyDefinitionsFromServer = TranslatorUtils.getTranslatorPropertyDefinitions((String)translatorName, (ITeiidTranslator.TranslatorPropertyType)ITeiidTranslator.TranslatorPropertyType.IMPORT);
                ArrayList<PropertyDefinition> defaultServerPropDefns = new ArrayList<PropertyDefinition>();
                PropertyDefinition[] propertyDefinitionArray = propertyDefinitionsFromServer;
                int n = propertyDefinitionsFromServer.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDefinition propDefn = propertyDefinitionArray[n2];
                    defaultServerPropDefns.add(propDefn);
                    ++n2;
                }
                if (!existingProperties.isEmpty()) {
                    for (Object key : importerProperties.keySet()) {
                        String keyStr = (String)key;
                        String value = (String)importerProperties.get(key);
                        PropertyDefinition serverPropDefn = null;
                        PropertyDefinition[] propertyDefinitionArray2 = propertyDefinitionsFromServer;
                        int n3 = propertyDefinitionsFromServer.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PropertyDefinition propDefn = propertyDefinitionArray2[n4];
                            if (keyStr.equals(propDefn.getId())) {
                                serverPropDefn = propDefn;
                                defaultServerPropDefns.remove(serverPropDefn);
                                break;
                            }
                            ++n4;
                        }
                        if (serverPropDefn == null) continue;
                        TranslatorOverrideProperty newProp = new TranslatorOverrideProperty(new TranslatorPropertyDefinition(serverPropDefn), value);
                        override.addProperty(newProp);
                    }
                }
                for (PropertyDefinition propDefn : defaultServerPropDefns) {
                    override.addProperty(new TranslatorOverrideProperty(new TranslatorPropertyDefinition(propDefn), null));
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            WidgetUtil.showError((Throwable)error);
        }
        return override;
    }

    private String getCurrentImportVdbName() {
        if (this.uniqueImportVdbName == null) {
            String importVdbName = Messages.TeiidImportManager_ImportVDBName;
            int count = 1;
            boolean vdbExists = this.getServerImportManager().vdbExists(importVdbName);
            while (vdbExists) {
                importVdbName = String.valueOf(Messages.TeiidImportManager_ImportVDBName) + count;
                vdbExists = this.getServerImportManager().vdbExists(importVdbName);
                if (count > 100) break;
                ++count;
            }
            this.uniqueImportVdbName = importVdbName;
        }
        return this.uniqueImportVdbName;
    }

    public boolean shouldRedeploy() {
        return this.redeploy;
    }

    public void setRedeploy(boolean changed) {
        this.redeploy = changed;
    }
}

