/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.exchange.Header;
import org.fusesource.ide.launcher.debug.model.values.CamelHeaderValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeadersVariable;

public class CamelHeaderVariable
extends BaseCamelVariable {
    private CamelHeadersVariable parent;

    public CamelHeaderVariable(CamelDebugTarget debugTarget, String name, Class type, CamelHeadersVariable parent) {
        super(debugTarget, name, type);
        this.parent = parent;
    }

    @Override
    public boolean supportsValueModification() {
        return true;
    }

    @Override
    public void setValue(String expression) throws DebugException {
        Header oldHeader = ((CamelHeaderValue)this.getValue()).getHeader();
        super.setValue(new CamelHeaderValue(this.fTarget, new Header(oldHeader.getKey(), expression, oldHeader.getType()), Header.class));
        this.markChanged();
        this.fireChangeEvent(512);
        this.updateValueOnRuntime(((CamelDebugTarget)this.getDebugTarget()).getDebugger());
    }

    @Override
    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    @Override
    protected void updateValueOnRuntime(CamelDebugFacade debugger) throws DebugException {
        Header h = ((CamelHeaderValue)this.getValue()).getHeader();
        if (Strings.isBlank((String)h.getValue())) {
            this.delete();
        } else {
            debugger.setMessageHeaderOnBreakpoint(this.getCurrentEndpointNodeId(), h.getKey(), h.getValue(), h.getType());
        }
    }

    public String toString() {
        try {
            return String.format("%s = %s", this.getName(), this.getValue().getValueString());
        }
        catch (DebugException debugException) {
            return super.toString();
        }
    }

    public void delete() {
        try {
            this.parent.deleteHeader(((CamelHeaderValue)this.getValue()).getHeader().getKey());
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }
}

