/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.modelgenerator.wsdl.ModelBuildingException;
import org.teiid.designer.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import org.teiid.designer.modelgenerator.wsdl.WSSoapConnectionInfoProvider;
import org.teiid.designer.modelgenerator.wsdl.model.Message;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.Part;
import org.teiid.designer.modelgenerator.wsdl.model.Port;
import org.teiid.designer.modelgenerator.wsdl.model.Service;
import org.teiid.designer.modelgenerator.wsdl.schema.extensions.SOAPSchemaProcessor;
import org.teiid.designer.modelgenerator.xsd.procedures.ITraversalCtxFactory;
import org.teiid.designer.modelgenerator.xsd.procedures.ProcedureBuilder;
import org.teiid.designer.modelgenerator.xsd.procedures.RequestTraversalContextFactory;
import org.teiid.designer.modelgenerator.xsd.procedures.ResultTraversalContextFactory;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RelationalModelBuilder {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalModelBuilder.class);
    public static final String XML = "XML";
    public static final String DOT_XMI = ".xmi";
    private static final String INVOKE = "invoke";
    private List<ModelResource> models;
    private Map<String, ModelResource> serviceNameToPhysicalMap;
    private Map<String, ModelResource> serviceNameToVirtualMap;
    private Model wsdlModel;
    private SchemaModel schemaModel;
    private IContainer folder;
    private RelationalFactory factory;
    private DatatypeManager datatypeManager = ModelerCore.getBuiltInTypesManager();
    private List<ProcedureBuilder> builders = new ArrayList<ProcedureBuilder>();
    private WSSoapConnectionInfoProvider connProvider;
    private IConnectionProfile connectionProfile;
    private XSDSchema[] schemas;
    boolean isSoapImportOption = false;
    IContainer soapSourceModelFolder;
    IContainer soapViewModelFolder;
    String soapSourceModelName;
    String soapViewModelName;

    private static String getString(String id) {
        return ModelGeneratorWsdlPlugin.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public RelationalModelBuilder(Model model, IConnectionProfile profile) throws SchemaProcessingException {
        this.wsdlModel = model;
        SOAPSchemaProcessor processor = new SOAPSchemaProcessor(null);
        processor.representTypes(true);
        processor.setNamespaces(this.wsdlModel.getNamespaces());
        this.schemas = this.wsdlModel.getSchemas();
        processor.processSchemas(this.schemas);
        this.schemaModel = processor.getSchemaModel();
        this.factory = RelationalPackage.eINSTANCE.getRelationalFactory();
        this.connectionProfile = profile;
        this.connProvider = new WSSoapConnectionInfoProvider();
    }

    public void modelOperations(List<Operation> operations, IContainer container) throws ModelBuildingException, ModelerCoreException {
        this.folder = container;
        this.models = new ArrayList<ModelResource>();
        this.serviceNameToPhysicalMap = new HashMap<String, ModelResource>();
        this.serviceNameToVirtualMap = new HashMap<String, ModelResource>();
        HashMap<String, Port> ports = new HashMap<String, Port>();
        for (Operation operation : operations) {
            ModelResource serviceVirtualModel;
            Port port = operation.getBinding().getPort();
            ports.put(port.getName(), port);
            try {
                this.getPhysicalModelForService(operation);
                serviceVirtualModel = this.getVirtualModelForService(operation);
            }
            catch (CoreException e) {
                throw new ModelBuildingException(e);
            }
            Schema schema = this.factory.createSchema();
            serviceVirtualModel.getEmfResource().getContents().add((Object)schema);
            schema.setName(operation.getName());
            schema.setNameInSource(operation.getName());
            ProcedureBuilder resultBuilder = new ProcedureBuilder(schema, serviceVirtualModel);
            this.builders.add(resultBuilder);
            this.modelInputMessage(operation, resultBuilder);
            ProcedureBuilder requestBuilder = new ProcedureBuilder(schema, serviceVirtualModel);
            this.builders.add(requestBuilder);
            this.modelOutputMessage(operation, requestBuilder);
        }
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                for (ModelResource resource : RelationalModelBuilder.this.models) {
                    try {
                        ModelUtilities.saveModelResource((ModelResource)resource, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    for (ProcedureBuilder builder : RelationalModelBuilder.this.builders) {
                        builder.createTransformations();
                    }
                    try {
                        ModelUtilities.saveModelResource((ModelResource)resource, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            workspaceModifyOperation.run((IProgressMonitor)monitor);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                throw new ModelBuildingException(((InvocationTargetException)ex).getTargetException());
            }
            throw new ModelBuildingException(ex);
        }
    }

    public void modelOperations(List<Operation> operations, IContainer sourceContainer, String sourceModelName, IContainer viewContainer, String viewModelName) throws ModelBuildingException, ModelerCoreException {
        this.isSoapImportOption = true;
        this.soapSourceModelFolder = sourceContainer;
        this.soapViewModelFolder = viewContainer;
        this.soapSourceModelName = sourceModelName;
        this.soapViewModelName = viewModelName;
        this.models = new ArrayList<ModelResource>();
        this.serviceNameToPhysicalMap = new HashMap<String, ModelResource>();
        this.serviceNameToVirtualMap = new HashMap<String, ModelResource>();
        HashMap<String, Port> ports = new HashMap<String, Port>();
        for (Operation operation : operations) {
            ModelResource serviceVirtualModel;
            Port port = operation.getBinding().getPort();
            ports.put(port.getName(), port);
            try {
                this.getPhysicalModelForService(operation);
                serviceVirtualModel = this.getVirtualModelForService(operation);
            }
            catch (CoreException e) {
                throw new ModelBuildingException(e);
            }
            Schema schema = this.factory.createSchema();
            serviceVirtualModel.getEmfResource().getContents().add((Object)schema);
            schema.setName(operation.getName());
            schema.setNameInSource(operation.getName());
            ProcedureBuilder resultBuilder = new ProcedureBuilder(schema, serviceVirtualModel);
            this.builders.add(resultBuilder);
            this.modelInputMessage(operation, resultBuilder);
            ProcedureBuilder requestBuilder = new ProcedureBuilder(schema, serviceVirtualModel);
            this.builders.add(requestBuilder);
            this.modelOutputMessage(operation, requestBuilder);
        }
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                for (ModelResource resource : RelationalModelBuilder.this.models) {
                    try {
                        ModelUtilities.saveModelResource((ModelResource)resource, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    for (ProcedureBuilder builder : RelationalModelBuilder.this.builders) {
                        builder.createTransformations();
                    }
                    try {
                        ModelUtilities.saveModelResource((ModelResource)resource, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            workspaceModifyOperation.run((IProgressMonitor)monitor);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                throw new ModelBuildingException(((InvocationTargetException)ex).getTargetException());
            }
            throw new ModelBuildingException(ex);
        }
    }

    private void createPhysicalProcedure(Service service, ModelResource serviceModel) throws ModelerCoreException {
        Procedure procedure = this.factory.createProcedure();
        serviceModel.getEmfResource().getContents().add((Object)procedure);
        procedure.setName(INVOKE);
        procedure.setNameInSource(INVOKE);
        ProcedureParameter param = this.factory.createProcedureParameter();
        procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setName(RelationalModelBuilder.getString("param.binding"));
        param.setNameInSource(RelationalModelBuilder.getString("param.binding"));
        param.setNullable(NullableType.NULLABLE_LITERAL);
        param.setType(this.datatypeManager.getBuiltInDatatype("string"));
        param = this.factory.createProcedureParameter();
        procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setName(RelationalModelBuilder.getString("param.action"));
        param.setNameInSource(RelationalModelBuilder.getString("param.action"));
        param.setNullable(NullableType.NULLABLE_LITERAL);
        param.setType(this.datatypeManager.getBuiltInDatatype("string"));
        param = this.factory.createProcedureParameter();
        procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setName(RelationalModelBuilder.getString("param.request"));
        param.setNameInSource(RelationalModelBuilder.getString("param.request"));
        param.setNullable(NullableType.NULLABLE_LITERAL);
        param.setType(this.datatypeManager.getBuiltInDatatype("XMLLiteral"));
        param = this.factory.createProcedureParameter();
        procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setName(RelationalModelBuilder.getString("param.endpoint"));
        param.setNameInSource(RelationalModelBuilder.getString("param.endpoint"));
        param.setNullable(NullableType.NULLABLE_LITERAL);
        param.setType(this.datatypeManager.getBuiltInDatatype("string"));
        param = this.factory.createProcedureParameter();
        procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.OUT_LITERAL);
        param.setName(RelationalModelBuilder.getString("param.result"));
        param.setNameInSource(RelationalModelBuilder.getString("param.result"));
        param.setNullable(NullableType.NULLABLE_LITERAL);
        param.setType(this.datatypeManager.getBuiltInDatatype("XMLLiteral"));
    }

    private void modelOutputMessage(Operation operation, ProcedureBuilder requestBuilder) throws ModelerCoreException {
        Message message = operation.getOutputMessage();
        if (message == null) {
            return;
        }
        Part[] parts = message.getParts();
        int i = 0;
        while (i < parts.length) {
            String elementNamespace;
            String elementName;
            Part part = parts[i];
            if (part.isElement()) {
                elementName = part.getElementName();
                elementNamespace = part.getElementNamespace();
            } else {
                elementName = part.getTypeName();
                elementNamespace = part.getTypeNamespace();
            }
            ResultTraversalContextFactory factory = new ResultTraversalContextFactory();
            QName qName = new QName(elementNamespace, elementName);
            SchemaObject sObject = this.schemaModel.getElement(qName);
            if (sObject != null) {
                requestBuilder.build(sObject, (ITraversalCtxFactory)factory);
            } else {
                XSDSimpleTypeDefinition simpleType = XSDSchemaImpl.getSchemaForSchema((String)this.schemas[0].getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", elementName);
                requestBuilder.build(simpleType, part.getName(), (ITraversalCtxFactory)factory);
            }
            ++i;
        }
    }

    private void modelInputMessage(Operation operation, ProcedureBuilder resultBuilder) throws ModelerCoreException {
        Message message = operation.getInputMessage();
        Part[] parts = message.getParts();
        int i = 0;
        while (i < parts.length) {
            String elementNamespace;
            String elementName;
            Part part = parts[i];
            if (part.isElement()) {
                elementName = part.getElementName();
                elementNamespace = part.getElementNamespace();
            } else {
                elementName = part.getTypeName();
                elementNamespace = part.getTypeNamespace();
            }
            RequestTraversalContextFactory factory = new RequestTraversalContextFactory();
            QName qName = new QName(elementNamespace, elementName);
            SchemaObject sObject = this.schemaModel.getElement(qName);
            if (sObject != null) {
                resultBuilder.build(sObject, (ITraversalCtxFactory)factory);
            } else {
                XSDSimpleTypeDefinition simpleType = XSDSchemaImpl.getSchemaForSchema((String)this.schemas[0].getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", elementName);
                resultBuilder.build(simpleType, part.getName(), (ITraversalCtxFactory)factory);
            }
            ++i;
        }
    }

    public ModelResource getPhysicalModelForService(Operation operation) throws CoreException {
        Port port = operation.getBinding().getPort();
        ModelResource serviceModel = null;
        if (this.serviceNameToPhysicalMap.containsKey(port.getService().getName())) {
            serviceModel = this.serviceNameToPhysicalMap.get(port.getService().getName());
        } else if (this.isSoapImportOption) {
            String srcName = this.soapSourceModelName;
            IFile iFile = this.createNewFile(this.soapSourceModelFolder, srcName);
            serviceModel = this.createNewModelResource(iFile);
            this.serviceNameToPhysicalMap.put(this.soapSourceModelName, serviceModel);
            ModelAnnotation modelAnnotation = serviceModel.getModelAnnotation();
            modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            modelAnnotation.setNameInSource(port.getLocationURI());
            if (!this.procedureExists(serviceModel, INVOKE)) {
                this.createPhysicalProcedure(port.getService(), serviceModel);
            }
            this.connProvider.setConnectionInfo(serviceModel, this.connectionProfile);
        } else {
            IFile iFile = this.createNewFile(this.folder, port.getService().getName());
            serviceModel = this.createNewModelResource(iFile);
            this.serviceNameToPhysicalMap.put(port.getService().getName(), serviceModel);
            ModelAnnotation modelAnnotation = serviceModel.getModelAnnotation();
            modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            modelAnnotation.setNameInSource(port.getLocationURI());
            if (!this.procedureExists(serviceModel, INVOKE)) {
                this.createPhysicalProcedure(port.getService(), serviceModel);
            }
            this.connProvider.setConnectionInfo(serviceModel, this.connectionProfile);
        }
        return serviceModel;
    }

    public boolean procedureExists(ModelResource modelResource, String procedureName) throws ModelWorkspaceException {
        if (modelResource != null) {
            for (Object obj : modelResource.getAllRootEObjects()) {
                EObject eObj = (EObject)obj;
                if (!(eObj instanceof Procedure) || !procedureName.equalsIgnoreCase(ModelObjectUtilities.getName((EObject)eObj))) continue;
                return true;
            }
        }
        return false;
    }

    public ModelResource getVirtualModelForService(Operation operation) throws CoreException {
        ModelResource serviceModel;
        Port port = operation.getBinding().getPort();
        if (this.serviceNameToVirtualMap.containsKey(String.valueOf(port.getService().getName()) + XML)) {
            serviceModel = this.serviceNameToVirtualMap.get(String.valueOf(port.getService().getName()) + XML);
        } else if (this.isSoapImportOption) {
            String viewName = this.soapViewModelName;
            IFile iFile = this.createNewFile(this.soapViewModelFolder, viewName);
            serviceModel = this.createNewModelResource(iFile);
            this.serviceNameToVirtualMap.put(this.soapViewModelName, serviceModel);
            ModelAnnotation modelAnnotation = serviceModel.getModelAnnotation();
            modelAnnotation.setModelType(ModelType.VIRTUAL_LITERAL);
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        } else {
            IFile iFile = this.createNewFile(this.folder, String.valueOf(port.getService().getName()) + XML);
            serviceModel = this.createNewModelResource(iFile);
            this.serviceNameToVirtualMap.put(port.getService().getName(), serviceModel);
            ModelAnnotation modelAnnotation = serviceModel.getModelAnnotation();
            modelAnnotation.setModelType(ModelType.VIRTUAL_LITERAL);
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        }
        return serviceModel;
    }

    private IFile createNewFile(IContainer container, String name) {
        if (name.endsWith(DOT_XMI)) {
            Path modelPath = new Path(name);
            IFile iFile = container.getFile((IPath)modelPath);
            return iFile;
        }
        Path modelPath = new Path(String.valueOf(name) + DOT_XMI);
        IFile iFile = container.getFile((IPath)modelPath);
        return iFile;
    }

    private ModelResource createNewModelResource(IFile iFile) {
        ModelResource resource = ModelerCore.create((IFile)iFile);
        this.models.add(resource);
        return resource;
    }
}

