/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.jobs;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.PublishedResourceHelper;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.views.ModeShapeContentProvider;
import org.jboss.tools.modeshape.rest.views.ModeShapeMessageConsole;
import org.modeshape.common.util.CheckArg;

public final class PublishJob
extends Job {
    private static final AtomicInteger JOB_ID = new AtomicInteger();
    private final List<IFile> files;
    private boolean includeProjectPath = false;
    private final int jobId;
    private final Type type;
    private final boolean version;
    private final ModeShapeWorkspace workspace;
    private final String workspaceArea;

    private static String getJobName(Type type, int jobId) {
        CheckArg.isNotNull((Object)((Object)type), (String)"type");
        if (Type.PUBLISH == type) {
            return NLS.bind((String)RestClientI18n.publishJobPublishName, (Object)jobId);
        }
        return NLS.bind((String)RestClientI18n.publishJobUnpublishName, (Object)jobId);
    }

    public PublishJob(Type type, List<IFile> files, ModeShapeWorkspace workspace, String workspaceArea, boolean includeProjectPath, boolean version) {
        super(PublishJob.getJobName(type, JOB_ID.incrementAndGet()));
        CheckArg.isNotNull(files, (String)"files");
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        this.type = type;
        this.files = files;
        this.workspace = workspace;
        this.includeProjectPath = includeProjectPath;
        this.version = version;
        this.jobId = JOB_ID.get();
        String temp = workspaceArea == null ? "" : workspaceArea;
        this.workspaceArea = temp.endsWith(File.separator) ? temp.substring(0, temp.length() - 1) : temp;
        this.setUser(true);
    }

    public boolean belongsTo(Object family) {
        return "modeshape.publishing.job.family".equals(family);
    }

    private ServerManager getServerManager() {
        return Activator.getDefault().getServerManager();
    }

    private boolean isPublishing() {
        return this.type == Type.PUBLISH;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        assert (this.workspace != null);
        long startTime = System.currentTimeMillis();
        boolean canceled = false;
        int numProcessed = 0;
        try {
            int fileCount = this.files.size();
            String name = this.isPublishing() ? NLS.bind((String)RestClientI18n.publishJobPublishTaskName, (Object)this.jobId) : NLS.bind((String)RestClientI18n.publishJobUnpublishTaskName, (Object)this.jobId);
            monitor.beginTask(name, fileCount);
            monitor.setTaskName(name);
            String serverUrl = this.workspace.getServer().getOriginalUrl();
            String repositoryName = this.workspace.getRepository().getName();
            String workspaceName = this.workspace.getName();
            if (this.isPublishing()) {
                ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublish, (Object[])new Object[]{this.jobId, serverUrl, repositoryName, workspaceName, fileCount, this.workspaceArea}));
            } else {
                ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublish, (Object[])new Object[]{this.jobId, serverUrl, repositoryName, workspaceName, fileCount, this.workspaceArea}));
            }
            PublishedResourceHelper resourceHelper = new PublishedResourceHelper(this.getServerManager());
            for (IFile eclipseFile : this.files) {
                if (monitor.isCanceled()) {
                    canceled = true;
                    throw new InterruptedException(NLS.bind((String)RestClientI18n.publishJobCanceled, (Object)this.jobId));
                }
                File file = eclipseFile.getLocation().toFile();
                String path = this.workspaceArea;
                IPath parentPath = eclipseFile.getParent().getFullPath();
                path = this.includeProjectPath ? String.valueOf(path) + parentPath : String.valueOf(path) + '/' + parentPath.removeFirstSegments(1).toString();
                URL url = this.getServerManager().getUrl(file, path, this.workspace);
                org.modeshape.web.jcr.rest.client.Status status = null;
                if (this.isPublishing()) {
                    status = this.getServerManager().publish(this.workspace, path, file, this.version);
                    if (!status.isError()) {
                        resourceHelper.addPublishedProperty(eclipseFile, this.workspace, url.toString());
                    }
                } else {
                    status = this.getServerManager().unpublish(this.workspace, path, file);
                    if (!status.isError()) {
                        resourceHelper.removePublishedProperty(eclipseFile, this.workspace, url.toString());
                    }
                }
                ++numProcessed;
                monitor.worked(1);
                ModeShapeContentProvider decorator = ModeShapeContentProvider.getDecorator();
                if (decorator != null) {
                    decorator.refresh(eclipseFile);
                }
                if (this.isPublishing() && status.isOk()) {
                    this.writeToConsole(eclipseFile, url, status);
                    continue;
                }
                this.writeToConsole(eclipseFile, null, status);
            }
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            Status status;
            try {
                String msg = null;
                msg = e instanceof InterruptedException ? e.getLocalizedMessage() : RestClientI18n.publishJobUnexpectedErrorMsg;
                status = new Status(1, "org.jboss.tools.modeshape.rest", msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                monitor.done();
                long milliseconds = System.currentTimeMillis() - startTime;
                long hours = milliseconds / 3600000L;
                long minutes = milliseconds % 3600000L / 60000L;
                long seconds = milliseconds % 3600000L % 60000L / 1000L;
                String duration = hours > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationMsg, (Object[])new Object[]{hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationNoHoursMsg, (Object)minutes, (Object)seconds) : (seconds > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationNoHoursNoMinutesMsg, (Object)seconds) : RestClientI18n.publishJobDurationShortMsg));
                if (canceled) {
                    if (this.isPublishing()) {
                        ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublishCanceledMsg, (Object[])new Object[]{this.jobId, numProcessed, this.files.size(), duration}));
                    } else {
                        ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublishCanceledMsg, (Object[])new Object[]{this.jobId, numProcessed, this.files.size(), duration}));
                    }
                } else if (this.isPublishing()) {
                    ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublishFinishedMsg, (Object)this.jobId, (Object)duration));
                } else {
                    ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublishFinishedMsg, (Object)this.jobId, (Object)duration));
                }
                throw throwable;
            }
            monitor.done();
            long milliseconds = System.currentTimeMillis() - startTime;
            long hours = milliseconds / 3600000L;
            long minutes = milliseconds % 3600000L / 60000L;
            long seconds = milliseconds % 3600000L % 60000L / 1000L;
            String duration = hours > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationMsg, (Object[])new Object[]{hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationNoHoursMsg, (Object)minutes, (Object)seconds) : (seconds > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationNoHoursNoMinutesMsg, (Object)seconds) : RestClientI18n.publishJobDurationShortMsg));
            if (canceled) {
                if (this.isPublishing()) {
                    ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublishCanceledMsg, (Object[])new Object[]{this.jobId, numProcessed, this.files.size(), duration}));
                } else {
                    ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublishCanceledMsg, (Object[])new Object[]{this.jobId, numProcessed, this.files.size(), duration}));
                }
            } else if (this.isPublishing()) {
                ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublishFinishedMsg, (Object)this.jobId, (Object)duration));
            } else {
                ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublishFinishedMsg, (Object)this.jobId, (Object)duration));
            }
            return status;
        }
        monitor.done();
        long milliseconds = System.currentTimeMillis() - startTime;
        long hours = milliseconds / 3600000L;
        long minutes = milliseconds % 3600000L / 60000L;
        long seconds = milliseconds % 3600000L % 60000L / 1000L;
        String duration = hours > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationMsg, (Object[])new Object[]{hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationNoHoursMsg, (Object)minutes, (Object)seconds) : (seconds > 0L ? NLS.bind((String)RestClientI18n.publishJobDurationNoHoursNoMinutesMsg, (Object)seconds) : RestClientI18n.publishJobDurationShortMsg));
        if (canceled) {
            if (this.isPublishing()) {
                ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublishCanceledMsg, (Object[])new Object[]{this.jobId, numProcessed, this.files.size(), duration}));
            } else {
                ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublishCanceledMsg, (Object[])new Object[]{this.jobId, numProcessed, this.files.size(), duration}));
            }
        } else if (this.isPublishing()) {
            ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobPublishFinishedMsg, (Object)this.jobId, (Object)duration));
        } else {
            ModeShapeMessageConsole.writeln(NLS.bind((String)RestClientI18n.publishJobUnpublishFinishedMsg, (Object)this.jobId, (Object)duration));
        }
        return iStatus;
    }

    private void writeToConsole(IFile file, URL url, org.modeshape.web.jcr.rest.client.Status status) {
        String message = null;
        if (status.isOk()) {
            message = this.isPublishing() ? NLS.bind((String)RestClientI18n.publishJobPublishFile, (Object[])new Object[]{this.jobId, file.getFullPath(), url.toString()}) : NLS.bind((String)RestClientI18n.publishJobUnpublishFile, (Object)this.jobId, (Object)file.getFullPath());
        } else if (status.isError()) {
            message = this.isPublishing() ? NLS.bind((String)RestClientI18n.publishJobPublishFileFailed, (Object)this.jobId, (Object)file.getFullPath()) : NLS.bind((String)RestClientI18n.publishJobUnpublishFileFailed, (Object)this.jobId, (Object)file.getFullPath());
            Activator.getDefault().log(status);
        } else if (status.isWarning()) {
            message = this.isPublishing() ? NLS.bind((String)RestClientI18n.publishJobPublishFileWarning, (Object)this.jobId, (Object)file.getFullPath()) : NLS.bind((String)RestClientI18n.publishJobUnpublishFileWarning, (Object)this.jobId, (Object)file.getFullPath());
            Activator.getDefault().log(status);
        } else {
            message = this.isPublishing() ? NLS.bind((String)RestClientI18n.publishJobPublishFileInfo, (Object)this.jobId, (Object)file.getFullPath()) : NLS.bind((String)RestClientI18n.publishJobUnpublishFileInfo, (Object)this.jobId, (Object)file.getFullPath());
            Activator.getDefault().log(status);
        }
        ModeShapeMessageConsole.writeln(message, file);
    }

    public static enum Type {
        PUBLISH,
        UNPUBLISH;

    }
}

