/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.dialogs;

import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.modeshape.common.util.CheckArg;

public final class DeleteServerDialog
extends MessageDialog {
    private final Collection<ModeShapeServer> serversBeingDeleted;

    public DeleteServerDialog(Shell parentShell, Collection<ModeShapeServer> serversBeingDeleted) {
        super(parentShell, RestClientI18n.deleteServerDialogTitle, Activator.getDefault().getImage("icons/views/modeShape_icon_16x.png"), null, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        CheckArg.isNotNull(serversBeingDeleted, (String)"serversBeingDeleted");
        this.serversBeingDeleted = serversBeingDeleted;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        String msg;
        super.configureShell(shell);
        if (this.serversBeingDeleted.size() == 1) {
            ModeShapeServer server = this.serversBeingDeleted.iterator().next();
            msg = NLS.bind((String)RestClientI18n.deleteServerDialogOneServerMsg, (Object)server.getName(), (Object)server.getUser());
        } else {
            msg = NLS.bind((String)RestClientI18n.deleteServerDialogMultipleServersMsg, (Object)this.serversBeingDeleted.size());
        }
        this.message = msg;
    }

    protected Control createCustomArea(Composite parent) {
        if (this.serversBeingDeleted.size() != 1) {
            List serverList = new List(parent, 0);
            serverList.setBackground(Display.getDefault().getSystemColor(22));
            GridData gd = new GridData(16384, 0x1000000, true, true);
            gd.horizontalIndent = 40;
            serverList.setLayoutData((Object)gd);
            for (ModeShapeServer server : this.serversBeingDeleted) {
                serverList.add(server.getName());
            }
        }
        return null;
    }
}

